//***************************************************************************************
//
//  Title:  tinyScramble, by One Wolf WebArt
//  Author: chris@onewolf.com (Christian Ricci)
//
//  For more information please refer to http://www.onewolf.com/
//
//  See also:  tinyScramble.txt [docs]
//  
//***************************************************************************************
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

public class tinyScramble extends Applet
    implements Runnable {		// Threaded application
 
    int delay=10, 			// Integer, controls scroll/change speed
        startDelay=0, 	 		// Integer, controls initial delay
        pause=1000,                     // Integer, controls delay btwn messages
        length,                         // Integer/Counter, length of input string
        numHits,			// Integer/Counter, number of correct hits
        maxMessages=1,                  // Integer, number of messages/links
        current,                        // Integer, current message being displayed
        xpos=0,                         // X position
        ypos=0;                         // Y position
    boolean loop=true;                  // Flag, loop through messages?
    Image offImage, bg;                 // Tools for double buffering
    Graphics offGrfx;                   // Tools for double buffering
    Color background, fontColor;        // Colors, foreground and background
    Thread runner;                      // Thread stuff
    String outString = new String("");  // String, current output
    String[] Message = new String[100]; // String, eventual output
    String xpos$, ypos$,                // Strings, x and y position (acting as flags)
           loop$;                       // String, loop (input)
    URL[] Link       = new URL[100];    // Link, per String
    String[] target  = new String[100]; // Target String, frame/window
    Font outFont;                       // Font, output font

//***************************************************************************************
//
//  Method:   Init
//  Purpose:  To retrieve and massage parameters from HTML
//
//***************************************************************************************
    public void init() {
        int size;

//****  Get Attributes                                         **************************

        String bgRed$      = getParameter("BGRED");
        String bgGreen$    = getParameter("BGGREEN");
        String bgBlue$     = getParameter("BGBLUE");
        String fgRed$      = getParameter("FGRED");
        String fgGreen$    = getParameter("FGGREEN");
        String fgBlue$     = getParameter("FGBLUE");
        String background$ = getParameter("BACKGROUND");
        String delay$      = getParameter("DELAY");
        String startDelay$ = getParameter("STARTDELAY");
        String pause$      = getParameter("PAUSE");
        String fontName$   = getParameter("FONTNAME");
        String fontSize$   = getParameter("FONTSIZE");
               loop$       = getParameter("LOOP");
               xpos$       = getParameter("XPOS");
               ypos$       = getParameter("YPOS");

//****  Massage Attributes, lines                              **************************        

        maxMessages = 1;
        while ((Message[maxMessages] =
                getParameter("MESSAGE" + Integer.toString(maxMessages)))
                != null) { maxMessages++; }

        for (int x=1; x<maxMessages; x++) {
            Link[x] = getURL(getParameter("LINK" + Integer.toString(x))); }

        for (int x=1; x<maxMessages; x++) {
            target[x] = getParameter("TARGET" + Integer.toString(x)); }

//****  Massage Attributes, performance/appearance stuff       **************************        

        if (xpos$ != null) 
	  xpos = Integer.parseInt(xpos$);

        if (ypos$ != null) 
	  ypos = Integer.parseInt(ypos$);

        if (delay$ != null) 
	  delay = Integer.parseInt(delay$);

        if (startDelay$ != null)
          startDelay = Integer.parseInt(startDelay$);

        if (pause$ != null)
          pause = Integer.parseInt(pause$);

//****  Massage Attributes, font                               **************************

        if ((fontSize$ != null) && (fontName$ != null)) {
            size = Integer.parseInt(fontSize$);
            outFont = new Font(fontName$, Font.PLAIN, size);
        }

//****  Massage Attributes, colors and background              **************************        

        int Red=255;
        int Green=255; 
        int Blue=255;
        int fRed=0;
        int fGreen=0; 
        int fBlue=0;

        if (bgRed$ != null) Red = Integer.parseInt(bgRed$);
        if (bgGreen$ != null) Green = Integer.parseInt(bgGreen$);
        if (bgBlue$ != null) Blue = Integer.parseInt(bgBlue$);
        if (fgRed$ != null) fRed = Integer.parseInt(fgRed$);
        if (fgGreen$ != null) fGreen = Integer.parseInt(fgGreen$);
        if (fgBlue$ != null) fBlue = Integer.parseInt(fgBlue$);

        fontColor = new Color(fRed, fGreen, fBlue);
        background = new Color(Red, Green, Blue);
        setBackground(background);

        if (background$ !=null)
          bg = getImage(getDocumentBase(), background$);

//****  Prep buffer                                            **************************               

        offImage = createImage(size().width, size().height);
        offGrfx = offImage.getGraphics();
    }

    URL getURL(String urlText) {
        URL pageURL = null;
        try { pageURL = new URL(getDocumentBase(), urlText); }
        catch (MalformedURLException m) { }
        return pageURL;
    }

//***************************************************************************************
//
//  Method:   Paint
//  Purpose:  Put the stuff on the screen
//
//***************************************************************************************

    public void paint(Graphics screen) {
          offGrfx.setColor(background);
          offGrfx.fillRect(0,0,size().width, size().height);
          if (bg != null)
            offGrfx.drawImage(bg, 0, 0, null);
          offGrfx.setColor(fontColor);
          if (outFont != null) offGrfx.setFont(outFont);
          offGrfx.drawString(outString, xpos, ypos);
          screen.drawImage(offImage, 0, 0, this);
    }

//***************************************************************************************
//
//  Method:   Update
//  Purpose:  Override standard version of method
//
//***************************************************************************************

    public void update(Graphics screen) {
          paint(screen); 
    }

//***************************************************************************************
//
//  Methods:  Start, run and stop
//  Purpose:  Thread methods.  Modify run in conjunction with paint to control 
//            text/content manipulation.
//
//***************************************************************************************

    public void start() {
        if (runner == null) {
            runner = new Thread(this);
            runner.start();
        }
    }

    public char genRandomChar() {
        double tmpDbl = Math.random()*90;
        return (char)(Math.floor(tmpDbl)+32);
    }

    public void run() {

        try { Thread.sleep(startDelay); }
        catch (InterruptedException e) { }

        while(loop) {

        for (current=1; current<maxMessages; current++) {

            length = Message[current].length();
            numHits = 0;

            int[] hits = new int[length];
            char[] output = new char[length];
            char[] input = new char[length];
 
            for(int x=0;x<length;x++) hits[x]=0; 
            input = Message[current].toCharArray();

            FontMetrics fm = getFontMetrics(outFont);
  
            if (xpos$ == null) xpos = (int)(0.5 * (size().width - fm.stringWidth(Message[current])));
            if (ypos$ == null) ypos = (int)(0.5 * (size().height + (0.5 * fm.getHeight())));

            while (numHits!=length) {
                for(int x=0;x<length;x++){
                    if (hits[x]!=1) {
                        output[x] = genRandomChar();
                        if (output[x]==input[x]){
                           hits[x]=1;
                           numHits++;
                        }
                    }
                }
                outString = new String(output);
                repaint();
                try { Thread.sleep(delay); }
                catch (InterruptedException e) { }
            }

        try { Thread.sleep(pause); }
        catch (InterruptedException e) { }

        }

        if (loop$ != null)
            if (loop$.equalsIgnoreCase("n")) loop = false;

        }

        current = maxMessages-1;

        while(true) {

            try { Thread.sleep(delay); }
            catch (InterruptedException e) { }

        }

    }

    public void stop() {
        if (runner != null) {
            runner.stop();
            runner = null;
        }
    }

    public boolean mouseDown(Event evt, int xx, int yy) {
        if (Link[current] != null) {
            runner.stop();
            AppletContext browser = getAppletContext();
            if (target[current] != null) {
                browser.showDocument(Link[current], target[current]);
            } else {
                browser.showDocument(Link[current]);
            }
        }
        return true;
    }
}
