// dynarule2 - Scalable horizontal rule with moving image(s)
//
// (c) 1996 Tor Ringstad (torhr@nvg.unit.no)
//
// $Id: dynarule2.java,v 1.1 1996/02/02 14:31:45 torhr Exp torhr $
// $Source: /home/stud/torhr/public_html/java/dynarule/RCS/dynarule2.java,v $
//
// This is the barebone version!

// Todo:
//   o Handle resizing
//   o Better color handling

import java.awt.*;
import java.lang.*;

public class dynarule2 extends java.applet.Applet implements Runnable {

  int xs,ys;      // x- and y-size of the applets window
  int size;       // the size (thickness) of the rule
  int dy;         // displacement of the line
  int num;        // number of copies of image
  Image img;      // holds the image
  Color fg,bg;    // foreground and background color
  Color lc,dc;    // light and dark color (calc'ed from foreground)
  float am,of;    // amplitude and offset
  float x;        // sine counter
  float dist;     // distance between images
  float speed;    // speed of the images (step on the sine curve)

  MediaTracker tracker = null;
  Image buffer_i = null;
  Graphics buffer_g = null;
  Thread kicker = null;
  float Pi2 = (float)(Math.PI * 2);

  public void init() {
    String s;
    tracker = new MediaTracker(this);

    xs = size().width;
    ys = size().height;
    s = getParameter("img");
    img = getImage(getDocumentBase(), s);
    tracker.addImage(img,0);
    s = getParameter("size");
    size = (s == null) ? 1 : Integer.valueOf(s).intValue();
    s = getParameter("num");
    num = (s == null) ? 1 : Integer.valueOf(s).intValue();
    s = getParameter("dy");
    dy = (s == null) ? 50 : Integer.valueOf(s).intValue();
    s = getParameter("dist");
    dist = (s == null) ? 1 : Float.valueOf(s).floatValue();
    s = getParameter("speed");
    speed = (s == null) ? Pi2/400 : Float.valueOf(s).floatValue();

    s = getParameter("bgcolor");
    bg = (s == null) ? getBackground() : 
                       new Color(Integer.valueOf(s,16).intValue());
    s = getParameter("fgcolor");
    fg = (s == null) ? bg :
                       new Color(Integer.valueOf(s,16).intValue());
    lc = fg.brighter();
    dc = fg.darker();

    buffer_i = createImage(size().width,size().height);
    buffer_g = buffer_i.getGraphics();
  }

  public void start() {
    try {
      showStatus("dynarule2: Loading image...");
      tracker.waitForID(0);
      showStatus("");
    } catch (InterruptedException c) {
      showStatus("dynarule2: Image loading interrupted");
      return;
    }

    am = (xs - img.getWidth(this)) / 2;
    of = am;
    x = 0;

    if (kicker==null) {
      kicker=new Thread(this);
      kicker.start();
    }
  }

  public void stop() {
    if (kicker != null) {
      kicker.stop();
      kicker = null;
    }
  }

  public void run() {
    while(true) {
      x += speed;
      if (x > Pi2) {
	    x -= Pi2;
	  }
      repaint();
      try {kicker.sleep(15);} catch (InterruptedException e) {}
    }
  }

  public void paint(Graphics g) {

    // Clear the entire background

    buffer_g.setColor(bg);
    buffer_g.fillRect(0,0,xs,ys);

    // Draw the rule

    buffer_g.setColor(lc);
    buffer_g.drawLine(xs-1,dy+size,0,dy+size);
    buffer_g.drawLine(xs-1,dy+size,xs-1,dy);
    buffer_g.setColor(dc);
    buffer_g.drawLine(0,dy,xs-1,dy);
    buffer_g.drawLine(0,dy,0,dy+size);

    // Draw all the images

    float xb = x;
    for(int a = 0; a < num; a++) {
      int xpos = (int)(Math.sin(xb)*am + of);
      buffer_g.drawImage(img,xpos,0,this);
      xb += dist;
    }

    // Copy the offscreen working area to the visible one

    g.drawImage(buffer_i,0,0,this);
  }

  public final synchronized void update(Graphics g) {
    paint(g);
  }

}

