/*
 * Decompiled with CFR 0.152.
 */
package ru.kryshen.fs1menu;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import ru.kryshen.awt.OffscreenBuffer;
import ru.kryshen.fs1menu.Animation;
import ru.kryshen.fs1menu.Menu;

public class MenuApplet
extends Applet
implements Runnable {
    static final String TITLE = "FS1 Menu";
    static final String VERSION = "1.2";
    static final String HOME = "http://bm.org.ru/java/fs1menu.html";
    private final boolean DISPLAY_AD = true;
    private Thread animationThread;
    Object animationMonitor = new Object();
    Vector buttons = new Vector();
    private int prefWidth = -1;
    private int prefHeight = -1;
    private Menu menu;
    private OffscreenBuffer offscreen = new OffscreenBuffer(this);
    private static boolean aa = true;
    private Thread windowDisposer;
    private Object wdLock = new Object();
    private int active = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (Thread.currentThread() == this.animationThread) {
            do {
                try {
                    Thread.currentThread();
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (Thread.currentThread() == this.animationThread && this.buttonsAnimation());
            try {
                Object object = this.animationMonitor;
                synchronized (object) {
                    this.animationMonitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Thread.currentThread() == this.windowDisposer) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Thread.currentThread() == this.windowDisposer) {
                this.disposeSubmenus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void windowActivated() {
        Object object = this.wdLock;
        synchronized (object) {
            ++this.active;
            this.windowDisposer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void windowDeactivated() {
        Object object = this.wdLock;
        synchronized (object) {
            --this.active;
            if (this.active == 0) {
                this.windowDisposer = new Thread(this);
                this.windowDisposer.start();
            }
        }
    }

    private boolean buttonsAnimation() {
        boolean bl = false;
        Enumeration enumeration = this.buttons.elements();
        while (enumeration.hasMoreElements()) {
            Menu.Button button = (Menu.Button)enumeration.nextElement();
            bl |= button.runAnimation();
        }
        return bl;
    }

    public void init() {
        this.setLayout(null);
        Banner banner = new Banner();
        Serializable serializable = banner.getPreferredSize();
        serializable.height = Integer.parseInt(this.getParameter("Banner.", "Banner.", "height", String.valueOf(serializable.height)));
        if (serializable.height < 15) {
            serializable.height = 15;
        }
        banner.setSize((Dimension)serializable);
        banner.setLocation((this.getSize().width - serializable.width) / 2, this.getSize().height - serializable.height);
        this.add(banner);
        this.menu = new Menu(this);
        this.menu.setLocation(0, 0);
        this.menu.setSize(this.getSize());
        this.add(this.menu);
        try {
            this.menu.init("");
            Animation.generateAll();
            int n = 0;
            while (n < this.menu.getComponentCount()) {
                serializable = this.menu.getComponent(n);
                if (serializable instanceof Menu.Button) {
                    ((Menu.Button)serializable).appearAnimation();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getParameter(String string, String string2, String string3) {
        String string4 = this.getParameter(string + string3);
        return string4 == null ? this.getParameter(string2 + string3) : string4;
    }

    String getParameter(String string, String string2, String string3, String string4) {
        String string5 = this.getParameter(string, string2, string3);
        return string5 == null ? string4 : string5;
    }

    static String convert(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (true) {
            int n3;
            if ((n2 = string.indexOf(92, n3 = ++n2)) < 0) {
                n2 = n;
            }
            if (n2 - n3 >= 1) {
                stringBuffer.append(string.substring(n3, n2));
            }
            if (n2 >= n - 1) break;
            switch (string.charAt(++n2)) {
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    ++n2;
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    ++n2;
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    ++n2;
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    ++n2;
                    break;
                }
                case 'u': {
                    try {
                        stringBuffer.append((char)Integer.valueOf(string.substring(n2 + 1, n2 + 5), 16).intValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n2 += 5;
                }
            }
        }
        return stringBuffer.toString();
    }

    public void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public void stop() {
        Thread thread = this.animationThread;
        this.animationThread = null;
        thread.interrupt();
    }

    public void destroy() {
        this.removeAll();
        this.buttons.removeAllElements();
    }

    public synchronized void update(Graphics graphics) {
        this.offscreen.update(graphics);
    }

    public void paint(Graphics graphics) {
        MenuApplet.enableAA(graphics);
        super.paint(graphics);
    }

    static void enableAA(Graphics graphics) {
        block2: {
            if (!aa) break block2;
            try {
                new Object(){

                    void setAA(Graphics graphics) throws Throwable {
                        ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                    }
                }.setAA(graphics);
            }
            catch (Throwable throwable) {
                System.err.println("FS1 Menu: " + throwable);
                System.err.println("FS1 Menu: WARNING: Your Java VM does not support text anti-aliasing.");
                aa = false;
            }
        }
    }

    void disposeSubmenus() {
        this.menu.disposeSubmenus();
    }

    private class Banner
    extends Component
    implements MouseListener {
        private final String AD_TEXT = "FS1 Menu";
        private final Font AD_FONT = new Font("Helvetica", 1, 10);
        private final int INS_H = 3;
        private final int INS_V = 3;
        private boolean me = false;

        Banner() {
            this.addMouseListener(this);
        }

        public void paint(Graphics graphics) {
            graphics.setFont(this.AD_FONT);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Dimension dimension = this.getSize();
            graphics.setColor(Color.black);
            int n = -1;
            while (n <= 1) {
                int n2 = -1;
                while (n2 <= 1) {
                    Menu.drawStringInRect(MenuApplet.TITLE, n, n2, dimension.width, dimension.height, graphics, fontMetrics);
                    ++n2;
                }
                ++n;
            }
            if (this.me) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.white);
            }
            Menu.drawStringInRect(MenuApplet.TITLE, 0, 0, dimension.width, dimension.height, graphics, fontMetrics);
        }

        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.AD_FONT);
            return new Dimension(fontMetrics.stringWidth(MenuApplet.TITLE) + 6, fontMetrics.getHeight() + 6);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuApplet.this.disposeSubmenus();
            try {
                MenuApplet.this.getAppletContext().showDocument(new URL(MenuApplet.HOME), "_blank");
            }
            catch (MalformedURLException malformedURLException) {}
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.me = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.me = false;
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

