/*
 * Decompiled with CFR 0.152.
 */
package ru.kryshen.fs1menu;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import ru.kryshen.fs1menu.ImageFilter;
import ru.kryshen.fs1menu.MenuApplet;

class Animation {
    static final int INTERVAL = 30;
    private Image[] frames;
    private Image[] shadedFrames;
    private final Image image1;
    private final Image image2;
    final float shading;
    private Component target;
    private boolean loaded = false;
    private int maxLength = 30;
    int width;
    int height;
    private static Hashtable cache = new Hashtable();

    static synchronized Animation getAnimation(MenuApplet menuApplet, String string, String string2) throws MalformedURLException, InterruptedException {
        String string3 = menuApplet.getParameter(string, string2, "image");
        String string4 = menuApplet.getParameter(string, string2, "mouseOverImage");
        float f = Float.valueOf(menuApplet.getParameter(string, string2, "shading", "0.15")).floatValue();
        Key key = new Key(new URL(menuApplet.getDocumentBase(), string3), new URL(menuApplet.getDocumentBase(), string4), f);
        Animation animation = (Animation)cache.get(key);
        if (animation != null) {
            return animation;
        }
        animation = new Animation(menuApplet, menuApplet.getImage(key.url1), menuApplet.getImage(key.url2), f);
        cache.put(key, animation);
        return animation;
    }

    private Animation(Component component, Image image, Image image2, float f) throws InterruptedException {
        this.image1 = image;
        this.image2 = image2;
        this.shading = f;
        this.target = component;
        this.frames = new Image[1];
        this.shadedFrames = new Image[1];
        this.frames[0] = image;
        this.frames[this.frames.length - 1] = image2;
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        mediaTracker.addImage(image2, 0);
        mediaTracker.waitForID(0);
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    synchronized void drawFrame(Graphics graphics, int n, int n2, int n3, boolean bl) {
        graphics.drawImage(bl ? this.shadedFrames[n3] : this.frames[n3], n, n2, null);
    }

    synchronized int getFramesNumber() {
        return this.frames.length;
    }

    synchronized void addLength(int n) {
        if (n > this.maxLength) {
            this.loaded = false;
            this.maxLength = n;
        }
    }

    synchronized void generate() throws InterruptedException {
        if (this.loaded) {
            return;
        }
        int n = this.maxLength / 30;
        this.frames = new Image[n];
        this.shadedFrames = new Image[n];
        this.frames[0] = this.image1;
        this.frames[this.frames.length - 1] = this.image2;
        MediaTracker mediaTracker = new MediaTracker(this.target);
        int n2 = this.image2.getWidth(null);
        int n3 = this.image2.getHeight(null);
        int[] nArray = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(this.image2, 0, 0, n2, n3, nArray, 0, n2);
        pixelGrabber.grabPixels();
        int n4 = 1;
        while (n4 <= this.frames.length - 2) {
            ImageFilter imageFilter = new ImageFilter(nArray, n2, (float)n4 / (float)(this.frames.length - 1));
            this.frames[n4] = this.target.createImage(new FilteredImageSource(this.image1.getSource(), imageFilter));
            mediaTracker.addImage(this.frames[n4], 0);
            ++n4;
        }
        mediaTracker.waitForID(0);
        int n5 = 0;
        while (n5 <= this.frames.length - 1) {
            if (this.shading > 0.001f) {
                ImageFilter imageFilter = new ImageFilter(null, 0, this.shading);
                this.shadedFrames[n5] = this.target.createImage(new FilteredImageSource(this.frames[n5].getSource(), imageFilter));
                mediaTracker.addImage(this.shadedFrames[n5], 1);
            } else {
                this.shadedFrames[n5] = this.frames[n5];
            }
            ++n5;
        }
        mediaTracker.waitForID(1);
        this.loaded = true;
    }

    static void generateAll() {
        Enumeration enumeration = cache.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Animation)enumeration.nextElement()).generate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class Key {
        URL url1;
        URL url2;
        float shading;

        Key(URL uRL, URL uRL2, float f) {
            this.url1 = uRL;
            this.url2 = uRL2;
            this.shading = f;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            return ((Key)object).shading == this.shading && this.url1.equals(((Key)object).url1) && this.url2.equals(((Key)object).url2);
        }

        public int hashCode() {
            return this.url1.hashCode();
        }
    }
}

