/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MenuHead
extends Panel
implements MouseListener {
    private CascadeMenu cm;
    private boolean active;
    private String label;
    private Color color1;
    private Color color2;
    private Color stColor;
    private Color textColor;
    private Color textOverColor;
    private Color tColor;
    private boolean done = false;
    private Font font1;
    private Font font2;
    private Font font;
    private ItemCanvas ic;
    private Item item;
    private MenuBar mb;
    private boolean ad;
    private Polygon p;

    public MenuHead(Item item, CascadeMenu cascadeMenu, MenuBar menuBar) {
        this.setLayout(null);
        this.item = item;
        this.mb = menuBar;
        this.color1 = cascadeMenu.getColor("Bar", 0, 0);
        this.color2 = cascadeMenu.getColor("Bar", 1, 0);
        this.textColor = cascadeMenu.getColor("Bar", 0, 1);
        this.textOverColor = cascadeMenu.getColor("Bar", 1, 1);
        this.font1 = cascadeMenu.getFont("Bar", 0);
        this.font2 = cascadeMenu.getFont("Bar", 1);
        this.font = this.font1;
        this.stColor = this.color1;
        this.tColor = this.textColor;
        this.setBackground(this.stColor);
        this.label = item.getText();
        this.cm = cascadeMenu;
        this.addMouseListener(this);
        if (item.hasSub()) {
            this.ic = new ItemCanvas(item.getMenuSet(), cascadeMenu, true);
        }
    }

    public int fontWidth() {
        FontMetrics fontMetrics = this.cm.getFontMetrics(this.font);
        return fontMetrics.stringWidth(this.label);
    }

    public int fontAlign() {
        FontMetrics fontMetrics = this.cm.getFontMetrics(this.font);
        return (this.getSize().height - fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) / 2;
    }

    public int fontCenter() {
        return this.getSize().width / 2 - this.fontWidth() / 2;
    }

    public int getPrefferedWidth() {
        return this.fontWidth() + 20;
    }

    public int getPrefferedHeight() {
        return this.cm.fontheight + 10;
    }

    private void doAction(boolean bl) {
        this.ic.setLocation(this.getBestXPosition(), this.getBestYPosition());
        this.ic.setSize(0, 0);
        this.cm.add(this.ic);
        this.ic.animate(this.ic.getItems() * this.cm.getItemHeight() + 4);
    }

    private int getBestXPosition() {
        int n;
        int n2 = this.getLocation().x;
        int n3 = this.ic.getPrefferedWidth();
        if (this.cm.useVert) {
            n2 = this.mb.width;
        }
        if (n2 + n3 > (n = this.cm.getWidth()) - 5) {
            n2 = n - n3 - 5;
        }
        return n2;
    }

    private int getBestYPosition() {
        int n;
        int n2;
        int n3 = this.getLocation().y + this.getSize().height - 2;
        if (this.cm.useVert) {
            n3 = this.getLocation().y;
        }
        if (n3 + (n2 = this.ic.getItems() * this.cm.getItemHeight() + 4) > (n = this.cm.getHeight()) - 5) {
            n3 = n - n2 - 5;
        }
        return n3;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().height;
        int[] nArray = new int[]{5, 8, 11};
        int[] nArray2 = new int[]{n / 2 - 3, n / 2 + 3, n / 2 - 3};
        this.p = new Polygon(nArray, nArray2, 3);
        graphics.setFont(this.font);
        graphics.setColor(this.stColor);
        if (this.active) {
            if (this.cm.useShadow) {
                graphics.setColor(this.stColor.darker());
                graphics.fillRect(0, 0, this.getSize().width, n);
                graphics.setColor(this.stColor);
                graphics.fillRect(2, 2, this.getSize().width, n);
            } else {
                graphics.setColor(this.stColor);
                graphics.fillRect(0, 0, this.getSize().width, n);
            }
        }
        graphics.setColor(this.tColor);
        graphics.fillPolygon(this.p);
        graphics.drawString(this.label, 5 + this.fontCenter(), this.fontAlign());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.item.hasAction()) {
            this.cm.performAction(this.item);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.item.hasAction()) {
            this.cm.show(this.item.getAction().toString());
        }
        this.active = true;
        this.stColor = this.color2;
        this.tColor = this.textOverColor;
        this.font = this.font2;
        this.mb.removeAll();
        if (this.item.hasSub()) {
            this.doAction(true);
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.cm.show("");
        this.active = false;
        this.stColor = this.color2;
        this.tColor = this.textColor;
        this.font = this.font1;
        this.repaint();
    }

    public void removeMenu() {
        if (this.item.hasSub()) {
            this.ic.stopFlag = true;
            this.cm.remove(this.ic);
        }
        if (this.item.hasSub()) {
            this.ic.removeAll();
        }
    }
}

