/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MenItem
extends Panel
implements MouseListener {
    private CascadeMenu cm;
    private String label;
    private Color color1;
    private Color color2;
    private Color stColor;
    private Color textColor;
    private Color textOverColor;
    private Color tColor;
    private Font font1;
    private Font font2;
    private Font font;
    private ItemCanvas ic;
    private boolean active;
    private ItemCanvas subIc;
    private boolean hasSub;
    private Item item;
    private Polygon p;
    private int offsetx = 20;
    private Graphics gbuf;
    private Image buf;

    public MenItem(Item item, CascadeMenu cascadeMenu, ItemCanvas itemCanvas) {
        this.ic = itemCanvas;
        this.item = item;
        this.setLayout(null);
        this.color1 = cascadeMenu.getColor("Item", 0, 0);
        this.color2 = cascadeMenu.getColor("Item", 1, 0);
        this.textColor = cascadeMenu.getColor("Item", 0, 1);
        this.textOverColor = cascadeMenu.getColor("Item", 1, 1);
        this.font1 = cascadeMenu.getFont("Item", 0);
        this.font2 = cascadeMenu.getFont("Item", 1);
        this.font = this.font1;
        this.stColor = this.color1;
        this.tColor = this.textColor;
        this.setBackground(this.stColor);
        this.label = item.getText();
        this.cm = cascadeMenu;
        this.addMouseListener(this);
        if (item.hasSub()) {
            this.giveSub(item);
        }
    }

    public void giveSub(Item item) {
        this.hasSub = true;
        this.subIc = new ItemCanvas(item.getMenuSet(), this.cm, false);
    }

    public int fontWidth() {
        FontMetrics fontMetrics = this.cm.getFontMetrics(this.font);
        return fontMetrics.stringWidth(this.label);
    }

    public int fontAlign() {
        FontMetrics fontMetrics = this.cm.getFontMetrics(this.font);
        return (this.getSize().height - fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) / 2;
    }

    public int fontCenter() {
        return this.getSize().width / 2 - this.fontWidth() / 2;
    }

    private int getBestXPosition() {
        int n;
        int n2 = this.getLocation().x + this.ic.getSize().width + this.ic.getLocation().x - 10;
        int n3 = this.subIc.getPrefferedWidth();
        if (n2 + n3 > (n = this.cm.getWidth()) - 5) {
            n2 = this.getLocation().x + this.ic.getLocation().x - n3;
        }
        return n2;
    }

    private int getBestYPosition() {
        int n;
        int n2 = this.getLocation().y + this.ic.getLocation().y - 2;
        int n3 = this.subIc.getItems() * 15 + 4;
        if (n2 + n3 > (n = this.cm.getHeight()) - 5) {
            n2 = n - n3 - 5;
        }
        return n2;
    }

    public void paint(Graphics graphics) {
        if (!this.ic.animating) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.buf == null) {
                this.buf = this.cm.createImage(n, n2);
                this.gbuf = this.buf.getGraphics();
            }
            int[] nArray = new int[]{n - 10, n - 10, n - 6};
            int[] nArray2 = new int[]{n2 / 2 - 3, n2 / 2 + 3, n2 / 2};
            this.p = new Polygon(nArray, nArray2, 3);
            this.gbuf.setFont(this.font);
            if (this.active) {
                this.gbuf.setColor(this.stColor);
                this.gbuf.fillRect(0, 0, n, n2);
            } else {
                this.gbuf.setColor(this.stColor);
                this.gbuf.fillRect(0, 0, n, n2);
            }
            this.gbuf.setColor(this.tColor);
            if (this.hasSub) {
                this.gbuf.fillPolygon(this.p);
            }
            if (this.item.getIcon() != null) {
                this.gbuf.drawImage(this.item.getIcon(), 0, n2 / 2 - 8, this);
            }
            this.gbuf.drawString(this.label, this.offsetx, this.fontAlign());
        }
        if (this.buf != null && !this.ic.animating) {
            graphics.drawImage(this.buf, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        if (!this.ic.animating) {
            this.paint(graphics);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.item.hasAction()) {
            this.cm.performAction(this.item);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.removeSubs();
        this.active = true;
        this.stColor = this.color2;
        this.tColor = this.textOverColor;
        this.font = this.font2;
        this.repaint();
        if (this.item.hasAction()) {
            this.cm.show(this.item.getAction().toString());
        }
        if (this.hasSub) {
            this.subIc.setLocation(this.getBestXPosition(), this.getBestYPosition());
            this.subIc.setSize(0, 0);
            this.cm.add(this.subIc);
            this.subIc.animate(this.subIc.getItems() * this.cm.getItemHeight() + 4);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.cm.show("");
        this.active = false;
        this.stColor = this.color1;
        this.tColor = this.textColor;
        this.font = this.font1;
        this.repaint();
    }

    public String toString() {
        return "Label: " + this.label + " Size: " + this.getBounds();
    }

    public void removeAll() {
        if (this.subIc != null) {
            this.subIc.removeAll();
            this.cm.remove(this.subIc);
        }
    }

    public void removeSubs() {
        this.ic.removeNestedSubs();
    }
}

