/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;

public class CascadeMenu
extends Applet
implements MouseListener {
    protected MenuBar mb;
    private Image logo;
    private int aw;
    private int ah;
    private int lw;
    private int lh = -2;
    private int menuBarHeight;
    private String debug = "MenuApplet";
    private MenuSet ms;
    private int itemh = 15;
    private boolean showAd;
    private int offset;
    private boolean registered;
    private boolean useAnim = false;
    private String dicon;
    private String dtarget;
    protected boolean useShadow;
    protected boolean useVert;
    protected int fontheight;

    public void init() {
        this.registered = this.checkRegistrationKey();
        this.aw = this.getSize().width;
        this.ah = this.getSize().height;
        this.setLayout(null);
        this.itemh = Integer.parseInt(this.getParameter("Item_Height"));
        this.offset = Integer.parseInt(this.getParameter("Item_Offset"));
        if (this.getParameter("Use_animation").toUpperCase().equals("YES")) {
            this.useAnim = true;
        }
        if (this.getParameter("Use_shadow").toUpperCase().equals("YES")) {
            this.useShadow = true;
        }
        if (this.getParameter("Use_vertical") != null && this.getParameter("Use_vertical").toUpperCase().equals("YES")) {
            this.useVert = true;
        }
        this.dicon = this.getParameter("Default_icon");
        this.dtarget = this.getParameter("Default_target");
        this.ms = this.getTree("Item_", true);
        this.logo = this.getImage(this.getCodeBase(), this.getParameter("bgimage"));
        this.setBackground(new Color(Integer.parseInt(this.getParameter("bgcolor"), 16)));
        this.menuBarHeight = Integer.parseInt(this.getParameter("Menubar_Height"));
        if (!this.useVert) {
            this.mb = new MenuBar(this.getWidth(), this.menuBarHeight, this.ms, this, this.registered);
            this.mb.setBounds(0, 0, this.getWidth(), this.menuBarHeight);
        } else {
            this.mb = new MenuBar(this.menuBarHeight, this.getHeight(), this.ms, this, this.registered);
            this.mb.setBounds(0, 0, this.menuBarHeight, this.getHeight());
            this.mb.setSize(this.mb.width, this.getHeight());
            this.repaint();
            this.validate();
            this.mb.repaint();
        }
        super.add(this.mb);
        this.addMouseListener(this);
    }

    public Component add(Component component) {
        super.add(component, 0);
        return component;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean useAnim() {
        return this.useAnim;
    }

    public void paint(Graphics graphics) {
        if (this.logo.getWidth(this) > 0 && this.logo != null) {
            this.lw = this.getWidth() / 2 - this.logo.getWidth(this) / 2;
            this.lh = this.getHeight() / 2 - this.logo.getHeight(this) / 2;
            graphics.drawImage(this.logo, this.lw, this.lh, this);
        } else if (this.logo != null) {
            graphics.drawImage(this.logo, this.lw, this.lh, this);
        }
    }

    public void performAction(Item item) {
        this.getAppletContext().showDocument(item.getAction(), item.getTarget());
    }

    public void show(String string) {
        this.getAppletContext().showStatus(string);
    }

    public int getWidth() {
        return this.aw;
    }

    public int getHeight() {
        return this.ah;
    }

    public Color getColor(String string, int n, int n2) {
        String string2 = n == 0 ? "Out" : "Over";
        if (string.equals("Bar")) {
            string = "Menubar";
        }
        Color color = new Color(0, 0, 0);
        try {
            if (n2 == 0) {
                color = new Color(Integer.parseInt(this.getParameter(string + "_bgcolor" + string2), 16));
            } else if (n2 == 1) {
                color = new Color(Integer.parseInt(this.getParameter(string + "_fgcolor" + string2), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    public Font getFont(String string, int n) {
        String string2 = n == 0 ? "Out" : "Over";
        if (string.equals("Bar")) {
            string = "Menubar";
        }
        Font font = new Font("TimesRoman", 0, 12);
        try {
            String string3 = this.getParameter(string + "_fontstyle" + string2);
            int n2 = Integer.parseInt(this.getParameter(string + "_fonttype" + string2));
            int n3 = Integer.parseInt(this.getParameter(string + "_fontsize" + string2));
            font = new Font(string3, n2, n3);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n4 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            if (n4 > this.fontheight) {
                this.fontheight = n4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return font;
    }

    public int getItemHeight() {
        return this.itemh;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mb.removeAll();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n > this.getWidth() - 10 || n < 10 || n2 > this.getHeight() - 10 || n2 < 10) {
            this.mb.removeAll();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    private MenuSet getTree(String string, boolean bl) {
        int n = 1;
        MenuSet menuSet = new MenuSet();
        Image image = null;
        while (this.exists(string + n)) {
            String string2;
            String string3 = string + n;
            String string4 = this.getParameter(string3 + "_Icon");
            if (string4 == null) {
                string4 = this.dicon;
            }
            if ((string2 = this.getParameter(string3 + "_Target")) == null) {
                string2 = this.dtarget;
            }
            if (string4 != null) {
                image = this.getImage(this.getCodeBase(), string4);
            }
            Item item = new Item(this.getParameter(string3 + "_Text"), this.makeURL(string3), string2, bl, image);
            if (this.exists(string + n + "_1")) {
                MenuSet menuSet2 = this.getTree(string + n + "_", false);
                item.giveSub(menuSet2);
            }
            ++n;
            menuSet.addItem(item);
        }
        return menuSet;
    }

    private URL makeURL(String string) {
        URL uRL = null;
        try {
            String string2 = this.getParameter(string + "_Action");
            if (string2 != null) {
                uRL = string2.toUpperCase().indexOf("http://") != -1 || string.toUpperCase().indexOf("https://") != -1 ? new URL(string2) : new URL(this.getDocumentBase(), string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private boolean exists(String string) {
        return this.getParameter(string + "_Text") != null;
    }

    private boolean checkRegistrationKey() {
        int n;
        int n2;
        int n3 = 13900;
        String string = this.getParameter("RegistrationKey");
        if (string == null || string.equals("") || string.equalsIgnoreCase("Unregistered")) {
            return false;
        }
        String string2 = this.getDocumentBase().getProtocol();
        String string3 = this.getDocumentBase().getHost().toUpperCase();
        if (string2.equalsIgnoreCase("file") || string3.equals("WWW.REALAPPLETS.COM") && string.equalsIgnoreCase("Demo")) {
            return true;
        }
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[4];
        try {
            n2 = 0;
            while (n2 < 6) {
                byArray[n2] = (byte)Integer.parseInt(string.substring(n2, n2 + 1), 16);
                byArray[n2 + 6] = (byte)Integer.parseInt(string.substring(n2 + 7, n2 + 8), 16);
                n2 = (byte)(n2 + 1);
            }
        }
        catch (Exception exception) {
            return false;
        }
        n2 = 0;
        while (n2 < 4) {
            byArray2[n2] = (byte)(byArray[n2 * 3] / 4 * 4 + byArray[n2 * 3 + 1] / 4);
            n2 = (byte)(n2 + 1);
        }
        if (n3 != (byArray2[0] * 2 + byArray2[1] * 3) % 16 + (byArray2[0] * 4 + byArray2[1] * 6) % 15 * 16 + (byArray2[2] * 2 + byArray2[3] * 3) % 14 * 240 + (byArray2[2] * 4 + byArray2[3] * 6) % 13 * 3360) {
            return false;
        }
        int n4 = 0;
        while (n4 < 4) {
            byArray2[n4] = 0;
            ++n4;
        }
        int n5 = 0;
        int n6 = string3.length() - 1;
        while (n6 >= 0 && n5 < 2) {
            if (string3.charAt(n6) == '.') {
                n5 = (byte)(n5 + 1);
            }
            n = -1;
            if (string3.charAt(n6) >= 'A' && string3.charAt(n6) <= 'Z') {
                n = string3.charAt(n6) - 65 + 1;
            }
            if (string3.charAt(n6) >= '0' && string3.charAt(n6) <= '9') {
                n = string3.charAt(n6) - 48 + 1;
            }
            if (n >= 0) {
                if ((string3.length() - n6) % 2 >= 1) {
                    byArray2[0] = (byte)((byArray2[0] + n) % 16);
                }
                if ((string3.length() - n6) % 4 >= 2) {
                    byArray2[1] = (byte)((byArray2[1] + n) % 16);
                }
                if ((string3.length() - n6) % 8 >= 4) {
                    byArray2[2] = (byte)((byArray2[2] + n) % 16);
                }
                if ((string3.length() - n6) % 16 >= 8) {
                    byArray2[3] = (byte)((byArray2[3] + n) % 16);
                }
            }
            --n6;
        }
        n = 0;
        while (n < 4) {
            if (byArray2[n] != byArray[n * 3 + 1] % 4 * 4 + byArray[n * 3 + 2] % 4) {
                return false;
            }
            n = (byte)(n + 1);
        }
        int n7 = 0;
        while (n7 < 4) {
            if (byArray[n7 * 3] % 4 * 4 + byArray[n7 * 3 + 2] / 4 != byArray[n7 * 3 + 1]) {
                return false;
            }
            n7 = (byte)(n7 + 1);
        }
        return true;
    }
}

