/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class TextBlock {
    private String title;
    private Vector text;
    private int rank;
    private int page;
    private int xco;
    private int yco;
    private NewsPro npro;
    int titlexco;
    boolean newLine = false;
    Group g;
    private int offset;
    String linktext;
    Vector linkPage = new Vector();
    Vector linkVector = new Vector();
    Vector linkTarget = new Vector();
    int ct = 0;
    int imgct = 0;
    Word tmp;
    boolean containslink;
    private int fontHeight;
    private int maxDescent;

    public TextBlock(String string, String string2, NewsPro newsPro, Group group) {
        this.g = group;
        if (group.isNew()) {
            group.setLastOffset(newsPro.skin.getOffset("textOffset"));
        }
        this.offset = group.getLastOffset();
        this.title = string;
        this.npro = newsPro;
        group.addRank(1);
        this.rank = group.getRank();
        this.page = group.getPages();
        this.yco = 20;
        this.titlexco = 20;
        this.fontHeight = newsPro.getFontHeight("textfont") + 2;
        this.maxDescent = newsPro.getFontDescent("textfont");
        while (string2.indexOf("<link") != -1) {
            string2 = this.extractPart("<link=", "</link>", string2);
            this.containslink = true;
        }
        while (string2.indexOf("<image") != -1) {
            string2 = this.extractImages(string2);
        }
        this.text = this.generateWords(string2);
    }

    public boolean containsLink() {
        return this.containslink;
    }

    public void drawBlock(Graphics graphics, Word word) {
        graphics.setFont(this.npro.skin.getFont("titlefont"));
        graphics.setColor(this.npro.skin.getColor("titlecolor"));
        graphics.drawString(this.getTitle(), this.titlexco, this.offset + 5);
        Enumeration enumeration = this.text.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            Word word2 = (Word)enumeration.nextElement();
            if (word2.isImage()) {
                int n = 0;
                n = word2.getW() - 5 > 8 && word2.getW() - 5 < 14 ? 10 : word2.getW() - 5;
                graphics.drawImage(this.npro.getIcon(word2.getText()), word2.getXco() + 20, word2.getYco() + this.offset - 10, n, n, this.npro);
            } else if (word2.isLink()) {
                graphics.setColor(this.npro.skin.getColor("ilinkcolor"));
                if (word != null && word2.getLink().equals(word.getLink())) {
                    graphics.setColor(this.npro.skin.getColor("alinkcolor"));
                    bl = true;
                }
            } else {
                graphics.setColor(this.npro.skin.getColor("textcolor"));
            }
            if (!word2.isImage()) {
                graphics.setFont(this.npro.skin.getFont("textfont"));
                graphics.drawString(word2.getText(), word2.getXco() + 20, word2.getYco() + this.offset);
            }
            if (!bl) continue;
            graphics.drawLine(word2.getXco() + 20, word2.getYco() + this.offset + this.maxDescent, word2.getXco() + 20 + word2.getW(), word2.getYco() + this.offset + this.maxDescent);
        }
    }

    private String extractImages(String string) {
        int n = this.getIndex("<image=\"", string);
        int n2 = this.getIndex("\">", string);
        String string2 = string.substring(n + 8, n2);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n2 + 2, string.length());
        String string5 = "";
        string5 = String.valueOf(string5) + " $$" + string2;
        string = String.valueOf(string3) + string5 + " " + string4;
        return string;
    }

    private String extractPart(String string, String string2, String string3) {
        int n = this.getIndex(string, string3);
        int n2 = this.getIndex(string2, string3);
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = string3.toUpperCase().indexOf("\">", n);
        String string4 = string3.substring(n + n3 + 1, n5);
        StringTokenizer stringTokenizer = new StringTokenizer(string4);
        string4 = stringTokenizer.nextToken();
        String string5 = "_self";
        if (stringTokenizer.hasMoreTokens()) {
            string4 = string4.substring(0, string4.length() - 1);
            string5 = stringTokenizer.nextToken();
            string5 = string5.substring(8, string5.length());
        }
        this.linktext = string3.substring(n5 + 2, n2);
        String string6 = string3.substring(0, n);
        String string7 = string3.substring(n2 + n4, string3.length());
        String string8 = "";
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.linktext);
        while (stringTokenizer2.hasMoreTokens()) {
            ++this.ct;
            this.linkPage.addElement(string4);
            this.linkTarget.addElement(string5);
            String string9 = stringTokenizer2.nextToken();
            this.linkVector.addElement(string9);
            string8 = String.valueOf(string8) + " %%" + this.ct;
        }
        string3 = String.valueOf(string6) + string8 + " " + string7;
        return string3;
    }

    private Vector generateWords(String string) {
        boolean bl = false;
        boolean bl2 = false;
        Vector<Word> vector = new Vector<Word>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            bl = false;
            bl2 = false;
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            if (this.hasBreak(string2 = string2.trim())) {
                string2 = this.removeTags(string2, "<BR>");
                this.newLine = true;
            }
            if (string2.length() <= 0) continue;
            if (this.isCode(string2)) {
                bl = true;
                string3 = string2;
                string2 = this.replaceWithWord(string2);
            }
            int n = this.npro.getFontWidth(string2) + 5;
            if (this.isImage(string2)) {
                bl2 = true;
                string3 = string2;
                n = this.npro.getFontHeight("textfont") + 5;
            }
            if (this.xco + n < this.npro.getMaxWidth() && this.yco + this.offset <= this.npro.getMaxHeight() && !this.newLine) {
                this.xco += n;
            } else {
                this.newLine = false;
                this.xco = n;
                this.yco += this.fontHeight;
                if (this.yco + this.offset > this.npro.getMaxHeight()) {
                    this.g.addPage();
                    this.page = this.g.getPages();
                    this.g.addRank(0);
                    this.rank = this.g.getRank();
                    this.offset = this.npro.skin.getOffset("textOffset");
                }
            }
            Word word = new Word(string2.trim(), this.xco - n, this.yco, n);
            if (bl) {
                word.setLink((String)this.linkPage.elementAt(this.getLinkRank(string3) - 1));
                word.setTarget((String)this.linkTarget.elementAt(this.getLinkRank(string3) - 1));
            }
            if (bl2) {
                word.setImage(true);
            }
            vector.addElement(word);
        }
        this.g.setLastOffset(this.offset + this.yco + this.fontHeight + 6);
        return vector;
    }

    public Word getActionItem() {
        return this.tmp;
    }

    private int getIndex(String string, String string2) {
        return string2.toUpperCase().indexOf(string.toUpperCase());
    }

    private int getLinkRank(String string) {
        int n = Integer.parseInt(string.substring(2, string.length()));
        return n;
    }

    public int getPage() {
        return this.page;
    }

    public int getRank() {
        return this.rank;
    }

    public String getTitle() {
        return this.title;
    }

    private boolean hasBreak(String string) {
        return string.toUpperCase().indexOf("<BR>") >= 0;
    }

    private boolean isCode(String string) {
        return string.indexOf("%%") != -1;
    }

    private boolean isImage(String string) {
        return string.indexOf("$$") != -1;
    }

    public boolean isOnLink(int n, int n2) {
        Enumeration enumeration = this.text.elements();
        while (enumeration.hasMoreElements()) {
            Word word = (Word)enumeration.nextElement();
            if (!word.isLink() || word.getXco() + 15 >= n || word.getXco() + word.getW() + 20 <= n || word.getYco() + this.offset - this.fontHeight / 2 >= n2 || word.getYco() + this.offset + this.fontHeight / 2 <= n2) continue;
            word.setActiveLink(true);
            this.tmp = word;
            return true;
        }
        return false;
    }

    private String removeTags(String string, String string2) {
        int n = this.getIndex(string2, string);
        string = String.valueOf(string.substring(0, n)) + string.substring(n + string2.length(), string.length());
        return string;
    }

    private String replaceWithWord(String string) {
        return (String)this.linkVector.elementAt(this.getLinkRank(string) - 1);
    }
}

