/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

class Group {
    protected Vector blockVector;
    private String title;
    private boolean isnew = true;
    private int nop = 1;
    private int rank;
    private int lastOffset;
    private int fontWidth;
    private int groupXco;

    public Group(String string, NewsPro newsPro) {
        this.title = string;
        this.fontWidth = newsPro.getGroupWidth(String.valueOf(string) + " (a)");
        this.groupXco = newsPro.getAppletWidth() / 2 - this.fontWidth / 2;
        this.lastOffset = newsPro.skin.getOffset("textOffset");
    }

    public void addBlocks(Vector vector) {
        this.blockVector = vector;
    }

    public void addPage() {
        ++this.nop;
    }

    public void addRank(int n) {
        this.rank = n == 0 ? 1 : ++this.rank;
    }

    public void drawGroup(int n, int n2, Graphics graphics, NewsPro newsPro, Word word) {
        Enumeration enumeration = this.blockVector.elements();
        while (enumeration.hasMoreElements()) {
            TextBlock textBlock = (TextBlock)enumeration.nextElement();
            if (textBlock.getPage() != n2 + 1 || textBlock.getRank() > n) continue;
            textBlock.drawBlock(graphics, word);
        }
        graphics.setFont(newsPro.skin.getFont("groupfont"));
        graphics.setColor(newsPro.skin.getColor("groupcolor"));
        graphics.drawString(String.valueOf(this.getTitle()) + " (" + (n2 + 1) + ")", this.groupXco, newsPro.skin.getOffset("groupOffset"));
    }

    public int getLastOffset() {
        return this.lastOffset;
    }

    public int getPages() {
        return this.nop;
    }

    public int getRank() {
        return this.rank;
    }

    public int getSize() {
        return this.blockVector.size();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasMoreOnPage(int n, int n2) {
        if (n > this.getSize()) {
            return false;
        }
        TextBlock textBlock = (TextBlock)this.blockVector.elementAt(n - 1);
        return textBlock.getRank() == n2;
    }

    public boolean hasMorePages(int n) {
        return n < this.nop;
    }

    public boolean isNew() {
        return this.isnew;
    }

    public void setLastOffset(int n) {
        this.lastOffset = n;
    }

    public void setNew(boolean bl) {
        this.isnew = bl;
    }
}

