/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class HexColorTool
extends Dialog
implements ActionListener,
WindowListener,
KeyListener {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private ColorField colorField;
    private Brightness brightField;
    private TextField hex = new TextField("808080", 6);
    private TextField tf;
    private Frame cmf;
    private Button ok = new Button("OK");
    private Canvas cc = new Canvas();
    private Button basicColors = new Button("Basic Colors -->");
    private BasicColorTable bct;
    private boolean basicVisible;
    private Color savedColor;

    public HexColorTool(Frame frame, TextField textField) {
        super(frame, "HexColorTool", true);
        this.setResizable(false);
        this.colorField = new ColorField(this);
        this.brightField = new Brightness(this);
        this.setLayout(null);
        this.tf = textField;
        this.cmf = frame;
        ((Component)this).setBackground(Color.lightGray);
        this.colorField.setBounds(20, 30, 256, 256);
        this.brightField.setBounds(280, 30, 30, 256);
        this.cc.setBounds(20, 300, 100, 25);
        this.hex.setBounds(130, 300, 50, 25);
        this.ok.setBounds(190, 300, 40, 25);
        this.basicColors.setBounds(240, 300, 100, 25);
        this.add(this.ok);
        this.add(this.basicColors);
        this.ok.addActionListener(this);
        this.basicColors.addActionListener(this);
        this.add(this.colorField);
        this.add(this.brightField);
        this.cc.setBackground(Color.gray);
        this.add(new Label("Hex Code:"));
        this.add(this.hex);
        this.add(this.cc);
        this.bct = new BasicColorTable(this);
        this.addWindowListener(this);
        this.hex.addKeyListener(this);
        this.hex.addActionListener(this);
    }

    public HexColorTool(Frame frame, Color color) {
        this(frame, new TextField());
        this.savedColor = color;
    }

    public void updateColor(Color color, boolean bl, boolean bl2) {
        this.cc.setBackground(color);
        if (bl2) {
            this.hex.setText(this.encodeToHex(color.getRGB() & 0xFFFFFF, 4));
        }
        this.cc.repaint();
        if (bl) {
            this.brightField.refresh(color);
        }
        if (bl) {
            this.brightField.repaint();
        }
        if (bl2) {
            this.colorField.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.tf.setText(this.hex.getText());
            this.dispose();
        } else if (actionEvent.getSource() == this.hex) {
            try {
                this.updateColor(this.HexToColor(this.hex.getText()), true, false);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.basicColors) {
            if (!this.basicVisible) {
                ((Component)this).setSize(this.getSize().width + 270, this.getSize().height);
                this.bct.setBounds(this.getSize().width - 270, this.getSize().height / 2 - 125, 250, 250);
                this.add(this.bct);
                this.bct.validate();
                this.basicVisible = true;
            } else {
                ((Component)this).setSize(this.getSize().width - 270, this.getSize().height);
                this.remove(this.bct);
                this.basicVisible = false;
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(19, 299, 101, 26, false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private String encodeToHex(int n, int n2) {
        char[] cArray = new char[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            cArray[--n3] = digits[n & n5];
            n >>>= n2;
        } while (n3 > 0);
        String string = new String(cArray);
        return string.substring(string.length() - 6, string.length()).toUpperCase();
    }

    private Color HexToColor(String string) {
        return new Color(Integer.parseInt(string, 16));
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            this.updateColor(this.HexToColor(this.hex.getText()), true, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

