/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;

public class ColorField
extends Canvas
implements MouseListener,
MouseMotionListener {
    private Image buf;
    private int x;
    private int y;
    private Graphics gbuf;
    private int[] colormap = new int[65025];
    private Image col = null;
    private HexColorTool hct;

    public ColorField(HexColorTool hexColorTool) {
        this.hct = hexColorTool;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        int n = 0;
        while (n < 255) {
            int n2 = 1;
            while (n2 <= 255) {
                this.colormap[n + (255 - n2) * 255] = Color.HSBtoRGB((float)n / 255.0f, (float)n2 / 255.0f, 0.75f);
                ++n2;
            }
            ++n;
        }
        this.col = this.createImage(new MemoryImageSource(255, 255, this.colormap, 0, 255));
    }

    public Color getColorAt(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.repaint();
        return new Color(this.colormap[n + n2 * 255]);
    }

    public void paint(Graphics graphics) {
        if (this.buf == null) {
            this.buf = this.createImage(this.getSize().width, this.getSize().height);
            this.gbuf = this.buf.getGraphics();
        }
        this.gbuf.drawImage(this.col, 0, 0, this);
        this.gbuf.setColor(Color.lightGray);
        this.gbuf.draw3DRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, false);
        this.gbuf.setColor(Color.black);
        this.gbuf.drawLine(this.x - 5, this.y, this.x + 5, this.y);
        this.gbuf.drawLine(this.x, this.y - 5, this.x, this.y + 5);
        graphics.drawImage(this.buf, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Color color = this.getColorAt(mouseEvent.getX(), mouseEvent.getY());
        this.hct.updateColor(color, true, true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Color color = this.getColorAt(mouseEvent.getX(), mouseEvent.getY());
        this.hct.updateColor(color, true, true);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

