/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;

public class ItemEdit
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    CMFrame cmf;
    WorkPanel wp;
    List list;
    TextField name;
    TextField action;
    TextField target;
    TextField icon;
    Label lname;
    Label laction;
    Label ltarget;
    Label licon;
    Label llist;
    Label ldepth;
    Label linfo;
    boolean adding;
    MenuSet ms;
    int level;
    int itemsadded;
    Button ok;
    Button edit;
    Button save;
    Button add;
    Button remove;
    Item[] items;
    Item currentItem;
    Item i;
    String mainhelp = "Select an item, when changed press Save. To go a level deeper press Edit";

    public ItemEdit(CMFrame cMFrame, WorkPanel workPanel, MenuSet menuSet, Item item, int n) {
        super(cMFrame, "Item Edit", true);
        if (menuSet == null) {
            menuSet = new MenuSet();
        }
        this.setLayout(null);
        this.ms = menuSet;
        this.cmf = cMFrame;
        this.level = n;
        this.wp = workPanel;
        this.addWindowListener(this);
        this.createGUI();
        this.placeGUI();
        this.extractItems();
        this.i = item;
        this.updateFields();
        if (n == 1) {
            this.remove(this.icon);
            this.remove(this.licon);
        }
    }

    private void extractItems() {
        this.ms.reset();
        this.items = new Item[100];
        int n = 0;
        while (n < this.ms.getSize()) {
            this.items[n] = this.ms.getNextItem();
            this.list.add(this.items[n].getText());
            ++n;
        }
        this.ms.reset();
    }

    private void createGUI() {
        this.ok = new Button("OK");
        this.save = new Button("Save Item");
        this.edit = new Button("Edit Sublevel");
        this.remove = new Button("Remove this");
        this.add = new Button("Add new Item");
        this.name = new TextField();
        this.action = new TextField();
        this.target = new TextField();
        this.icon = new TextField();
        this.list = new List(1, false);
        this.lname = new Label("Item Text");
        this.laction = new Label("Link");
        this.ltarget = new Label("Target Window");
        this.licon = new Label("Icon image");
        this.ldepth = new Label("Level: " + this.level);
        this.linfo = new Label(this.mainhelp);
    }

    private void placeGUI() {
        int n = 150;
        int n2 = 80;
        int n3 = 20;
        this.save.setBounds(40, 200, 120, 30);
        this.add(this.save);
        this.lname.setBounds(30, 30, n2, n3);
        this.add(this.lname);
        this.name.setBounds(120, 30, n, n3);
        this.add(this.name);
        this.laction.setBounds(30, 70, n2, n3);
        this.add(this.laction);
        this.action.setBounds(120, 70, n, n3);
        this.add(this.action);
        this.ltarget.setBounds(30, 110, n2, n3);
        this.add(this.ltarget);
        this.target.setBounds(120, 110, n, n3);
        this.add(this.target);
        this.licon.setBounds(30, 150, n2, n3);
        this.add(this.licon);
        this.icon.setBounds(120, 150, n, n3);
        this.add(this.icon);
        this.ok.setBounds(40, 280, 60, n3 + 20);
        this.add(this.ok);
        this.edit.setBounds(120, 300, 100, n3);
        this.add(this.edit);
        this.edit.setEnabled(false);
        this.add.setBounds(240, 300, 100, n3);
        this.add(this.add);
        this.add.setEnabled(true);
        this.add.addActionListener(this);
        this.remove.setBounds(360, 300, 100, n3);
        this.add(this.remove);
        this.remove.setEnabled(true);
        this.remove.addActionListener(this);
        this.list.setBounds(300, 30, 100, 200);
        this.list.addItemListener(this);
        this.ldepth.setBounds(300, 250, n2, n3);
        this.add(this.ldepth);
        this.linfo.setBounds(30, 330, 400, n3);
        this.add(this.linfo);
        this.save.addActionListener(this);
        this.ok.addActionListener(this);
        this.edit.addActionListener(this);
        this.add(this.list);
        this.list.select(0);
    }

    private void updateFields() {
        this.name.setEnabled(true);
        this.target.setEnabled(true);
        this.edit.setEnabled(true);
        this.action.setEnabled(true);
        this.icon.setEnabled(true);
        this.save.setEnabled(true);
        this.name.setText("");
        this.action.setText("");
        this.target.setText("");
        this.icon.setText("");
        if (this.list.getItemCount() > 0) {
            this.edit.setEnabled(true);
            this.currentItem = this.items[this.list.getSelectedIndex()];
            this.name.setText(this.currentItem.getText());
            String string = this.currentItem.getURLName();
            if (string != null) {
                this.action.setText(string);
            }
            this.target.setText(this.currentItem.getTarget());
            Image image = this.currentItem.getIcon();
            if (image != null) {
                this.icon.setText(this.currentItem.getImageName());
            }
            System.out.println("Icon:" + this.currentItem.getImageName());
        } else {
            this.save.setEnabled(false);
            this.name.setEnabled(false);
            this.target.setEnabled(false);
            this.edit.setEnabled(false);
            this.action.setEnabled(false);
            this.icon.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateFields();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.saveAll();
            this.dispose();
        } else if (actionEvent.getSource() == this.edit) {
            ItemEdit itemEdit = new ItemEdit(this.cmf, this.wp, this.items[this.list.getSelectedIndex()].getMenuSet(), this.items[this.list.getSelectedIndex()], this.level + 1);
            ((Component)itemEdit).setSize(500, 400);
            ((Component)itemEdit).setVisible(true);
        } else if (actionEvent.getSource() == this.save) {
            this.saveItem();
        } else if (actionEvent.getSource() == this.remove) {
            this.deleteItem();
        } else if (actionEvent.getSource() == this.add) {
            this.addItem();
        }
    }

    private void saveItem() {
        boolean bl = false;
        if (this.level == 1) {
            bl = true;
        }
        URL uRL = null;
        Image image = null;
        if (this.level > 1 && this.icon.getText().length() < 1 && this.wp.defaulticon.getText().length() > 1) {
            this.icon.setText(this.wp.defaulticon.getText());
        }
        if (this.target.getText().length() < 1 && this.wp.defaulttarget.getText().length() > 1) {
            this.target.setText(this.wp.defaulttarget.getText());
        }
        if (this.icon.getText().length() > 3) {
            image = this.cmf.cme.getImage(this.cmf.cme.getCodeBase(), this.icon.getText());
        }
        try {
            uRL = new URL(this.action.getText());
        }
        catch (Exception exception) {
            try {
                uRL = new URL(this.cmf.cme.getCodeBase(), this.action.getText());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (this.action.getText().length() < 1) {
            uRL = null;
        }
        if (!this.adding) {
            MenuSet menuSet = this.items[this.list.getSelectedIndex()].getMenuSet();
            this.items[this.list.getSelectedIndex()] = new Item(this.name.getText(), uRL, this.target.getText(), bl, image);
            this.items[this.list.getSelectedIndex()].setImageName(this.icon.getText());
            this.items[this.list.getSelectedIndex()].setURLName(this.action.getText());
            this.items[this.list.getSelectedIndex()].giveSub(menuSet);
            this.ms.replaceItem(this.currentItem.getText(), this.items[this.list.getSelectedIndex()]);
            this.list.replaceItem(this.name.getText(), this.list.getSelectedIndex());
        }
        if (this.adding) {
            this.items[this.list.getItemCount()] = new Item(this.name.getText(), uRL, this.target.getText(), bl, image);
            this.items[this.list.getItemCount()].setImageName(this.icon.getText());
            this.items[this.list.getItemCount()].setURLName(this.action.getText());
            this.ms.addItem(this.items[this.list.getItemCount()]);
            this.list.add(this.items[this.list.getItemCount()].getText());
        }
        this.adding = false;
        this.list.requestFocus();
        this.list.select(0);
    }

    private void deleteItem() {
        if (this.level > 1) {
            int n = this.list.getSelectedIndex();
            this.items[n] = null;
            this.list.replaceItem("REMOVED", n);
        } else {
            int n = this.list.getSelectedIndex();
            this.ms.removeItem(this.items[n].getText());
            this.items[n] = null;
            this.list.replaceItem("REMOVED", n);
        }
        this.list.requestFocus();
        this.list.select(0);
    }

    private void addItem() {
        this.name.setEnabled(true);
        this.target.setEnabled(true);
        this.edit.setEnabled(true);
        this.action.setEnabled(true);
        this.icon.setEnabled(true);
        this.save.setEnabled(true);
        ++this.itemsadded;
        this.name.setText("New Item" + this.itemsadded);
        this.target.setText("");
        this.action.setText("");
        this.icon.setText("");
        this.adding = true;
        this.list.select(this.list.getItemCount());
    }

    private void saveAll() {
        if (this.level > 1) {
            MenuSet menuSet = new MenuSet();
            int n = 0;
            while (n < this.list.getItemCount()) {
                if (this.items[n] != null) {
                    menuSet.addItem(this.items[n]);
                }
                System.out.println("Newms got: " + this.items[n]);
                ++n;
            }
            if (menuSet.getSize() > 0) {
                this.i.giveSub(menuSet);
            } else {
                this.i.giveSub(null);
            }
            System.out.println("Item " + this.i + " got " + menuSet);
        }
        this.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

