/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;

public class Brightness
extends Canvas
implements MouseMotionListener,
MouseListener {
    private final int HEIGHT = 256;
    private final int WIDTH = 30;
    private int[] colormap = new int[7680];
    private Image col_img = null;
    private Image buf;
    private Graphics gbuf;
    private HexColorTool hct;
    private int mouseY = 0;
    private int prevY = 0;

    public Brightness(HexColorTool hexColorTool) {
        this.hct = hexColorTool;
        this.setBackground(Color.lightGray);
        int n = 0;
        while (n < 30) {
            int n2 = 1;
            while (n2 <= 256) {
                this.colormap[n + (256 - n2) * 30] = Color.HSBtoRGB(0.0f, 0.0f, (float)n2 / 256.0f);
                ++n2;
            }
            ++n;
        }
        this.col_img = this.createImage(new MemoryImageSource(30, 256, this.colormap, 0, 30));
        this.mouseY = 128;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void refresh(Color color) {
        int n;
        int n2 = 0;
        while (n2 < 30) {
            n = 1;
            while (n <= 128) {
                this.colormap[n2 + n * 30] = 0xFF000000 | n * 2 * (color.getRed() - 255) / 256 + 255 << 16 | n * 2 * (color.getGreen() - 255) / 256 + 255 << 8 | n * 2 * (color.getBlue() - 255) / 256 + 255;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 30) {
            int n3 = 128;
            while (n3 < 256) {
                this.colormap[n + n3 * 30] = 0xFF000000 | color.getRed() * 2 * (256 - n3) / 256 << 16 | color.getGreen() * 2 * (256 - n3) / 256 << 8 | color.getBlue() * 2 * (256 - n3) / 256;
                ++n3;
            }
            ++n;
        }
        this.col_img = this.createImage(new MemoryImageSource(30, 256, this.colormap, 0, 30));
        this.mouseY = 128;
        this.repaint();
    }

    public Color getColorAt(int n, int n2) {
        return new Color(this.colormap[n + n2 * 30]);
    }

    public Color getColor() {
        return new Color(this.colormap[this.mouseY * 30]);
    }

    public void setCursor(int n) {
        this.mouseY = n;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Color color = this.getColorAt(n, n2);
        this.hct.updateColor(color, false, false);
        this.setCursor(n2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Color color = this.getColorAt(mouseEvent.getX(), mouseEvent.getY());
        this.hct.updateColor(color, false, true);
        this.setCursor(mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.buf == null) {
            this.buf = this.createImage(n, n2);
            this.gbuf = this.buf.getGraphics();
        }
        this.gbuf.setColor(Color.lightGray);
        this.gbuf.fillRect(0, 0, n, n2);
        int[] nArray = new int[]{0, 5, 0};
        int[] nArray2 = new int[]{this.mouseY - 5, this.mouseY, this.mouseY + 5};
        this.gbuf.setColor(Color.black);
        this.gbuf.fillPolygon(nArray, nArray2, 3);
        this.gbuf.drawImage(this.col_img, 5, 0, this);
        this.gbuf.setColor(Color.lightGray);
        this.gbuf.draw3DRect(0, 0, n - 1, n2 - 1, false);
        graphics.drawImage(this.buf, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

