/**
Menu Applet 1.0
Copyright (C) 1998  Mihai Munteanu

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me at:

* http://www.obs-us.com/people/mihai
* e-mail:  m.munteanu@shef.ac.uk   or   mmm@deltanet.roknet.ro
* Mihai Munteanu
  str. M.Eminescu 44
  2200 Brasov, ROMANIA
* fax: +40 (0)68 410330
*/

import java.awt.*;
import java.net.*;
import java.applet.*;
import java.io.*;

public	class MenuApplet extends Applet {


	int menuSize; 		//The maximum size of the menu and submenu
	int maxSizeFound;	//The maximum size of the menu and submenu found after scaning the ini file
	int itemsNr = 0;	//the number of menu items
	int[] subItemsNr;	//the number of submenu items

	String[] webAddress;	//the url of every submenu item

	URL base;		//the base url of the applet
	String targetWindow;	//the window that will display the document
	
	int selectedItem;

	LabelButton[] menuItem;
	Panel[] subMenuPanel;

	LabelButton[] subMenuItem;
	Panel[] emptyPanel;

	int emptyPanelCount;
	
	LabelButton select, goTo;

	Panel panelLeft, panelRight, panelMenu, panelSubMenu;

	LabelButton hide, empty;

	String fontType; //sets the font type
	String fontStyle;//sets the font style
	int fSt; 	//sets the font style, afret pasrsing hte fontStyle 
			//0-plain,1-bold,2-italic,3-bold+italic

  public void init() {		
		
	targetWindow = getParameter("targetWindow");
	if(targetWindow==null){
		 targetWindow = "_self";
	}

	fontType = getParameter("fontType");
	if(fontType == null){
		 fontType = "Helvetica";
	}


	fontStyle = getParameter("fontStyle");
	if (fontStyle != null){
		try{
			fSt = Integer.parseInt(fontStyle);

			if(fSt<0 || fSt>3){
				fSt = 0;
			}
		}catch(NumberFormatException e){
			fSt = 0;
		}
	}
	else{
		 fSt = 0;
	}


	menuSize=20;
	maxSizeFound=0;
	menuItem = new LabelButton[menuSize];
	subItemsNr = new int[menuSize];

	subMenuItem = new LabelButton[menuSize*menuSize];
	webAddress = new String[menuSize*menuSize];

	base = getCodeBase();


	readIniFile();


	selectedItem=0;

	subMenuPanel = new Panel[menuSize];

	emptyPanel = new Panel[menuSize*menuSize];
	emptyPanelCount=0;

	setLayout(new BorderLayout());

	panelLeft = new Panel();
	panelLeft.setBackground(new Color(230, 230, 230));
	panelLeft.setLayout(new BorderLayout());
	panelSubMenu = new Panel();
        panelSubMenu.setLayout(new CardLayout());

	for(int i = 0; i<menuSize; i++){
		subMenuPanel[i]=new Panel();
		subMenuPanel[i].setLayout(new GridLayout(0,1));
	}

	select = new LabelButton("Select:", 0, 0, 0, 255, 255, 255, fontType, fSt);
	goTo   = new LabelButton("Go to:", 0, 0, 0, 255, 255, 255, fontType, fSt);
	select.setLightColor( 0, 0, 0);

	goTo.setLightColor( 0, 0, 0);


	panelRight = new Panel();
	panelRight.setBackground(new Color(255, 255, 255));
	panelRight.setLayout(new BorderLayout());
	panelMenu = new Panel();
        panelMenu.setLayout(new GridLayout(0,1));
	


	for(int i = 0; i<maxSizeFound; i++){
		if(i<itemsNr){
			panelMenu.add(menuItem[i]);
		}
		else{
			emptyPanel[emptyPanelCount] = new Panel();
			panelMenu.add(emptyPanel[emptyPanelCount]);
			emptyPanelCount++;
		}


		panelSubMenu.add(String.valueOf(i), subMenuPanel[i]);

		for(int j =(menuSize*i); j<((menuSize*i)+maxSizeFound); j++){

			if(j<menuSize*i+subItemsNr[i]){
				subMenuPanel[i].add(subMenuItem[j]);
			}
			else{
				emptyPanel[emptyPanelCount] = new Panel();
				subMenuPanel[i].add(emptyPanel[emptyPanelCount]);
				emptyPanelCount++;
			}
		}
		menuItem[0].setbkColor(230, 230, 230);
		menuItem[0].setLightColor(230, 230, 230);
	}


	select.disable();
	goTo.disable();

	panelRight.add("North", select);
	panelRight.add("Center",panelMenu);

	panelLeft.add("North", goTo);
	panelLeft.add("Center", panelSubMenu);

	add("West", panelRight);
	add("Center", panelLeft);

	validate();
  }



  public void readIniFile(){
	
	for(int i =0; i<menuSize; i++) subItemsNr[i]=0;
	
	try{
		URL iniFile = new URL(getCodeBase(), "MenuApplet.ini");
		DataInputStream dis= new DataInputStream(iniFile.openStream());

		String inputLine;

		while((inputLine = dis.readLine()) != null){
		  if (inputLine.length()>0){

			StringBuffer labelItem = new StringBuffer();
			StringBuffer urlItem = new StringBuffer();

			boolean name=false;
			boolean url=false;
			boolean urlEnd=false;

			if(inputLine.charAt(0)=='+'){
				name=true;
				for(int i=1; i<inputLine.length(); i++){
					if(inputLine.charAt(i)=='+') name=false;
					if(name){
						labelItem.append(inputLine.charAt(i));
					}
				}
				menuItem[itemsNr]= new LabelButton(labelItem.toString(), 255, 255, 255, 0, 0, 0, fontType, fSt);
				menuItem[itemsNr].setFgLightColor(0,0,255);
				menuItem[itemsNr].setMouseDownFgColor(255,0,0);
				itemsNr++;
				if(itemsNr>maxSizeFound) maxSizeFound=itemsNr;
			}


			if(inputLine.charAt(0)=='\\'){
				name=true;

				for(int i=1; i<(inputLine.length()-1); i++){
					if((inputLine.charAt(i)=='\\')) name=false;

					if(name){
						labelItem.append(inputLine.charAt(i));
					}
					else if((inputLine.charAt(i)=='\"') && (url==false) && (urlEnd==false)) url=true;
					else if((inputLine.charAt(i+1)=='\"') && (url==true) && (urlEnd==false)) urlEnd=true;
					if((url)&&(urlEnd==false)){
						urlItem.append(inputLine.charAt(i+1));
					}

				}


				subMenuItem[menuSize*(itemsNr-1)+subItemsNr[itemsNr-1]]= new LabelButton(labelItem.toString(), 230, 230, 230, 0, 0, 0, fontType, fSt);
				subMenuItem[menuSize*(itemsNr-1)+subItemsNr[itemsNr-1]].setLightColor(230,230,230);
				subMenuItem[menuSize*(itemsNr-1)+subItemsNr[itemsNr-1]].setFgLightColor(0,0,255);
				subMenuItem[menuSize*(itemsNr-1)+subItemsNr[itemsNr-1]].setMouseDownFgColor(255,0,0);
				webAddress[menuSize*(itemsNr-1)+subItemsNr[itemsNr-1]]= new String(urlItem.toString());
				subItemsNr[itemsNr-1]++;
				if(subItemsNr[itemsNr-1]>maxSizeFound) maxSizeFound=subItemsNr[itemsNr-1];
			}


		    }//end of first if
		}//end of while
		dis.close();

	}catch(MalformedURLException e){
		System.out.println(e);
	}catch(IOException e){
		System.out.println(e);
	}

  }



  public boolean action(Event e, Object arg){
    Object target = e.target;

	for(int i=0; i<menuSize; i++){
	   if(target == this.menuItem[i]){

		if(i!=selectedItem){
			menuItem[i].setbkColor(230, 230, 230);
			menuItem[i].setLightColor(230, 230, 230);
			menuItem[i].setfgColor(0, 0, 0);
			menuItem[selectedItem].setbkColor(255,255,255);
			menuItem[selectedItem].setLightColor(255,255,255);
			menuItem[selectedItem].setfgColor(0,0,0);
			selectedItem=i;
		}
		((CardLayout)panelSubMenu.getLayout()).show(panelSubMenu, String.valueOf(i));
	   	return true;
	   }
    	}

 
	for(int i=0; i<menuSize*menuSize; i++){
	    if(target == this.subMenuItem[i]){

		//subMenuItem[i].setfgColor(0,150,255);
		//subMenuItem[i].setFgLightColor(0,150,255);

		URL theUrl = null;
		try{
			if((webAddress[i].charAt(0)=='h')&&
			   (webAddress[i].charAt(1)=='t')&&
			   (webAddress[i].charAt(2)=='t')&&
			   (webAddress[i].charAt(3)=='p')&&
			   (webAddress[i].charAt(4)==':')&&
			   (webAddress[i].charAt(5)=='/')&&
			   (webAddress[i].charAt(6)=='/')){

				theUrl = new URL(webAddress[i]);
			}
			else{
				theUrl = new URL(base, webAddress[i]);
			}

		}catch(MalformedURLException exp){
			System.out.println(exp);
		}

			getAppletContext().showDocument(theUrl, targetWindow);

	      return true;
    	    }
	}

   return true;
  }

}
