/**
Label Button 0.1
Copyright (C) 1998  Mihai Munteanu

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me at:

* http://www.obs-us.com/people/mihai
* e-mail:  m.munteanu@shef.ac.uk   or   mmm@deltanet.roknet.ro
* Mihai Munteanu
  str. M.Eminescu 44
  2200 Brasov, ROMANIA
* fax: +40 (0)68 410330
*/


import java.awt.*;
import java.net.*;


public class LabelButton extends Canvas {

  
	private boolean mouseIsDown = false;
	private boolean mouseIsOver = false;
	public String labelText;
	private Color bkColor, bkLightColor, fgColor, fgLightColor, mouseDownFgColor, tempColor;
	public int LX=3, LY=13;
	private int labelX, labelY;
	Font FontKind;


//  constructors

	public LabelButton() {
		super();
		FontKind = new Font("Helvetica", Font.BOLD, 12);
		labelText = "button";
		resize((7*labelText.length()+6),18);
		bkColor= new Color(204,204,204);
		bkLightColor= new Color(51,51,51);
		fgColor= new Color(0,0,0);
		fgLightColor= new Color(0,0,0);
		mouseDownFgColor = fgLightColor;
		this.setBackground(bkColor);
		tempColor=fgColor;
		labelX=LX;
		labelY=LY;

	}

	public LabelButton(String lab) {
		super();
		FontKind = new Font("Helvetica", Font.BOLD, 12);
		labelText = lab;
		resize((7*labelText.length()+6),18);
		bkColor= new Color(204,204,204);
		bkLightColor= new Color(51,51,51);
		fgColor= new Color(0,0,0);
		fgLightColor= new Color(0,0,0);
		mouseDownFgColor = fgLightColor;
		this.setBackground(bkColor);
		tempColor=fgColor;
		labelX=LX;
		labelY=LY;

	}

	public LabelButton(String lab, int r, int g, int b) {
		super();
		FontKind = new Font("Helvetica", Font.BOLD, 12);
		labelText = lab;
		bkColor= new Color(r, g, b );
		bkLightColor=setLtColor(r,g,b);
		fgColor= new Color(0,0,0);
		fgLightColor= new Color(0,0,0);
		mouseDownFgColor = fgLightColor;
		resize((7*labelText.length()+6),18);
		this.setBackground(bkColor);
		tempColor=fgColor;
		labelX=LX;
		labelY=LY;
	}


	public LabelButton(String lab, int r, int g, int b, int fr, int fg, int fb) {
		super();
		FontKind = new Font("Helvetica", Font.BOLD, 12);
		labelText = lab;
		bkColor= new Color(r, g, b );
		bkLightColor=setLtColor(r,g,b);
		fgColor= new Color(fr,fg,fb);
		fgLightColor= new Color(fr,fg,fb);
		mouseDownFgColor = fgLightColor;
		resize((7*labelText.length()+6),18);
		this.setBackground(bkColor);
		tempColor=fgColor;
		labelX=LX;
		labelY=LY;
	}


	public LabelButton(String lab, int r, int g, int b, int fr, int fg, int fb, String fntt, int fnts) {
		super();
		FontKind = new Font(fntt, fnts, 12);
		labelText = lab;
		bkColor= new Color(r, g, b );
		bkLightColor=setLtColor(r,g,b);
		fgColor= new Color(fr,fg,fb);
		fgLightColor= new Color(fr,fg,fb);
		mouseDownFgColor = fgLightColor;
		resize((7*labelText.length()+6),18);
		this.setBackground(bkColor);
		tempColor=fgColor;
		labelX=LX;
		labelY=LY;
	}



  private Color setLtColor(int r, int g, int b){
	if(r<204)
		r=r+51;
	else
		r=255;


	if(g<205)
		g=g+51;
	else
		g=255;

	if(b<205)
		b=b+51;
	else
		b=255;

	return(new Color(r,g,b));
  }




  public void paint(Graphics g) {
	g.setColor(tempColor);
	g.setFont(FontKind);
	g.drawString(labelText,labelX,labelY);
  }


  public boolean mouseDown(Event event, int x, int y) {
    mouseIsDown = true;
    mouseIsOver = true;
	labelX=LX+1;
	labelY=LY+1;
	tempColor=mouseDownFgColor;
	repaint();
    return(true);
  }


  public boolean mouseEnter(Event event, int x, int y) {
    mouseIsOver = true;
	labelX=LX;
	labelY=LY;
	tempColor=fgLightColor;
	this.setBackground(bkLightColor);
      repaint();
    return(true);
  }



  public boolean mouseUp(Event event, int x, int y) {
    mouseIsDown = false;

    if (inside(x,y)) {

    mouseIsOver = true;
	labelX=LX;
	labelY=LY;
	tempColor=fgLightColor;
      repaint();
      event.id = Event.ACTION_EVENT;
      return(action(event, event.arg));

    } else
      return(false);
  }



  public boolean mouseExit(Event event, int x, int y) {
      mouseIsOver = false;
	labelX=LX;
	labelY=LY;
	this.setBackground(bkColor);
      	tempColor=fgColor;
      repaint();
      return(true);
  }

  public void setbkColor(int r, int g, int b){
		bkColor= new Color(r, g, b );
		bkLightColor=setLtColor(r,g,b);
		this.setBackground(bkColor);
  }

  public void setfgColor(int r, int g, int b){
		fgColor= new Color(r, g, b );
		repaint();
  }

  public void setLightColor(int r, int g, int b){
		bkLightColor= new Color(r, g, b );
		repaint();
  }

  public void setFgLightColor(int r, int g, int b){
		fgLightColor= new Color(r, g, b );
		repaint();
  }


  public void setMouseDownFgColor(int r, int g, int b){
		mouseDownFgColor= new Color(r, g, b );
		repaint();
  }


}
