import java.applet.*;
import java.awt.*;
import java.awt.image.*;
import java.net.*;


public class ImageAudio extends Applet implements ImageObserver
{
	private String m_image = "";
	private String m_audio = "";
	private String m_url = "";
	private int m_X = -1;
	private int m_Y = -1;
	private int m_w = 0;
	private int m_h = 0;
	private Color m_color = Color.yellow;
	private Graphics m_graphics;
    
	private final String PARAM_image = "image";
	private final String PARAM_audio = "audio";
	private final String PARAM_X = "X";
	private final String PARAM_Y = "Y";
	private final String PARAM_width = "w";
	private final String PARAM_height = "h";
	private final String PARAM_color = "color";
	private final String PARAM_url = "url";


	private Image img;
	private AudioClip sound;
 	public ImageAudio()
	{
	}

	public String getAppletInfo()
	{
		return "Name: ImageAudio\r\n" +
		       "Author: Geetha Kathiawadi\r\n" ;
	}

	public String[][] getParameterInfo()
	{
		String[][] info =
		{
			{ PARAM_image, "String", "Image file" },
			{ PARAM_audio, "String", "Audio file" },
			{ PARAM_X, "String", "X" },
			{ PARAM_Y, "String", "Y" },
			{ PARAM_width, "String", "width" },
			{ PARAM_height, "String", "Height" },
			{ PARAM_color, "String", "Color" },
			{ PARAM_url, "String", "url" },
		};
		return info;		
	}

	public void init()
	{
		String param;

		param = getParameter(PARAM_image);
		if (param != null)
			m_image = param;
		try{
			img = getImage(getDocumentBase(), m_image);
		}
		catch (Exception e) {
		   		   
		}

		param = getParameter(PARAM_audio);
		if (param != null)
			m_audio = param;

		param = getParameter(PARAM_url);
		if (param != null)
			m_url = param;

		param = getParameter(PARAM_X);
		if (param != null)
			try{m_X = Integer.parseInt(param);}
		catch(NumberFormatException e){}

		param = getParameter(PARAM_Y);
		if (param != null)
			try{m_Y = Integer.parseInt(param);}
		catch(NumberFormatException e){}

		param = getParameter(PARAM_width);
		if (param != null)
			try{m_w = Integer.parseInt(param);}
		catch(NumberFormatException e){}

		param = getParameter(PARAM_height);
		if (param != null)
			try{m_h = Integer.parseInt(param);}
		catch(NumberFormatException e){}

		param = getParameter(PARAM_color);
		if (param != null)
			m_color = new Color(Integer.parseInt(param));
	}


	public void destroy()
	{
	}

	public void paint(Graphics g)
	{
		g.drawImage(img,0,0,this);
	}




	public boolean mouseEnter(Event evt, int x, int y)
	{
		playAudio();
		m_graphics=getGraphics();
		m_graphics.setColor(m_color);
		m_graphics.drawOval(m_X,m_Y,m_w,m_h);
		return true;
	}

	public boolean mouseExit(Event evt, int x, int y)
	{
		sound.stop();
		getGraphics().drawImage(img,0,0,this);
		return true;
	}
    public void drawImage(Graphics g, Image img, int imgx, int imgy,
			  int x, int y, int w, int h) {
	Graphics ng = g.create();
	ng.clipRect(x, y, w, h);
	ng.drawImage(img, imgx, imgy, this);
    }
	public void playAudio()
	{
	try {
		sound = getAudioClip(getCodeBase(), m_audio);
		}
	catch (Exception e) {
		}
	sound.play();  
	}

	public boolean mouseDown(Event evt, int x, int y)
	{
	URL theUrl;
    	if (m_url != ""){
	try {
        theUrl = new URL(getDocumentBase(), m_url);
        getAppletContext().showDocument(theUrl,"_self");
    	}
    catch (MalformedURLException e)
    {
    }
	}
		return true;
	}


}
