/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

import com.ibm.clock.TimerListener;
import com.ibm.clock.TimerSupport;

class Timer
implements Runnable {
    public static final long DEFAULT_TICKING_FREQUENCY = 1000L;
    private long tickingFrequency = 1000L;
    private TimerSupport timerSupport;
    private Thread timerThread;
    private static final boolean DEBUG = true;

    private TimerSupport getTimerSupport() {
        if (this.timerSupport == null) {
            this.timerSupport = new TimerSupport(this);
        }
        return this.timerSupport;
    }

    synchronized long getTickingFrequency() {
        return this.tickingFrequency;
    }

    synchronized void setTickingFrequency(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        this.tickingFrequency = l;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.getTickingFrequency());
            }
            catch (InterruptedException interruptedException) {}
            this.getTimerSupport().fireTimeChangedEvent();
        }
    }

    private Thread getTimerThread() {
        if (this.timerThread == null) {
            this.timerThread = new Thread(this);
        }
        return this.timerThread;
    }

    public synchronized void startTicking() {
        try {
            Thread thread = this.getTimerThread();
            thread.start();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            Timer.debug(illegalThreadStateException.toString());
            return;
        }
    }

    public synchronized void stopTicking() throws SecurityException {
        this.getTimerThread().stop();
    }

    public void addTimerListener(TimerListener timerListener) {
        this.getTimerSupport().addTimerListener(timerListener);
    }

    public void removeTimerListener(TimerListener timerListener) {
        this.getTimerSupport().removeTimerListener(timerListener);
    }

    private static final void debug(String string) {
        System.out.println("Timer::" + string);
    }

    Timer() {
    }
}

