/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

public class Time {
    public static final int HOURS_IN_DAY = 24;
    public static final int MINUTES_IN_HOUR = 60;
    public static final int SECONDS_IN_MINUTE = 60;
    protected static final long MILLISECONDS_IN_DAY = 86400000L;
    protected static final long MILLISECONDS_IN_HOUR = 3600000L;
    protected static final long MILLISECONDS_IN_MINUTE = 60000L;
    protected static final long MILLISECONDS_IN_SECOND = 1000L;
    private long time;

    public Time() {
        this(0L);
    }

    protected Time(long l) throws IllegalArgumentException {
        this.setInMillis(l);
    }

    public Time(int n, int n2, int n3) {
        if (!(this.isProperHour(n) && this.isProperMinute(n2) && this.isProperSecond(n3))) {
            throw new IllegalArgumentException();
        }
        this.setInMillis(this.computeTime(n, n2, n3));
    }

    protected synchronized void setInMillis(long l) throws IllegalArgumentException {
        if (!this.isProperTime(l)) {
            throw new IllegalArgumentException();
        }
        this.time = l;
    }

    public long getInMillis() {
        return this.time;
    }

    public int getHour() {
        return (int)(this.getInMillis() / 3600000L);
    }

    public synchronized void setHour(int n) throws IllegalArgumentException {
        if (!this.isProperHour(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getMinute();
        int n3 = this.getSecond();
        this.setInMillis(this.computeTime(n, n2, n3));
    }

    public int getMinute() {
        long l = this.getInMillis() % 3600000L;
        return (int)(l / 60000L);
    }

    public void setMinute(int n) {
        if (!this.isProperMinute(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getHour();
        int n3 = this.getSecond();
        this.setInMillis(this.computeTime(n2, n, n3));
    }

    public int getSecond() {
        long l = this.getInMillis() % 60000L;
        return (int)(l / 1000L);
    }

    public void setSecond(int n) {
        if (!this.isProperSecond(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getHour();
        int n3 = this.getMinute();
        this.setInMillis(this.computeTime(n2, n3, n));
    }

    private boolean isProperTime(long l) {
        return l >= 0L && l < 86400000L;
    }

    private boolean isProperHour(int n) {
        return n >= 0 && n < 24;
    }

    private boolean isProperMinute(int n) {
        return n >= 0 && n < 60;
    }

    private boolean isProperSecond(int n) {
        return n >= 0 && n < 60;
    }

    private long computeTime(int n, int n2, int n3) {
        return (long)n * 3600000L + (long)n2 * 60000L + (long)n3 * 1000L;
    }
}

