/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

import com.ibm.clock.AnalogDisplay;
import com.ibm.clock.ClockDisplay;
import com.ibm.clock.ClockRefresher;
import com.ibm.clock.DigitalDisplay;
import com.ibm.clock.Time;
import com.ibm.clock.Timer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class IClock
extends Panel
implements Serializable,
PropertyChangeListener {
    public static final int ANALOG = 4;
    public static final int DIGITAL = 5;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private transient PropertyChangeSupport changesNotifier;
    private transient PropertyChangeListener propertyChangeListener;
    private DigitalDisplay digitalDisplay;
    private transient Timer timer;
    private transient ClockRefresher refresher;
    private int displayMode = 5;
    private long timeOffset;
    private TimeZone currentTimeZone;
    private transient Calendar calendar;
    private AnalogDisplay analogDisplay;
    private transient ClockDisplay clockDisplay;
    private transient boolean clockStarted = false;
    private transient boolean inConstructor = true;
    private static final boolean DEBUG = false;

    public IClock() {
        super.setLayout(new BorderLayout());
        this.setDisplayMode(4);
        this.start();
        this.inConstructor = false;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void start() {
        if (this.clockStarted) {
            return;
        }
        this.getTimer().addTimerListener(this.getRefresher());
        this.getTimer().startTicking();
        this.clockStarted = true;
    }

    public void stop() throws SecurityException {
        if (!this.clockStarted) {
            return;
        }
        this.getTimer().stopTicking();
        this.getTimer().removeTimerListener(this.getRefresher());
        this.timer = null;
        this.clockStarted = false;
    }

    private ClockRefresher getRefresher() {
        if (this.refresher == null) {
            this.refresher = new ClockRefresher(this);
        }
        return this.refresher;
    }

    private DigitalDisplay getDigitalDisplay() {
        if (this.digitalDisplay == null) {
            this.digitalDisplay = new DigitalDisplay();
            this.digitalDisplay.addPropertyChangeListener(this);
        }
        return this.digitalDisplay;
    }

    private AnalogDisplay getAnalogDisplay() {
        if (this.analogDisplay == null) {
            this.analogDisplay = new AnalogDisplay();
            this.analogDisplay.addPropertyChangeListener(this);
        }
        return this.analogDisplay;
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        return this.timer;
    }

    public TimeZone getTimeZone() {
        if (this.currentTimeZone == null) {
            this.currentTimeZone = TimeZone.getDefault();
        }
        return this.currentTimeZone;
    }

    public void setTimeZone(TimeZone timeZone) throws IllegalArgumentException {
        if (timeZone == null) {
            throw new IllegalArgumentException();
        }
        if (timeZone.equals(this.getTimeZone())) {
            return;
        }
        this.currentTimeZone = timeZone;
        this.getDigitalDisplay().setTimeZone(this.currentTimeZone);
        this.invalidateCalendar();
    }

    private void invalidateCalendar() {
        this.calendar = null;
    }

    private Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.getTimeZone());
        }
        return this.calendar;
    }

    public void setTime(Time time) throws IllegalArgumentException {
        if (time == null) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis();
        Calendar calendar = this.getCalendar();
        calendar.setTime(new Date(l));
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        Time time2 = new Time(n, n2, n3);
        this.setTimeOffset(time.getInMillis() - time2.getInMillis());
    }

    private long getTimeOffset() {
        return this.timeOffset;
    }

    private void setTimeOffset(long l) {
        this.timeOffset = l;
    }

    void refresh() {
        IClock iClock = this;
        synchronized (iClock) {
            Time time = this.getTime();
            this.getClockDisplay().setTime(time.getHour(), time.getMinute(), time.getSecond());
            return;
        }
    }

    private ClockDisplay getClockDisplay() {
        if (this.clockDisplay == null) {
            switch (this.getDisplayMode()) {
                case 5: {
                    this.clockDisplay = this.getDigitalDisplay();
                    break;
                }
                case 4: {
                    this.clockDisplay = this.getAnalogDisplay();
                    break;
                }
            }
        }
        return this.clockDisplay;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getPropertyChangeNotifier().firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public Time getTime() {
        Calendar calendar = this.getCalendar();
        long l = System.currentTimeMillis();
        long l2 = l + this.getTimeOffset();
        calendar.setTime(new Date(l2));
        Time time = new Time(calendar.get(11), calendar.get(12), calendar.get(13));
        return time;
    }

    private PropertyChangeSupport getPropertyChangeNotifier() {
        if (this.changesNotifier == null) {
            this.changesNotifier = new PropertyChangeSupport(this);
        }
        return this.changesNotifier;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().removePropertyChangeListener(propertyChangeListener);
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int n) throws IllegalArgumentException {
        if (this.getDisplayMode() == n) {
            return;
        }
        int n2 = this.displayMode;
        this.displayMode = n;
        switch (n) {
            case 5: {
                this.setDisplay(this.getDigitalDisplay());
                break;
            }
            case 4: {
                this.setDisplay(this.getAnalogDisplay());
                break;
            }
            default: {
                throw new IllegalArgumentException(" bad display mode = " + n);
            }
        }
        this.getPropertyChangeNotifier().firePropertyChange("displayMode", new Integer(n2), new Integer(n));
    }

    private void setDisplay(Component component) {
        this.removeAll();
        this.add("Center", component);
        this.clockDisplay = null;
        this.validate();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.start();
    }

    private final void debug(String string) {
    }

    public Color getAnalogBorderColor() {
        return this.getAnalogDisplay().getBorderColor();
    }

    public void setAnalogBorderColor(Color color) {
        this.getAnalogDisplay().setBorderColor(color);
    }

    public int getAnalogBorderWidth() {
        return this.getAnalogDisplay().getBorderWidth();
    }

    public void setAnalogBorderWidth(int n) {
        this.getAnalogDisplay().setBorderWidth(n);
    }

    public Color getAnalogDialColor() {
        return this.getAnalogDisplay().getDialColor();
    }

    public void setAnalogDialColor(Color color) {
        this.getAnalogDisplay().setDialColor(color);
    }

    public Color getAnalogTickColor() {
        return this.getAnalogDisplay().getTickColor();
    }

    public void setAnalogTickColor(Color color) {
        this.getAnalogDisplay().setTickColor(color);
    }

    public int getAnalogTickStyle() {
        return this.getAnalogDisplay().getTickStyle();
    }

    public void setAnalogTickStyle(int n) {
        this.getAnalogDisplay().setTickStyle(n);
    }

    public int getAnalogNumeralStyle() {
        return this.getAnalogDisplay().getNumeralStyle();
    }

    public void setAnalogNumeralStyle(int n) {
        this.getAnalogDisplay().setNumeralStyle(n);
    }

    public Color getAnalogNumeralColor() {
        return this.getAnalogDisplay().getNumeralColor();
    }

    public void setAnalogNumeralColor(Color color) {
        this.getAnalogDisplay().setNumeralColor(color);
    }

    public Font getAnalogNumeralFont() {
        return this.getAnalogDisplay().getNumeralFont();
    }

    public void setAnalogNumeralFont(Font font) {
        this.getAnalogDisplay().setNumeralFont(font);
    }

    public Color getAnalogHourHandColor() {
        return this.getAnalogDisplay().getHourHandColor();
    }

    public void setAnalogHourHandColor(Color color) {
        this.getAnalogDisplay().setHourHandColor(color);
    }

    public boolean getAnalogHourHandVisible() {
        return this.getAnalogDisplay().isHourHandVisible();
    }

    public void setAnalogHourHandVisible(boolean bl) {
        this.getAnalogDisplay().setHourHandVisible(bl);
    }

    public Color getAnalogMinuteHandColor() {
        return this.getAnalogDisplay().getMinuteHandColor();
    }

    public void setAnalogMinuteHandColor(Color color) {
        this.getAnalogDisplay().setMinuteHandColor(color);
    }

    public boolean getAnalogMinuteHandVisible() {
        return this.getAnalogDisplay().isMinuteHandVisible();
    }

    public void setAnalogMinuteHandVisible(boolean bl) {
        this.getAnalogDisplay().setMinuteHandVisible(bl);
    }

    public Color getAnalogSecondHandColor() {
        return this.getAnalogDisplay().getSecondHandColor();
    }

    public void setAnalogSecondHandColor(Color color) {
        this.getAnalogDisplay().setSecondHandColor(color);
    }

    public boolean getAnalogSecondHandVisible() {
        return this.getAnalogDisplay().isSecondHandVisible();
    }

    public void setAnalogSecondHandVisible(boolean bl) {
        this.getAnalogDisplay().setSecondHandVisible(bl);
    }

    public Font getDigitalNumeralFont() {
        return this.getDigitalDisplay().getNumeralFont();
    }

    public void setDigitalNumeralFont(Font font) {
        this.getDigitalDisplay().setNumeralFont(font);
    }

    public Color getDigitalForeGroundColor() {
        return this.getDigitalDisplay().getForeGroundColor();
    }

    public void setDigitalForeGroundColor(Color color) {
        this.getDigitalDisplay().setForeGroundColor(color);
    }

    public Color getDigitalBackGroundColor() {
        return this.getDigitalDisplay().getBackGroundColor();
    }

    public void setDigitalBackGroundColor(Color color) {
        this.getDigitalDisplay().setBackGroundColor(color);
    }

    public int getDigitalDisplayStyle() {
        return this.getDigitalDisplay().getDisplayStyle();
    }

    public void setDigitalDisplayStyle(int n) {
        this.getDigitalDisplay().setDisplayStyle(n);
    }

    public boolean getDigitalDisplayAMPM() {
        return this.getDigitalDisplay().getDisplayAMPM();
    }

    public void setDigitalDisplayAMPM(boolean bl) {
        this.getDigitalDisplay().setDisplayAMPM(bl);
    }

    public boolean getDigitalTwelveHourMode() {
        return this.getDigitalDisplay().getTwelveHourMode();
    }

    public void setDigitalTwelveHourMode(boolean bl) {
        this.getDigitalDisplay().setTwelveHourMode(bl);
    }
}

