/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

import com.ibm.clock.ClockDisplay;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.TimeZone;

public class DigitalDisplay
extends Canvas
implements ClockDisplay,
Serializable,
Cloneable {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int SHORT = 2;
    private static final int ZEROHOUR = 12;
    private boolean displayAMPM = true;
    private boolean twelveHourMode = true;
    private int displayStyle;
    private Font numeralFont;
    private Color backGroundColor;
    private Color foreGroundColor;
    private static final int DEFAULT_DISPLAY_STYLE = 0;
    private static final boolean DEFAULT_DISPLAY_AMPM = true;
    private static final boolean DEFAULT_DISPLAY_TWELVEHOURMODE = true;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.black;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.lightGray;
    private static final String AMstr = new String("AM");
    private static final String PMstr = new String("PM");
    private static final String colonFormat = new String(":");
    private static final String justBlank = " ";
    private transient int hour24;
    private transient int hour;
    private transient int minute;
    private transient int second;
    private transient int xcoord;
    private transient int ycoord;
    private transient boolean isAMPM = true;
    private transient String timeZoneStr;
    private transient String formattedMinute;
    private transient String formattedSecond;
    private transient String AMPMstr = new String(" ");
    private transient StringBuffer displayStr;
    private TimeZone currentTimeZone;
    private transient PropertyChangeSupport changesNotifier;
    private transient Image offscreen;
    private transient Image digitalImage;
    private static final boolean DEBUG = false;

    public DigitalDisplay() {
    }

    public DigitalDisplay(int n, Color color, Color color2, Font font, boolean bl, boolean bl2) {
        this();
        this.setDisplayStyle(n);
        this.setForeGroundColor(color);
        this.setBackGroundColor(color2);
        this.setNumeralFont(font);
        this.setDisplayAMPM(bl);
        this.setTwelveHourMode(bl2);
    }

    public Font getNumeralFont() {
        if (this.numeralFont == null) {
            this.numeralFont = new Font("Dialog", 0, 18);
        }
        return this.numeralFont;
    }

    public void setNumeralFont(Font font) throws NullPointerException {
        if (font == null) {
            throw new NullPointerException();
        }
        Font font2 = this.numeralFont;
        this.numeralFont = font;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("numeralFont", font2, font);
    }

    public void setTime(int n, int n2, int n3) {
        if (this.checkTime(n, n2, n3)) {
            this.hour = n;
            this.minute = n2;
            this.second = n3;
            this.isAMPM = true;
            this.repaint();
            return;
        }
        throw new IllegalArgumentException();
    }

    private boolean checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        return n3 >= 0 && n3 <= 59;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(this.getNumeralFont());
        dimension.width = fontMetrics.stringWidth(this.displayStrFormatter().toString());
        dimension.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        return dimension;
    }

    private StringBuffer displayStrFormatter() {
        this.getDisplayStr().setLength(0);
        this.formatTimePortion();
        this.formatAMPMPortion();
        return this.displayStr;
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        Image image = this.getDigitalImage();
        graphics2.drawImage(image, 0, 0, null);
        graphics2.setFont(this.getNumeralFont());
        FontMetrics fontMetrics = this.getFontMetrics(this.getNumeralFont());
        int n = fontMetrics.stringWidth(this.displayStrFormatter().toString());
        int n2 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent();
        Rectangle rectangle = this.getBounds();
        graphics2.setColor(this.getBackGroundColor());
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2.setColor(this.getForeGroundColor());
        this.xcoord = (rectangle.width - n) / 2;
        this.ycoord = (rectangle.height + n2) / 2;
        graphics2.drawString(this.displayStrFormatter().toString(), this.xcoord, this.ycoord);
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics2.dispose();
    }

    public Image getDigitalImage() {
        if (this.digitalImage == null) {
            this.digitalImage = this.createImage(this.getSize().width, this.getSize().height);
            Graphics graphics = this.digitalImage.getGraphics();
            graphics.setFont(this.getNumeralFont());
            FontMetrics fontMetrics = this.getFontMetrics(this.getNumeralFont());
            int n = fontMetrics.stringWidth(this.displayStrFormatter().toString());
            int n2 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent();
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBackGroundColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(this.getForeGroundColor());
            this.xcoord = (rectangle.width - n) / 2;
            this.ycoord = (rectangle.height + n2) / 2;
        }
        return this.digitalImage;
    }

    public void setForeGroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.foreGroundColor;
        this.foreGroundColor = color;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("foreGroundColor", color2, color);
    }

    public void setBackGroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.backGroundColor;
        this.backGroundColor = color;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("backGroundColor", color2, color);
    }

    public Color getForeGroundColor() {
        if (this.foreGroundColor == null) {
            this.foreGroundColor = DEFAULT_FOREGROUND_COLOR;
        }
        return this.foreGroundColor;
    }

    public Color getBackGroundColor() {
        if (this.backGroundColor == null) {
            this.backGroundColor = DEFAULT_BACKGROUND_COLOR;
        }
        return this.backGroundColor;
    }

    public void setTwelveHourMode(boolean bl) {
        boolean bl2 = this.twelveHourMode;
        this.twelveHourMode = bl;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("twelveHourMode", new Boolean(bl2), new Boolean(bl));
    }

    public boolean getTwelveHourMode() {
        return this.twelveHourMode;
    }

    public void setDisplayAMPM(boolean bl) {
        boolean bl2 = this.displayAMPM;
        this.displayAMPM = bl;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("displayAMPM", new Boolean(bl2), new Boolean(bl));
    }

    public boolean getDisplayAMPM() {
        return this.displayAMPM;
    }

    public void setDisplayStyle(int n) {
        int n2 = this.displayStyle;
        this.displayStyle = n;
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("displayStyle", new Integer(n2), new Integer(n));
    }

    public int getDisplayStyle() {
        if (!(this.displayStyle == 0 | this.displayStyle == 1 | this.displayStyle == 2)) {
            this.displayStyle = 0;
        }
        return this.displayStyle;
    }

    private void formatTimePortion() {
        this.formattedMinute = this.minute < 10 ? String.valueOf(colonFormat) + "0" + this.minute : String.valueOf(colonFormat) + this.minute;
        this.formattedSecond = this.second < 10 ? String.valueOf(colonFormat) + "0" + this.second : String.valueOf(colonFormat) + this.second;
        if (this.isAMPM) {
            if (this.twelveHourMode) {
                if (this.hour == 12) {
                    this.AMPMstr = PMstr;
                } else if (this.hour < 12) {
                    this.AMPMstr = AMstr;
                } else if (this.hour > 12) {
                    this.hour -= 12;
                    this.AMPMstr = PMstr;
                }
            }
            this.isAMPM = false;
        }
        String string = String.valueOf(this.hour);
        if (!this.twelveHourMode && this.hour < 10) {
            string = "0" + string;
        }
        this.getDisplayStr().append(string);
        this.getDisplayStr().append(this.formattedMinute);
        if (this.displayStyle != 2) {
            this.getDisplayStr().append(this.formattedSecond);
        }
    }

    private void formatAMPMPortion() {
        if (this.twelveHourMode && this.displayAMPM) {
            this.getDisplayStr().append(justBlank).append(this.getAMPMstr());
        }
        if (this.displayStyle == 0) {
            this.getDisplayStr().append(justBlank).append(this.getTimeZoneStr());
        }
    }

    public void setTimeZone(TimeZone timeZone) throws IllegalArgumentException {
        if (timeZone == null) {
            throw new IllegalArgumentException();
        }
        if (timeZone.equals(this.currentTimeZone)) {
            return;
        }
        this.currentTimeZone = timeZone;
        this.timeZoneStr = this.currentTimeZone.getID();
        this.repaint();
    }

    private TimeZone getTimeZone() {
        if (this.currentTimeZone == null) {
            this.currentTimeZone = TimeZone.getDefault();
        }
        return this.currentTimeZone;
    }

    private StringBuffer getDisplayStr() {
        if (this.displayStr == null) {
            this.displayStr = new StringBuffer();
        }
        return this.displayStr;
    }

    private String getTimeZoneStr() {
        if (this.timeZoneStr == null) {
            this.timeZoneStr = TimeZone.getDefault().getID();
        }
        return this.timeZoneStr;
    }

    private String getAMPMstr() {
        if (this.AMPMstr == null) {
            this.AMPMstr = "AM";
        }
        return this.AMPMstr;
    }

    private PropertyChangeSupport getPropertyChangeNotifier() {
        if (this.changesNotifier == null) {
            this.changesNotifier = new PropertyChangeSupport(this);
        }
        return this.changesNotifier;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().removePropertyChangeListener(propertyChangeListener);
    }

    private static final void debug(String string) {
    }
}

