/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

import java.awt.Color;
import java.awt.Graphics;

class ClockHand {
    public static final int DEFAULT_LENGTH = 30;
    public static final int MINIMUM_WIDTH = 1;
    private boolean visible = true;
    private int length = 30;
    private Color color;
    private int width = 1;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) throws IllegalArgumentException {
        if (!this.isProperWidth(n)) {
            throw new IllegalArgumentException(" width =" + n);
        }
        this.width = n;
    }

    protected boolean isProperWidth(int n) {
        return n >= 1;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = Color.black;
        }
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(" bad length = " + n);
        }
        this.length = n;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected boolean isProperAngle(double d) {
        return !(d < 0.0) && !(d > Math.PI * 2);
    }

    public void paint(Graphics graphics, int n, int n2, double d) {
        if (!this.isVisible()) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.getColor());
        graphics.translate(n, n2);
        this.drawLine(graphics, d, this.getWidth(), this.getLength());
        this.drawTop(graphics, d, this.getWidth(), this.getLength(), this.getWidth() / 2);
        this.drawCentre(graphics, this.getWidth());
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    private void drawLine(Graphics graphics, double d, int n, int n2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        int n3 = (int)Math.round((double)n2 * d3);
        int n4 = (int)Math.round((double)n2 * d2);
        if (n != 1) {
            int n5 = (int)Math.round((double)n * d2 / 2.0);
            int n6 = (int)Math.round((double)n * d3 / 2.0);
            nArray[0] = n5;
            nArray2[0] = -n6;
            nArray[1] = -n5;
            nArray2[1] = n6;
            nArray[2] = n3 - n5;
            nArray2[2] = n4 + n6;
            nArray[3] = n3 + n5;
            nArray2[3] = n4 - n6;
            graphics.fillPolygon(nArray, nArray2, 4);
            return;
        }
        graphics.drawLine(0, 0, n3, n4);
    }

    private void drawTop(Graphics graphics, double d, int n, int n2, int n3) {
        if (n <= 2) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        int n4 = (int)Math.round((double)n2 * d3);
        int n5 = (int)Math.round((double)n2 * d2);
        int n6 = (int)Math.round((double)n * d2 / 2.0);
        int n7 = (int)Math.round((double)n * d3 / 2.0);
        nArray[0] = n4 + n6;
        nArray2[0] = n5 - n7;
        nArray[1] = n4 - n6;
        nArray2[1] = n5 + n7;
        nArray[2] = (int)Math.round((double)(n2 + n3) * d3);
        nArray2[2] = (int)Math.round((double)(n2 + n3) * d2);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void drawCentre(Graphics graphics, int n) {
        int n2 = -n;
        int n3 = -n;
        graphics.fillOval(n2, n3, n * 2, n * 2);
    }

    ClockHand() {
    }
}

