/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.clock;

import com.ibm.clock.ClockDisplay;
import com.ibm.clock.ClockHand;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class AnalogDisplay
extends Canvas
implements ClockDisplay,
Serializable,
Cloneable {
    public static final int TICK_STYLE_ALL = 0;
    public static final int TICK_STYLE_MAJOR = 1;
    public static final int TICK_STYLE_MINIMAL = 2;
    public static final int TICK_STYLE_NONE = 3;
    public static final int NUMERAL_ROMAN = 0;
    public static final int NUMERAL_PLAIN = 1;
    private static final int DEFAULT_BORDER_WIDTH = 6;
    private static final Color DEFAULT_BORDER_COLOR = Color.black;
    private static final Color DEFAULT_DIAL_COLOR = Color.white;
    private static final Color DEFAULT_TICK_COLOR = Color.green;
    private static final int DEFAULT_TICK_STYLE = 1;
    private static final int DEFAULT_TICK_WIDTH = 3;
    private static final int DEFAULT_NUMERAL_STYLE = 1;
    private static final Color DEFAULT_NUMERAL_COLOR = Color.black;
    private static final Color DEFAULT_HOUR_HAND_COLOR = Color.black;
    private static final Color DEFAULT_MINUTE_HAND_COLOR = Color.black;
    private static final Color DEFAULT_SECOND_HAND_COLOR = Color.black;
    private static final int DEFAULT_HOUR_HAND_THICKNESS = 6;
    private static final int DEFAULT_MINUTE_HAND_THICKNESS = 6;
    private static final int DEFAULT_SECOND_HAND_THICKNESS = 1;
    private static final int DEFAULT_NUMERAL_INSET = 8;
    private static final int DEFAULT_DIAL_RADIUS = 100;
    private static final String[] plainNumerals = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "1", "2"};
    private static final String[] romanNumerals = new String[]{"III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "I", "II"};
    private transient ClockHand hourHand;
    private transient ClockHand minuteHand;
    private transient ClockHand secondHand;
    private Color borderColor;
    private int borderWidth = 6;
    private Color dialColor;
    private Color tickColor;
    private int tickStyle = -1;
    private int numeralStyle = -1;
    private Color numeralColor;
    private Font numeralFont;
    private Color hourHandColor;
    private boolean hourHandVisible = true;
    private Color minuteHandColor;
    private boolean minuteHandVisible = true;
    private Color secondHandColor;
    private boolean secondHandVisible = true;
    private int tickWidth = 3;
    private transient Image dialImage;
    private transient int hour;
    private transient int minute;
    private transient int second;
    private transient double[] sinTheta;
    private transient double[] cosTheta;
    private transient int sideLength;
    private transient PropertyChangeSupport changesNotifier;
    private transient Image offscreen;
    private static final boolean DEBUG = false;

    public AnalogDisplay() {
    }

    public AnalogDisplay(Color color, int n, Color color2, Color color3, int n2, int n3, Color color4, Font font, Color color5, boolean bl, Color color6, boolean bl2, Color color7, boolean bl3) throws IllegalArgumentException {
        this();
        if (color == null || color2 == null || color3 == null || color4 == null || font == null || color5 == null || color6 == null || color7 == null) {
            throw new IllegalArgumentException();
        }
        if (!(this.isProperBorderWidth(n) && this.isProperTickStyle(n2) && this.isProperNumeralStyle(n3))) {
            throw new IllegalArgumentException();
        }
        this.borderColor = color;
        this.borderWidth = n;
        this.dialColor = color2;
        this.tickColor = color3;
        this.tickStyle = n2;
        this.numeralStyle = n3;
        this.numeralColor = color4;
        this.numeralFont = font;
        this.hourHandColor = color5;
        this.hourHandVisible = bl;
        this.minuteHandColor = color6;
        this.minuteHandVisible = bl2;
        this.secondHandColor = color7;
        this.secondHandVisible = bl3;
    }

    public Font getNumeralFont() {
        if (this.numeralFont == null) {
            this.numeralFont = this.getFont();
        }
        return this.numeralFont;
    }

    public void setNumeralFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException();
        }
        Font font2 = this.numeralFont;
        this.numeralFont = font;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("numeralFont", font2, font);
    }

    public Color getHourHandColor() {
        if (this.hourHandColor == null) {
            this.setHourHandColor(DEFAULT_HOUR_HAND_COLOR);
        }
        return this.hourHandColor;
    }

    public void setHourHandColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.hourHandColor;
        this.hourHandColor = color;
        this.getHourHand().setColor(color);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("hourHandColor", color2, color);
    }

    public Color getMinuteHandColor() {
        if (this.minuteHandColor == null) {
            this.setMinuteHandColor(DEFAULT_HOUR_HAND_COLOR);
        }
        return this.minuteHandColor;
    }

    public void setMinuteHandColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.minuteHandColor;
        this.minuteHandColor = color;
        this.getMinuteHand().setColor(color);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("minuteHandColor", color2, color);
    }

    public Color getSecondHandColor() {
        if (this.secondHandColor == null) {
            this.setSecondHandColor(DEFAULT_HOUR_HAND_COLOR);
        }
        return this.secondHandColor;
    }

    public void setSecondHandColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.secondHandColor;
        this.secondHandColor = color;
        this.getSecondHand().setColor(color);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("secondHandColor", color2, color);
    }

    public boolean isHourHandVisible() {
        return this.hourHandVisible;
    }

    public void setHourHandVisible(boolean bl) {
        boolean bl2 = this.hourHandVisible;
        this.hourHandVisible = bl;
        this.getHourHand().setVisible(bl);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("hourHandVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isMinuteHandVisible() {
        return this.minuteHandVisible;
    }

    public void setMinuteHandVisible(boolean bl) {
        boolean bl2 = this.minuteHandVisible;
        this.minuteHandVisible = bl;
        this.getMinuteHand().setVisible(bl);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("minuteHandVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isSecondHandVisible() {
        return this.secondHandVisible;
    }

    public void setSecondHandVisible(boolean bl) {
        boolean bl2 = this.secondHandVisible;
        this.secondHandVisible = bl;
        this.getSecondHand().setVisible(bl);
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("secondHandVisible", new Boolean(bl2), new Boolean(bl));
    }

    private int computeHourHandLength() {
        int n = this.computeMinuteHandLength();
        n -= this.getTickWidth();
        if ((n = (int)(0.75 * (double)n)) < 0) {
            n = 0;
        }
        return n;
    }

    private int computeSecondHandLength() {
        int n = this.getSideLength() / 2;
        n -= this.getBorderWidth();
        if ((n -= this.getBorderInset()) < 0) {
            n = 0;
        }
        return n;
    }

    private int computeMinuteHandLength() {
        int n = this.computeSecondHandLength();
        n -= this.getNumeralInset();
        n -= this.getMinuteHand().getWidth();
        if (--n < 0) {
            n = 0;
        }
        return n;
    }

    private void setHour(int n) {
        this.hour = n;
    }

    private int getHour() {
        return this.hour;
    }

    private void setMinute(int n) {
        this.minute = n;
    }

    private int getMinute() {
        return this.minute;
    }

    private void setSecond(int n) {
        this.second = n;
    }

    private int getSecond() {
        return this.second;
    }

    public int getTickStyle() {
        if (this.tickStyle < 0) {
            this.tickStyle = 1;
        }
        return this.tickStyle;
    }

    public void setTickStyle(int n) throws IllegalArgumentException {
        if (!this.isProperTickStyle(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.tickStyle;
        this.tickStyle = n;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("tickStyle", new Integer(n2), new Integer(n));
    }

    protected boolean isProperTickStyle(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int getNumeralStyle() {
        if (this.numeralStyle < 0) {
            this.numeralStyle = 1;
        }
        return this.numeralStyle;
    }

    public void setNumeralStyle(int n) {
        if (!this.isProperNumeralStyle(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.numeralStyle;
        this.numeralStyle = n;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("numeralStyle", new Integer(n2), new Integer(n));
    }

    protected boolean isProperNumeralStyle(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.sideLength = n3 <= n4 ? n3 : n4;
        this.getHourHand().setLength(this.computeHourHandLength());
        this.getMinuteHand().setLength(this.computeMinuteHandLength());
        this.getSecondHand().setLength(this.computeSecondHandLength());
        this.invalidateDialImage();
    }

    private void invalidateDialImage() {
        this.dialImage = null;
    }

    private int getSideLength() {
        return this.sideLength;
    }

    protected String getNumberString(int n) {
        switch (this.getNumeralStyle()) {
            case 1: {
                return plainNumerals[n];
            }
            case 0: {
                return romanNumerals[n];
            }
        }
        return null;
    }

    public Color getNumeralColor() {
        if (this.numeralColor == null) {
            this.numeralColor = DEFAULT_NUMERAL_COLOR;
        }
        return this.numeralColor;
    }

    public void setNumeralColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.numeralColor;
        this.numeralColor = color;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("numeralColor", color2, color);
    }

    private double getSinTheta(int n) {
        if (this.sinTheta == null) {
            this.sinTheta = new double[60];
            int n2 = 0;
            while (n2 < 60) {
                this.sinTheta[n2] = Math.sin((double)n2 * 0.10471975511965977);
                ++n2;
            }
        }
        return this.sinTheta[n];
    }

    private double getCosTheta(int n) {
        if (this.cosTheta == null) {
            this.cosTheta = new double[60];
            int n2 = 0;
            while (n2 < 60) {
                this.cosTheta[n2] = Math.cos((double)n2 * 0.10471975511965977);
                ++n2;
            }
        }
        return this.cosTheta[n];
    }

    public Color getTickColor() {
        if (this.tickColor == null) {
            this.tickColor = DEFAULT_TICK_COLOR;
        }
        return this.tickColor;
    }

    public void setTickColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.tickColor;
        this.tickColor = color;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("tickColor", color2, color);
    }

    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = DEFAULT_BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.borderColor;
        this.borderColor = color;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("borderColor", color2, color);
    }

    public Color getDialColor() {
        if (this.dialColor == null) {
            this.dialColor = DEFAULT_DIAL_COLOR;
        }
        return this.dialColor;
    }

    public void setDialColor(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Color color2 = this.dialColor;
        this.dialColor = color;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("dialColor", color2, color);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        if (!this.isProperBorderWidth(n)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.borderWidth;
        this.borderWidth = n;
        this.invalidateDialImage();
        this.repaint();
        this.getPropertyChangeNotifier().firePropertyChange("borderWidth", new Integer(n2), new Integer(n));
    }

    protected boolean isProperBorderWidth(int n) {
        return n >= 1;
    }

    private int getTickWidth() {
        return this.tickWidth;
    }

    public synchronized void setTime(int n, int n2, int n3) {
        if (this.checkTime(n, n2, n3)) {
            this.setHour(n);
            this.setMinute(n2);
            this.setSecond(n3);
            this.repaint();
            return;
        }
        throw new IllegalArgumentException();
    }

    private boolean checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        return n3 >= 0 && n3 <= 59;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        n += this.getBorderWidth();
        n += this.getBorderInset();
        n += this.getNumeralInset();
        n += this.getTickWidth();
        return new Dimension(n += this.getPreferredDialRadius(), n);
    }

    private int getPreferredDialRadius() {
        return 100;
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
        this.invalidateDialImage();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        Color color = graphics2.getColor();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics2.setColor(color);
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        Image image = this.getDialImage();
        graphics2.drawImage(image, 0, 0, null);
        this.getBounds();
        int n = (this.getSecond() + 45) % 60;
        int n2 = (this.getMinute() + 45) % 60;
        int n3 = (this.getHour() + 9) % 12;
        double d = (double)n * 0.10471975511965977;
        double d2 = (double)n2 * 0.10471975511965977;
        double d3 = (double)n3 * 0.5235987755982988;
        int n4 = this.getSideLength() / 2;
        int n5 = this.getSideLength() / 2;
        this.getHourHand().paint(graphics2, n4, n5, d3 += (double)(this.getMinute() / 12) * 0.10471975511965977);
        this.getMinuteHand().paint(graphics2, n4, n5, d2);
        this.getSecondHand().paint(graphics2, n4, n5, d);
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics2.dispose();
    }

    private int getBorderInset() {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(this.getNumeralFont());
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(this.getNumberString(0));
        int n4 = n3 > (n = fontMetrics.stringWidth(this.getNumberString(6))) ? n3 : n;
        n4 = n4 > n2 ? n4 : n2;
        n4 = (n4 + 1) / 2;
        return n4;
    }

    private int getNumeralInset() {
        return this.getBorderInset();
    }

    private Image getDialImage() {
        if (this.dialImage == null) {
            int n = 0;
            int n2 = 0;
            int n3 = this.getSideLength();
            this.dialImage = this.createImage(n3, n3);
            Graphics graphics = this.dialImage.getGraphics();
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n3, n3);
            graphics.setColor(color);
            this.drawBorder(graphics, n, n2, n3);
            int n4 = this.getBorderWidth() + this.getBorderInset();
            this.drawNumbers(graphics, n += n4, n2 += n4, n3 -= 2 * n4);
            int n5 = this.getTickWidth() + this.getNumeralInset();
            this.drawTicks(graphics, n += n5, n2 += n5, n3 -= 2 * n5);
            this.getHourHand().setLength(this.computeHourHandLength());
            this.getMinuteHand().setLength(this.computeMinuteHandLength());
            this.getSecondHand().setLength(this.computeSecondHandLength());
        }
        return this.dialImage;
    }

    private void drawBorder(Graphics graphics, int n, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBorderColor());
        graphics.fillOval(n, n2, n3, n3);
        int n4 = this.getBorderWidth();
        graphics.setColor(this.getDialColor());
        graphics.fillOval(n += n4, n2 += n4, n3 -= 2 * n4, n3);
        graphics.setColor(color);
    }

    private void drawTicks(Graphics graphics, int n, int n2, int n3) {
        switch (this.getTickStyle()) {
            case 0: {
                this.drawTicks(graphics, n, n2, n3, 60);
                return;
            }
            case 1: {
                this.drawTicks(graphics, n, n2, n3, 12);
                return;
            }
            case 2: {
                this.drawTicks(graphics, n, n2, n3, 4);
                return;
            }
        }
    }

    private void drawTicks(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3 / 2;
        int n6 = n2 + n3 / 2;
        graphics.translate(n5, n6);
        Color color = graphics.getColor();
        int n7 = this.getTickWidth();
        int n8 = n3 / 2;
        graphics.setColor(this.getTickColor());
        int n9 = 0;
        int n10 = 0;
        int n11 = 60 / n4;
        int n12 = 0;
        while (n12 < n4) {
            double d = this.getCosTheta(n12 * n11);
            double d2 = this.getSinTheta(n12 * n11);
            n9 = (int)((double)n8 * d);
            n10 = (int)((double)n8 * d2);
            graphics.fillOval(n9 -= n7 / 2, n10 -= n7 / 2, n7, n7);
            ++n12;
        }
        graphics.setColor(color);
        graphics.translate(-n5, -n6);
    }

    private void drawNumbers(Graphics graphics, int n, int n2, int n3) {
        int n4 = n + n3 / 2;
        int n5 = n2 + n3 / 2;
        graphics.translate(n4, n5);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        int n6 = n3 / 2;
        graphics.setColor(this.getNumeralColor());
        graphics.setFont(this.getNumeralFont());
        int n7 = 0;
        int n8 = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = 0;
        while (n9 < 12) {
            double d = this.getCosTheta(5 * n9);
            double d2 = this.getSinTheta(5 * n9);
            n7 = (int)((double)n6 * d);
            n8 = (int)((double)n6 * d2);
            int n10 = fontMetrics.stringWidth(this.getNumberString(n9));
            int n11 = fontMetrics.getAscent() + fontMetrics.getDescent();
            graphics.drawString(this.getNumberString(n9), n7 -= n10 / 2, n8 += n11 / 2);
            ++n9;
        }
        graphics.setColor(color);
        graphics.setFont(font);
        graphics.translate(-n4, -n5);
    }

    private ClockHand getHourHand() {
        if (this.hourHand == null) {
            this.hourHand = new ClockHand();
            this.hourHand.setWidth(6);
        }
        return this.hourHand;
    }

    private ClockHand getMinuteHand() {
        if (this.minuteHand == null) {
            this.minuteHand = new ClockHand();
            this.minuteHand.setWidth(6);
        }
        return this.minuteHand;
    }

    private ClockHand getSecondHand() {
        if (this.secondHand == null) {
            this.secondHand = new ClockHand();
            this.secondHand.setWidth(1);
        }
        return this.secondHand;
    }

    private PropertyChangeSupport getPropertyChangeNotifier() {
        if (this.changesNotifier == null) {
            this.changesNotifier = new PropertyChangeSupport(this);
        }
        return this.changesNotifier;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeNotifier().removePropertyChangeListener(propertyChangeListener);
    }

    private void debug(String string) {
    }
}

