/*-----------------------------------------------------------------
*  ClockMan 1.2.
*  Author:  Ivan 'MCG' Boldyrev <bii714@cclib.nsu.ru>
*	http://members.tripod.com/~ivan_mcg/
*------------------------------------------------------------------
*   This is a last comment in this file. I have no own computer,
* and I have no time to comment my programs. I am sorry.
*----------------------------------------------------------------*/


import java.awt.*;
import java.util.StringTokenizer;
import java.util.Random;

public class ClockApp extends java.applet.Applet implements Runnable
{  final static String auth="Go to author's homepage";
   final static Random generator=new Random();
   Thread clThr;
   Image faceIm;
   Dimension oldSz;
   Color faceColor, backColor, noseColor;
   Color hCol, mCol, sCol;
   Point m = new Point(0, 0);
   boolean mouseIn, over;
   int sz;
   int sLen, mLen, hLen, face, dEye, eye, bl;
   int nose, hH, hM;
   volatile int hE;

   public String getAppletInfo()
   {  return "ClockMan v1.2. Author: Ivan Boldyrev <bii714@cclib.nsu.ru>\n"
         +"http://members.tripod.com/~ivan_mcg\t(Eng)\n"
         +"http://www.halyava.ru/applet\t\t(Rus)";
   }

   public void start()
   {  faceColor=parseColor(getParameter("FACE"), new Color(0xFF, 0xE4,
            0xB5));
      backColor=parseColor(getParameter("BACK"), Color.white);
      noseColor=parseColor(getParameter("NOSE"), Color.cyan);
      hCol=parseColor(getParameter("HCOL"), Color.blue);
      mCol=parseColor(getParameter("MCOL"), Color.green);
      sCol=parseColor(getParameter("SCOL"), Color.red);
      over=false;
      (clThr=new Thread(this, "Anima")).start();
   }

   public void run()
   {  Graphics pen=getGraphics();
      int time=10;
      try
      {  while (!over)
         {  Thread.sleep(1100-System.currentTimeMillis()%1000);
            if (time--==0)
            {  for ( ; hE<=dEye; hE+=4)
                  update(pen);
               for ( ; hE>0; hE-=4)
                  update(pen);
               hE=0;
               time=((generator.nextInt()>>8)&7)+1;
               System.gc();
            }
            update(pen);
         }
     }
     catch (InterruptedException e)
     { }
     finally
     {  pen.dispose();
        System.gc();
     }
   }

   public void stop()
   {  over=true;
      clThr=null;
   }

   public void update(Graphics g)
   {  java.util.Date now = new java.util.Date();
      Dimension s=size();
      sz = Math.min(s.width, s.height)>>1;
      if (oldSz==null || s.width!=oldSz.width || s.height!=oldSz.height)
      {  faceIm=null;
         System.gc();
         faceIm=createImage(s.width, s.height);
         oldSz=s;
         sLen=sz-(sz>>4);
         mLen=sz-(sz>>2);
         hLen=sz>>1;
         face=sz-(sz>>3);
         dEye=face>>1;
         eye=dEye>>1;
         bl=eye>>1;
         nose=bl;
         hH=nose-(nose>>3);
         hM=nose>>1;
      }
      Graphics iGr=faceIm.getGraphics();
      int sec=now.getSeconds();
      double ang=Math.PI*sec/30.;
      if (!mouseIn)
      {  m.x=(int)(Math.sin(ang)*sLen);
         m.y=-(int)(Math.cos(ang)*sLen);
      }
      iGr.setColor(backColor);
      iGr.fillRect(0, 0, s.width, s.height);
      iGr.translate(s.width>>1, s.height>>1);
      iGr.setColor(faceColor);
      iGr.fillOval(-face, -face, face<<1, face<<1);
      drawEye(iGr, -dEye+bl, -dEye, eye, bl, m);
      drawEye(iGr, dEye-bl, -dEye, eye, bl, m);
      iGr.setColor(Color.black);
      int dx=(int)(Math.sin(ang)*bl), sta=180, stb=0;
      if (dx<0)
      {  dx=-dx;
         sta=0;
         stb=180;
      }
      if (dx==0)
         iGr.drawLine(-dEye, dEye, dEye, dEye);
      else
      {  iGr.drawArc(-dEye, dEye-dx, dEye, dx<<1, sta, 180);
         iGr.drawArc(0, dEye-dx, dEye, dx<<1, stb, 180);
      }
      int min;
      drawArrow(iGr,
            (now.getHours()+(min=now.getMinutes())/60.0)*Math.PI/6, hH,
            hLen, hCol);
      drawArrow(iGr, (min+sec/60.0)*Math.PI/30, hM, mLen, mCol);
      drawArrow(iGr, sec*Math.PI/30, 2, sLen, sCol);
      iGr.setColor(noseColor);
      iGr.fillOval(-(nose>>1), -(nose>>1), nose, nose);
      g.drawImage(faceIm, 0, 0, null);
      iGr.dispose();
   }

   public void paint(Graphics g)
   {  update(g);
   }

   final static private void drawArrow(Graphics g, double ang, int wd,
         int len, Color col)
   {  g.setColor(col);
      len <<= 1; --wd;
      int[] xp=new int[3], yp=new int[3];
      double s=Math.sin(ang)/2, c=Math.cos(ang)/2;
      xp[0]=(int)Math.round(s*len);
      yp[0]=-(int)Math.round(c*len);
      xp[1]=(int)Math.round(wd*(c-s));
      yp[1]=(int)Math.round(wd*(c+s));
      xp[2]=-(int)Math.round(wd*(c+s));
      yp[2]=(int)Math.round(wd*(c-s));
      g.fillPolygon(xp, yp, 3);
      g.drawLine(0, 0, xp[0], yp[0]);
   }

   final private void drawEye(Graphics g, int x, int y, int re, int rb,
         Point sc)
   {  double l=Math.sqrt((sc.x-x)*(sc.x-x)+(sc.y-y)*(sc.y-y)), c, s;
      if (Math.abs(l)>bl)
      {  c=(sc.x-x)/l; s=(sc.y-y)/l;
      }
      else
         s=c=0.;
      g.setColor(Color.white);
      g.fillOval(x-re, y-re, re<<1, re<<1);
      g.setColor(Color.black);
      g.fillOval(x-rb+(int)(c*(re-rb)), y-rb+(int)(s*(re-rb)),
            rb<<1, rb<<1);
      g.setColor(faceColor);
      g.fillRect(x-re, y-re, re<<1, hE);
   }

   public boolean mouseMove(Event e, int x, int y)
   {  if (oldSz!=null)
      {  m.x=x-(oldSz.width>>1);
         m.y=y-(oldSz.height>>1);
         repaint();
      }
      return true;
   }

   final static private Color parseColor(String src, Color def)
   {  if (src==null || src.length()<2)
         return def;
      try
      {  if (src.charAt(0)=='#')
            return new Color(Integer.parseInt(src.substring(1), 16)
                  | 0xFF000000);
         else
         {  StringTokenizer stt=new StringTokenizer(src, " ;,");
            int res=0xFF;
            for (int i=0; i<3; ++i)
            {  res <<= 8;
               res |= Integer.parseInt(stt.nextToken());
            }
            return new Color(res);
         }
      }
      catch (Exception e)
      {  return def;
      }
   }
}
