/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class SPButton
extends Canvas
implements MouseListener {
    private SecretPass secretPass;
    private Image bufferImage;
    private Graphics bufferGraphics;
    private Dimension bufferSize = null;
    private Image image;
    private Color[] colors;
    private String fontStyle = "TimesRoman";
    private int fontSize = 0;
    private FontMetrics fontMetrics;
    private int actionIndex;
    private String label;
    private int mouseState = 0;

    public SPButton(SecretPass secretPass, Image image, Color[] colors, String fontStyle, String fontSizeString, int actionIndex, String label) {
        this.secretPass = secretPass;
        this.image = image;
        this.colors = colors;
        this.setBackground(colors[0]);
        if (!fontStyle.equals("")) {
            this.fontStyle = fontStyle;
        }
        if (fontSizeString.equals("") || fontSizeString.equalsIgnoreCase("Auto")) {
            this.fontSize = 0;
        } else {
            try {
                this.fontSize = Integer.parseInt(fontSizeString);
                if (this.fontSize <= 0) {
                    this.fontSize = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.actionIndex = actionIndex;
        this.label = label;
        this.setCursor(new Cursor(12));
        this.addMouseListener(this);
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    private void confirmBuffer() {
        Dimension size = this.getSize();
        if (this.bufferSize == null || !this.bufferSize.equals(size)) {
            if (size.width < 10) {
                size.width = 10;
            }
            if (size.height < 10) {
                size.height = 10;
            }
            this.bufferImage = this.createImage(size.width, size.height);
            this.bufferGraphics = this.bufferImage.getGraphics();
            Font font = null;
            font = this.fontSize > 0 ? new Font(this.fontStyle, 0, this.fontSize) : new Font(this.fontStyle, 0, size.height - 6);
            this.bufferGraphics.setFont(font);
            this.fontMetrics = this.bufferGraphics.getFontMetrics();
            this.bufferSize = new Dimension(size);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.confirmBuffer();
        int imageWidth = this.image.getWidth(this);
        int imageHeight = this.image.getHeight(this);
        if (imageWidth >= 0 && imageHeight >= 0) {
            this.bufferGraphics.drawImage(this.image, 0, 0, this.bufferSize.width, this.bufferSize.height, 0, this.mouseState * imageHeight / 3, imageWidth, (this.mouseState + 1) * imageHeight / 3, this);
        }
        this.bufferGraphics.setColor(this.colors[this.mouseState + 1]);
        this.bufferGraphics.drawString(this.label, (this.bufferSize.width - this.fontMetrics.stringWidth(this.label)) / 2, this.bufferSize.height - this.fontMetrics.getDescent() - (this.fontSize == 0 ? 3 : (this.bufferSize.height - this.fontSize) / 2));
        graphics.drawImage(this.bufferImage, 0, 0, this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseState != 1) {
            this.mouseState = 1;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseState != 0) {
            this.mouseState = 0;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseState != 2) {
            this.mouseState = 2;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseState == 2) {
            this.secretPass.actionPerformed(this.actionIndex);
            this.mouseState = 1;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

