/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Vector;

class PGC_GraphPanel
extends Panel
implements Runnable {
    private PGC owner;
    private Image offscreen_img;
    private Graphics offscreen_graphics;
    private Dimension offscreen_size;
    private Image background_img;
    private boolean animation_enabled = false;
    private Thread animation_thread;
    private boolean painting = false;
    private Point graphsize = new Point(0, 0);
    private Point base = new Point(0, 0);
    private Complex center = Complex.Number(0.0);
    private int op = 0;
    private int zoom = 1;
    private int tracking_var = -1;
    private Complex tracking_scroll;
    private int current_var;
    private boolean origin_connector = false;
    private boolean plotting = false;
    private int font_char_width;
    private int font_char_height;
    private double font_mid_distance;
    private final int PIXMAX = 32752;
    private final int INTMAX = 0x7FFFFFFE;

    public PGC_GraphPanel(PGC pGC) {
        this.owner = pGC;
        int n = 0;
        while (n < this.owner.variable.length) {
            if (this.owner.variable[n].is_function) {
                this.owner.variable[n].plotting_vec = new Vector();
            }
            ++n;
        }
        this.background_img = this.owner.LoadBackgroundImage();
    }

    public boolean GetLine() {
        return this.origin_connector;
    }

    public void SetLine(boolean bl) {
        this.origin_connector = bl;
        this.repaint();
    }

    public boolean GetSpin() {
        return this.animation_thread != null;
    }

    public void SetSpin(boolean bl) {
        if (bl) {
            if (this.animation_thread == null) {
                this.animation_thread = new Thread(this);
                this.animation_thread.start();
                return;
            }
        } else if (this.animation_thread != null) {
            this.animation_thread.stop();
            this.animation_thread = null;
            this.repaint();
        }
    }

    public void EnableSpin(boolean bl) {
        this.animation_enabled = bl;
    }

    public boolean GetEnableSpin() {
        return this.animation_enabled;
    }

    public boolean GetPlot() {
        return this.plotting;
    }

    public void SetPlot(boolean bl) {
        if (!bl) {
            this.PlotBreak();
        }
        this.plotting = bl;
        this.repaint();
    }

    public void PlotBreak() {
        if (this.plotting) {
            this.PlotAdd(4, null);
            this.PlotAdd(5, null);
            this.PlotAdd(6, null);
            this.PlotAdd(7, null);
            this.PlotAdd(8, null);
            this.PlotAdd(9, null);
        }
    }

    public void PlotAdd(int n, Complex complex) {
        this.owner.variable[n].plotting_vec.addElement(complex);
    }

    public void PlotClear() {
        int n = 0;
        while (n < this.owner.variable.length) {
            if (this.owner.variable[n].is_function) {
                this.owner.variable[n].plotting_vec = null;
                this.owner.variable[n].plotting_vec = new Vector();
            }
            ++n;
        }
        this.repaint();
    }

    private int FindDisplayableInputVariable(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.owner.variable.length) {
            if (n >= this.owner.variable.length) {
                n = 0;
            }
            if (this.owner.variable[n].is_input && this.owner.variable[n].is_displayed) {
                bl = true;
                break;
            }
            ++n;
            ++n2;
        }
        if (!bl) {
            n = 0;
        }
        return n;
    }

    public void UpdateDisplay() {
        this.current_var = this.FindDisplayableInputVariable(this.current_var);
        this.SetZoomDelta(0);
    }

    public void PaintNow() {
        this.paint(this.getGraphics());
    }

    public int GetOp() {
        return this.op;
    }

    public void SetOp(int n) {
        this.op = n;
        this.current_var = this.FindDisplayableInputVariable(this.current_var);
        this.PlotBreak();
        this.repaint();
    }

    public int GetZoom() {
        return this.zoom;
    }

    public void SetZoomDelta(int n) {
        double d = this.zoom;
        d = d <= 10.0 ? (d += (double)n) : (d <= 40.0 ? (d += (double)(2 * n)) : (d <= 100.0 ? (d += (double)(4 * n)) : (d <= 400.0 ? (d += (double)(10 * n)) : (d <= 1000.0 ? (d += (double)(40 * n)) : (d <= 4000.0 ? (d += (double)(100 * n)) : (d <= 10000.0 ? (d += (double)(400 * n)) : (d <= 40000.0 ? (d += (double)(1000 * n)) : (d <= 100000.0 ? (d += (double)(4000 * n)) : (d <= 400000.0 ? (d += (double)(10000 * n)) : (d <= 1000000.0 ? (d += (double)(40000 * n)) : (d <= 4000000.0 ? (d += (double)(100000 * n)) : (d <= 1.0E7 ? (d += (double)(400000 * n)) : (d <= 4.0E7 ? (d += (double)(1000000 * n)) : (d <= 1.0E8 ? (d += (double)(4000000 * n)) : (d <= 4.0E8 ? (d += (double)(10000000 * n)) : (d <= 1.0E9 ? (d += (double)(40000000 * n)) : (d += (double)(100000000 * n))))))))))))))))));
        int n2 = 1;
        n2 = d < 1.0 ? 1 : (d > 2.0E9 ? 2000000000 : (int)(d + 0.5));
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 >= 10) {
            n2 = n2 < 40 ? (n2 + 1) / 2 * 2 : (n2 < 100 ? (n2 + 3) / 4 * 4 : (n2 < 400 ? (n2 + 9) / 10 * 10 : (n2 < 1000 ? (n2 + 39) / 40 * 40 : (n2 < 4000 ? (n2 + 99) / 100 * 100 : (n2 < 10000 ? (n2 + 399) / 400 * 400 : (n2 < 40000 ? (n2 + 999) / 1000 * 1000 : (n2 < 100000 ? (n2 + 3999) / 4000 * 4000 : (n2 < 400000 ? (n2 + 9999) / 10000 * 10000 : (n2 < 1000000 ? (n2 + 39999) / 40000 * 40000 : (n2 < 4000000 ? (n2 + 99999) / 100000 * 100000 : (n2 < 10000000 ? (n2 + 399999) / 400000 * 400000 : (n2 < 40000000 ? (n2 + 999999) / 1000000 * 1000000 : (n2 < 100000000 ? (n2 + 3999999) / 4000000 * 4000000 : (n2 < 400000000 ? (n2 + 9999999) / 10000000 * 10000000 : (n2 < 1000000000 ? (n2 + 39999999) / 40000000 * 40000000 : (n2 + 99999999) / 100000000 * 100000000)))))))))))))));
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.zoom = n2;
        this.repaint();
    }

    public void SetZoom(int n) {
        this.zoom = n;
        this.SetZoomDelta(0);
    }

    public void SetCenterDelta(int n, int n2) {
        Point point = new Point(this.base.x + n, this.base.y + n2);
        this.center = this.GetComplex(point);
        this.repaint();
    }

    public void SetCenter(Complex complex) {
        if (complex == null) {
            complex = Complex.Number(0.0, 0.0);
        }
        this.center = complex;
        this.repaint();
    }

    public void SetActivePoint(int n) {
        this.current_var = this.FindDisplayableInputVariable(n);
    }

    public void NextActivePoint() {
        this.current_var = this.FindDisplayableInputVariable(this.current_var + 1);
    }

    public boolean Painting() {
        return this.painting;
    }

    private int GetXOrigin() {
        double d = (double)this.base.x - Math.floor(this.center.re * (double)this.zoom + 0.5);
        if (d < -2.147483646E9) {
            d = -2.147483646E9;
        }
        if (d > 2.147483646E9) {
            d = 2.147483646E9;
        }
        return (int)d;
    }

    private int GetYOrigin() {
        double d = (double)this.base.y + Math.floor(this.center.im * (double)this.zoom + 0.5);
        if (d < -2.147483646E9) {
            d = -2.147483646E9;
        }
        if (d > 2.147483646E9) {
            d = 2.147483646E9;
        }
        return (int)d;
    }

    private void ComplexToPoint(Complex complex, Point point) {
        double d = (double)this.base.x - Math.floor(this.center.re * (double)this.zoom + 0.5);
        double d2 = (double)this.base.y + Math.floor(this.center.im * (double)this.zoom + 0.5);
        double d3 = Math.floor(complex.re * (double)this.zoom + 0.5);
        double d4 = Math.floor(complex.im * (double)this.zoom + 0.5);
        double d5 = d + d3;
        double d6 = d2 - d4;
        if (d5 < -2.147483646E9) {
            d5 = -2.147483646E9;
            if (d3 != 0.0) {
                d6 = d2 - d4 * (-2.147483646E9 - d) / d3;
            }
        }
        if (d5 > 2.147483646E9) {
            d5 = 2.147483646E9;
            if (d3 != 0.0) {
                d6 = d2 - d4 * (2.147483646E9 - d) / d3;
            }
        }
        if (d6 < -2.147483646E9) {
            d6 = -2.147483646E9;
            if (d4 != 0.0) {
                d5 = d + d3 * (d2 - -2.147483646E9) / d4;
            }
        }
        if (d6 > 2.147483646E9) {
            d6 = 2.147483646E9;
            if (d4 != 0.0) {
                d5 = d + d3 * (d2 - 2.147483646E9) / d4;
            }
        }
        point.x = (int)d5;
        point.y = (int)d6;
    }

    private void PointToComplex(Point point, Complex complex) {
        double d = (double)this.base.x - Math.floor(this.center.re * (double)this.zoom + 0.5);
        double d2 = (double)this.base.y + Math.floor(this.center.im * (double)this.zoom + 0.5);
        complex.re = ((double)point.x - d) / (double)this.zoom;
        complex.im = (d2 - (double)point.y) / (double)this.zoom;
    }

    private Point GetPoint(Complex complex) {
        Point point = new Point(0, 0);
        this.ComplexToPoint(complex, point);
        return point;
    }

    private Complex GetComplex(Point point) {
        Complex complex = new Complex();
        this.PointToComplex(point, complex);
        return complex;
    }

    private boolean PointVisible(Point point) {
        boolean bl = point.x >= 0 && point.y >= 0 && point.x < this.graphsize.x && point.y < this.graphsize.y;
        return bl;
    }

    private int PixelLimit(int n, int n2, int n3, int n4, int n5) {
        double d = n2;
        double d2 = (double)n3 - (double)n;
        double d3 = (double)n4 - (double)n2;
        if (d2 != 0.0) {
            d = (double)n4 - d3 * ((double)n3 - (double)n5) / d2;
        }
        int n6 = (int)Math.floor(d + 0.5);
        return n6;
    }

    private void DrawLine(int n, int n2, int n3, int n4) {
        if (n < -32752) {
            n2 = this.PixelLimit(n, n2, n3, n4, -32752);
            n = -32752;
        }
        if (n > 32752) {
            n2 = this.PixelLimit(n, n2, n3, n4, 32752);
            n = 32752;
        }
        if (n2 < -32752) {
            n = this.PixelLimit(n2, n, n4, n3, -32752);
            n2 = -32752;
        }
        if (n2 > 32752) {
            n = this.PixelLimit(n2, n, n4, n3, 32752);
            n2 = 32752;
        }
        if (n3 < -32752) {
            n4 = this.PixelLimit(n3, n4, n, n2, -32752);
            n3 = -32752;
        }
        if (n3 > 32752) {
            n4 = this.PixelLimit(n3, n4, n, n2, 32752);
            n3 = 32752;
        }
        if (n4 < -32752) {
            n3 = this.PixelLimit(n4, n3, n2, n, -32752);
            n4 = -32752;
        }
        if (n4 > 32752) {
            n3 = this.PixelLimit(n4, n3, n2, n, 32752);
            n4 = 32752;
        }
        this.offscreen_graphics.drawLine(n, n2, n3, n4);
    }

    private void DrawRect(int n, int n2, int n3, int n4) {
        if (n >= -32752 && n <= 32752 && n2 >= -32752 && n2 <= 32752) {
            this.offscreen_graphics.drawRect(n, n2, n3, n4);
        }
    }

    private void FillRect(int n, int n2, int n3, int n4) {
        if (n >= -32752 && n <= 32752 && n2 >= -32752 && n2 <= 32752) {
            this.offscreen_graphics.fillRect(n, n2, n3, n4);
        }
    }

    private void DrawString(String string, int n, int n2) {
        if (n >= -32752 && n <= 32752 && n2 >= -32752 && n2 <= 32752) {
            this.offscreen_graphics.drawString(string, n, n2);
        }
    }

    private void DrawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n >= -32752 && n <= 32752 && n2 >= -32752 && n2 <= 32752) {
            this.offscreen_graphics.drawImage(image, n, n2, imageObserver);
        }
    }

    private int GetVariableCoordinatesIndex(Complex complex) {
        int n = -1;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.owner.variable.length) {
            if (this.owner.variable[n2].is_input && this.owner.variable[n2].is_displayed) {
                Complex complex2 = Complex.Sub(this.owner.variable[n2].coordinates, complex);
                double d2 = complex2.re * complex2.re + complex2.im * complex2.im;
                double d3 = d2 * (double)(this.zoom * this.zoom);
                if (!(d3 > 400.0) && (n == -1 || d2 < d)) {
                    n = n2;
                    d = d2;
                }
            }
            ++n2;
        }
        return n;
    }

    private void GetFontInfo() {
        if (this.font_char_height == 0) {
            char c = 'e';
            FontMetrics fontMetrics = this.offscreen_graphics.getFontMetrics();
            this.font_char_height = fontMetrics.getAscent();
            this.font_char_width = fontMetrics.charWidth(c);
            this.font_char_height -= this.font_char_height >> 2;
            this.font_mid_distance = Math.sqrt(this.font_char_height * this.font_char_height + this.font_char_width * this.font_char_width) / 2.0;
        }
    }

    private void DrawPointLabel(PGC_Variable pGC_Variable, Color color) {
        Complex complex = pGC_Variable.coordinates;
        if (complex != null) {
            Complex complex2;
            String string = pGC_Variable.name;
            int n = 32;
            if (string.length() >= 1) {
                n = string.charAt(0);
            }
            this.GetFontInfo();
            int n2 = 6;
            double d = Complex.Abs(complex);
            Complex complex3 = Complex.Number();
            if (d == 0.0) {
                complex3.re = 1.0 / (double)this.zoom * (this.font_mid_distance + (double)n2);
                complex3.im = 0.0;
            } else {
                complex3.re = complex.re / d * (1.0 / (double)this.zoom) * (this.font_mid_distance + (double)n2);
                complex3.im = complex.im / d * (1.0 / (double)this.zoom) * (this.font_mid_distance + (double)n2);
            }
            Complex complex4 = Complex.Number(1.0);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.owner.variable.length) {
                if (n4 != pGC_Variable.index && this.owner.variable[n4].is_displayed && this.owner.variable[n4].coordinates != null) {
                    complex2 = Complex.Sub(this.owner.variable[n4].coordinates, complex);
                    double d2 = complex2.re * complex2.re + complex2.im * complex2.im;
                    double d3 = d2 * (double)(this.zoom * this.zoom);
                    if (d3 < 1.0) {
                        Point point = this.GetPoint(complex);
                        Point point2 = this.GetPoint(this.owner.variable[n4].coordinates);
                        if (point.x == point2.x && point.y == point2.y && n4 < pGC_Variable.index) {
                            ++n3;
                        }
                    }
                }
                ++n4;
            }
            if (n3 == 1) {
                complex4 = Complex.Number(0.0, -1.0);
            } else if (n3 == 2) {
                complex4 = Complex.Number(-1.0, 0.0);
            } else if (n3 == 3) {
                complex4 = Complex.Number(0.0, 1.0);
            }
            complex3 = Complex.Mul(complex3, complex4);
            complex2 = Complex.Add(complex, complex3);
            Point point = this.GetPoint(complex2);
            point.x -= this.font_char_width / 2;
            point.y += this.font_char_height / 2;
            this.offscreen_graphics.setColor(color);
            this.DrawString(string, point.x, point.y);
        }
    }

    private void AnimationStep() {
        double d = 0.031415926535897934;
        Complex complex = this.owner.variable[this.current_var].coordinates;
        Complex complex2 = Complex.Number(Math.cos(d), Math.sin(d));
        this.owner.variable[this.current_var].coordinates = Complex.Mul(complex, complex2);
    }

    private void UserDefined() {
        PGC_Eval pGC_Eval = this.owner.GetEval();
        int n = 0;
        while (n < this.owner.variable.length) {
            if ((n != 4 || this.op >= 12) && this.owner.variable[n].is_function && this.owner.variable[n].is_displayed) {
                pGC_Eval.Evaluate(this.owner.variable[n].expression);
                this.owner.variable[n].coordinates = pGC_Eval.value;
            }
            ++n;
        }
    }

    public void init() {
    }

    public void run() {
        this.setBackground(PGC.color_background);
        while (true) {
            if (!this.painting) {
                this.AnimationStep();
                this.repaint();
            }
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Complex complex = this.GetComplex(new Point(n, n2));
        this.owner.DisplayCoordinates(complex);
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.requestFocus();
        this.owner.SetSpin(false);
        if (this.tracking_var == -1) {
            if (event.controlDown() || event.metaDown()) {
                Complex complex;
                this.tracking_scroll = complex = this.GetComplex(new Point(n, n2));
            } else {
                Complex complex = this.GetComplex(new Point(n, n2));
                this.tracking_var = this.GetVariableCoordinatesIndex(complex);
                if (this.tracking_var >= 0) {
                    this.current_var = this.tracking_var;
                }
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.owner.SetSpin(false);
        Complex complex = this.GetComplex(new Point(n, n2));
        this.owner.DisplayCoordinates(complex);
        if (this.tracking_var >= 0) {
            if (event.shiftDown()) {
                Complex complex2 = Complex.Floor(Complex.Number(complex.re + 0.5, complex.im + 0.5));
                double d = Math.abs(complex.re - complex2.re);
                double d2 = Math.abs(complex.im - complex2.im);
                if (d <= 9.0 / (double)this.zoom && d2 <= 9.0 / (double)this.zoom) {
                    complex.re = complex2.re;
                    complex.im = complex2.im;
                } else if (d > d2) {
                    complex.im = complex2.im;
                } else {
                    complex.re = complex2.re;
                }
            }
            this.owner.variable[this.tracking_var].coordinates = complex;
            this.repaint();
        } else if (this.tracking_scroll != null) {
            Point point = this.GetPoint(this.tracking_scroll);
            Point point2 = new Point(point.x - (n - this.base.x), point.y - (n2 - this.base.y));
            this.owner.SetCenter(this.GetComplex(point2));
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.owner.SetSpin(false);
        if (this.tracking_var >= 0) {
            this.tracking_var = -1;
            this.repaint();
        }
        if (this.tracking_scroll != null) {
            this.tracking_scroll = null;
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.owner.DisplayCoordinates(null);
        return true;
    }

    public boolean keyDown(Event event, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        if (event.shiftDown()) {
            n4 = 5;
        }
        boolean bl4 = event.controlDown();
        if (n == 1004) {
            bl = true;
            bl2 = true;
            n2 = 0;
            n3 = -n4;
        } else if (n == 1005) {
            bl = true;
            bl2 = true;
            n2 = 0;
            n3 = n4;
        } else if (n == 1006) {
            bl = true;
            bl2 = true;
            n2 = -n4;
            n3 = 0;
        } else if (n == 1007) {
            bl = true;
            bl2 = true;
            n2 = n4;
            n3 = 0;
        } else if (n == 43) {
            bl = true;
            this.owner.SetZoomDelta(1);
        } else if (n == 61) {
            bl = true;
            this.owner.SetZoomDelta(1);
        } else if (n == 45) {
            bl = true;
            this.owner.SetZoomDelta(-1);
        } else if (n == 108) {
            bl = true;
            this.owner.CheckLine(null);
        } else if (n == 76) {
            bl = true;
            this.owner.CheckLine(null);
        } else if (n == 115) {
            bl = true;
            this.owner.CheckSpin(null);
        } else if (n == 83) {
            bl = true;
            this.owner.CheckSpin(null);
        } else if (n == 112) {
            bl = true;
            this.owner.CheckPlot(null);
        } else if (n == 80) {
            bl = true;
            this.owner.CheckPlot(null);
        } else if (n == 99) {
            bl = true;
            this.owner.Clear();
        } else if (n == 67) {
            bl = true;
            this.owner.Clear();
        } else if (n == 32) {
            bl = true;
            this.owner.Step(1);
        } else if (n == 62) {
            bl = true;
            this.owner.Step(100);
        } else if (n == 122) {
            bl = true;
            this.owner.SetCenter(null);
            this.owner.SetZoom(this.owner.option_zoom);
        } else if (n == 90) {
            bl = true;
            this.owner.SetCenter(null);
            this.owner.SetZoom(this.owner.option_zoom);
        } else if (n == 110) {
            bl = true;
            bl3 = true;
        } else if (n == 78) {
            bl = true;
            bl3 = true;
        }
        if (bl2) {
            if (bl4) {
                this.owner.SetCenterDelta(n2 * 20, n3 * 20);
            } else {
                Point point = this.GetPoint(this.owner.variable[this.current_var].coordinates);
                point.x += n2;
                point.y += n3;
                this.owner.variable[this.current_var].coordinates = this.GetComplex(point);
                this.repaint();
            }
        }
        if (bl3) {
            this.NextActivePoint();
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        Object object;
        int n;
        Object object2;
        int n2;
        Dimension dimension = this.size();
        this.graphsize.x = dimension.width;
        this.graphsize.y = dimension.height;
        if (this.graphsize.x < 1 || this.graphsize.y < 1) {
            return;
        }
        this.painting = true;
        this.base.x = this.graphsize.x / 2;
        this.base.y = this.graphsize.y / 2;
        if (this.offscreen_img == null || this.graphsize.x != this.offscreen_size.width || this.graphsize.y != this.offscreen_size.height) {
            this.offscreen_img = this.createImage(this.graphsize.x, this.graphsize.y);
            this.offscreen_size = new Dimension(dimension);
            this.offscreen_graphics = this.offscreen_img.getGraphics();
            this.offscreen_graphics.setFont(this.getFont());
        }
        this.owner.variable[4].coordinates = null;
        this.owner.variable[5].coordinates = null;
        this.owner.variable[6].coordinates = null;
        this.owner.variable[7].coordinates = null;
        this.owner.variable[8].coordinates = null;
        this.owner.variable[9].coordinates = null;
        if (this.op == 1) {
            this.owner.variable[4].coordinates = Complex.Add(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
        } else if (this.op == 2) {
            this.owner.variable[4].coordinates = Complex.Sub(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
        } else if (this.op == 3) {
            this.owner.variable[4].coordinates = Complex.Mul(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
        } else if (this.op == 4) {
            this.owner.variable[4].coordinates = Complex.Div(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
        } else if (this.op == 5) {
            this.owner.variable[4].coordinates = Complex.Pow(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
        } else if (this.op == 6) {
            this.owner.variable[4].coordinates = Complex.Number(Complex.Dot(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates));
        } else if (this.op == 7) {
            this.owner.variable[4].coordinates = Complex.Number(Complex.Cross(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates));
        } else if (this.op == 8) {
            this.owner.variable[4].coordinates = Complex.Number(Complex.Dot(this.owner.variable[0].coordinates, this.owner.variable[2].coordinates), Complex.Dot(this.owner.variable[1].coordinates, this.owner.variable[2].coordinates));
        } else if (this.op == 9) {
            this.owner.variable[4].coordinates = Complex.Sqrt(this.owner.variable[0].coordinates);
        } else if (this.op == 10) {
            this.owner.variable[4].coordinates = Complex.Pow(this.owner.variable[0].coordinates, Complex.Number(0.3333333333333333));
        } else if (this.op == 11) {
            this.owner.variable[4].coordinates = Complex.Exp(this.owner.variable[0].coordinates);
        }
        this.UserDefined();
        Complex complex = null;
        Complex complex2 = null;
        Complex complex3 = null;
        Complex complex4 = null;
        Complex complex5 = null;
        Complex complex6 = null;
        Complex complex7 = null;
        Complex complex8 = null;
        Complex complex9 = null;
        Complex complex10 = null;
        if (this.owner.variable[0].is_displayed) {
            complex = this.owner.variable[0].coordinates;
        }
        if (this.owner.variable[1].is_displayed) {
            complex2 = this.owner.variable[1].coordinates;
        }
        if (this.owner.variable[2].is_displayed) {
            complex3 = this.owner.variable[2].coordinates;
        }
        if (this.owner.variable[3].is_displayed) {
            complex4 = this.owner.variable[3].coordinates;
        }
        if (this.owner.variable[4].is_displayed) {
            complex5 = this.owner.variable[4].coordinates;
        }
        if (this.owner.variable[5].is_displayed) {
            complex6 = this.owner.variable[5].coordinates;
        }
        if (this.owner.variable[6].is_displayed) {
            complex7 = this.owner.variable[6].coordinates;
        }
        if (this.owner.variable[7].is_displayed) {
            complex8 = this.owner.variable[7].coordinates;
        }
        if (this.owner.variable[8].is_displayed) {
            complex9 = this.owner.variable[8].coordinates;
        }
        if (this.owner.variable[9].is_displayed) {
            complex10 = this.owner.variable[9].coordinates;
        }
        this.owner.TextFieldsOutput(complex, complex2, complex3, complex4, complex5, complex6, complex7, complex8, complex9, complex10);
        if (this.plotting) {
            if (complex5 != null) {
                this.PlotAdd(4, complex5);
            }
            if (complex6 != null) {
                this.PlotAdd(5, complex6);
            }
            if (complex7 != null) {
                this.PlotAdd(6, complex7);
            }
            if (complex8 != null) {
                this.PlotAdd(7, complex8);
            }
            if (complex9 != null) {
                this.PlotAdd(8, complex9);
            }
            if (complex10 != null) {
                this.PlotAdd(9, complex10);
            }
        }
        this.offscreen_graphics.setColor(PGC.color_background);
        this.offscreen_graphics.fillRect(0, 0, this.graphsize.x, this.graphsize.y);
        if (this.background_img != null) {
            n2 = this.GetXOrigin() - this.background_img.getWidth(this) / 2;
            int n3 = this.GetYOrigin() - this.background_img.getHeight(this) / 2;
            this.DrawImage(this.background_img, n2, n3, this);
        }
        Complex complex11 = this.GetComplex(new Point(0, 0));
        Complex complex12 = this.GetComplex(this.graphsize);
        if (this.zoom >= 8) {
            n2 = this.zoom;
            complex11.re = Math.floor(complex11.re);
            complex11.im = Math.floor(complex11.im);
            complex12.re = Math.ceil(complex12.re);
            complex12.im = Math.ceil(complex12.im);
        } else {
            n2 = this.zoom * 10;
            complex11.re = Math.floor(complex11.re / 10.0) * 10.0;
            complex11.im = Math.floor(complex11.im / 10.0) * 10.0;
            complex12.re = Math.ceil(complex12.re / 10.0) * 10.0;
            complex12.im = Math.ceil(complex12.im / 10.0) * 10.0;
        }
        Point point = this.GetPoint(complex11);
        Point point2 = this.GetPoint(complex12);
        this.offscreen_graphics.setColor(PGC.color_grid);
        int n4 = point.x;
        while (n4 <= point2.x) {
            this.DrawLine(n4, 0, n4, this.graphsize.y);
            n4 += n2;
        }
        int n5 = point.y;
        while (n5 <= point2.y) {
            this.DrawLine(0, n5, this.graphsize.x, n5);
            n5 += n2;
        }
        this.offscreen_graphics.setColor(PGC.color_axis);
        this.DrawLine(0, this.GetYOrigin(), this.graphsize.x, this.GetYOrigin());
        this.DrawLine(this.GetXOrigin(), 0, this.GetXOrigin(), this.graphsize.y);
        PGC_Eval pGC_Eval = this.owner.GetEval();
        int n6 = 0;
        while (n6 < this.owner.variable.length) {
            if (this.owner.variable[n6].is_function && !this.owner.variable[n6].is_displayed) {
                Object object3;
                String string = this.owner.variable[n6].expression;
                if (n6 == 4) {
                    this.offscreen_graphics.setColor(PGC.color_func_f_plot);
                }
                if (n6 == 5) {
                    this.offscreen_graphics.setColor(PGC.color_func_g_plot);
                }
                if (n6 == 6) {
                    this.offscreen_graphics.setColor(PGC.color_func_h_plot);
                }
                if (n6 == 7) {
                    this.offscreen_graphics.setColor(PGC.color_func_k_plot);
                }
                if (n6 == 8) {
                    this.offscreen_graphics.setColor(PGC.color_func_m_plot);
                }
                if (n6 == 9) {
                    this.offscreen_graphics.setColor(PGC.color_func_n_plot);
                }
                pGC_Eval.Evaluate(string);
                if (pGC_Eval.uses_autoplot_t) {
                    object2 = null;
                    object3 = Complex.Number(0.0);
                    double d = this.owner.t_minimum;
                    double d2 = this.owner.t_maximum;
                    n = this.owner.t_count;
                    if (d > d2) {
                        d = this.owner.t_maximum;
                        d2 = this.owner.t_minimum;
                    }
                    if (n < 1) {
                        n = 1;
                    }
                    double d3 = (d2 - d) / (double)n;
                    double d4 = d2 + d3;
                    double d5 = d;
                    while (d5 < d4) {
                        ((Complex)object3).re = d5;
                        ((Complex)object3).im = 0.0;
                        this.owner.SetAutoplotVariable((Complex)object3);
                        pGC_Eval.Evaluate(string);
                        Complex complex13 = pGC_Eval.value;
                        if (complex13 == null) {
                            object2 = null;
                        } else if (!Complex.IsDefined(complex13)) {
                            object2 = null;
                        } else {
                            Point point3 = this.GetPoint(complex13);
                            this.FillRect(point3.x, point3.y, 1, 1);
                            if (object2 != null && (this.PointVisible((Point)object2) || this.PointVisible(point3))) {
                                this.DrawLine(((Point)object2).x, ((Point)object2).y, point3.x, point3.y);
                            }
                            object2 = point3;
                        }
                        d5 += d3;
                    }
                } else if (pGC_Eval.uses_autoplot_x) {
                    object2 = null;
                    object3 = new Point(0, 0);
                    Complex complex14 = Complex.Number(0.0);
                    int n7 = 0;
                    while (n7 < this.graphsize.x) {
                        ((Point)object3).x = n7;
                        ((Point)object3).y = 0;
                        this.PointToComplex((Point)object3, complex14);
                        complex14.im = 0.0;
                        this.owner.SetAutoplotVariable(complex14);
                        pGC_Eval.Evaluate(string);
                        Complex complex15 = pGC_Eval.value;
                        if (complex15 == null) {
                            object2 = null;
                        } else if (!this.owner.LooksReal(complex15)) {
                            object2 = null;
                        } else if (!Complex.IsDefined(complex15)) {
                            object2 = null;
                        } else {
                            complex15.im = complex15.re;
                            complex15.re = complex14.re;
                            object = this.GetPoint(complex15);
                            this.FillRect(((Point)object).x, ((Point)object).y, 1, 1);
                            if (object2 != null && (this.PointVisible((Point)object2) || this.PointVisible((Point)object))) {
                                this.DrawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                            }
                            object2 = object;
                        }
                        ++n7;
                    }
                }
                this.owner.SetAutoplotVariable(null);
            }
            ++n6;
        }
        int n8 = 0;
        while (n8 < this.owner.variable.length) {
            if (this.owner.variable[n8].plotting_vec != null) {
                object2 = null;
                if (n8 == 4) {
                    this.offscreen_graphics.setColor(PGC.color_func_f_plot);
                }
                if (n8 == 5) {
                    this.offscreen_graphics.setColor(PGC.color_func_g_plot);
                }
                if (n8 == 6) {
                    this.offscreen_graphics.setColor(PGC.color_func_h_plot);
                }
                if (n8 == 7) {
                    this.offscreen_graphics.setColor(PGC.color_func_k_plot);
                }
                if (n8 == 8) {
                    this.offscreen_graphics.setColor(PGC.color_func_m_plot);
                }
                if (n8 == 9) {
                    this.offscreen_graphics.setColor(PGC.color_func_n_plot);
                }
                int n9 = 0;
                while (n9 < this.owner.variable[n8].plotting_vec.size()) {
                    Complex complex16 = (Complex)this.owner.variable[n8].plotting_vec.elementAt(n9);
                    if (complex16 == null) {
                        object2 = null;
                    } else if (!Complex.IsDefined(complex16)) {
                        object2 = null;
                    } else {
                        Point point4 = this.GetPoint(complex16);
                        this.FillRect(point4.x, point4.y, 1, 1);
                        if (object2 != null && (this.PointVisible((Point)object2) || this.PointVisible(point4))) {
                            this.DrawLine(((Point)object2).x, ((Point)object2).y, point4.x, point4.y);
                        }
                        object2 = point4;
                    }
                    ++n9;
                }
            }
            ++n8;
        }
        int n10 = 0;
        while (n10 < this.owner.variable.length) {
            if (this.owner.variable[n10].is_input && this.owner.variable[n10].is_displayed && Complex.IsDefined(this.owner.variable[n10].coordinates)) {
                object2 = this.GetPoint(this.owner.variable[n10].coordinates);
                if (this.origin_connector) {
                    this.offscreen_graphics.setColor(PGC.color_origin_connector_line);
                    this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), ((Point)object2).x, ((Point)object2).y);
                }
                this.DrawPointLabel(this.owner.variable[n10], PGC.color_input_label);
            }
            ++n10;
        }
        this.DrawPointLabel(this.owner.variable[4], PGC.color_func_f_label);
        this.DrawPointLabel(this.owner.variable[5], PGC.color_func_g_label);
        this.DrawPointLabel(this.owner.variable[6], PGC.color_func_h_label);
        this.DrawPointLabel(this.owner.variable[7], PGC.color_func_k_label);
        this.DrawPointLabel(this.owner.variable[8], PGC.color_func_m_label);
        this.DrawPointLabel(this.owner.variable[9], PGC.color_func_n_label);
        int n11 = 0;
        while (n11 < this.owner.variable.length) {
            if (this.owner.variable[n11].is_input && this.owner.variable[n11].is_displayed) {
                object2 = this.GetPoint(this.owner.variable[n11].coordinates);
                Rectangle rectangle = new Rectangle((Point)object2);
                rectangle.grow(2, 2);
                this.offscreen_graphics.setColor(PGC.color_input_point);
                this.DrawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < this.owner.variable.length) {
            if (this.owner.variable[n12].is_function && this.owner.variable[n12].is_displayed && (object = this.owner.variable[n12].coordinates) != null && Complex.IsDefined((Complex)object)) {
                n = 0;
                while (true) {
                    object2 = this.GetPoint((Complex)object);
                    if (this.origin_connector) {
                        this.offscreen_graphics.setColor(PGC.color_origin_connector_line);
                        this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), ((Point)object2).x, ((Point)object2).y);
                    }
                    Rectangle rectangle = new Rectangle((Point)object2);
                    rectangle.grow(2, 2);
                    if (n12 == 4) {
                        this.offscreen_graphics.setColor(PGC.color_func_f_point);
                    }
                    if (n12 == 5) {
                        this.offscreen_graphics.setColor(PGC.color_func_g_point);
                    }
                    if (n12 == 6) {
                        this.offscreen_graphics.setColor(PGC.color_func_h_point);
                    }
                    if (n12 == 7) {
                        this.offscreen_graphics.setColor(PGC.color_func_k_point);
                    }
                    if (n12 == 8) {
                        this.offscreen_graphics.setColor(PGC.color_func_m_point);
                    }
                    if (n12 == 9) {
                        this.offscreen_graphics.setColor(PGC.color_func_n_point);
                    }
                    this.DrawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    if (n12 == 4 && this.op == 9 && n < 1) {
                        object = Complex.Neg((Complex)object);
                    } else {
                        if (n12 != 4 || this.op != 10 || n >= 2) break;
                        object = Complex.Mul((Complex)object, Complex.Number(-0.5, Math.sqrt(3.0) / 2.0));
                    }
                    ++n;
                }
            }
            ++n12;
        }
        if (!(this.op != 6 && this.op != 7 || this.tracking_var == -1 && this.animation_thread == null)) {
            Point point5;
            if (this.current_var == 0) {
                object = Complex.Shadow(this.owner.variable[0].coordinates, this.owner.variable[1].coordinates);
                object2 = this.GetPoint(this.owner.variable[0].coordinates);
                point5 = this.GetPoint(this.owner.variable[1].coordinates);
            } else {
                object = Complex.Shadow(this.owner.variable[1].coordinates, this.owner.variable[0].coordinates);
                object2 = this.GetPoint(this.owner.variable[1].coordinates);
                point5 = this.GetPoint(this.owner.variable[0].coordinates);
            }
            Point point6 = this.GetPoint((Complex)object);
            this.offscreen_graphics.setColor(PGC.color_origin_connector_line);
            this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), ((Point)object2).x, ((Point)object2).y);
            this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), point5.x, point5.y);
            this.offscreen_graphics.setColor(PGC.color_lightray);
            this.DrawLine(((Point)object2).x, ((Point)object2).y, point6.x, point6.y);
            this.offscreen_graphics.setColor(PGC.color_shadow);
            Rectangle rectangle = new Rectangle(point6);
            rectangle.grow(2, 2);
            this.DrawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), point6.x, point6.y);
        }
        if (this.op == 8 && (this.tracking_var == 2 || this.animation_thread != null && this.current_var == 2)) {
            int n13 = 0;
            while (n13 <= 1) {
                Complex complex17 = Complex.Shadow(this.owner.variable[2].coordinates, this.owner.variable[n13].coordinates);
                object2 = this.GetPoint(this.owner.variable[2].coordinates);
                Point point7 = this.GetPoint(this.owner.variable[n13].coordinates);
                Point point8 = this.GetPoint(complex17);
                this.offscreen_graphics.setColor(PGC.color_origin_connector_line);
                this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), ((Point)object2).x, ((Point)object2).y);
                this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), point7.x, point7.y);
                this.offscreen_graphics.setColor(PGC.color_lightray);
                this.DrawLine(((Point)object2).x, ((Point)object2).y, point8.x, point8.y);
                this.offscreen_graphics.setColor(PGC.color_shadow);
                Rectangle rectangle = new Rectangle(point8);
                rectangle.grow(2, 2);
                this.DrawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.DrawLine(this.GetXOrigin(), this.GetYOrigin(), point8.x, point8.y);
                int n14 = -1;
                if (n13 == 0) {
                    n14 = 10;
                } else if (n13 == 1) {
                    n14 = 11;
                }
                if (n14 != -1) {
                    this.owner.variable[n14].coordinates = complex17;
                    this.owner.variable[n14].is_displayed = true;
                    this.DrawPointLabel(this.owner.variable[n14], PGC.color_shadow_label);
                    this.owner.variable[n14].is_displayed = false;
                }
                ++n13;
            }
        }
        if (this.owner.option_graph_border) {
            this.offscreen_graphics.setColor(PGC.color_3d_dark);
            this.offscreen_graphics.drawLine(0, 0, this.graphsize.x - 2, 0);
            this.offscreen_graphics.drawLine(0, 0, 0, this.graphsize.y - 2);
            this.offscreen_graphics.setColor(Color.black);
            this.offscreen_graphics.drawLine(1, 1, this.graphsize.x - 1, 1);
            this.offscreen_graphics.drawLine(1, 1, 1, this.graphsize.y - 1);
            this.offscreen_graphics.setColor(Color.lightGray);
            this.offscreen_graphics.drawLine(this.graphsize.x - 2, 1, this.graphsize.x - 2, this.graphsize.y - 2);
            this.offscreen_graphics.drawLine(1, this.graphsize.y - 2, this.graphsize.x - 2, this.graphsize.y - 2);
            this.offscreen_graphics.setColor(PGC.color_3d_light);
            this.offscreen_graphics.drawLine(this.graphsize.x - 1, 0, this.graphsize.x - 1, this.graphsize.y - 1);
            this.offscreen_graphics.drawLine(0, this.graphsize.y - 1, this.graphsize.x - 1, this.graphsize.y - 1);
        }
        graphics.drawImage(this.offscreen_img, 0, 0, this);
        this.painting = false;
    }
}

