/*
 * Decompiled with CFR 0.152.
 */
class PGC_Eval {
    private PGC owner;
    public String input;
    public Complex value;
    public String message;
    public boolean empty;
    public boolean uses_autoplot;
    public boolean uses_autoplot_x;
    public boolean uses_autoplot_t;
    public boolean[] uses_input = new boolean[14];
    public boolean[] allowed = new boolean[14];
    public String recursive;
    private int pos;
    private int ch;
    private String token;
    private int token_pos;
    private int token_type;
    private int CHAR_EOS = -1;
    private static final int TOKEN_TYPE_UNDEFINED = 0;
    private static final int TOKEN_TYPE_EOS = 1;
    private static final int TOKEN_TYPE_NUMBER = 2;
    private static final int TOKEN_TYPE_SYMBOL = 3;
    private static final int TOKEN_TYPE_ID = 16384;
    private static final int TOKEN_TYPE_ID_CLASS_VAR = 20480;
    private static final int TOKEN_TYPE_ID_CLASS_FUNC = 24576;
    private static final int TOKEN_TYPE_ID_I = 20481;
    private static final int TOKEN_TYPE_ID_PI = 20482;
    private static final int TOKEN_TYPE_ID_E = 20483;
    private static final int TOKEN_TYPE_ID_INFINITY = 20484;
    private static final int TOKEN_TYPE_ID_NAN = 20485;
    private static final int TOKEN_TYPE_ID_A = 20486;
    private static final int TOKEN_TYPE_ID_AX = 20487;
    private static final int TOKEN_TYPE_ID_AY = 20488;
    private static final int TOKEN_TYPE_ID_B = 20489;
    private static final int TOKEN_TYPE_ID_BX = 20490;
    private static final int TOKEN_TYPE_ID_BY = 20491;
    private static final int TOKEN_TYPE_ID_C = 20492;
    private static final int TOKEN_TYPE_ID_CX = 20493;
    private static final int TOKEN_TYPE_ID_CY = 20494;
    private static final int TOKEN_TYPE_ID_D = 20495;
    private static final int TOKEN_TYPE_ID_DX = 20496;
    private static final int TOKEN_TYPE_ID_DY = 20497;
    private static final int TOKEN_TYPE_ID_F = 20498;
    private static final int TOKEN_TYPE_ID_FX = 20499;
    private static final int TOKEN_TYPE_ID_FY = 20500;
    private static final int TOKEN_TYPE_ID_G = 20501;
    private static final int TOKEN_TYPE_ID_GX = 20502;
    private static final int TOKEN_TYPE_ID_GY = 20503;
    private static final int TOKEN_TYPE_ID_H = 20504;
    private static final int TOKEN_TYPE_ID_HX = 20505;
    private static final int TOKEN_TYPE_ID_HY = 20506;
    private static final int TOKEN_TYPE_ID_K = 20507;
    private static final int TOKEN_TYPE_ID_KX = 20508;
    private static final int TOKEN_TYPE_ID_KY = 20509;
    private static final int TOKEN_TYPE_ID_M = 20510;
    private static final int TOKEN_TYPE_ID_MX = 20511;
    private static final int TOKEN_TYPE_ID_MY = 20512;
    private static final int TOKEN_TYPE_ID_N = 20513;
    private static final int TOKEN_TYPE_ID_NX = 20514;
    private static final int TOKEN_TYPE_ID_NY = 20515;
    private static final int TOKEN_TYPE_ID_X = 20516;
    private static final int TOKEN_TYPE_ID_T = 20517;
    private static final int TOKEN_TYPE_ID_S = 20518;
    private static final int TOKEN_TYPE_ID_Z = 20519;
    private static final int TOKEN_TYPE_ID_ABS = 24577;
    private static final int TOKEN_TYPE_ID_ARG = 24578;
    private static final int TOKEN_TYPE_ID_CONJ = 24579;
    private static final int TOKEN_TYPE_ID_INT = 24580;
    private static final int TOKEN_TYPE_ID_CEIL = 24581;
    private static final int TOKEN_TYPE_ID_FLOOR = 24582;
    private static final int TOKEN_TYPE_ID_SQRT = 24583;
    private static final int TOKEN_TYPE_ID_EXP = 24584;
    private static final int TOKEN_TYPE_ID_LOG = 24585;
    private static final int TOKEN_TYPE_ID_SIN = 24586;
    private static final int TOKEN_TYPE_ID_COS = 24587;
    private static final int TOKEN_TYPE_ID_TAN = 24588;
    private static final int TOKEN_TYPE_ID_COT = 24589;
    private static final int TOKEN_TYPE_ID_SEC = 24590;
    private static final int TOKEN_TYPE_ID_CSC = 24591;
    private static final int TOKEN_TYPE_ID_SINH = 24592;
    private static final int TOKEN_TYPE_ID_COSH = 24593;
    private static final int TOKEN_TYPE_ID_TANH = 24594;
    private static final int TOKEN_TYPE_ID_COTH = 24595;
    private static final int TOKEN_TYPE_ID_SECH = 24596;
    private static final int TOKEN_TYPE_ID_CSCH = 24597;
    private static final int TOKEN_TYPE_ID_ASIN = 24598;
    private static final int TOKEN_TYPE_ID_ACOS = 24599;
    private static final int TOKEN_TYPE_ID_ATAN = 24600;
    private static final int TOKEN_TYPE_ID_ACOT = 24601;
    private static final int TOKEN_TYPE_ID_ASEC = 24602;
    private static final int TOKEN_TYPE_ID_ACSC = 24603;
    private static final int TOKEN_TYPE_ID_ASINH = 24604;
    private static final int TOKEN_TYPE_ID_ACOSH = 24605;
    private static final int TOKEN_TYPE_ID_ATANH = 24606;
    private static final int TOKEN_TYPE_ID_ACOTH = 24607;
    private static final int TOKEN_TYPE_ID_ASECH = 24608;
    private static final int TOKEN_TYPE_ID_ACSCH = 24609;
    private static final int TOKEN_TYPE_ID_RE = 24610;
    private static final int TOKEN_TYPE_ID_IM = 24611;
    private static final int TOKEN_TYPE_ID_REALONLY = 24612;

    public PGC_Eval(PGC pGC) {
        this.owner = pGC;
        int n = 0;
        while (n < this.allowed.length) {
            this.allowed[n] = true;
            ++n;
        }
    }

    public void Evaluate(String string) {
        this.input = string;
        this.message = "";
        this.uses_autoplot = false;
        this.uses_autoplot_x = false;
        this.uses_autoplot_t = false;
        int n = 0;
        while (n < this.uses_input.length) {
            this.uses_input[n] = false;
            ++n;
        }
        this.LexInitialize();
        this.empty = this.token_type == 1;
        this.recursive = null;
        this.value = this.ParseExpression();
        if (this.recursive != null) {
            this.ParseError("Recursive definition with " + this.recursive);
        }
    }

    private void LexInitialize() {
        this.pos = 0;
        this.LexGetChar();
        this.LexGetToken();
    }

    private boolean LexIsEos() {
        return this.ch == this.CHAR_EOS;
    }

    private boolean LexIsSpace() {
        return this.ch >= 0 && this.ch <= 32;
    }

    private boolean LexIsIdentifierChar() {
        return this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch == 95;
    }

    private boolean LexIsDigit() {
        return this.ch >= 48 && this.ch <= 57;
    }

    private void LexGetChar() {
        if (this.pos >= this.input.length()) {
            this.ch = this.CHAR_EOS;
            return;
        }
        this.ch = this.input.charAt(this.pos);
        ++this.pos;
    }

    private void LexAdvance() {
        this.token = String.valueOf(this.token) + (char)this.ch;
        this.LexGetChar();
    }

    private void LexWhiteSpace() {
        block0: while (true) {
            if (this.LexIsSpace()) {
                this.LexGetChar();
                continue;
            }
            if (this.ch != 123) break;
            int n = 1;
            this.LexGetChar();
            do {
                if (this.LexIsEos()) continue block0;
                if (this.ch == 123) {
                    ++n;
                }
                if (this.ch == 125) {
                    --n;
                }
                this.LexGetChar();
            } while (n != 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void LexGetToken() {
        block10: {
            block8: {
                block9: {
                    this.token = "";
                    this.token_type = 0;
                    this.LexWhiteSpace();
                    this.token_pos = this.pos;
                    if (this.LexIsEos()) {
                        this.token_type = 1;
                        return;
                    }
                    if (this.LexIsIdentifierChar()) {
                        while (this.LexIsIdentifierChar()) {
                            this.LexAdvance();
                        }
                        this.token_type = this.LexTokenId(this.token);
                        return;
                    }
                    if (!this.LexIsDigit() && this.ch != 46) break block8;
                    this.token_type = 2;
                    var1_1 = this.ch == 46;
                    while (this.LexIsDigit()) {
                        this.LexAdvance();
                    }
                    if (this.ch != 46) break block9;
                    this.LexAdvance();
                    if (!var1_1 || this.LexIsDigit()) ** GOTO lbl26
                    this.token_type = 3;
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        this.LexAdvance();
lbl26:
                        // 2 sources

                        ** while (this.LexIsDigit())
                    }
                }
                if (this.token_type == 2 && this.ch == 101 || this.ch == 69) {
                    this.LexAdvance();
                    if (this.ch == 43 || this.ch == 45) {
                        this.LexAdvance();
                    }
                    while (this.LexIsDigit()) {
                        this.LexAdvance();
                    }
                    return;
                }
                break block10;
            }
            this.token_type = 3;
            this.LexAdvance();
        }
    }

    private int LexTokenId(String string) {
        int n = 16384;
        if (string.equalsIgnoreCase("i")) {
            n = 20481;
        } else if (string.equalsIgnoreCase("j")) {
            n = 20481;
        } else if (string.equalsIgnoreCase("pi")) {
            n = 20482;
        } else if (string.equalsIgnoreCase("e")) {
            n = 20483;
        } else if (string.equalsIgnoreCase("infinity")) {
            n = 20484;
        } else if (string.equalsIgnoreCase("nan")) {
            n = 20485;
        } else if (string.equalsIgnoreCase("a")) {
            n = 20486;
        } else if (string.equalsIgnoreCase("ax")) {
            n = 20487;
        } else if (string.equalsIgnoreCase("ay")) {
            n = 20488;
        } else if (string.equalsIgnoreCase("b")) {
            n = 20489;
        } else if (string.equalsIgnoreCase("bx")) {
            n = 20490;
        } else if (string.equalsIgnoreCase("by")) {
            n = 20491;
        } else if (string.equalsIgnoreCase("c")) {
            n = 20492;
        } else if (string.equalsIgnoreCase("cx")) {
            n = 20493;
        } else if (string.equalsIgnoreCase("cy")) {
            n = 20494;
        } else if (string.equalsIgnoreCase("d")) {
            n = 20495;
        } else if (string.equalsIgnoreCase("dx")) {
            n = 20496;
        } else if (string.equalsIgnoreCase("dy")) {
            n = 20497;
        } else if (string.equalsIgnoreCase("f")) {
            n = 20498;
        } else if (string.equalsIgnoreCase("fx")) {
            n = 20499;
        } else if (string.equalsIgnoreCase("fy")) {
            n = 20500;
        } else if (string.equalsIgnoreCase("g")) {
            n = 20501;
        } else if (string.equalsIgnoreCase("gx")) {
            n = 20502;
        } else if (string.equalsIgnoreCase("gy")) {
            n = 20503;
        } else if (string.equalsIgnoreCase("h")) {
            n = 20504;
        } else if (string.equalsIgnoreCase("hx")) {
            n = 20505;
        } else if (string.equalsIgnoreCase("hy")) {
            n = 20506;
        } else if (string.equalsIgnoreCase("k")) {
            n = 20507;
        } else if (string.equalsIgnoreCase("kx")) {
            n = 20508;
        } else if (string.equalsIgnoreCase("ky")) {
            n = 20509;
        } else if (string.equalsIgnoreCase("m")) {
            n = 20510;
        } else if (string.equalsIgnoreCase("mx")) {
            n = 20511;
        } else if (string.equalsIgnoreCase("my")) {
            n = 20512;
        } else if (string.equalsIgnoreCase("n")) {
            n = 20513;
        } else if (string.equalsIgnoreCase("nx")) {
            n = 20514;
        } else if (string.equalsIgnoreCase("ny")) {
            n = 20515;
        } else if (string.equalsIgnoreCase("x")) {
            n = 20516;
        } else if (string.equalsIgnoreCase("t")) {
            n = 20517;
        } else if (string.equalsIgnoreCase("s")) {
            n = 20518;
        } else if (string.equalsIgnoreCase("z")) {
            n = 20519;
        } else if (string.equalsIgnoreCase("abs")) {
            n = 24577;
        } else if (string.equalsIgnoreCase("arg")) {
            n = 24578;
        } else if (string.equalsIgnoreCase("conj")) {
            n = 24579;
        } else if (string.equalsIgnoreCase("int")) {
            n = 24580;
        } else if (string.equalsIgnoreCase("ceil")) {
            n = 24581;
        } else if (string.equalsIgnoreCase("floor")) {
            n = 24582;
        } else if (string.equalsIgnoreCase("sqrt")) {
            n = 24583;
        } else if (string.equalsIgnoreCase("exp")) {
            n = 24584;
        } else if (string.equalsIgnoreCase("log")) {
            n = 24585;
        } else if (string.equalsIgnoreCase("ln")) {
            n = 24585;
        } else if (string.equalsIgnoreCase("sin")) {
            n = 24586;
        } else if (string.equalsIgnoreCase("cos")) {
            n = 24587;
        } else if (string.equalsIgnoreCase("tan")) {
            n = 24588;
        } else if (string.equalsIgnoreCase("cot")) {
            n = 24589;
        } else if (string.equalsIgnoreCase("sec")) {
            n = 24590;
        } else if (string.equalsIgnoreCase("csc")) {
            n = 24591;
        } else if (string.equalsIgnoreCase("sinh")) {
            n = 24592;
        } else if (string.equalsIgnoreCase("cosh")) {
            n = 24593;
        } else if (string.equalsIgnoreCase("tanh")) {
            n = 24594;
        } else if (string.equalsIgnoreCase("coth")) {
            n = 24595;
        } else if (string.equalsIgnoreCase("sech")) {
            n = 24596;
        } else if (string.equalsIgnoreCase("csch")) {
            n = 24597;
        } else if (string.equalsIgnoreCase("asin")) {
            n = 24598;
        } else if (string.equalsIgnoreCase("acos")) {
            n = 24599;
        } else if (string.equalsIgnoreCase("atan")) {
            n = 24600;
        } else if (string.equalsIgnoreCase("acot")) {
            n = 24601;
        } else if (string.equalsIgnoreCase("asec")) {
            n = 24602;
        } else if (string.equalsIgnoreCase("acsc")) {
            n = 24603;
        } else if (string.equalsIgnoreCase("asinh")) {
            n = 24604;
        } else if (string.equalsIgnoreCase("acosh")) {
            n = 24605;
        } else if (string.equalsIgnoreCase("atanh")) {
            n = 24606;
        } else if (string.equalsIgnoreCase("acoth")) {
            n = 24607;
        } else if (string.equalsIgnoreCase("asech")) {
            n = 24608;
        } else if (string.equalsIgnoreCase("acsch")) {
            n = 24609;
        } else if (string.equalsIgnoreCase("arcsin")) {
            n = 24598;
        } else if (string.equalsIgnoreCase("arccos")) {
            n = 24599;
        } else if (string.equalsIgnoreCase("arctan")) {
            n = 24600;
        } else if (string.equalsIgnoreCase("arccot")) {
            n = 24601;
        } else if (string.equalsIgnoreCase("arcsec")) {
            n = 24602;
        } else if (string.equalsIgnoreCase("arccsc")) {
            n = 24603;
        } else if (string.equalsIgnoreCase("arcsinh")) {
            n = 24604;
        } else if (string.equalsIgnoreCase("arccosh")) {
            n = 24605;
        } else if (string.equalsIgnoreCase("arctanh")) {
            n = 24606;
        } else if (string.equalsIgnoreCase("arccoth")) {
            n = 24607;
        } else if (string.equalsIgnoreCase("arcsech")) {
            n = 24608;
        } else if (string.equalsIgnoreCase("arccsch")) {
            n = 24609;
        } else if (string.equalsIgnoreCase("re")) {
            n = 24610;
        } else if (string.equalsIgnoreCase("im")) {
            n = 24611;
        } else if (string.equalsIgnoreCase("realonly")) {
            n = 24612;
        }
        return n;
    }

    private Complex ParseExpression() {
        Complex complex;
        if (this.token_type == 1) {
            complex = null;
        } else {
            complex = this.ParseExpr(0, false);
            if (this.token_type != 1) {
                this.ParseError("Unexpected text, at " + this.token_pos);
            }
        }
        return complex;
    }

    private Complex ParseExpr(int n, boolean bl) {
        Complex complex = null;
        if (n == 5) {
            if (this.token.equals("+") || this.token.equals("-")) {
                String string = this.token;
                this.LexGetToken();
                complex = this.ParseExpr(n, bl);
                complex = this.EvalOp(string, complex);
            } else if ((this.token_type & 0x6000) == 24576) {
                int n2 = this.token_type;
                this.LexGetToken();
                complex = this.ParseExpr(n, bl);
                complex = this.EvalFunction(n2, complex);
            } else {
                complex = this.ParseExpr(n + 1, bl);
            }
        } else if (n == 6) {
            if (this.token.equals("(")) {
                this.LexGetToken();
                complex = this.ParseExpr(0, false);
                if (this.token.equals(")")) {
                    this.LexGetToken();
                } else {
                    this.ParseError("Expected a matching ')', at " + this.token_pos);
                }
            } else if (this.token.equals("|") && !bl) {
                String string = this.token;
                this.LexGetToken();
                complex = this.ParseExpr(0, true);
                if (this.token.equals("|")) {
                    this.LexGetToken();
                } else {
                    this.ParseError("Expected a matching '|', at " + this.token_pos);
                }
                complex = this.EvalOp(string, complex);
            } else if (this.token_type == 2) {
                complex = this.EvalNumber(this.token);
                this.LexGetToken();
            } else if ((this.token_type & 0x5000) == 20480) {
                int n3 = this.token_type;
                complex = this.EvalVariable(n3);
                this.LexGetToken();
            } else if ((this.token_type & 0x4000) == 16384) {
                this.ParseError("Unknown identifier '" + this.token + "', at " + this.token_pos);
                this.LexGetToken();
            } else {
                this.ParseError("Expected an expression, at " + this.token_pos);
            }
        } else {
            complex = this.ParseExpr(n + 1, bl);
        }
        complex = this.ParseExprTail(n, complex, bl);
        return complex;
    }

    private Complex ParseExprTail(int n, Complex complex, boolean bl) {
        Complex complex2 = null;
        if (n == 0 && this.token.equals(",") || n == 1 && this.token.equalsIgnoreCase("dot") || n == 1 && this.token.equalsIgnoreCase("cross") || n == 2 && this.token.equals("+") || n == 2 && this.token.equals("-") || n == 3 && this.token.equals("*") || n == 3 && this.token.equals("/") || n == 3 && this.token.equalsIgnoreCase("rem") || n == 3 && this.token.equalsIgnoreCase("mod") || n == 4 && this.token.equals("^")) {
            String string = this.token;
            this.LexGetToken();
            Complex complex3 = this.ParseExpr(n + 1, bl);
            complex2 = this.EvalOp(string, complex, complex3);
            complex2 = this.ParseExprTail(n, complex2, bl);
        } else if (n == 3 && (this.token.equals("(") || this.token.equals("|") && !bl || this.token_type == 2 || (this.token_type & 0x5000) == 20480 || (this.token_type & 0x6000) == 24576)) {
            String string = "*";
            Complex complex4 = this.ParseExpr(n + 1, bl);
            complex2 = this.EvalOp(string, complex, complex4);
            complex2 = this.ParseExprTail(n, complex2, bl);
        } else if (n == 6 && this.token.equals(".")) {
            this.LexGetToken();
            if (this.token.equalsIgnoreCase("x") || this.token.equalsIgnoreCase("y")) {
                complex2 = this.EvalComponent(complex, this.token);
                this.LexGetToken();
            } else {
                this.ParseError("Expected '.x' or '.y', at " + this.token_pos);
            }
            complex2 = this.ParseExprTail(n, complex2, bl);
        } else {
            complex2 = complex;
        }
        return complex2;
    }

    private void ParseError(String string) {
        if (this.message.length() == 0) {
            this.message = string;
        }
    }

    private Complex EvalOp(String string, Complex complex) {
        Complex complex2 = null;
        if (complex != null) {
            if (string.equals("+")) {
                complex2 = complex;
            } else if (string.equals("-")) {
                complex2 = Complex.Neg(complex);
            } else if (string.equals("|")) {
                complex2 = Complex.Number(Complex.Abs(complex));
            }
        }
        return complex2;
    }

    private Complex EvalOp(String string, Complex complex, Complex complex2) {
        Complex complex3 = null;
        if (complex != null && complex2 != null) {
            if (string.equals(",")) {
                complex3 = Complex.Number(complex.re, complex2.re);
            } else if (string.equals("+")) {
                complex3 = Complex.Add(complex, complex2);
            } else if (string.equals("-")) {
                complex3 = Complex.Sub(complex, complex2);
            } else if (string.equals("*")) {
                complex3 = Complex.Mul(complex, complex2);
            } else if (string.equals("/")) {
                complex3 = Complex.Div(complex, complex2);
            } else if (string.equalsIgnoreCase("rem")) {
                complex3 = Complex.Rem(complex, complex2);
            } else if (string.equalsIgnoreCase("mod")) {
                complex3 = Complex.Mod(complex, complex2);
            } else if (string.equals("^")) {
                complex3 = Complex.Pow(complex, complex2);
            } else if (string.equalsIgnoreCase("dot")) {
                complex3 = Complex.Number(Complex.Dot(complex, complex2));
            } else if (string.equalsIgnoreCase("cross")) {
                complex3 = Complex.Number(Complex.Cross(complex, complex2));
            } else {
                this.ParseError("Expected an operator, at " + this.token_pos);
            }
        }
        return complex3;
    }

    private Complex EvalComponent(Complex complex, String string) {
        Complex complex2 = null;
        if (complex != null) {
            if (string.equalsIgnoreCase("x")) {
                complex2 = Complex.Number(complex.re);
            } else if (string.equalsIgnoreCase("y")) {
                complex2 = Complex.Number(complex.im);
            } else {
                this.ParseError("Expected 'x' or 'y', at " + this.token_pos);
            }
        }
        return complex2;
    }

    private Complex EvalNumber(String string) {
        Complex complex = null;
        Double d = PGC_Utility.DoubleValue(string);
        if (d == null) {
            this.ParseError("Bad number format '" + string + "', at " + this.token_pos);
        } else {
            complex = Complex.Number(d);
        }
        return complex;
    }

    private Complex EvalVariable(int n) {
        Complex complex = null;
        if (n == 20481) {
            complex = Complex.Number(0.0, 1.0);
        } else if (n == 20482) {
            complex = Complex.Number(Math.PI);
        } else if (n == 20483) {
            complex = Complex.Number(Math.E);
        } else if (n == 20484) {
            complex = Complex.Number(Double.POSITIVE_INFINITY);
        } else if (n == 20485) {
            complex = Complex.Number(Double.NaN);
        } else if (n == 20486) {
            complex = this.owner.GetVariableCoordinates(0);
            if (complex != null) {
                complex = Complex.Number(complex);
            }
            this.uses_input[0] = true;
        } else if (n == 20487) {
            complex = this.owner.GetVariableCoordinates(0);
            if (complex != null) {
                complex = Complex.Number(complex.re);
            }
            this.uses_input[0] = true;
        } else if (n == 20488) {
            complex = this.owner.GetVariableCoordinates(0);
            if (complex != null) {
                complex = Complex.Number(complex.im);
            }
            this.uses_input[0] = true;
        } else if (n == 20489) {
            complex = this.owner.GetVariableCoordinates(1);
            if (complex != null) {
                complex = Complex.Number(complex);
            }
            this.uses_input[1] = true;
        } else if (n == 20490) {
            complex = this.owner.GetVariableCoordinates(1);
            if (complex != null) {
                complex = Complex.Number(complex.re);
            }
            this.uses_input[1] = true;
        } else if (n == 20491) {
            complex = this.owner.GetVariableCoordinates(1);
            if (complex != null) {
                complex = Complex.Number(complex.im);
            }
            this.uses_input[1] = true;
        } else if (n == 20492) {
            complex = this.owner.GetVariableCoordinates(2);
            if (complex != null) {
                complex = Complex.Number(complex);
            }
            this.uses_input[2] = true;
        } else if (n == 20493) {
            complex = this.owner.GetVariableCoordinates(2);
            if (complex != null) {
                complex = Complex.Number(complex.re);
            }
            this.uses_input[2] = true;
        } else if (n == 20494) {
            complex = this.owner.GetVariableCoordinates(2);
            if (complex != null) {
                complex = Complex.Number(complex.im);
            }
            this.uses_input[2] = true;
        } else if (n == 20495) {
            complex = this.owner.GetVariableCoordinates(3);
            if (complex != null) {
                complex = Complex.Number(complex);
            }
            this.uses_input[3] = true;
        } else if (n == 20496) {
            complex = this.owner.GetVariableCoordinates(3);
            if (complex != null) {
                complex = Complex.Number(complex.re);
            }
            this.uses_input[3] = true;
        } else if (n == 20497) {
            complex = this.owner.GetVariableCoordinates(3);
            if (complex != null) {
                complex = Complex.Number(complex.im);
            }
            this.uses_input[3] = true;
        } else if (n == 20498) {
            complex = this.EvalUserDefinedFunction(4, 0);
        } else if (n == 20499) {
            complex = this.EvalUserDefinedFunction(4, 1);
        } else if (n == 20500) {
            complex = this.EvalUserDefinedFunction(4, 2);
        } else if (n == 20501) {
            complex = this.EvalUserDefinedFunction(5, 0);
        } else if (n == 20502) {
            complex = this.EvalUserDefinedFunction(5, 1);
        } else if (n == 20503) {
            complex = this.EvalUserDefinedFunction(5, 2);
        } else if (n == 20504) {
            complex = this.EvalUserDefinedFunction(6, 0);
        } else if (n == 20505) {
            complex = this.EvalUserDefinedFunction(6, 1);
        } else if (n == 20506) {
            complex = this.EvalUserDefinedFunction(6, 2);
        } else if (n == 20507) {
            complex = this.EvalUserDefinedFunction(7, 0);
        } else if (n == 20508) {
            complex = this.EvalUserDefinedFunction(7, 1);
        } else if (n == 20509) {
            complex = this.EvalUserDefinedFunction(7, 2);
        } else if (n == 20510) {
            complex = this.EvalUserDefinedFunction(8, 0);
        } else if (n == 20511) {
            complex = this.EvalUserDefinedFunction(8, 1);
        } else if (n == 20512) {
            complex = this.EvalUserDefinedFunction(8, 2);
        } else if (n == 20513) {
            complex = this.EvalUserDefinedFunction(9, 0);
        } else if (n == 20514) {
            complex = this.EvalUserDefinedFunction(9, 1);
        } else if (n == 20515) {
            complex = this.EvalUserDefinedFunction(9, 2);
        } else if (n == 20516) {
            complex = this.owner.GetAutoplotVariable();
            this.uses_autoplot = true;
            this.uses_autoplot_x = true;
        } else if (n == 20517) {
            complex = this.owner.GetAutoplotVariable();
            this.uses_autoplot = true;
            this.uses_autoplot_t = true;
        } else if (n == 20518) {
            complex = this.owner.GetAutoincrementVariable();
        } else if (n == 20519) {
            complex = Complex.Number(this.owner.GetZoom(), 0.0);
        }
        return complex;
    }

    private Complex EvalFunction(int n, Complex complex) {
        Complex complex2 = null;
        if (complex != null) {
            if (n == 24577) {
                complex2 = Complex.Number(Complex.Abs(complex));
            } else if (n == 24578) {
                complex2 = Complex.Number(Complex.Arg(complex));
            } else if (n == 24579) {
                complex2 = Complex.Conj(complex);
            } else if (n == 24580) {
                complex2 = Complex.Int(complex);
            } else if (n == 24581) {
                complex2 = Complex.Ceil(complex);
            } else if (n == 24582) {
                complex2 = Complex.Floor(complex);
            } else if (n == 24583) {
                complex2 = Complex.Sqrt(complex);
            } else if (n == 24584) {
                complex2 = Complex.Exp(complex);
            } else if (n == 24585) {
                complex2 = Complex.Log(complex);
            } else if (n == 24586) {
                complex2 = Complex.Sin(complex);
            } else if (n == 24587) {
                complex2 = Complex.Cos(complex);
            } else if (n == 24588) {
                complex2 = Complex.Tan(complex);
            } else if (n == 24589) {
                complex2 = Complex.Cot(complex);
            } else if (n == 24590) {
                complex2 = Complex.Sec(complex);
            } else if (n == 24591) {
                complex2 = Complex.Csc(complex);
            } else if (n == 24592) {
                complex2 = Complex.Sinh(complex);
            } else if (n == 24593) {
                complex2 = Complex.Cosh(complex);
            } else if (n == 24594) {
                complex2 = Complex.Tanh(complex);
            } else if (n == 24595) {
                complex2 = Complex.Coth(complex);
            } else if (n == 24596) {
                complex2 = Complex.Sech(complex);
            } else if (n == 24597) {
                complex2 = Complex.Csch(complex);
            } else if (n == 24598) {
                complex2 = Complex.Asin(complex);
            } else if (n == 24599) {
                complex2 = Complex.Acos(complex);
            } else if (n == 24600) {
                complex2 = Complex.Atan(complex);
            } else if (n == 24601) {
                complex2 = Complex.Acot(complex);
            } else if (n == 24602) {
                complex2 = Complex.Asec(complex);
            } else if (n == 24603) {
                complex2 = Complex.Acsc(complex);
            } else if (n == 24604) {
                complex2 = Complex.Asinh(complex);
            } else if (n == 24605) {
                complex2 = Complex.Acosh(complex);
            } else if (n == 24606) {
                complex2 = Complex.Atanh(complex);
            } else if (n == 24607) {
                complex2 = Complex.Acoth(complex);
            } else if (n == 24608) {
                complex2 = Complex.Asech(complex);
            } else if (n == 24609) {
                complex2 = Complex.Acsch(complex);
            } else if (n == 24610) {
                complex2 = Complex.Number(complex.re);
            } else if (n == 24611) {
                complex2 = Complex.Number(complex.im);
            } else if (n == 24612 && this.owner.LooksReal(complex)) {
                complex2 = Complex.Number(complex);
            }
        }
        return complex2;
    }

    private Complex EvalUserDefinedFunction(int n, int n2) {
        Complex complex = null;
        if (this.allowed[n]) {
            PGC_Eval pGC_Eval = new PGC_Eval(this.owner);
            int n3 = 0;
            while (n3 < this.allowed.length) {
                pGC_Eval.allowed[n3] = this.allowed[n3];
                ++n3;
            }
            pGC_Eval.allowed[n] = false;
            String string = this.owner.GetVariableExpression(n);
            pGC_Eval.Evaluate(string);
            complex = pGC_Eval.value;
            if (complex != null) {
                if (n2 == 1) {
                    complex = Complex.Number(complex.re);
                }
                if (n2 == 2) {
                    complex = Complex.Number(complex.im);
                }
            }
            if (pGC_Eval.recursive != null) {
                this.recursive = pGC_Eval.recursive;
            }
            if (pGC_Eval.uses_autoplot) {
                this.uses_autoplot = true;
            }
            if (pGC_Eval.uses_autoplot_x) {
                this.uses_autoplot_x = true;
            }
            if (pGC_Eval.uses_autoplot_t) {
                this.uses_autoplot_t = true;
            }
            int n4 = 0;
            while (n4 < this.uses_input.length) {
                if (pGC_Eval.uses_input[n4]) {
                    this.uses_input[n4] = true;
                }
                ++n4;
            }
        } else {
            this.recursive = this.owner.variable[n].name;
        }
        return complex;
    }
}

