/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;

public class PGC
extends Applet {
    private String[] main_args;
    private PGC_Frame main_frame;
    private Container main_parent;
    private Dimension main_size;
    private Point main_location;
    private Panel pnl_root_launch;
    private Panel pnl_root_calculator;
    private PGC_GraphPanel pnl_graph;
    private Panel pnl_ctl;
    private Panel pnl_ctl_buttons;
    private Panel pnl_ctl_buttons_function;
    private Panel pnl_ctl_buttons_zoom;
    private Panel pnl_ctl_buttons_func;
    private Panel pnl_ctl_coordinates;
    private Panel pnl_ctl_coordinates_description;
    private PGC_ChoiceOp choice_op;
    private PGC_ButtonFixed btn_zoomout;
    private PGC_ButtonFixed btn_zoomin;
    private Checkbox chk_line;
    private Checkbox chk_spin;
    private Checkbox chk_plot;
    private PGC_ButtonFixed btn_details;
    private PGC_ButtonFixed btn_step;
    private PGC_ButtonFixed btn_plot_clear;
    private PGC_ButtonFixed btn_about;
    private PGC_ButtonFixed btn_attach_detach;
    private Button btn_launch;
    private Label lbl_zoom;
    private PGC_LabelFixed lbl_description;
    private PGC_LabelFixed lbl_coordinate_x;
    private PGC_LabelFixed lbl_coordinate_y;
    private PGC_LabelFixed lbl_f_expr;
    private PGC_LabelFixed lbl_g_expr;
    private PGC_TextFieldFixed txt_f_expr;
    private PGC_TextFieldFixed txt_g_expr;
    private PGC_TextFrame about_frame;
    private Point about_location;
    private PGC_DetailsFrame details_frame;
    private Point details_location;
    private static PGC_TextFrame trace_frame = null;
    private PGC_Eval eval = new PGC_Eval(this);
    public boolean stand_alone = false;
    public boolean launch_mode = false;
    public static boolean option_enable_trace = true;
    public String option_launch_button = "";
    public int option_launch_size_x = 560;
    public int option_launch_size_y = 440;
    public String option_background_image;
    public boolean option_control_panel = true;
    public boolean option_graph_border = true;
    public boolean option_builtin_functions = true;
    public boolean option_builtin_examples = true;
    public Complex option_center = Complex.Number(0.0);
    public int option_zoom = 80;
    public boolean option_line = true;
    public boolean option_plot = false;
    public boolean option_spin = false;
    public int option_active;
    public int option_op = 1;
    public PGC_Variable[] variable = new PGC_Variable[14];
    public double t_minimum = -10.0;
    public double t_maximum = 10.0;
    public int t_count = 200;
    public static Color color_panel = new Color(204, 204, 204);
    public static Color color_background = new Color(255, 255, 255);
    public static Color color_axis = new Color(0, 0, 0);
    public static Color color_grid = new Color(236, 236, 236);
    public static Color color_origin_connector_line = new Color(204, 204, 204);
    public static Color color_input_point = new Color(0, 0, 0);
    public static Color color_input_label = new Color(102, 102, 102);
    public static Color color_func_f_point = new Color(0, 0, 255);
    public static Color color_func_f_label = new Color(0, 0, 255);
    public static Color color_func_f_plot = new Color(153, 153, 255);
    public static Color color_func_g_point = new Color(204, 0, 0);
    public static Color color_func_g_label = new Color(204, 0, 0);
    public static Color color_func_g_plot = new Color(255, 153, 153);
    public static Color color_func_h_point = new Color(0, 153, 0);
    public static Color color_func_h_label = new Color(0, 153, 0);
    public static Color color_func_h_plot = new Color(0, 204, 0);
    public static Color color_func_k_point = new Color(204, 0, 204);
    public static Color color_func_k_label = new Color(204, 0, 204);
    public static Color color_func_k_plot = new Color(204, 102, 204);
    public static Color color_func_m_point = new Color(0, 153, 153);
    public static Color color_func_m_label = new Color(0, 153, 153);
    public static Color color_func_m_plot = new Color(102, 204, 204);
    public static Color color_func_n_point = new Color(102, 102, 102);
    public static Color color_func_n_label = new Color(102, 102, 102);
    public static Color color_func_n_plot = new Color(153, 153, 153);
    public static Color color_lightray = new Color(255, 204, 0);
    public static Color color_shadow = new Color(255, 102, 153);
    public static Color color_shadow_label = new Color(255, 0, 0);
    public static Color color_3d_dark = new Color(153, 153, 153);
    public static Color color_3d_light = new Color(236, 236, 236);
    public static Dimension component_tiny_button_size = new Dimension(24, -1);
    public static Dimension component_normal_button_size = new Dimension(64, -1);
    public static Dimension component_number_text_size = new Dimension(164, -1);
    public static Dimension component_wide_text_size = new Dimension(360, -1);
    public static Dimension component_full_text_size = new Dimension(388, -1);
    public static final int VAR_A = 0;
    public static final int VAR_B = 1;
    public static final int VAR_C = 2;
    public static final int VAR_D = 3;
    public static final int VAR_F = 4;
    public static final int VAR_G = 5;
    public static final int VAR_H = 6;
    public static final int VAR_K = 7;
    public static final int VAR_M = 8;
    public static final int VAR_N = 9;
    public static final int VAR_SHADOW_X = 10;
    public static final int VAR_SHADOW_Y = 11;
    public static final int VAR_AUTOPLOT = 12;
    public static final int VAR_AUTOINCREMENT = 13;
    public static final int VAR_COUNT = 14;
    public static final int OP_UNDEFINED = 0;
    public static final int OP_ADD = 1;
    public static final int OP_SUB = 2;
    public static final int OP_MUL = 3;
    public static final int OP_DIV = 4;
    public static final int OP_POW = 5;
    public static final int OP_DOT = 6;
    public static final int OP_CROSS = 7;
    public static final int OP_MAT = 8;
    public static final int OP_SQRT = 9;
    public static final int OP_CUBERT = 10;
    public static final int OP_EXP = 11;
    public static final int OP_USER = 12;
    public static final int OP_EXAMPLE_1 = 13;
    public static final int OP_EXAMPLE_2 = 14;
    public static final int OP_EXAMPLE_3 = 15;
    public static final int OP_EXAMPLE_4 = 16;
    public static final int OP_EXAMPLE_5 = 17;
    public static final int OP_EXAMPLE_6 = 18;
    public static final int OP_EXAMPLE_7 = 19;
    public static final int OP_EXAMPLE_8 = 20;
    public static final int OP_COUNT = 21;
    public static final int OP_EXAMPLE_9 = 21;
    public static final int OP_EXAMPLE_10 = 22;

    public void MainFrameLaunch() {
        if (this.main_frame == null) {
            Dimension dimension;
            this.main_frame = new PGC_Frame(this, "Plane Graphic Calculator");
            this.LayoutCalculator();
            this.SetOptions();
            this.main_frame.setLayout(new BorderLayout());
            this.main_frame.add("Center", this.pnl_root_calculator);
            this.main_frame.pack();
            if (this.main_size == null) {
                dimension = new Dimension(this.option_launch_size_x, this.option_launch_size_y);
                dimension.height += 50;
                dimension.width += 6;
                this.main_size = dimension;
            } else {
                dimension = new Dimension(this.main_size);
            }
            this.main_frame.resize(dimension);
            if (this.main_location == null) {
                this.main_location = new Point(20, 20);
            }
            this.main_frame.move(this.main_location.x, this.main_location.y);
            this.main_frame.validate();
            if (this.btn_attach_detach != null) {
                this.btn_attach_detach.setLabel("Close");
            }
            this.main_frame.show();
            return;
        }
        this.main_frame.toFront();
        this.main_frame.show();
        this.main_frame.requestFocus();
    }

    public void MainFrameUnlaunch() {
        if (this.main_frame != null) {
            this.main_size = new Dimension(this.main_frame.size());
            Point point = this.main_frame.location();
            this.main_location = new Point(point.x, point.y);
            this.main_frame.remove(this);
            this.main_frame.dispose();
            this.main_frame = null;
        }
    }

    public void MainFrameDetach() {
        Dimension dimension;
        this.main_parent = this.getParent();
        this.main_frame = new PGC_Frame(this, "Plane Graphic Calculator");
        if (this.main_size == null) {
            this.main_size = this.main_parent == null ? new Dimension(this.size()) : new Dimension(this.main_parent.size());
            dimension = new Dimension(this.main_size);
            dimension.height += 50;
            dimension.width += 6;
        } else {
            dimension = new Dimension(this.main_size);
        }
        this.main_frame.resize(dimension);
        if (this.main_location == null) {
            if (this.main_parent == null) {
                this.main_location = new Point(20, 20);
            } else {
                Point point = this.main_parent.location();
                this.main_location = new Point(point.x + 20, point.y + 20);
            }
        }
        this.main_frame.move(this.main_location.x, this.main_location.y);
        this.main_frame.add("Center", this);
        this.main_frame.validate();
        if (this.btn_attach_detach != null) {
            this.btn_attach_detach.setLabel("Attach");
        }
        this.main_frame.show();
    }

    public void MainFrameAttach() {
        if (this.stand_alone) {
            System.exit(0);
        }
        this.main_size = new Dimension(this.getParent().size());
        Point point = this.getParent().location();
        this.main_location = new Point(point.x, point.y);
        if (this.main_frame != null) {
            this.main_frame.remove(this);
            this.main_frame.dispose();
            this.main_frame = null;
        }
        if (this.main_parent != null) {
            this.main_parent.add("Center", this);
            this.main_parent.validate();
            if (this.btn_attach_detach != null) {
                this.btn_attach_detach.setLabel("Detach");
            }
            this.main_parent.show();
        }
    }

    public void MainFrameDestroy() {
        if (this.main_frame != null) {
            this.main_frame.remove(this);
            this.main_frame.dispose();
            this.main_frame = null;
        }
        this.FrameDestroy(this.about_frame);
        this.FrameDestroy(this.details_frame);
    }

    public void MainFrameClose() {
        if (this.launch_mode) {
            this.MainFrameUnlaunch();
            this.MainFrameDestroy();
            return;
        }
        this.MainFrameAttach();
    }

    public static GridBagConstraints StdConstraintsFillMax() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    public static GridBagConstraints StdConstraintsFillMax(Insets insets) {
        GridBagConstraints gridBagConstraints = PGC.StdConstraintsFillMax();
        gridBagConstraints.insets = insets;
        return gridBagConstraints;
    }

    public static GridBagConstraints StdConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    public static GridBagConstraints StdConstraints(Insets insets) {
        GridBagConstraints gridBagConstraints = PGC.StdConstraints();
        gridBagConstraints.insets = insets;
        return gridBagConstraints;
    }

    public static GridBagConstraints StdConstraintsNewLine() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    public static GridBagConstraints StdConstraintsNewLine(Insets insets) {
        GridBagConstraints gridBagConstraints = PGC.StdConstraintsNewLine();
        gridBagConstraints.insets = insets;
        return gridBagConstraints;
    }

    public static Panel StdPanel() {
        Panel panel = new Panel();
        panel.setBackground(color_panel);
        panel.setLayout(new GridBagLayout());
        return panel;
    }

    private void LayoutCalculator() {
        Component component = this.pnl_root_calculator = PGC.StdPanel();
        this.pnl_graph = new PGC_GraphPanel(this);
        component = this.pnl_graph;
        this.pnl_root_calculator.add(this.pnl_graph);
        ((GridBagLayout)this.pnl_root_calculator.getLayout()).setConstraints(component, PGC.StdConstraintsFillMax());
        if (this.option_control_panel) {
            component = this.pnl_ctl = PGC.StdPanel();
            this.pnl_root_calculator.add(this.pnl_ctl);
            ((GridBagLayout)this.pnl_root_calculator.getLayout()).setConstraints(component, PGC.StdConstraintsNewLine(new Insets(5, 10, 5, 0)));
            component = this.pnl_ctl_buttons = PGC.StdPanel();
            this.pnl_ctl.add(this.pnl_ctl_buttons);
            ((GridBagLayout)this.pnl_ctl.getLayout()).setConstraints(component, PGC.StdConstraints());
            component = this.pnl_ctl_buttons_function = PGC.StdPanel();
            this.pnl_ctl_buttons.add(this.pnl_ctl_buttons_function);
            ((GridBagLayout)this.pnl_ctl_buttons.getLayout()).setConstraints(component, PGC.StdConstraintsNewLine(new Insets(3, 0, 0, 0)));
            component = new Label("Function: ");
            this.pnl_ctl_buttons_function.add(component);
            this.choice_op = new PGC_ChoiceOp(this);
            component = this.choice_op;
            this.pnl_ctl_buttons_function.add(this.choice_op);
            this.choice_op.setBackground(Color.white);
            int n = 1;
            while (n < 21) {
                if ((n >= 12 || this.option_builtin_functions) && (n <= 12 || this.option_builtin_examples)) {
                    this.choice_op.addItem(PGC.OpChoiceLabel(n));
                }
                ++n;
            }
            component = new PGC_LabelFixed(new Dimension(10, -1));
            this.pnl_ctl_buttons_function.add(component);
            this.btn_details = new PGC_ButtonFixed("Details", component_normal_button_size);
            component = this.btn_details;
            this.pnl_ctl_buttons_function.add(this.btn_details);
            this.btn_step = new PGC_ButtonFixed("Step", component_normal_button_size);
            component = this.btn_step;
            this.pnl_ctl_buttons_function.add(this.btn_step);
            this.btn_plot_clear = new PGC_ButtonFixed("Clear", component_normal_button_size);
            component = this.btn_plot_clear;
            this.pnl_ctl_buttons_function.add(this.btn_plot_clear);
            this.btn_about = new PGC_ButtonFixed("About", component_normal_button_size);
            component = this.btn_about;
            this.pnl_ctl_buttons_function.add(this.btn_about);
            if (!this.stand_alone) {
                this.btn_attach_detach = new PGC_ButtonFixed("Detach", component_normal_button_size);
                component = this.btn_attach_detach;
                this.pnl_ctl_buttons_function.add(this.btn_attach_detach);
            }
            component = this.pnl_ctl_buttons_zoom = PGC.StdPanel();
            this.pnl_ctl_buttons.add(this.pnl_ctl_buttons_zoom);
            ((GridBagLayout)this.pnl_ctl_buttons.getLayout()).setConstraints(component, PGC.StdConstraintsNewLine(new Insets(3, 0, 0, 0)));
            this.lbl_zoom = new Label("Zoom: 9999 X ");
            component = this.lbl_zoom;
            this.pnl_ctl_buttons_zoom.add(this.lbl_zoom);
            this.btn_zoomout = new PGC_ButtonFixed("-", component_tiny_button_size);
            component = this.btn_zoomout;
            this.pnl_ctl_buttons_zoom.add(this.btn_zoomout);
            this.btn_zoomin = new PGC_ButtonFixed("+", component_tiny_button_size);
            component = this.btn_zoomin;
            this.pnl_ctl_buttons_zoom.add(this.btn_zoomin);
            component = new PGC_LabelFixed(new Dimension(20, -1));
            this.pnl_ctl_buttons_zoom.add(component);
            this.lbl_coordinate_x = new PGC_LabelFixed("x =", new Dimension(82, -1));
            component = this.lbl_coordinate_x;
            this.pnl_ctl_buttons_zoom.add(this.lbl_coordinate_x);
            component = new PGC_LabelFixed(new Dimension(4, -1));
            this.pnl_ctl_buttons_zoom.add(component);
            this.lbl_coordinate_y = new PGC_LabelFixed("y =", new Dimension(82, -1));
            component = this.lbl_coordinate_y;
            this.pnl_ctl_buttons_zoom.add(this.lbl_coordinate_y);
            component = new PGC_LabelFixed(new Dimension(20, -1));
            this.pnl_ctl_buttons_zoom.add(component);
            this.chk_plot = new Checkbox("Plot  ", null, false);
            component = this.chk_plot;
            this.pnl_ctl_buttons_zoom.add(this.chk_plot);
            this.chk_spin = new Checkbox("Spin  ", null, false);
            component = this.chk_spin;
            this.pnl_ctl_buttons_zoom.add(this.chk_spin);
            this.chk_line = new Checkbox("Line  ", null, false);
            component = this.chk_line;
            this.pnl_ctl_buttons_zoom.add(this.chk_line);
            component = this.pnl_ctl_buttons_func = PGC.StdPanel();
            this.pnl_ctl_buttons.add(this.pnl_ctl_buttons_func);
            ((GridBagLayout)this.pnl_ctl_buttons.getLayout()).setConstraints(component, PGC.StdConstraintsNewLine(new Insets(3, 0, 0, 0)));
            this.lbl_f_expr = new PGC_LabelFixed("f = ", new Dimension(22, -1));
            component = this.lbl_f_expr;
            this.pnl_ctl_buttons_func.add(this.lbl_f_expr);
            ((GridBagLayout)this.pnl_ctl_buttons_func.getLayout()).setConstraints(component, PGC.StdConstraints());
            this.txt_f_expr = new PGC_TextFieldFixed(this, new Dimension(220, -1));
            component = this.txt_f_expr;
            this.pnl_ctl_buttons_func.add(this.txt_f_expr);
            component = new PGC_LabelFixed("", new Dimension(12, -1));
            this.pnl_ctl_buttons_func.add(component);
            this.lbl_g_expr = new PGC_LabelFixed("g = ", new Dimension(26, -1));
            component = this.lbl_g_expr;
            this.pnl_ctl_buttons_func.add(this.lbl_g_expr);
            ((GridBagLayout)this.pnl_ctl_buttons_func.getLayout()).setConstraints(component, PGC.StdConstraints());
            this.txt_g_expr = new PGC_TextFieldFixed(this, new Dimension(220, -1));
            component = this.txt_g_expr;
            this.pnl_ctl_buttons_func.add(this.txt_g_expr);
        }
        this.pnl_graph.init();
        this.pnl_graph.show();
    }

    private void LayoutLaunchButton() {
        Component component = this.pnl_root_launch = PGC.StdPanel();
        this.btn_launch = new Button(this.option_launch_button);
        component = this.btn_launch;
        this.pnl_root_launch.add(this.btn_launch);
        ((GridBagLayout)this.pnl_root_launch.getLayout()).setConstraints(component, PGC.StdConstraintsFillMax());
    }

    private void DefineVariables() {
        int n = 0;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "a";
        this.variable[n].is_input = true;
        this.variable[n].coordinates = Complex.Number(1.0, 1.0);
        n = 1;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "b";
        this.variable[n].is_input = true;
        this.variable[n].coordinates = Complex.Number(1.125, -0.25);
        n = 2;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "c";
        this.variable[n].is_input = true;
        this.variable[n].coordinates = Complex.Number(-0.5, -1.0);
        n = 3;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "d";
        this.variable[n].is_input = true;
        this.variable[n].coordinates = Complex.Number(-0.25, 0.5);
        n = 4;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "f";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 5;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "g";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 6;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "h";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 7;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "k";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 8;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "m";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 9;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "n";
        this.variable[n].is_function = true;
        this.variable[n].expression = "";
        n = 10;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "x";
        n = 11;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "y";
        n = 12;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "";
        this.variable[n].is_autoplot_var = true;
        n = 13;
        this.variable[n] = new PGC_Variable();
        this.variable[n].index = n;
        this.variable[n].name = "";
        this.variable[n].is_autoincr_var = true;
        this.variable[n].coordinates = Complex.Number(0.0, 0.0);
    }

    public static String OpDescription(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "Addition";
                break;
            }
            case 2: {
                string = "Subtraction";
                break;
            }
            case 3: {
                string = "Complex multiplication";
                break;
            }
            case 4: {
                string = "Complex division";
                break;
            }
            case 5: {
                string = "Complex power";
                break;
            }
            case 6: {
                string = "Vector dot product";
                break;
            }
            case 7: {
                string = "Vector cross product";
                break;
            }
            case 8: {
                string = "Matrix multiplication";
                break;
            }
            case 9: {
                string = "Complex square roots";
                break;
            }
            case 10: {
                string = "Complex cube roots";
                break;
            }
            case 11: {
                string = "Complex exponential";
                break;
            }
            case 12: {
                string = "User-defined functions";
                break;
            }
            case 13: {
                string = "Example 1";
                break;
            }
            case 14: {
                string = "Example 2";
                break;
            }
            case 15: {
                string = "Example 3";
                break;
            }
            case 16: {
                string = "Example 4";
                break;
            }
            case 17: {
                string = "Example 5";
                break;
            }
            case 18: {
                string = "Example 6";
                break;
            }
            case 19: {
                string = "Example 7";
                break;
            }
            case 20: {
                string = "Example 8";
                break;
            }
            case 21: {
                string = "Example 9";
                break;
            }
            case 22: {
                string = "Example 10";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String OpLabel(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "f = a + b";
                break;
            }
            case 2: {
                string = "f = a - b";
                break;
            }
            case 3: {
                string = "f = a * b";
                break;
            }
            case 4: {
                string = "f = a / b";
                break;
            }
            case 5: {
                string = "f = a ^ b";
                break;
            }
            case 6: {
                string = "f = a \u00b7 b";
                break;
            }
            case 7: {
                string = "f = a \u00d7 b";
                break;
            }
            case 8: {
                string = "f = mat(a,b) \u00b7 c";
                break;
            }
            case 9: {
                string = "f = V\u00afa";
                break;
            }
            case 10: {
                string = "f = 3V\u00afa";
                break;
            }
            case 11: {
                string = "f = exp a";
                break;
            }
            case 12: {
                string = "user-defined";
                break;
            }
            case 13: {
                string = "example 1";
                break;
            }
            case 14: {
                string = "example 2";
                break;
            }
            case 15: {
                string = "example 3";
                break;
            }
            case 16: {
                string = "example 4";
                break;
            }
            case 17: {
                string = "example 5";
                break;
            }
            case 18: {
                string = "example 6";
                break;
            }
            case 19: {
                string = "example 7";
                break;
            }
            case 20: {
                string = "example 8";
                break;
            }
            case 21: {
                string = "example 9";
                break;
            }
            case 22: {
                string = "example 10";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String OpExpression(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "a + b";
                break;
            }
            case 2: {
                string = "a - b";
                break;
            }
            case 3: {
                string = "a * b";
                break;
            }
            case 4: {
                string = "a / b";
                break;
            }
            case 5: {
                string = "a ^ b";
                break;
            }
            case 6: {
                string = "a dot b";
                break;
            }
            case 7: {
                string = "a cross b";
                break;
            }
            case 8: {
                string = "(a dot c, b dot c)";
                break;
            }
            case 9: {
                string = "sqrt a";
                break;
            }
            case 10: {
                string = "a ^ (1/3)";
                break;
            }
            case 11: {
                string = "exp a";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String OpChoiceLabel(int n) {
        return "  " + PGC.OpLabel(n) + "  ";
    }

    public static int OpEvalChoiceLabel(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < 21) {
            if (string.equals(PGC.OpChoiceLabel(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static int OpArgCount(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 1;
                break;
            }
            case 10: {
                n2 = 1;
                break;
            }
            case 11: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static void Trace(Object object) {
        if (option_enable_trace) {
            if (trace_frame == null) {
                trace_frame = new PGC_TextFrame(null, "Trace", 20, 80);
                trace_frame.init();
                trace_frame.show();
            }
            trace_frame.Write(object);
        }
    }

    public static void AssertionFailure() {
        throw new Error("assertion failure");
    }

    public boolean GetLine() {
        return this.pnl_graph.GetLine();
    }

    public void SetLine(boolean bl) {
        if (this.pnl_ctl != null && this.chk_line.getState() == !bl) {
            this.chk_line.setState(bl);
        }
        this.pnl_graph.SetLine(bl);
    }

    public void CheckLine(Boolean bl) {
        if (bl != null) {
            this.SetLine(bl);
            return;
        }
        this.SetLine(!this.GetLine());
    }

    public boolean GetSpin() {
        return this.pnl_graph.GetSpin();
    }

    public void SetSpin(boolean bl) {
        if (bl && !this.GetEnableSpin()) {
            bl = false;
        }
        if (this.pnl_ctl != null && this.chk_spin.getState() == !bl) {
            this.chk_spin.setState(bl);
        }
        this.pnl_graph.SetSpin(bl);
    }

    public void CheckSpin(Boolean bl) {
        if (bl != null) {
            this.SetSpin(bl);
            return;
        }
        this.SetSpin(!this.GetSpin());
    }

    public void EnableSpin(boolean bl) {
        if (this.pnl_ctl != null) {
            this.chk_spin.enable(bl);
        }
        this.pnl_graph.EnableSpin(bl);
        if (!bl) {
            this.SetSpin(false);
        }
    }

    public boolean GetEnableSpin() {
        return this.pnl_graph.GetEnableSpin();
    }

    public boolean GetPlot() {
        return this.pnl_graph.GetPlot();
    }

    public void SetPlot(boolean bl) {
        if (this.pnl_ctl != null && this.chk_plot.getState() == !bl) {
            this.chk_plot.setState(bl);
        }
        this.pnl_graph.SetPlot(bl);
    }

    public void CheckPlot(Boolean bl) {
        if (bl != null) {
            this.SetPlot(bl);
            return;
        }
        this.SetPlot(!this.GetPlot());
    }

    public void Clear() {
        this.SetPlot(false);
        this.SetAutoincrementVariable(Complex.Number(0.0));
        this.pnl_graph.PlotClear();
        this.UpdateDisplay();
    }

    public void AttachDetach() {
        if (this.btn_attach_detach != null) {
            if (this.main_frame == null) {
                this.MainFrameDetach();
                return;
            }
            this.MainFrameClose();
        }
    }

    public void GraphFocus() {
        this.pnl_graph.requestFocus();
    }

    public void About() {
        if (this.about_frame == null) {
            this.about_frame = new PGC_TextFrame(this, "Plane Graphic Calculator", 10, 50);
            this.about_frame.init();
            if (this.about_location != null) {
                this.about_frame.move(this.about_location.x, this.about_location.y);
            } else {
                this.about_frame.move(50, 50);
            }
            this.AboutText();
            this.about_frame.show();
        }
        this.about_frame.toFront();
        this.about_frame.show();
        this.about_frame.requestFocus();
    }

    private void AboutText() {
        String string = "";
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + " Plane Graphic Calculator\n";
        string = String.valueOf(string) + " Version 1.0\n";
        string = String.valueOf(string) + " July 2000\n";
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + " This software is donated to the public,\n";
        string = String.valueOf(string) + " and can be used with no restrictions.\n";
        string = String.valueOf(string) + "\n";
        this.about_frame.Write(string);
        this.about_frame.ShowTop();
    }

    public void Details() {
        if (this.details_frame == null) {
            this.details_frame = new PGC_DetailsFrame(this, "Details");
            this.details_frame.init();
            this.UpdateDisplay();
            if (this.details_location != null) {
                this.details_frame.move(this.details_location.x, this.details_location.y);
            } else {
                this.details_frame.move(50, 50);
            }
            this.details_frame.show();
        } else {
            this.UpdateDisplay();
        }
        this.details_frame.toFront();
        this.details_frame.show();
        this.details_frame.requestFocus();
    }

    public void FrameDestroy(Frame frame) {
        if (frame != null) {
            frame.dispose();
            if (frame == this.about_frame) {
                this.about_frame = null;
                this.about_location = frame.location();
                return;
            }
            if (frame == this.details_frame) {
                this.details_frame = null;
                this.details_location = frame.location();
            }
        }
    }

    public PGC_Eval GetEval() {
        return this.eval;
    }

    public void UpdateDisplay() {
        int n;
        int n2 = this.GetOp();
        boolean bl = false;
        PGC_Eval pGC_Eval = this.GetEval();
        pGC_Eval.Evaluate(this.variable[4].expression);
        if (!pGC_Eval.empty) {
            bl = true;
        }
        if (bl && n2 < 12) {
            n2 = 12;
            this.pnl_graph.SetOp(n2);
        }
        if (this.pnl_ctl != null && this.choice_op.getSelectedItem() != PGC.OpChoiceLabel(n2)) {
            this.choice_op.select(PGC.OpChoiceLabel(n2));
        }
        if (this.details_frame != null) {
            this.details_frame.lbl_error_message.setText("");
        }
        int n3 = 0;
        while (n3 < this.variable.length) {
            this.variable[n3].is_displayed = false;
            ++n3;
        }
        int n4 = PGC.OpArgCount(n2);
        if (n4 == 1) {
            this.variable[0].is_displayed = true;
            this.variable[4].is_displayed = true;
        } else if (n4 == 2) {
            this.variable[0].is_displayed = true;
            this.variable[1].is_displayed = true;
            this.variable[4].is_displayed = true;
        } else if (n4 == 3) {
            this.variable[0].is_displayed = true;
            this.variable[1].is_displayed = true;
            this.variable[2].is_displayed = true;
            this.variable[4].is_displayed = true;
        }
        PGC_Eval pGC_Eval2 = this.GetEval();
        String string = "";
        int n5 = 0;
        while (n5 < this.variable.length) {
            if (this.variable[n5].is_function && (n5 != 4 || n2 >= 12)) {
                pGC_Eval2.Evaluate(this.variable[n5].expression);
                this.variable[n5].is_displayed = !pGC_Eval2.empty && !pGC_Eval2.uses_autoplot;
                n = 0;
                while (n < this.variable.length) {
                    if (this.variable[n].is_input) {
                        this.variable[n].is_displayed = this.variable[n].is_displayed || pGC_Eval2.uses_input[n];
                    }
                    ++n;
                }
                if (pGC_Eval2.message.length() > 0 && string.length() == 0) {
                    string = "ERROR in " + this.variable[n5].name + ": " + pGC_Eval2.message;
                }
            }
            ++n5;
        }
        if (this.details_frame != null && string.length() > 0) {
            this.details_frame.lbl_error_message.setText(string);
        }
        n = 0;
        while (n < this.variable.length) {
            if (this.variable[n].is_input && this.variable[n].is_displayed) {
                ++n4;
            }
            ++n;
        }
        this.EnableSpin(n4 > 0);
        if (this.details_frame != null) {
            boolean bl2 = this.variable[0].is_displayed;
            this.details_frame.lbl_a.setText(bl2 ? "a" : "");
            this.details_frame.lbl_a_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_a_x.setEditable(bl2);
            this.details_frame.txt_a_x.enable(bl2);
            this.details_frame.txt_a_x.select(0, 0);
            this.details_frame.lbl_a_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_a_y.setEditable(bl2);
            this.details_frame.txt_a_y.enable(bl2);
            this.details_frame.txt_a_y.select(0, 0);
            bl2 = this.variable[1].is_displayed;
            this.details_frame.lbl_b.setText(bl2 ? "b" : "");
            this.details_frame.lbl_b_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_b_x.setEditable(bl2);
            this.details_frame.txt_b_x.enable(bl2);
            this.details_frame.txt_b_x.select(0, 0);
            this.details_frame.lbl_b_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_b_y.setEditable(bl2);
            this.details_frame.txt_b_y.enable(bl2);
            this.details_frame.txt_b_y.select(0, 0);
            bl2 = this.variable[2].is_displayed;
            this.details_frame.lbl_c.setText(bl2 ? "c" : "");
            this.details_frame.lbl_c_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_c_x.setEditable(bl2);
            this.details_frame.txt_c_x.enable(bl2);
            this.details_frame.txt_c_x.select(0, 0);
            this.details_frame.lbl_c_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_c_y.setEditable(bl2);
            this.details_frame.txt_c_y.enable(bl2);
            this.details_frame.txt_c_y.select(0, 0);
            bl2 = this.variable[3].is_displayed;
            this.details_frame.lbl_d.setText(bl2 ? "d" : "");
            this.details_frame.lbl_d_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_d_x.setEditable(bl2);
            this.details_frame.txt_d_x.enable(bl2);
            this.details_frame.txt_d_x.select(0, 0);
            this.details_frame.lbl_d_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_d_y.setEditable(bl2);
            this.details_frame.txt_d_y.enable(bl2);
            this.details_frame.txt_d_y.select(0, 0);
            bl2 = this.variable[4].is_displayed;
            this.details_frame.lbl_f.setText(bl2 ? "f" : "");
            this.details_frame.lbl_f_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_f_x.setEditable(false);
            this.details_frame.txt_f_x.enable(bl2);
            this.details_frame.txt_f_x.select(0, 0);
            this.details_frame.lbl_f_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_f_y.setEditable(false);
            this.details_frame.txt_f_y.enable(bl2);
            this.details_frame.txt_f_y.select(0, 0);
            bl2 = this.variable[5].is_displayed;
            this.details_frame.lbl_g.setText(bl2 ? "g" : "");
            this.details_frame.lbl_g_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_g_x.setEditable(false);
            this.details_frame.txt_g_x.enable(bl2);
            this.details_frame.txt_g_x.select(0, 0);
            this.details_frame.lbl_g_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_g_y.setEditable(false);
            this.details_frame.txt_g_y.enable(bl2);
            this.details_frame.txt_g_y.select(0, 0);
            bl2 = this.variable[6].is_displayed;
            this.details_frame.lbl_h.setText(bl2 ? "h" : "");
            this.details_frame.lbl_h_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_h_x.setEditable(false);
            this.details_frame.txt_h_x.enable(bl2);
            this.details_frame.txt_h_x.select(0, 0);
            this.details_frame.lbl_h_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_h_y.setEditable(false);
            this.details_frame.txt_h_y.enable(bl2);
            this.details_frame.txt_h_y.select(0, 0);
            bl2 = this.variable[7].is_displayed;
            this.details_frame.lbl_k.setText(bl2 ? "k" : "");
            this.details_frame.lbl_k_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_k_x.setEditable(false);
            this.details_frame.txt_k_x.enable(bl2);
            this.details_frame.txt_k_x.select(0, 0);
            this.details_frame.lbl_k_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_k_y.setEditable(false);
            this.details_frame.txt_k_y.enable(bl2);
            this.details_frame.txt_k_y.select(0, 0);
            bl2 = this.variable[8].is_displayed;
            this.details_frame.lbl_m.setText(bl2 ? "m" : "");
            this.details_frame.lbl_m_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_m_x.setEditable(false);
            this.details_frame.txt_m_x.enable(bl2);
            this.details_frame.txt_m_x.select(0, 0);
            this.details_frame.lbl_m_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_m_y.setEditable(false);
            this.details_frame.txt_m_y.enable(bl2);
            this.details_frame.txt_m_y.select(0, 0);
            bl2 = this.variable[9].is_displayed;
            this.details_frame.lbl_n.setText(bl2 ? "n" : "");
            this.details_frame.lbl_n_x.setText(bl2 ? " x= " : "");
            this.details_frame.txt_n_x.setEditable(false);
            this.details_frame.txt_n_x.enable(bl2);
            this.details_frame.txt_n_x.select(0, 0);
            this.details_frame.lbl_n_y.setText(bl2 ? " y= " : "");
            this.details_frame.txt_n_y.setEditable(false);
            this.details_frame.txt_n_y.enable(bl2);
            this.details_frame.txt_n_y.select(0, 0);
        }
        if (this.pnl_ctl != null) {
            this.txt_f_expr.select(0, 0);
            this.txt_g_expr.select(0, 0);
            this.txt_f_expr.setText(this.variable[4].expression);
            this.txt_g_expr.setText(this.variable[5].expression);
            Complex complex = this.variable[13].coordinates;
            if (complex != null) {
                if (complex.re < 0.5) {
                    this.btn_step.setLabel("Step");
                } else {
                    this.btn_step.setLabel("Step " + (int)(complex.re + 0.5));
                }
            }
        }
        if (this.details_frame != null) {
            this.details_frame.txt_h_expr.select(0, 0);
            this.details_frame.txt_k_expr.select(0, 0);
            this.details_frame.txt_m_expr.select(0, 0);
            this.details_frame.txt_n_expr.select(0, 0);
            this.details_frame.txt_h_expr.setText(this.variable[6].expression);
            this.details_frame.txt_k_expr.setText(this.variable[7].expression);
            this.details_frame.txt_m_expr.setText(this.variable[8].expression);
            this.details_frame.txt_n_expr.setText(this.variable[9].expression);
            this.details_frame.txt_t_min.select(0, 0);
            this.details_frame.txt_t_max.select(0, 0);
            this.details_frame.txt_t_rep.select(0, 0);
            this.details_frame.txt_t_min.setText(String.valueOf(this.t_minimum));
            this.details_frame.txt_t_max.setText(String.valueOf(this.t_maximum));
            this.details_frame.txt_t_rep.setText(String.valueOf(this.t_count));
        }
        this.pnl_graph.UpdateDisplay();
    }

    public int GetOp() {
        return this.pnl_graph.GetOp();
    }

    public void SetOp(int n) {
        if (n < 12) {
            this.variable[4].expression = "";
        }
        if (n >= 13 && n <= 22) {
            int n2 = 4;
            while (n2 <= 9) {
                this.SetVariableExpression(n2, "");
                ++n2;
            }
            this.SetSpin(false);
            this.SetPlot(false);
            this.Clear();
            switch (n) {
                case 13: {
                    this.SetVariableExpression(4, "(a+b)/2");
                    this.SetLine(false);
                    break;
                }
                case 14: {
                    this.SetVariableExpression(4, "(cy, cx)");
                    this.SetVariableExpression(5, "(-fx, fy)");
                    this.SetLine(true);
                    break;
                }
                case 15: {
                    this.SetVariableExpression(4, "2x - 1");
                    this.SetVariableExpression(5, "2x^2 + 4x + 1");
                    break;
                }
                case 16: {
                    this.SetVariableExpression(4, "sin(x/ax * pi/2) * ay");
                    this.SetLine(false);
                    break;
                }
                case 17: {
                    this.SetVariableExpression(4, "(cos t, sin t)");
                    this.SetVariableExpression(5, "c + t d");
                    this.SetLine(true);
                    break;
                }
                case 18: {
                    this.SetVariableExpression(4, "(ax cos t + i ay sin t) * b + c");
                    this.SetLine(true);
                    break;
                }
                case 19: {
                    this.SetVariableExpression(4, "i^(4s/5)   {click the Step button}");
                    this.SetVariableExpression(5, "{click the Step button 5 times}");
                    this.SetLine(false);
                    this.SetPlot(true);
                    break;
                }
                case 20: {
                    this.SetVariableExpression(4, "i^(8t(ax+(s/2000),ay/100))");
                    this.SetLine(false);
                    break;
                }
            }
        }
        this.pnl_graph.SetOp(n);
        this.UpdateDisplay();
    }

    public void SetZoomDelta(int n) {
        this.pnl_graph.SetZoomDelta(n);
        if (this.pnl_ctl != null) {
            String string = "";
            int n2 = this.GetZoom();
            string = n2 < 10000 ? String.valueOf(n2) : (n2 < 10000000 ? n2 / 1000 + "K" : n2 / 1000000 + "M");
            String string2 = "Zoom: " + string + " X  ";
            this.lbl_zoom.setText(string2);
        }
    }

    public void SetZoom(int n) {
        this.pnl_graph.SetZoom(n);
        this.SetZoomDelta(0);
    }

    public int GetZoom() {
        return this.pnl_graph.GetZoom();
    }

    public boolean LooksReal(Complex complex) {
        return Math.abs(complex.im) < 0.5 / (double)this.GetZoom();
    }

    public void SetCenterDelta(int n, int n2) {
        this.pnl_graph.SetCenterDelta(n, n2);
    }

    public void SetCenter(Complex complex) {
        this.pnl_graph.SetCenter(complex);
    }

    public void SetActivePoint(int n) {
        this.pnl_graph.SetActivePoint(n);
    }

    public void DisplayCoordinates(Complex complex) {
        if (this.pnl_ctl != null) {
            double d;
            if (complex == null) {
                this.lbl_coordinate_x.setText("x = ");
                this.lbl_coordinate_y.setText("y = ");
                return;
            }
            int n = this.GetZoom();
            double d2 = Math.log(10.0);
            double d3 = Math.log(n) / d2;
            double d4 = Math.exp((Math.floor(d3) + 2.0) * d2);
            int n2 = (d4 = Math.floor(d4 + 0.5)) > 1.0E9 ? 1000000000 : (int)d4;
            double d5 = complex.re > 0.0 ? 1.0 : (d = complex.re < 0.0 ? -1.0 : 0.0);
            double d6 = complex.im > 0.0 ? 1.0 : (complex.im < 0.0 ? -1.0 : 0.0);
            double d7 = d * (Math.floor(Math.abs(complex.re) * (double)n2 + 0.5) / (double)n2);
            double d8 = d6 * (Math.floor(Math.abs(complex.im) * (double)n2 + 0.5) / (double)n2);
            this.lbl_coordinate_x.setText("x = " + String.valueOf(d7));
            this.lbl_coordinate_y.setText("y = " + String.valueOf(d8));
        }
    }

    public Complex GetVariableCoordinates(int n) {
        Complex complex = null;
        if (this.variable[n].is_displayed) {
            complex = this.variable[n].coordinates;
        }
        return complex;
    }

    public void SetVariableCoordinates(int n, Complex complex) {
        if (this.variable[n].is_displayed) {
            this.variable[n].coordinates = complex;
        }
    }

    public String GetVariableExpression(int n) {
        String string = this.variable[n].expression;
        if (this.GetOp() < 12 && n == 4) {
            string = PGC.OpExpression(this.GetOp());
        }
        return string;
    }

    public void SetVariableExpression(int n, String string) {
        this.variable[n].expression = string;
    }

    public Complex GetAutoplotVariable() {
        return this.variable[12].coordinates;
    }

    public void SetAutoplotVariable(Complex complex) {
        this.variable[12].coordinates = complex;
    }

    public Complex GetAutoincrementVariable() {
        return this.variable[13].coordinates;
    }

    public void SetAutoincrementVariable(Complex complex) {
        this.variable[13].coordinates = complex;
    }

    public void Step(int n) {
        if (!this.pnl_graph.Painting()) {
            int n2 = 0;
            while (n2 < n) {
                if (this.variable[4].is_displayed) {
                    this.SetVariableCoordinates(0, this.variable[4].coordinates);
                }
                Complex complex = this.GetAutoincrementVariable();
                this.SetAutoincrementVariable(Complex.Number(complex.re + 1.0));
                this.pnl_graph.PaintNow();
                ++n2;
            }
            this.UpdateDisplay();
        }
    }

    public void TextFieldsInput(PGC_TextFieldFixed pGC_TextFieldFixed) {
        if (this.details_frame != null) {
            Complex complex = Complex.Number();
            Complex complex2 = Complex.Number();
            Complex complex3 = Complex.Number();
            Complex complex4 = Complex.Number();
            this.eval.Evaluate(this.details_frame.txt_a_x.getText());
            if (this.eval.value != null) {
                complex.re = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_a_y.getText());
            if (this.eval.value != null) {
                complex.im = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_b_x.getText());
            if (this.eval.value != null) {
                complex2.re = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_b_y.getText());
            if (this.eval.value != null) {
                complex2.im = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_c_x.getText());
            if (this.eval.value != null) {
                complex3.re = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_c_y.getText());
            if (this.eval.value != null) {
                complex3.im = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_d_x.getText());
            if (this.eval.value != null) {
                complex4.re = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_d_y.getText());
            if (this.eval.value != null) {
                complex4.im = this.eval.value.re;
            }
            this.SetVariableCoordinates(0, complex);
            this.SetVariableCoordinates(1, complex2);
            this.SetVariableCoordinates(2, complex3);
            this.SetVariableCoordinates(3, complex4);
            this.variable[4].expression = this.txt_f_expr.getText();
            this.variable[5].expression = this.txt_g_expr.getText();
            this.variable[6].expression = this.details_frame.txt_h_expr.getText();
            this.variable[7].expression = this.details_frame.txt_k_expr.getText();
            this.variable[8].expression = this.details_frame.txt_m_expr.getText();
            this.variable[9].expression = this.details_frame.txt_n_expr.getText();
            this.eval.Evaluate(this.details_frame.txt_t_min.getText());
            if (this.eval.value != null) {
                this.t_minimum = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_t_max.getText());
            if (this.eval.value != null) {
                this.t_maximum = this.eval.value.re;
            }
            this.eval.Evaluate(this.details_frame.txt_t_rep.getText());
            if (this.eval.value != null) {
                this.t_count = (int)this.eval.value.re;
            }
        }
        if (this.pnl_ctl != null) {
            this.variable[4].expression = this.txt_f_expr.getText();
            this.variable[5].expression = this.txt_g_expr.getText();
        }
        this.UpdateDisplay();
        this.SetZoomDelta(0);
    }

    public void TextFieldsOutput(Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6, Complex complex7, Complex complex8, Complex complex9, Complex complex10) {
        if (this.details_frame != null) {
            PGC_TextFieldFixed pGC_TextFieldFixed = this.details_frame.txt_a_x;
            PGC_TextFieldFixed pGC_TextFieldFixed2 = this.details_frame.txt_a_y;
            if (complex == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_b_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_b_y;
            if (complex2 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex2.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex2.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_c_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_c_y;
            if (complex3 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex3.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex3.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_d_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_d_y;
            if (complex4 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex4.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex4.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_f_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_f_y;
            if (complex5 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex5.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex5.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_g_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_g_y;
            if (complex6 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex6.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex6.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_h_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_h_y;
            if (complex7 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex7.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex7.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_k_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_k_y;
            if (complex8 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex8.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex8.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_m_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_m_y;
            if (complex9 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
            } else {
                pGC_TextFieldFixed.setText(String.valueOf(complex9.re));
                pGC_TextFieldFixed2.setText(String.valueOf(complex9.im));
            }
            pGC_TextFieldFixed = this.details_frame.txt_n_x;
            pGC_TextFieldFixed2 = this.details_frame.txt_n_y;
            if (complex10 == null) {
                pGC_TextFieldFixed.setText("");
                pGC_TextFieldFixed2.setText("");
                return;
            }
            pGC_TextFieldFixed.setText(String.valueOf(complex10.re));
            pGC_TextFieldFixed2.setText(String.valueOf(complex10.im));
        }
    }

    public Image LoadBackgroundImage() {
        Image image = null;
        if (this.option_background_image != null && this.option_background_image.length() > 0) {
            image = this.getImage(this.getCodeBase(), this.option_background_image);
        }
        return image;
    }

    private void SetOptions() {
        this.SetOp(this.option_op);
        this.SetCenter(this.option_center);
        this.SetZoom(this.option_zoom);
        this.SetLine(this.option_line);
        this.SetPlot(this.option_plot);
        this.SetSpin(this.option_spin);
        this.SetActivePoint(this.option_active);
    }

    public static void main(String[] stringArray) {
        PGC pGC = new PGC();
        pGC.main_args = stringArray;
        pGC.stand_alone = true;
        pGC.init();
        Dimension dimension = new Dimension(pGC.option_launch_size_x, pGC.option_launch_size_y);
        pGC.resize(dimension);
        pGC.start();
        pGC.MainFrameDetach();
    }

    public void init() {
        this.MainFrameDestroy();
        PGC_Eval pGC_Eval = this.GetEval();
        String string = this.getParameter("enable_trace");
        if (string != null) {
            boolean bl = option_enable_trace = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("launch_button")) != null) {
            this.option_launch_button = new String(string);
        }
        this.launch_mode = this.option_launch_button != null && this.option_launch_button.length() > 0;
        string = this.getParameter("launch_size");
        if (string != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.option_launch_size_x = (int)pGC_Eval.value.re;
                this.option_launch_size_y = (int)pGC_Eval.value.im;
            }
        }
        if ((string = this.getParameter("background_image")) != null) {
            this.option_background_image = new String(string);
        }
        if ((string = this.getParameter("control_panel")) != null) {
            boolean bl = this.option_control_panel = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("graph_border")) != null) {
            boolean bl = this.option_graph_border = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("builtin_examples")) != null) {
            boolean bl = this.option_builtin_examples = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("builtin_functions")) != null) {
            boolean bl = this.option_builtin_functions = PGC_Utility.IValue(string) != 0;
        }
        if (!this.option_builtin_functions) {
            this.option_op = 12;
        }
        if ((string = this.getParameter("center")) != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.option_center = pGC_Eval.value;
            }
        }
        if ((string = this.getParameter("zoom")) != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.option_zoom = (int)pGC_Eval.value.re;
            }
        }
        if ((string = this.getParameter("line")) != null) {
            boolean bl = this.option_line = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("plot")) != null) {
            boolean bl = this.option_plot = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("spin")) != null) {
            boolean bl = this.option_spin = PGC_Utility.IValue(string) != 0;
        }
        if ((string = this.getParameter("active")) != null) {
            if (string.equalsIgnoreCase("a")) {
                this.option_active = 0;
            }
            if (string.equalsIgnoreCase("b")) {
                this.option_active = 1;
            }
            if (string.equalsIgnoreCase("c")) {
                this.option_active = 2;
            }
            if (string.equalsIgnoreCase("d")) {
                this.option_active = 3;
            }
        }
        if ((string = this.getParameter("t_minimum")) != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.t_minimum = pGC_Eval.value.re;
            }
        }
        if ((string = this.getParameter("t_maximum")) != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.t_maximum = pGC_Eval.value.re;
            }
        }
        if ((string = this.getParameter("t_count")) != null) {
            pGC_Eval.Evaluate(string);
            if (pGC_Eval.value != null) {
                this.t_count = (int)pGC_Eval.value.re;
            }
        }
        this.DefineVariables();
        int n = 0;
        while (n < this.variable.length) {
            if (this.variable[n].is_input) {
                string = this.getParameter(this.variable[n].name);
                if (string != null) {
                    String string2 = string;
                    pGC_Eval.Evaluate(string2);
                    if (pGC_Eval.value != null) {
                        this.variable[n].coordinates = pGC_Eval.value;
                    }
                }
            } else if (this.variable[n].is_function && (string = this.getParameter(this.variable[n].name)) != null) {
                this.variable[n].expression = string;
                if (n == 4 && string.length() > 0) {
                    this.option_op = 12;
                }
            }
            ++n;
        }
        if (this.launch_mode) {
            this.LayoutLaunchButton();
            this.setLayout(new BorderLayout());
            this.add("Center", this.pnl_root_launch);
            return;
        }
        this.LayoutCalculator();
        this.setLayout(new BorderLayout());
        this.add("Center", this.pnl_root_calculator);
        this.SetOptions();
    }

    public void start() {
    }

    public void stop() {
        this.MainFrameDestroy();
    }

    public boolean action(Event event, Object object) {
        if (event.id == 1001) {
            if (event.target == this.btn_details) {
                this.Details();
                return true;
            }
            if (event.target == this.btn_step) {
                this.Step(1);
                return true;
            }
            if (event.target == this.btn_plot_clear) {
                this.Clear();
                return true;
            }
            if (event.target == this.btn_about) {
                this.About();
                return true;
            }
            if (event.target == this.btn_attach_detach) {
                this.AttachDetach();
                return true;
            }
            if (event.target == this.btn_launch) {
                this.MainFrameLaunch();
                return true;
            }
            if (event.target == this.btn_zoomout) {
                this.SetZoomDelta(-1);
                return true;
            }
            if (event.target == this.btn_zoomin) {
                this.SetZoomDelta(1);
                return true;
            }
            if (event.target == this.chk_line) {
                this.CheckLine((Boolean)event.arg);
                return true;
            }
            if (event.target == this.chk_spin) {
                this.CheckSpin((Boolean)event.arg);
                return true;
            }
            if (event.target == this.chk_plot) {
                this.CheckPlot((Boolean)event.arg);
                return true;
            }
        }
        return super.action(event, object);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl = super.mouseDown(event, n, n2);
        if (event.target.getClass().toString().equals("class java.awt.Panel")) {
            this.GraphFocus();
        }
        return bl;
    }

    public boolean keyDown(Event event, int n) {
        boolean bl;
        if (n == 10 || n == 27) {
            this.GraphFocus();
            bl = true;
        } else {
            bl = event.target.getClass().toString().equals("class PGC_ButtonFixed") ? this.pnl_graph.keyDown(event, n) : (event.target.getClass().toString().equals("class java.awt.Checkbox") ? this.pnl_graph.keyDown(event, n) : (event.target.getClass().toString().equals("class java.awt.Panel") ? this.pnl_graph.keyDown(event, n) : super.keyDown(event, n)));
        }
        return bl;
    }

    public String getParameter(String string) {
        String string2 = this.stand_alone ? null : super.getParameter(string);
        return string2;
    }
}

