/*
 * Decompiled with CFR 0.152.
 */
class Complex {
    public double re;
    public double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public Complex(double d, double d2) {
        if (d == -0.0) {
            d = 0.0;
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        this.re = d;
        this.im = d2;
    }

    public static Complex Number(double d, double d2) {
        return new Complex(d, d2);
    }

    public static Complex Number(double d) {
        return new Complex(d, 0.0);
    }

    public static Complex Number() {
        return new Complex(0.0, 0.0);
    }

    public static Complex Number(Complex complex) {
        return new Complex(complex.re, complex.im);
    }

    public static boolean IsNaN(Complex complex) {
        return Double.isNaN(complex.re) || Double.isNaN(complex.im);
    }

    public static boolean IsInfinite(Complex complex) {
        return Double.isInfinite(complex.re) || Double.isInfinite(complex.im);
    }

    public static boolean IsDefined(Complex complex) {
        return !Complex.IsNaN(complex) && !Complex.IsInfinite(complex);
    }

    public static Complex Add(Complex complex, Complex complex2) {
        double d = complex.re + complex2.re;
        double d2 = complex.im + complex2.im;
        return new Complex(d, d2);
    }

    public static Complex Sub(Complex complex, Complex complex2) {
        double d = complex.re - complex2.re;
        double d2 = complex.im - complex2.im;
        return new Complex(d, d2);
    }

    public static Complex Neg(Complex complex) {
        double d = -complex.re;
        double d2 = -complex.im;
        return new Complex(d, d2);
    }

    public static Complex Mul(Complex complex, Complex complex2) {
        double d;
        double d2;
        if (complex.im == 0.0 && complex2.im == 0.0) {
            d2 = complex.re * complex2.re;
            d = 0.0;
        } else {
            d2 = complex.re * complex2.re - complex.im * complex2.im;
            d = complex.re * complex2.im + complex.im * complex2.re;
        }
        return new Complex(d2, d);
    }

    public static Complex Mul(Complex complex, double d) {
        double d2 = complex.re * d;
        double d3 = complex.im * d;
        return new Complex(d2, d3);
    }

    public static Complex Muli(Complex complex, double d) {
        double d2 = -complex.im * d;
        double d3 = complex.re * d;
        return new Complex(d2, d3);
    }

    public static Complex Div(Complex complex, Complex complex2) {
        double d;
        double d2;
        if (complex.im == 0.0 && complex2.im == 0.0) {
            d2 = complex.re / complex2.re;
            d = 0.0;
        } else {
            double d3 = Complex.Dot(complex2, complex2);
            d2 = (complex.re * complex2.re + complex.im * complex2.im) / d3;
            d = (complex.im * complex2.re - complex.re * complex2.im) / d3;
        }
        return new Complex(d2, d);
    }

    public static double Abs(Complex complex) {
        double d = Math.sqrt(Complex.Dot(complex, complex));
        return d;
    }

    public static double Arg(Complex complex) {
        double d = Math.atan2(complex.im, complex.re);
        return d;
    }

    public static Complex Conj(Complex complex) {
        double d = complex.re;
        double d2 = -complex.im;
        return new Complex(d, d2);
    }

    public static Complex Int(Complex complex) {
        double d = complex.re >= 0.0 ? Math.floor(complex.re) : Math.ceil(complex.re);
        double d2 = complex.im >= 0.0 ? Math.floor(complex.im) : Math.ceil(complex.im);
        return new Complex(d, d2);
    }

    public static Complex Ceil(Complex complex) {
        double d = Math.ceil(complex.re);
        double d2 = Math.ceil(complex.im);
        return new Complex(d, d2);
    }

    public static Complex Floor(Complex complex) {
        double d = Math.floor(complex.re);
        double d2 = Math.floor(complex.im);
        return new Complex(d, d2);
    }

    public static Complex Rem(Complex complex, Complex complex2) {
        double d = Math.IEEEremainder(complex.re, complex2.re);
        double d2 = 0.0;
        return new Complex(d, d2);
    }

    public static Complex Mod(Complex complex, Complex complex2) {
        double d = complex.re / complex2.re;
        double d2 = d - Math.floor(d);
        double d3 = complex2.re * d2;
        double d4 = 0.0;
        return new Complex(d3, d4);
    }

    public static Complex Sqrt(Complex complex) {
        double d = Math.sqrt((Complex.Abs(complex) + complex.re) * 0.5);
        double d2 = d == 0.0 ? Math.sqrt(-complex.re) : 0.5 * complex.im / d;
        return new Complex(d, d2);
    }

    public static Complex Pow(Complex complex, Complex complex2) {
        double d;
        double d2;
        if (complex.re == 0.0 && complex.im == 0.0 && complex2.im == 0.0 && complex2.re > 0.0) {
            d2 = 0.0;
            d = 0.0;
        } else if (complex.im == 0.0 && complex.re > 0.0) {
            double d3 = Math.log(complex.re);
            double d4 = complex2.re * d3;
            double d5 = complex2.im * d3;
            double d6 = Math.exp(d4);
            d2 = d6 * Math.cos(d5);
            d = d6 * Math.sin(d5);
        } else if (complex2.im == 0.0) {
            double d7 = Complex.Abs(complex);
            double d8 = Complex.Arg(complex);
            double d9 = Math.exp(complex2.re * Math.log(d7));
            d2 = d9 * Math.cos(complex2.re * d8);
            d = d9 * Math.sin(complex2.re * d8);
        } else {
            double d10 = Complex.Abs(complex);
            double d11 = Complex.Arg(complex);
            double d12 = Math.log(d10);
            double d13 = Math.exp(complex2.re * d12 - complex2.im * d11);
            double d14 = complex2.im * d12 + complex2.re * d11;
            d2 = d13 * Math.cos(d14);
            d = d13 * Math.sin(d14);
        }
        return new Complex(d2, d);
    }

    public static Complex Exp(Complex complex) {
        double d = Math.exp(complex.re);
        double d2 = d * Math.cos(complex.im);
        double d3 = d * Math.sin(complex.im);
        return new Complex(d2, d3);
    }

    public static Complex Log(Complex complex) {
        double d = Complex.Dot(complex, complex);
        double d2 = Math.log(d) * 0.5;
        double d3 = Complex.Arg(complex);
        return new Complex(d2, d3);
    }

    public static Complex Sin(Complex complex) {
        double d = Math.exp(complex.im);
        double d2 = d / 2.0;
        double d3 = 0.5 / d;
        double d4 = Math.sin(complex.re) * (d2 + d3);
        double d5 = Math.cos(complex.re) * (d2 - d3);
        return new Complex(d4, d5);
    }

    public static Complex Cos(Complex complex) {
        double d = Math.exp(complex.im);
        double d2 = d / 2.0;
        double d3 = 0.5 / d;
        double d4 = Math.cos(complex.re) * (d2 + d3);
        double d5 = Math.sin(complex.re) * -(d2 - d3);
        return new Complex(d4, d5);
    }

    public static Complex Tan(Complex complex) {
        Complex complex2 = Complex.Sin(complex);
        Complex complex3 = Complex.Cos(complex);
        return Complex.Div(complex2, complex3);
    }

    public static Complex Cot(Complex complex) {
        Complex complex2 = Complex.Sin(complex);
        Complex complex3 = Complex.Cos(complex);
        return Complex.Div(complex3, complex2);
    }

    public static Complex Sec(Complex complex) {
        Complex complex2 = Complex.Cos(complex);
        return Complex.Div(Complex.Number(1.0, 0.0), complex2);
    }

    public static Complex Csc(Complex complex) {
        Complex complex2 = Complex.Sin(complex);
        return Complex.Div(Complex.Number(1.0, 0.0), complex2);
    }

    public static Complex Sinh(Complex complex) {
        double d = Math.exp(complex.re);
        double d2 = d / 2.0;
        double d3 = 0.5 / d;
        double d4 = Math.cos(complex.im) * (d2 - d3);
        double d5 = Math.sin(complex.im) * (d2 + d3);
        return new Complex(d4, d5);
    }

    public static Complex Cosh(Complex complex) {
        double d = Math.exp(complex.re);
        double d2 = d / 2.0;
        double d3 = 0.5 / d;
        double d4 = Math.cos(complex.im) * (d2 + d3);
        double d5 = Math.sin(complex.im) * (d2 - d3);
        return new Complex(d4, d5);
    }

    public static Complex Tanh(Complex complex) {
        Complex complex2 = Complex.Sinh(complex);
        Complex complex3 = Complex.Cosh(complex);
        return Complex.Div(complex2, complex3);
    }

    public static Complex Coth(Complex complex) {
        Complex complex2 = Complex.Sinh(complex);
        Complex complex3 = Complex.Cosh(complex);
        return Complex.Div(complex3, complex2);
    }

    public static Complex Sech(Complex complex) {
        Complex complex2 = Complex.Cosh(complex);
        return Complex.Div(Complex.Number(1.0), complex2);
    }

    public static Complex Csch(Complex complex) {
        Complex complex2 = Complex.Sinh(complex);
        return Complex.Div(Complex.Number(1.0), complex2);
    }

    public static Complex Asin(Complex complex) {
        Complex complex2 = Complex.Sqrt(Complex.Sub(Complex.Number(1.0), Complex.Mul(complex, complex)));
        return Complex.Muli(Complex.Log(Complex.Add(Complex.Muli(complex, 1.0), complex2)), -1.0);
    }

    public static Complex Acos(Complex complex) {
        Complex complex2 = Complex.Sqrt(Complex.Sub(Complex.Number(1.0), Complex.Mul(complex, complex)));
        return Complex.Muli(Complex.Log(Complex.Add(complex, Complex.Muli(complex2, 1.0))), -1.0);
    }

    public static Complex Atan(Complex complex) {
        Complex complex2 = Complex.Number(0.0, 1.0);
        return Complex.Muli(Complex.Log(Complex.Div(Complex.Add(complex2, complex), Complex.Sub(complex2, complex))), 0.5);
    }

    public static Complex Asec(Complex complex) {
        return Complex.Acos(Complex.Div(Complex.Number(1.0), complex));
    }

    public static Complex Acsc(Complex complex) {
        return Complex.Asin(Complex.Div(Complex.Number(1.0), complex));
    }

    public static Complex Acot(Complex complex) {
        Complex complex2 = Complex.Number(0.0, 1.0);
        return Complex.Muli(Complex.Log(Complex.Div(Complex.Add(complex2, complex), Complex.Sub(complex, complex2))), -0.5);
    }

    public static Complex Asinh(Complex complex) {
        Complex complex2 = Complex.Sqrt(Complex.Add(Complex.Mul(complex, complex), Complex.Number(1.0)));
        return Complex.Log(Complex.Add(complex, complex2));
    }

    public static Complex Acosh(Complex complex) {
        Complex complex2 = Complex.Sqrt(Complex.Sub(Complex.Mul(complex, complex), Complex.Number(1.0)));
        return Complex.Log(Complex.Add(complex, complex2));
    }

    public static Complex Atanh(Complex complex) {
        Complex complex2 = Complex.Number(1.0);
        return Complex.Mul(Complex.Log(Complex.Div(Complex.Add(complex2, complex), Complex.Sub(complex2, complex))), 0.5);
    }

    public static Complex Asech(Complex complex) {
        return Complex.Acosh(Complex.Div(Complex.Number(1.0), complex));
    }

    public static Complex Acsch(Complex complex) {
        return Complex.Asinh(Complex.Div(Complex.Number(1.0), complex));
    }

    public static Complex Acoth(Complex complex) {
        Complex complex2 = Complex.Number(1.0);
        return Complex.Mul(Complex.Log(Complex.Div(Complex.Add(complex2, complex), Complex.Sub(complex, complex2))), 0.5);
    }

    public static double Dot(Complex complex, Complex complex2) {
        double d = complex.re * complex2.re + complex.im * complex2.im;
        if (d == -0.0) {
            d = 0.0;
        }
        return d;
    }

    public static double Cross(Complex complex, Complex complex2) {
        double d = complex.re * complex2.im - complex.im * complex2.re;
        if (d == -0.0) {
            d = 0.0;
        }
        return d;
    }

    public static Complex Shadow(Complex complex, Complex complex2) {
        double d = Complex.Dot(complex2, complex2);
        double d2 = Complex.Dot(complex, complex2) / d;
        return Complex.Mul(complex2, d2);
    }
}

