/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ImageViewer
extends Applet
implements Runnable {
    String HillmanSoftware = "Applets by Joe";
    String Author = "ImageViewer - Copyright(c) 2001 Joe Hillman";
    Font hfont = new Font("TimesRoman", 2, 15);
    FontMetrics hfm = this.getFontMetrics(this.hfont);
    Color hColor;
    boolean bTrialVersion = true;
    boolean bloaded = false;
    Thread loopThread;
    Thread loadThread;
    Image offImage;
    Graphics offScreen;
    Vector vImageStats = new Vector();
    final int EXPAND = 1;
    final int SHRINK = 2;
    final int CS_WAIT = 1;
    boolean bDrawing = false;
    int iImage;
    int iMode = 2;
    int iSpeed;
    int iImageSize;
    int iTotalImages;
    int iCurrentImageCnt;
    boolean bSetHighlight = false;
    boolean bUrlActive = false;
    boolean bAuthor = false;
    Image j1;
    Image j2;
    Image j3;
    Image j4;

    public void init() {
        Graphics g = this.getGraphics();
        Dimension d = this.size();
        this.offImage = this.createImage(this.size().width, this.size().height);
        this.offScreen = this.offImage.getGraphics();
    }

    public void loadImages() {
        String szImageName;
        String szImage;
        int iCnt = 0;
        int iXcnt = 0;
        int iYcnt = 0;
        int iXpos = 0;
        int iYpos = 0;
        boolean iApos = false;
        boolean iBpos = false;
        Image imgNew = null;
        Image imgOld = null;
        String szTemp = this.getParameter("Author");
        if (szTemp == null) {
            return;
        }
        if (szTemp.equalsIgnoreCase(this.Author)) {
            this.bAuthor = true;
        } else {
            return;
        }
        while ((szImage = this.getParameter(szImageName = "Image" + ++iCnt)) != null) {
        }
        this.iTotalImages = iCnt;
        iCnt = 0;
        szTemp = this.getParameter("Speed");
        if (szTemp == null) {
            this.iImageSize = 15;
        } else {
            this.iSpeed = Integer.parseInt(szTemp);
            if (this.iSpeed > 50) {
                this.iSpeed = 50;
            }
            if (this.iSpeed < 1) {
                this.iSpeed = 1;
            }
        }
        szTemp = this.getParameter("ImageSize");
        if (szTemp == null) {
            this.iImageSize = 4;
        } else {
            this.iImageSize = Integer.parseInt(szTemp);
            if (this.iImageSize > 100) {
                this.iImageSize = 100;
            }
            if (this.iImageSize < 1) {
                this.iImageSize = 1;
            }
        }
        this.showStatus("Loading Images...");
        while (true) {
            szImageName = "Image" + ++iCnt;
            szImage = this.getParameter(szImageName);
            this.iCurrentImageCnt = iCnt;
            if (szImage == null) break;
            try {
                imgNew = this.getImage(new URL(this.getDocumentBase(), szImage));
            }
            catch (MalformedURLException malformedURLException) {}
            while (imgNew.getWidth(this) == -1) {
            }
            if (imgOld != null) {
                this.vImageStats.addElement(new ImageStats(imgNew, iXpos, iYpos, imgOld.getWidth(this) / this.iImageSize, imgOld.getHeight(this) / this.iImageSize));
            } else {
                this.vImageStats.addElement(new ImageStats(imgNew, iXpos, iYpos, imgNew.getWidth(this) / this.iImageSize, imgNew.getHeight(this) / this.iImageSize));
            }
            if ((iXpos = (imgOld = imgNew).getWidth(this) / this.iImageSize * ++iXcnt) + imgOld.getWidth(this) / this.iImageSize <= this.size().width) continue;
            iXpos = 0;
            iXcnt = 0;
            iYpos = imgOld.getHeight(this) / this.iImageSize * ++iYcnt;
        }
        this.showStatus(this.Author);
    }

    public void start() {
        if (this.loopThread == null) {
            this.loopThread = new Thread(this);
            this.loopThread.start();
        }
        if (!this.bloaded && this.loadThread == null) {
            this.loadThread = new Thread(this);
            this.loadThread.start();
        }
    }

    public void stop() {
        if (this.loopThread != null) {
            this.loopThread.stop();
            this.loopThread = null;
        }
        if (this.loadThread != null) {
            this.loadThread.stop();
            this.loadThread = null;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        long startTime = System.currentTimeMillis();
        if (!this.bloaded && Thread.currentThread() == this.loadThread) {
            this.loadImages();
            this.bloaded = true;
            this.loadThread.stop();
        }
        while (Thread.currentThread() == this.loopThread) {
            if (!this.bUrlActive && this.bDrawing) {
                this.bDrawing = false;
                this.startImage(this.iImage, this.iMode);
            }
            this.repaint();
            try {
                Thread.sleep(Math.max(0L, (startTime += 10L) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public boolean mouseExit(Event evt, int x, int y) {
        this.bSetHighlight = false;
        return true;
    }

    public boolean mouseBrowse(int x1, int y1, int xpos, int ypos, String currentString, FontMetrics fm) {
        int x2 = xpos + fm.stringWidth(currentString);
        int y2 = ypos + (fm.getHeight() - 20);
        return x1 >= xpos && y1 >= ypos - fm.getHeight() && x1 <= x2 && y1 <= y2;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        int yPos;
        int xPos = this.size().width - this.hfm.stringWidth(this.HillmanSoftware) - 5;
        this.bSetHighlight = this.mouseBrowse(x, y, xPos, yPos = this.size().height - (this.hfm.getHeight() - 15), this.HillmanSoftware, this.hfm);
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (this.bUrlActive) {
            return true;
        }
        if (this.bSetHighlight) {
            try {
                AppletContext context = this.getAppletContext();
                context.showDocument(new URL("http://users.ev1.net/~jhillman/ImageViewer.htm"));
            }
            catch (MalformedURLException malformedURLException) {}
            this.bUrlActive = true;
            return true;
        }
        if (this.bDrawing) {
            return true;
        }
        int i = 0;
        while (i < this.vImageStats.size()) {
            ImageStats ImgStat = (ImageStats)this.vImageStats.elementAt(i);
            if (ImgStat.State == 1) {
                this.iMode = 2;
                ImgStat.State = 2;
                this.bDrawing = true;
                this.iImage = i;
                return true;
            }
            if (ImgStat.CheckBrowse(x, y)) {
                this.bDrawing = true;
                this.iImage = i;
                this.iMode = 1;
                ImgStat.State = 1;
            }
            ++i;
        }
        return true;
    }

    public void startImage(int Element, int iMode) {
        ImageStats ImgStat = (ImageStats)this.vImageStats.elementAt(Element);
        switch (iMode) {
            case 1: {
                this.scroll(Element, 1, 0, 0);
                break;
            }
            case 2: {
                this.scroll(Element, 2, 0, 0);
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void scroll(int Pic, int start, int time, int pause) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        this.offScreen.setColor(Color.black);
        this.offScreen.fillRect(0, 0, this.size().width, this.size().height);
        if (!this.bAuthor) {
            this.offScreen.setColor(Color.red);
            this.offScreen.drawString("Fill in author value with", 0, this.size().height / 2);
            this.offScreen.drawString(this.Author, 0, this.size().height / 2 + this.hfm.getHeight());
        } else if (!this.bloaded) {
            this.offScreen.setColor(Color.white);
            this.offScreen.drawString("Loading image " + this.iCurrentImageCnt + " of " + (this.iTotalImages - 1), this.size().width / 3, this.size().height / 2);
        } else {
            ImageStats ImgStat;
            int j = 0;
            while (j < this.vImageStats.size()) {
                ImgStat = (ImageStats)this.vImageStats.elementAt(j);
                this.offScreen.drawImage(ImgStat.Img, ImgStat.xImagePos, ImgStat.yImagePos, ImgStat.xImageSize, ImgStat.yImageSize, this);
                ++j;
            }
            ImgStat = (ImageStats)this.vImageStats.elementAt(this.iImage);
            this.offScreen.drawImage(ImgStat.Img, ImgStat.xImagePos, ImgStat.yImagePos, ImgStat.xImageSize, ImgStat.yImageSize, this);
            if (this.bTrialVersion) {
                if (this.bSetHighlight) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.offScreen.setColor(Color.blue);
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    this.offScreen.setColor(Color.white);
                }
                int x = this.size().width - this.hfm.stringWidth(this.HillmanSoftware) - 5;
                int y = this.size().height - (this.hfm.getHeight() - 10);
                this.offScreen.setFont(this.hfont);
                this.offScreen.drawString(this.HillmanSoftware, x, y);
            }
        }
        g.drawImage(this.offImage, 0, 0, this);
    }
}

