/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.StringTokenizer;

public class VideoWall2ech
extends Applet
implements Runnable {
    AppletUtil3 aut;
    boolean first_time = true;
    double color_percent = 0.2;
    Graphics bufferG;
    Image bufferI;
    int width;
    int height;
    int rows = 3;
    int columns = 3;
    int speed = 300;
    int iw;
    int ih;
    int spaces;
    int position;
    Image[] images;
    Image mask;
    MediaTracker mt;
    String order = "random";
    Thread woohoo;

    public void init() {
        this.aut = new AppletUtil3(this);
        this.width = this.size().width;
        this.height = this.size().height;
        this.mt = new MediaTracker(this);
        this.bufferI = this.createImage(this.width, this.height);
        this.bufferG = this.bufferI.getGraphics();
        String string = this.getParameter("ORDER");
        if (string != null) {
            this.order = string.toLowerCase();
        }
        if ((string = this.getParameter("ROWS")) != null) {
            this.rows = Integer.parseInt(string);
        }
        if ((string = this.getParameter("COLUMNS")) != null) {
            this.columns = Integer.parseInt(string);
        }
        if ((string = this.getParameter("SPEED")) != null) {
            this.speed = Integer.parseInt(string);
        }
        if ((string = this.getParameter("COLOR.PERCENT")) != null) {
            this.color_percent = new Double(string);
        }
        if ((string = this.getParameter("IMAGE.MASK")) != null) {
            this.showStatus("Loading MASK images");
            try {
                this.mask = this.getImage(this.getDocumentBase(), string);
                this.mt.addImage(this.mask, -1);
                this.mt.waitForID(-1);
            }
            catch (Exception exception) {}
        }
        if ((string = this.getParameter("IMAGES")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            this.images = new Image[n];
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.showStatus("Loading image #1");
                    this.images[n2] = this.getImage(this.getDocumentBase(), stringTokenizer.nextToken());
                    this.mt.addImage(this.images[n2], n2);
                    if (n2 == 0) {
                        this.mt.waitForID(n2);
                        this.iw = this.images[n2].getWidth(this);
                        this.ih = this.images[n2].getHeight(this);
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        this.spaces = this.rows * this.columns;
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(this.speed);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void paint(Graphics graphics) {
        if (this.first_time) {
            this.first_time = false;
            this.position = this.order.equals("random") ? (int)(Math.random() * (double)this.spaces) : (this.order.equals("forward") ? 0 : this.spaces - 1);
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.columns) {
                    this.bufferG.setColor(this.aut.makeColor("0-255,0-255,0-255"));
                    this.bufferG.fillRect(n2 * this.iw, n * this.ih, this.iw, this.ih);
                    if (this.mask != null) {
                        this.bufferG.drawImage(this.mask, n2 * this.iw, n * this.ih, this);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = this.position / this.columns;
            int n3 = this.position % this.columns;
            if (Math.random() > this.color_percent) {
                int n4 = (int)(Math.random() * (double)this.images.length);
                if (!this.mt.checkID(n4)) {
                    int n5 = n4 + 1;
                    this.showStatus("Loading image #" + n5);
                    try {
                        this.mt.waitForID(n4);
                    }
                    catch (Exception exception) {}
                    this.showStatus("");
                }
                if (this.images[n4] != null) {
                    this.bufferG.drawImage(this.images[n4], n3 * this.iw, n * this.ih, this);
                }
            } else {
                this.bufferG.setColor(this.aut.makeColor("0-255,0-255,0-255"));
                this.bufferG.fillRect(n3 * this.iw, n * this.ih, this.iw, this.ih);
            }
            if (this.mask != null) {
                this.bufferG.drawImage(this.mask, n3 * this.iw, n * this.ih, this);
            }
            this.position = this.order.equals("random") ? (int)(Math.random() * (double)this.spaces) : (this.order.equals("forward") ? (this.position + 1) % this.spaces : (this.position - 1 + this.spaces) % this.spaces);
        }
        graphics.drawImage(this.bufferI, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void start() {
        if (this.woohoo == null) {
            this.woohoo = new Thread(this);
        }
        if (this.getParameter("AUTHOR").equals("Eric Harshbarger, http://www.ericharshbarger.org") && this.getParameter("COPYRIGHT").equals("VideoWall applet, Copyright 1998, Eric Harshbarger")) {
            this.woohoo.start();
            return;
        }
        System.out.println("AUTHOR & COPYRIGHT parameters are incorrect.");
    }

    public void stop() {
        if (this.woohoo != null) {
            this.woohoo.stop();
            this.woohoo = null;
        }
    }

    public void destroy() {
        if (this.bufferG != null) {
            this.bufferG.dispose();
        }
    }
}

