/*
 * Decompiled with CFR 0.152.
 */
package com.alexi;

import com.alexi.AImage;
import com.alexi.ATextWithFont;
import com.alexi.IGraphicObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class AScrollTextDisplayer {
    protected int m_previousLineY = 0;
    protected int m_currentLineHeight = 0;
    protected int m_currentLineX = 0;
    protected int m_width = 0;
    protected Vector graphicalObjectsVector = new Vector(10);
    protected Vector currentLineObjectsVector = new Vector(10);
    protected Vector linkObjectsVector = new Vector(10);
    public Color backColor = null;
    protected Graphics m_dummyGraphics = null;
    protected int m_deltaBetweenLines = 4;

    public AScrollTextDisplayer(int n) {
        this.m_width = n;
    }

    public AScrollTextDisplayer(Graphics graphics, int n) {
        this.m_width = n;
        this.m_dummyGraphics = graphics;
    }

    protected void addFormattedExactText(String string, Font font, Color color, int n, String string2) {
        ATextWithFont aTextWithFont = new ATextWithFont(string, font, color, string2);
        FontMetrics fontMetrics = this.m_dummyGraphics.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(string);
        aTextWithFont.boundingRectangle.x = this.m_currentLineX;
        if (n > this.m_currentLineHeight) {
            this.m_currentLineHeight = n;
            this.updateCurrentLine();
        }
        aTextWithFont.boundingRectangle.y = this.m_previousLineY;
        aTextWithFont.boundingRectangle.width = n2;
        aTextWithFont.boundingRectangle.height = this.m_currentLineHeight;
        this.graphicalObjectsVector.addElement(aTextWithFont);
        this.currentLineObjectsVector.addElement(aTextWithFont);
        if (string2 != null) {
            this.linkObjectsVector.addElement(aTextWithFont);
        }
    }

    public void addFormattedText(String string, Font font, Color color, String string2) {
        FontMetrics fontMetrics = this.m_dummyGraphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = 0;
        while (true) {
            String string3;
            if ((n2 = fontMetrics.stringWidth(string)) + this.m_currentLineX <= this.m_width) {
                this.addFormattedExactText(string, font, color, n, string2);
                this.m_currentLineX += n2;
                break;
            }
            int n3 = this.m_width - this.m_currentLineX;
            int n4 = 1;
            while (n4 <= string.length()) {
                string3 = string.substring(0, n4);
                n2 = fontMetrics.stringWidth(string3);
                if (n2 > n3) break;
                ++n4;
            }
            if (--n4 > 0) {
                int n5 = n4;
                while (string.charAt(n5) != ' ' && n5 >= 0) {
                    --n5;
                }
                if (n5 > 0) {
                    n4 = n5;
                    string3 = string.substring(0, n4);
                    this.addFormattedExactText(string3, font, color, n, string2);
                    string = string.substring(n4, string.length());
                }
            }
            this.goToNextLine();
        }
    }

    public void addImage(Image image, int n, int n2) {
        AImage aImage = new AImage(image, n, n2);
        aImage.boundingRectangle.x = this.m_currentLineX;
        if (n2 > this.m_currentLineHeight) {
            this.m_currentLineHeight = n2;
            this.updateCurrentLine();
        }
        aImage.boundingRectangle.y = this.m_previousLineY;
        aImage.boundingRectangle.width = n;
        aImage.boundingRectangle.height = n2;
        this.graphicalObjectsVector.addElement(aImage);
        this.currentLineObjectsVector.addElement(aImage);
        if (this.m_currentLineX + n > this.m_width) {
            this.goToNextLine();
        } else {
            this.m_currentLineX += n;
        }
    }

    public void drawAll(Graphics graphics, int n, int n2) {
        Color color = null;
        if (this.backColor != null) {
            color = graphics.getColor();
            graphics.setColor(this.backColor);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
        }
        int n3 = this.graphicalObjectsVector.size();
        int n4 = 0;
        while (n4 < n3) {
            ((IGraphicObject)this.graphicalObjectsVector.elementAt(n4)).drawGraphicObject(graphics);
            ++n4;
        }
    }

    public String getClickedLink(int n, int n2) {
        int n3 = this.linkObjectsVector.size();
        IGraphicObject iGraphicObject = null;
        int n4 = 0;
        while (n4 < n3) {
            iGraphicObject = (IGraphicObject)this.linkObjectsVector.elementAt(n4);
            if (iGraphicObject.boundingRectangle.contains(n, n2)) {
                return ((ATextWithFont)iGraphicObject).getURL();
            }
            ++n4;
        }
        return null;
    }

    public int getHeight() {
        return this.m_previousLineY + this.m_currentLineHeight;
    }

    public String getURL(int n) {
        Object e;
        String string;
        if (n >= 0 && n < this.linkObjectsVector.size() && (string = (e = this.linkObjectsVector.elementAt(n)).getClass().getName()).equalsIgnoreCase("com.alexi.ATextWithFont")) {
            return ((ATextWithFont)e).getURL();
        }
        return null;
    }

    protected void goToNextLine() {
        if (this.m_currentLineHeight >= 0) {
            if (this.m_currentLineHeight == 0) {
                this.m_currentLineHeight = 10;
            }
            this.m_previousLineY += this.m_currentLineHeight + this.m_deltaBetweenLines;
            this.m_currentLineHeight = 0;
            this.m_currentLineX = 0;
            this.currentLineObjectsVector.removeAllElements();
        }
    }

    protected void updateCurrentLine() {
        int n = this.currentLineObjectsVector.size();
        int n2 = 0;
        while (n2 < n) {
            ((IGraphicObject)this.currentLineObjectsVector.elementAt((int)n2)).boundingRectangle.height = this.m_currentLineHeight;
            ++n2;
        }
    }

    public int updateLinks(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.linkObjectsVector.size();
        int n5 = -1;
        IGraphicObject iGraphicObject = null;
        int n6 = 0;
        while (n6 < n4) {
            iGraphicObject = (IGraphicObject)this.linkObjectsVector.elementAt(n6);
            if (iGraphicObject.boundingRectangle.contains(n, n2)) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n3 != n5) {
            if (n5 != -1) {
                iGraphicObject.drawGraphicObject(graphics, n, n2);
            }
            if (n3 >= 0 && n3 < n4) {
                ((IGraphicObject)this.linkObjectsVector.elementAt(n3)).drawGraphicObject(graphics, n, n2);
            }
        }
        return n5;
    }
}

