/*
 * Decompiled with CFR 0.152.
 */
package com.alexi;

import com.alexi.AHTMLTag;
import com.alexi.AScrollTextDisplayer;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class AScrollText
extends Applet
implements MouseMotionListener,
MouseListener,
Runnable {
    Font m_font = new Font("Times", 0, 14);
    String m_str = "";
    Thread thread;
    int xPos = 5;
    private boolean bStartFromBottom = true;
    public Image m_offImage = null;
    public Graphics m_offGraphics = null;
    private int yStart = 0;
    private int savedY = 0;
    private boolean motionStopped = false;
    protected String bodyTag = "body";
    protected String underlineTag = "u";
    protected String boldTag = "b";
    protected String italicTag = "i";
    protected String fontTag = "font";
    protected String paragraphTag = "p";
    protected String lineBreakTag = "br";
    protected String imageTag = "img";
    protected String urlTag = "a";
    protected Font currentFont = null;
    protected AScrollTextDisplayer theScrollTextDisplayer = null;
    protected int m_currentIndex = 0;
    protected int m_lastMouseXPos = -1;
    protected int m_lastMouseYPos = -1;
    protected Color backColor = null;
    protected Color foreColor = null;
    protected int m_linkIndex = -1;
    protected int m_height = 0;
    protected Cursor m_handCursor = new Cursor(12);
    protected Cursor m_normalCursor = new Cursor(0);
    protected int m_initialDelay = 500;
    protected int m_smallSleep = 20;
    protected int m_scrollDelta = 1;
    private String m_userName = null;
    private int m_userKey = 0;

    protected AHTMLTag extractHTMLTag() {
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        AHTMLTag aHTMLTag = new AHTMLTag();
        ++this.m_currentIndex;
        n = this.m_currentIndex;
        while (this.m_str.charAt(this.m_currentIndex) != ' ' && this.m_str.charAt(this.m_currentIndex) != '>') {
            ++this.m_currentIndex;
        }
        n2 = this.m_currentIndex;
        string = this.m_str.substring(n, n2);
        aHTMLTag.setName(string);
        n = n2;
        while (this.m_str.charAt(this.m_currentIndex) != '>') {
            if (!bl) {
                if (this.m_str.charAt(this.m_currentIndex) == ' ') {
                    ++n;
                }
                if (this.m_str.charAt(this.m_currentIndex) == '=') {
                    string2 = this.m_str.substring(n, this.m_currentIndex);
                    bl = true;
                    n = this.m_currentIndex + 1;
                }
            } else if (this.m_str.charAt(this.m_currentIndex) == ' ') {
                string3 = this.m_str.substring(n, this.m_currentIndex);
                aHTMLTag.addAttribute(string2, string3);
                bl = false;
                n = this.m_currentIndex + 1;
            }
            ++this.m_currentIndex;
        }
        if (bl) {
            string3 = this.m_str.substring(n, this.m_currentIndex);
            aHTMLTag.addAttribute(string2, string3);
        }
        ++this.m_currentIndex;
        return aHTMLTag;
    }

    public String getAppletInfo() {
        return "AXScroller\n\nHigh performance vertical scroller.\nCreation date: (2/14/00 3:31:51 PM)\n@author: \nAlexandru Indrei";
    }

    protected Color getColorFromString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string.charAt(0) == '#') {
            return Color.decode(string);
        }
        if (string.equalsIgnoreCase("red")) {
            n = 255;
        }
        if (string.equalsIgnoreCase("green")) {
            n2 = 255;
        }
        if (string.equalsIgnoreCase("blue")) {
            n3 = 255;
        }
        string.equalsIgnoreCase("white");
        if (string.equalsIgnoreCase("black")) {
            n3 = 255;
            n = 255;
            n2 = 255;
        }
        if (string.equalsIgnoreCase("gray")) {
            n3 = 127;
            n = 127;
            n2 = 127;
        }
        if (string.equalsIgnoreCase("yellow")) {
            n = 255;
            n2 = 255;
        }
        if (string.equalsIgnoreCase("magenta")) {
            n = 255;
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    protected AScrollTextDisplayer getDisplayer() {
        if (this.theScrollTextDisplayer == null) {
            this.theScrollTextDisplayer = new AScrollTextDisplayer(this.getGraphics(), this.getSize().width);
        }
        return this.theScrollTextDisplayer;
    }

    protected int getFontExactSize(int n) {
        switch (n) {
            case 1: {
                return 8;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 18;
            }
            case 6: {
                return 24;
            }
            case 7: {
                return 36;
            }
        }
        return 12;
    }

    protected int getIntFromString(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void init() {
        super.init();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.loadFromAppletParams();
    }

    protected void loadFromAppletParams() {
        String string = this.getParameter("htmlSourceFile");
        if (string != null) {
            URL uRL = null;
            try {
                uRL = new URL(string);
                System.out.println(String.valueOf(uRL.toString()) + " URL formed well");
            }
            catch (Exception exception) {
                try {
                    uRL = new URL(this.getDocumentBase(), string);
                }
                catch (Exception exception2) {
                    System.out.println("Error Reading Config file");
                }
            }
            if (uRL != null) {
                try {
                    String string2;
                    DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
                    while ((string2 = dataInputStream.readLine()) != null) {
                        this.m_str = String.valueOf(this.m_str) + string2;
                    }
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error Reading Config file");
                }
            }
        }
        if ((string = this.getParameter("initialDelay")) != null) {
            this.m_initialDelay = this.getIntFromString(string);
        }
        if ((string = this.getParameter("normalDelay")) != null && this.getIntFromString(string) >= 0) {
            this.m_smallSleep = this.getIntFromString(string);
        }
        if ((string = this.getParameter("scrollStep")) != null && this.getIntFromString(string) >= 0) {
            this.m_scrollDelta = this.getIntFromString(string);
        }
        if ((string = this.getParameter("userName")) != null) {
            this.m_userName = new String(string);
        }
        if ((string = this.getParameter("userKey")) != null && this.getIntFromString(string) >= 0) {
            this.m_userKey = this.getIntFromString(string);
        }
    }

    protected Image loadImage(String string) {
        try {
            Image image = null;
            this.showStatus(String.valueOf(new String(" Loading image ")) + string);
            URL uRL = this.getCodeBase();
            image = this.getImage(uRL, string);
            if (image != null) {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {}
            }
            return image;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " occurred when trying to load image " + string);
            return null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.getX();
        mouseEvent.getY();
        String string = null;
        if (this.m_linkIndex != -1) {
            string = this.getDisplayer().getURL(this.m_linkIndex);
        }
        if (string != null) {
            this.navigateURL(string);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        this.yStart += n - this.savedY;
        if (this.yStart > 0 || this.yStart + this.m_height <= 0) {
            this.yStart = 0;
        }
        this.savedY = n;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.motionStopped = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_lastMouseXPos = -1;
        this.m_lastMouseYPos = -1;
        this.motionStopped = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_lastMouseXPos = mouseEvent.getX();
        this.m_lastMouseYPos = mouseEvent.getY();
        this.motionStopped = true;
        if (this.m_offGraphics == null) {
            return;
        }
        int n = -1;
        n = this.yStart + this.m_height > this.m_lastMouseYPos ? this.getDisplayer().updateLinks(this.m_offGraphics, this.m_lastMouseXPos, this.m_lastMouseYPos - this.yStart, this.m_linkIndex) : this.getDisplayer().updateLinks(this.m_offGraphics, this.m_lastMouseXPos, this.m_lastMouseYPos - this.yStart - this.m_height, this.m_linkIndex);
        if (this.m_linkIndex != n) {
            this.m_linkIndex = n;
            if (this.m_linkIndex != -1) {
                this.setCursor(this.m_handCursor);
                this.showStatus(this.getDisplayer().getURL(this.m_linkIndex));
            } else {
                this.setCursor(this.m_normalCursor);
                this.showStatus(null);
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.savedY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void navigateURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL(this.getCodeBase(), string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.err.println("Bad url: " + string);
            }
        }
        if (uRL != null) {
            this.getAppletContext().showDocument(uRL);
        }
    }

    protected void normalSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.m_offImage, 0, this.yStart, this);
        if (this.yStart + this.m_height < this.getSize().height) {
            graphics.drawImage(this.m_offImage, 0, this.yStart + this.m_height, this);
        }
    }

    protected void parseHTMLTag(Font font, Color color) {
        Font font2 = null;
        Color color2 = null;
        String string = null;
        String string2 = font.getName();
        int n = font.getSize();
        int n2 = font.getStyle();
        int n3 = this.m_str.length();
        if (color != null) {
            color2 = new Color(color.getRGB());
        }
        this.m_str.substring(this.m_currentIndex);
        AHTMLTag aHTMLTag = this.extractHTMLTag();
        if (aHTMLTag != null) {
            if (aHTMLTag.is(this.paragraphTag) || aHTMLTag.is(this.lineBreakTag)) {
                this.getDisplayer().goToNextLine();
                return;
            }
            if (aHTMLTag.is(this.bodyTag)) {
                int n4 = 0;
                while (n4 < aHTMLTag.getNoOfAttributes()) {
                    String string3;
                    if (aHTMLTag.getAttributeName(n4).equalsIgnoreCase("bgcolor")) {
                        string3 = aHTMLTag.getAttributeValue(n4);
                        this.backColor = this.getColorFromString(string3);
                    }
                    if (aHTMLTag.getAttributeName(n4).equalsIgnoreCase("text")) {
                        string3 = aHTMLTag.getAttributeValue(n4);
                        color2 = this.getColorFromString(string3);
                    }
                    ++n4;
                }
                font2 = new Font(string2, n2, n);
            } else if (aHTMLTag.is(this.boldTag)) {
                font2 = new Font(string2, n2 | 1, n);
            } else if (aHTMLTag.is(this.underlineTag)) {
                font2 = new Font(string2, n2, n);
            } else if (aHTMLTag.is(this.italicTag)) {
                font2 = new Font(string2, n2 | 2, n);
            } else if (aHTMLTag.is(this.fontTag)) {
                String string4 = string2;
                int n5 = n;
                int n6 = 0;
                while (n6 < aHTMLTag.getNoOfAttributes()) {
                    String string5;
                    if (aHTMLTag.getAttributeName(n6).equalsIgnoreCase("face")) {
                        string4 = aHTMLTag.getAttributeValue(n6);
                    }
                    if (aHTMLTag.getAttributeName(n6).equalsIgnoreCase("size")) {
                        string5 = aHTMLTag.getAttributeValue(n6);
                        int n7 = 0;
                        char c = string5.charAt(n7++);
                        int n8 = 3;
                        int n9 = 1;
                        if (c == '-') {
                            n9 = -1;
                        } else if (c == '+') {
                            n9 = 1;
                        } else {
                            n8 = 0;
                            --n7;
                        }
                        c = string5.charAt(n7);
                        int n10 = n8 + n9 * (c - 48);
                        n5 = this.getFontExactSize(n10);
                    }
                    if (aHTMLTag.getAttributeName(n6).equalsIgnoreCase("color")) {
                        string5 = aHTMLTag.getAttributeValue(n6);
                        color2 = this.getColorFromString(string5);
                    }
                    ++n6;
                }
                font2 = new Font(string4, n2, n5);
            } else {
                if (aHTMLTag.is(this.imageTag)) {
                    String string6 = null;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    while (n13 < aHTMLTag.getNoOfAttributes()) {
                        Integer n14;
                        if (aHTMLTag.getAttributeName(n13).equalsIgnoreCase("src")) {
                            string6 = aHTMLTag.getAttributeValue(n13);
                        }
                        if (aHTMLTag.getAttributeName(n13).equalsIgnoreCase("width")) {
                            n14 = new Integer(aHTMLTag.getAttributeValue(n13));
                            n11 = n14;
                        }
                        if (aHTMLTag.getAttributeName(n13).equalsIgnoreCase("height")) {
                            n14 = new Integer(aHTMLTag.getAttributeValue(n13));
                            n12 = n14;
                        }
                        ++n13;
                    }
                    if (string6 != null) {
                        Image image = this.loadImage(string6);
                        this.getDisplayer().addImage(image, n11, n12);
                    }
                    return;
                }
                if (aHTMLTag.is(this.urlTag)) {
                    int n15 = 0;
                    while (n15 < aHTMLTag.getNoOfAttributes()) {
                        if (aHTMLTag.getAttributeName(n15).equalsIgnoreCase("href")) {
                            string = aHTMLTag.getAttributeValue(n15);
                        }
                        ++n15;
                    }
                    font2 = new Font(string2, n2, n);
                } else {
                    font2 = new Font(string2, n2, n);
                }
            }
        }
        String string7 = "";
        char c = ' ';
        while (this.m_currentIndex < n3) {
            c = this.m_str.charAt(this.m_currentIndex);
            if (c == '&') {
                while ((c = this.m_str.charAt(++this.m_currentIndex)) != ';') {
                }
                ++this.m_currentIndex;
                continue;
            }
            if (c == '<') {
                if (string7.length() > 0) {
                    this.getDisplayer().addFormattedText(string7, font2, color2, string);
                }
                if (this.m_str.charAt(this.m_currentIndex + 1) == '/') {
                    ++this.m_currentIndex;
                    c = this.m_str.charAt(this.m_currentIndex);
                    while (this.m_currentIndex < n3 && c != '>') {
                        ++this.m_currentIndex;
                        c = this.m_str.charAt(this.m_currentIndex);
                    }
                    if (this.m_currentIndex < n3) {
                        ++this.m_currentIndex;
                    }
                    return;
                }
                this.parseHTMLTag(font2, color2);
                string7 = "";
                continue;
            }
            string7 = String.valueOf(string7) + c;
            ++this.m_currentIndex;
        }
        if (string7.length() > 0) {
            this.getDisplayer().addFormattedText(string7, font2, color2, string);
        }
    }

    public void run() {
        int n = this.m_initialDelay;
        while (true) {
            if (!this.motionStopped) {
                this.yStart -= this.m_scrollDelta;
                if (this.yStart + this.m_height <= 0) {
                    this.yStart = 0;
                }
                this.repaint();
            }
            this.smartSleep(n);
            n = this.m_smallSleep;
        }
    }

    protected void smartSleep(int n) {
        if (n < 10) {
            this.normalSleep(n);
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        while (l2 > l) {
            this.normalSleep(10);
            l2 -= 10L;
        }
    }

    public void start() {
        this.m_currentIndex = 0;
        this.parseHTMLTag(this.m_font, null);
        if (this.verifyLicense() == 0) {
            this.getDisplayer().goToNextLine();
            this.getDisplayer().addFormattedText("Visit AXScroll homepage", this.getFont(), new Color(255, 255, 255), "http://alexi.webmessenger.ro");
        }
        this.m_height = this.getDisplayer().getHeight();
        this.m_height += this.getSize().height - this.m_height % this.getSize().height;
        this.m_offImage = this.createImage(this.getSize().width, this.m_height);
        this.m_offGraphics = this.m_offImage.getGraphics();
        this.getDisplayer().backColor = this.backColor;
        this.getDisplayer().drawAll(this.m_offGraphics, this.getSize().width, this.m_height);
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private int verifyLicense() {
        if (this.m_userName == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_userName.length()) {
            n += this.m_userName.charAt(n2);
            ++n2;
        }
        if ((n = n % 333 * 2 - 1) == this.m_userKey) {
            return 1;
        }
        return 0;
    }
}

