/*
 * Decompiled with CFR 0.152.
 */
package projet.palette;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.Serializable;

public class ColorPalette
implements Serializable {
    byte[][] palette;
    static final long serialVersionUID = -4142362085611022583L;

    public ColorPalette(byte[][] byArray) {
        this.palette = byArray;
    }

    public Color getColor(int n) {
        return new Color((this.palette[0][n] & 0xFF) << 16 | (this.palette[1][n] & 0xFF) << 8 | this.palette[2][n] & 0xFF);
    }

    public int getRGB(int n) {
        return (this.palette[0][n] & 0xFF) << 16 | (this.palette[1][n] & 0xFF) << 8 | this.palette[2][n] & 0xFF;
    }

    public void change(int n, int n2) {
        this.palette[0][n] = (byte)(n2 >> 16 & 0xFF);
        this.palette[1][n] = (byte)(n2 >> 8 & 0xFF);
        this.palette[2][n] = (byte)(n2 & 0xFF);
    }

    public void change(int n, Color color) {
        this.change(n, color.getRGB());
    }

    public void change(int n, int n2, int n3) {
        int n4 = n;
        while (n4 <= n2) {
            this.change(n4, n3);
            ++n4;
        }
    }

    public void getReds(byte[] byArray) {
        byArray = this.palette[0];
    }

    public void getGreens(byte[] byArray) {
        byArray = this.palette[1];
    }

    public void getBlues(byte[] byArray) {
        byArray = this.palette[2];
    }

    public IndexColorModel getIndexColorModel(int n) {
        return new IndexColorModel(n, this.palette[0].length, this.palette[0], this.palette[1], this.palette[2]);
    }

    public void filtre(int n, int n2, int n3, float f) {
        n3 %= 3;
        if (f > 0.0f) {
            int n4 = n;
            while (n4 <= n2) {
                this.augmente(n3, n4, f);
                this.diminue((n3 + 1) % 3, n4, (float)(1.0 - (double)f / 2.0));
                this.diminue((n3 + 2) % 3, n4, (float)(1.0 - (double)f / 2.0));
                ++n4;
            }
            return;
        }
        f = -f;
        int n5 = n;
        while (n5 <= n2) {
            this.diminue(n3, n5, 1.0f - f);
            this.augmente((n3 + 1) % 3, n5, (float)((double)f / 2.0));
            this.augmente((n3 + 2) % 3, n5, (float)((double)f / 2.0));
            ++n5;
        }
    }

    private void augmente(int n, int n2, float f) {
        this.palette[n][n2] = (byte)((float)this.val(this.palette[n][n2]) + (float)(255 - this.val(this.palette[n][n2])) * f);
    }

    private void diminue(int n, int n2, float f) {
        this.palette[n][n2] = (byte)((float)this.val(this.palette[n][n2]) * f);
    }

    public void light(int n, int n2, float f) {
        if (f > 0.0f) {
            int n3 = n;
            while (n3 <= n2) {
                this.augmente(0, n3, f);
                this.augmente(1, n3, f);
                this.augmente(2, n3, f);
                ++n3;
            }
            return;
        }
        f += 1.0f;
        int n4 = n;
        while (n4 <= n2) {
            this.diminue(0, n4, f);
            this.diminue(1, n4, f);
            this.diminue(2, n4, f);
            ++n4;
        }
    }

    public void blackAndWhite(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            int n4 = (int)((double)((this.palette[0][n3] & 0xFF) + (this.palette[1][n3] & 0xFF) + (this.palette[2][n3] & 0xFF)) / 3.0);
            this.palette[0][n3] = (byte)n4;
            this.palette[1][n3] = (byte)n4;
            this.palette[2][n3] = (byte)n4;
            ++n3;
        }
    }

    private boolean ap(int n, int n2) {
        return (double)n < (double)n2 * 1.25 && (double)n > (double)n2 * 0.75;
    }

    public void couleur(int n, int n2, float f) {
        if (f > 0.0f) {
            int n3 = n;
            while (n3 <= n2) {
                int n4 = this.val(this.palette[0][n3]);
                int n5 = this.val(this.palette[1][n3]);
                int n6 = this.val(this.palette[2][n3]);
                if (this.ap(n4, n5) && n4 > n6) {
                    this.augmente(0, n3, (float)((double)f / 2.0));
                    this.augmente(1, n3, (float)((double)f / 2.0));
                    this.diminue(2, n3, 1.0f - f);
                } else if (this.ap(n4, n6) && n4 > n5) {
                    this.augmente(0, n3, (float)((double)f / 2.0));
                    this.augmente(2, n3, (float)((double)f / 2.0));
                    this.diminue(1, n3, 1.0f - f);
                } else if (this.ap(n5, n6) && n5 > n4) {
                    this.augmente(1, n3, (float)((double)f / 2.0));
                    this.augmente(2, n3, (float)((double)f / 2.0));
                    this.diminue(0, n3, 1.0f - f);
                } else if (n4 > n5 && n4 > n6) {
                    this.augmente(0, n3, f);
                    this.diminue(1, n3, (float)(1.0 - (double)f / 2.0));
                    this.diminue(2, n3, (float)(1.0 - (double)f / 2.0));
                } else if (n5 > n4 && n5 > n6) {
                    this.augmente(1, n3, f);
                    this.diminue(0, n3, (float)(1.0 - (double)f / 2.0));
                    this.diminue(2, n3, (float)(1.0 - (double)f / 2.0));
                } else if (n6 > n4 && n6 > n5) {
                    this.augmente(2, n3, f);
                    this.diminue(0, n3, (float)(1.0 - (double)f / 2.0));
                    this.diminue(1, n3, (float)(1.0 - (double)f / 2.0));
                } else if (n5 == n6 && n5 == n4) {
                    if (n5 > 127) {
                        this.augmente(0, n3, f);
                        this.augmente(1, n3, f);
                        this.augmente(2, n3, f);
                    } else {
                        this.diminue(0, n3, 1.0f - f);
                        this.diminue(1, n3, 1.0f - f);
                        this.diminue(2, n3, 1.0f - f);
                    }
                }
                ++n3;
            }
            return;
        }
        int n7 = n;
        while (n7 <= n2) {
            int n8 = this.val(this.palette[0][n7]);
            int n9 = this.val(this.palette[1][n7]);
            int n10 = this.val(this.palette[2][n7]);
            if (this.ap(n8, n9) && n8 > n10) {
                this.diminue(0, n7, (float)((double)f / 2.0 + 1.0));
                this.diminue(1, n7, (float)((double)f / 2.0 + 1.0));
                this.augmente(2, n7, -f);
            } else if (this.ap(n8, n10) && n8 > n9) {
                this.diminue(0, n7, (float)((double)f / 2.0 + 1.0));
                this.diminue(2, n7, (float)((double)f / 2.0 + 1.0));
                this.augmente(1, n7, -f);
            } else if (this.ap(n9, n10) && n9 > n8) {
                this.diminue(1, n7, (float)((double)f / 2.0 + 1.0));
                this.diminue(2, n7, (float)((double)f / 2.0 + 1.0));
                this.augmente(0, n7, -f);
            } else if (n8 > n9 && n8 > n10) {
                this.diminue(0, n7, f + 1.0f);
                this.augmente(1, n7, (float)((double)(-f) / 2.0));
                this.augmente(2, n7, (float)((double)(-f) / 2.0));
            } else if (n9 > n8 && n9 > n10) {
                this.diminue(1, n7, f + 1.0f);
                this.augmente(0, n7, (float)((double)(-f) / 2.0));
                this.augmente(2, n7, (float)((double)(-f) / 2.0));
            } else if (n10 > n8 && n10 > n9) {
                this.diminue(2, n7, f + 1.0f);
                this.augmente(0, n7, (float)((double)(-f) / 2.0));
                this.augmente(1, n7, (float)((double)(-f) / 2.0));
            } else if (n9 == n10 && n9 == n8) {
                if (n9 > 127) {
                    this.diminue(0, n7, 1.0f + f);
                    this.diminue(1, n7, 1.0f + f);
                    this.diminue(2, n7, 1.0f + f);
                } else {
                    this.augmente(0, n7, -f);
                    this.augmente(1, n7, -f);
                    this.augmente(2, n7, -f);
                }
            }
            ++n7;
        }
    }

    public void fade(int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.val(this.palette[0][n]);
        int n5 = this.val(this.palette[1][n]);
        int n6 = this.val(this.palette[2][n]);
        int n7 = this.val(this.palette[0][n2]);
        int n8 = this.val(this.palette[1][n2]);
        int n9 = this.val(this.palette[2][n2]);
        double d = (double)(n7 - n4) / (double)n3;
        double d2 = (double)(n8 - n5) / (double)n3;
        double d3 = (double)(n9 - n6) / (double)n3;
        int n10 = n + 1;
        int n11 = 1;
        while (n10 < n2) {
            this.palette[0][n10] = (byte)((double)n4 + (double)n11 * d);
            this.palette[1][n10] = (byte)((double)n5 + (double)n11 * d2);
            this.palette[2][n10] = (byte)((double)n6 + (double)n11 * d3);
            ++n10;
            ++n11;
        }
    }

    public void aleaFade(int n, int n2, int n3) {
        int[] nArray = new int[n3 + 2];
        float f = (float)(n2 - n) / (float)(n3 + 1);
        nArray[0] = n;
        nArray[nArray.length - 1] = n2;
        int n4 = 1;
        while (n4 < nArray.length - 1) {
            nArray[n4] = (int)Math.floor((float)n + (float)n4 * f);
            this.change(nArray[n4], (int)(Math.random() * 2.147483647E9));
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3 + 1) {
            this.fade(nArray[n5], nArray[n5 + 1]);
            ++n5;
        }
    }

    public void fluidite(int n, int n2, float f) {
        if (f > 0.0f) {
            int n3 = (int)(127.0f * f);
            int n4 = 0;
            int[][] nArray = new int[4][this.palette[0].length];
            int n5 = n + 2;
            while (n5 < n2 - 1) {
                int n6 = (int)(((double)this.val(this.palette[0][n5 - 2]) + (double)this.val(this.palette[0][n5 - 1]) + (double)this.val(this.palette[0][n5 + 1]) + (double)this.val(this.palette[0][n5 - 2])) / 4.0);
                int n7 = (int)(((double)this.val(this.palette[1][n5 - 2]) + (double)this.val(this.palette[1][n5 - 1]) + (double)this.val(this.palette[1][n5 + 1]) + (double)this.val(this.palette[1][n5 + 2])) / 4.0);
                int n8 = (int)(((double)this.val(this.palette[2][n5 - 2]) + (double)this.val(this.palette[2][n5 - 1]) + (double)this.val(this.palette[2][n5 + 1]) + (double)this.val(this.palette[2][n5 + 2])) / 4.0);
                if (this.val(this.palette[0][n5]) < n6 - n3 || this.val(this.palette[0][n5]) > n6 + n3 || this.val(this.palette[1][n5]) < n7 - n3 || this.val(this.palette[1][n5]) > n7 + n3 || this.val(this.palette[2][n5]) > n8 + n3 || this.val(this.palette[2][n5]) < n8 - n3) {
                    nArray[0][n4] = n5;
                    nArray[1][n4] = n6;
                    nArray[2][n4] = n7;
                    nArray[3][n4] = n8;
                    ++n4;
                }
                ++n5;
            }
            int n9 = 0;
            while (n9 < n4) {
                this.palette[0][nArray[0][n9]] = (byte)nArray[1][n9];
                this.palette[1][nArray[0][n9]] = (byte)nArray[2][n9];
                this.palette[2][nArray[0][n9]] = (byte)nArray[3][n9];
                ++n9;
            }
            return;
        }
        f = (float)((double)(-f) / 2.0);
        int n10 = n;
        while (n10 <= n2) {
            int n11 = 0;
            while (n11 < 3) {
                float f2 = (float)Math.random();
                if ((double)f2 > 0.5) {
                    this.augmente(n11, n10, f2 * f);
                } else {
                    this.diminue(n11, n10, 1.0f - f2 * f);
                }
                ++n11;
            }
            ++n10;
        }
    }

    public int length() {
        return this.palette[0].length;
    }

    private int val(byte by) {
        return by & 0xFF;
    }
}

