import java.applet.*;
import java.awt.*;

class ParameterUtilities
{
	private Applet applet;

	ParameterUtilities(Applet applet)
	{
		this.applet=applet;
	}

	Color getColorParameter(String name,Color default_)
	{
		String parameter=applet.getParameter(name);

		if(parameter==null)
			return default_;
		else if(parameter.equalsIgnoreCase("random"))
			return new Color((int)(Math.random()*0x1000000));
		else if(parameter.equalsIgnoreCase("dark random"))
			return new Color((int)(Math.random()*0x1000000)).darker();
		else if(parameter.equalsIgnoreCase("light random"))
			return new Color((int)(Math.random()*0x1000000)).brighter();
		else
			return new Color(Integer.parseInt(parameter,16));
	}

	int getStringArrayParameter(String name,String values[],int default_)
	{
		int n;
		String parameter=applet.getParameter(name);

		if(parameter==null)
			return default_;
		else if(parameter.equalsIgnoreCase("random"))
			return (int)(Math.random()*values.length);
		else
			for(n=0;n<values.length;n++)
				if(parameter.equalsIgnoreCase(values[n]))
					return n;

		return default_;
	}

	int getIntegerParameter(String name,int xdefault)
	{
		String parameter=applet.getParameter(name);

		if(parameter==null)
			return xdefault;
		else
			return Integer.parseInt(parameter,10);
	}
}

