/**
 * This class provides vertex and surface data for 3D letters.
 * <P>
 * author: Michael Kraus<BR>
 * version: 1.2<BR>
 * date: 1999/5/17<BR>
 * environment: JDK 1.0.2<BR>
 * email: <A href="michael.kraus@informatik.uni-muenchen.de">michael.kraus@informatik.uni-muenchen.de</A><BR>
 * homepage: <A href="www.informatik.uni-muenchen.de/~michael.kraus">www.informatik.uni-muenchen.de/~michael.kraus</A>
 */

public class KubikFont
{
	private static int X=0;
	private static int Y=1;
	private static int Z=2;

	private static int local[][][]=
	{
		{	// 'A'
			{-3,-5},{3,-5},{3,5},{1,5},{1,1},{-1,1},{-1,5},{-3,5},
			{-1,-3},{1,-3},{1,-1},{-1,-1}
		},
		{	// 'B'
			{-3,-5},{3,-5},{3,-2},{1,0},{3,2},{3,5},{-3,5},
			{-1,-3},{1,-3},{-1,-1},
			{-1,1},{1,3},{-1,3}
		},
		{	// 'C'
			{-3,-5},{3,-5},{3,-3},{-1,-3},{-1,3},{3,3},{3,5},
			{-3,5}
		},
		{	// 'D'
			{-3,-5},{0,-5},{4,-1},{4,1},{0,5},{-3,5},
			{-1,-3},{2,0},{-1,3}
		},
		{	// 'E'
			{-3,-5},{3,-5},{3,-3},{-1,-3},{-1,-1},{3,-1},{3,1},{-1,1},{-1,3},{3,3},{3,5},{-3,5}
		},
		{	// 'F'
			{-3,-5},{3,-5},{3,-3},{-1,-3},{-1,-1},{3,-1},{3,1},{-1,1},{-1,5},{-3,5}
		},
		{	// 'G'
			{-3,-5},{3,-5},{3,-3},{-1,-3},{-1,3},{1,3},{1,-1},{3,-1},{3,5},{-3,5}
		},
		{	// 'H'
			{-3,-5},{-1,-5},{-1,-1},{1,-1},{1,-5},{3,-5},{3,5},{1,5},{1,1},{-1,1},{-1,5},{-3,5}
		},
		{	// 'I'
			{-1,-5},{1,-5},{1,5},{-1,5}
		},
		{	// 'J'
			{-3,1},{-1,1},{-1,3},{1,3},{1,-5},{3,-5},{3,5},{-3,5}
		},
		{	// 'K'
			{-3,-5},{-1,-5},{-1,-1},{1,-5},{4,-5},{1,0},{4,5},{1,5},{-1,1},{-1,5},{-3,5}
		},
		{	// 'L'
			{-3,-5},{-1,-5},{-1,3},{3,3},{3,5},{-3,5}
		},
		{	// 'M'
			{-4,-5},{-2,-5},{0,-1},{2,-5},{4,-5},{4,5},{2,5},{2,-1},{0,3},{-2,-1},{-2,5},{-4,5}
		},
		{	// 'N'
			{-3,-5},{-1,-5},{1,0},{1,-5},{3,-5},{3,5},{1,5},{-1,0},{-1,5},{-3,5}
		},
		{	// 'O'
			{-3,-5},{3,-5},{3,5},{-3,5},
			{-1,-3},{1,-3},{1,3},{-1,3}
		},
		{	// 'P'
			{-3,-5},{3,-5},{3,1},{-1,1},{-1,5},{-3,5},
			{-1,-3},{1,-3},{1,-1},{-1,-1}
		},
		{	// 'Q'
			{-3,-5},{3,-5},{3,4},{4,6},{3,7},{2,5},{-3,5},
			{-1,-3},{1,-3},{1,0},{0,1},{1,3},{-1,3}
		},
		{	// 'R'
			{-3,-5},{3,-5},{3,1},{1,1},{4,5},{1,5},{-1,2},{-1,5},{-3,5},
			{-1,-3},{1,-3},{1,-1},{-1,-1}
		},
		{	// 'S'
			{-3,-5},{3,-5},{3,-3},{-1,-3},{-1,-1},{3,-1},{3,5},{-3,5},{-3,3},{1,3},{1,1},{-3,1}
		},
		{	// 'T'
			{-3,-5},{3,-5},{3,-3},{1,-3},{1,5},{-1,5},{-1,-3},{-3,-3}
		},
		{	// 'U'
			{-3,-5},{-1,-5},{-1,3},{1,3},{1,-5},{3,-5},{3,5},{-3,5}
		},
		{	// 'V'
			{-3,-5},{-1,-5},{0,0},{1,-5},{3,-5},{1,5},{-1,5}
		},
		{	// 'W'
			{-4,5},{-2,5},{0,1},{2,5},{4,5},{4,-5},{2,-5},{2,1},{0,-3},{-2,1},{-2,-5},{-4,-5}
		},
		{	// 'X'
			{-3,-5},{-1,-5},{0,-3},{1,-5},{3,-5},{1,0},{3,5},{1,5},{0,3},{-1,5},{-3,5},{-1,0}
		},
		{	// 'Y'
			{-3,-5},{-1,-5},{0,-3},{1,-5},{3,-5},{1,0},{1,5},{-1,5},{-1,0}
		},
		{	// 'Z'
			{-3,-5},{3,-5},{3,-3},{0,3},{3,3},{3,5},{-3,5},{-3,3},{0,-3},{-3,-3}
		}
	};

	private static int surface[][][]=
	{
		{	// 'A'
			{0,1,2,3,4,5,6,7},
			{8,9,10,11}
		},
		{	// 'B'
			{0,1,2,3,4,5,6},
			{7,8,9},
			{10,11,12}
		},
		{	// 'C'
			{0,1,2,3,4,5,6,7}
		},
		{	// 'D'
			{0,1,2,3,4,5},
			{6,7,8}
		},
		{	// 'E'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'F'
			{0,1,2,3,4,5,6,7,8,9}
		},
		{	// 'G'
			{0,1,2,3,4,5,6,7,8,9}
		},
		{	// 'H'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'I'
			{0,1,2,3}
		},
		{	// 'J'
			{0,1,2,3,4,5,6,7}
		},
		{	// 'K'
			{0,1,2,3,4,5,6,7,8,9,10}
		},
		{	// 'L'
			{0,1,2,3,4,5}
		},
		{	// 'M'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'N'
			{0,1,2,3,4,5,6,7,8,9}
		},
		{	// 'O'
			{0,1,2,3},
			{4,5,6,7}
		},
		{	// 'P'
			{0,1,2,3,4,5},
			{6,7,8,9}
		},
		{	// 'Q'
			{0,1,2,3,4,5,6},
			{7,8,9,10,11,12}
		},
		{	// 'R'
			{0,1,2,3,4,5,6,7,8},
			{9,10,11,12}
		},
		{	// 'S'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'T'
			{0,1,2,3,4,5,6,7}
		},
		{	// 'U'
			{0,1,2,3,4,5,6,7}
		},
		{	// 'V'
			{0,1,2,3,4,5,6}
		},
		{	// 'W'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'X'
			{0,1,2,3,4,5,6,7,8,9,10,11}
		},
		{	// 'Y'
			{0,1,2,3,4,5,6,7,8}
		},
		{	// 'Z'
			{0,1,2,3,4,5,6,7,8,9}
		}
	};

	private static int width[]=
	{
		6,6,6,6,6,6,6,6,2,6,6,6,8,6,6,6,6,6,6,6,6,6,8,6,6,6
	};

	private static int height=10;

	private static int ZOOM=10;

	public static int SPACEWIDTH=2*ZOOM;
	public static int LINEHEIGHT=(height+2)*ZOOM;

	public static int[][] getLocal(char name)
	{
		int n;

		int size=local[name-'A'].length;

		int newlocal[][]=new int[2*size][3];

		for(n=0;n<size;n++)
		{
			newlocal[n][X]=ZOOM*local[name-'A'][n][X];
			newlocal[n][Y]=ZOOM*local[name-'A'][n][Y];
			newlocal[n][Z]=-ZOOM;

			newlocal[n+size][X]=ZOOM*local[name-'A'][n][X];
			newlocal[n+size][Y]=ZOOM*local[name-'A'][n][Y];
			newlocal[n+size][Z]=ZOOM;
		}

		return newlocal;
	}

	public static int[][] getLocal(String string)
	{
		int n;
		int m;
		int size;
		int newlocal[][];
		int pointer;

		size=0;

		for(n=0;n<string.length();n++)
			size+=local[string.charAt(n)-'A'].length;

		newlocal=new int[2*size][3];

		pointer=0;

		for(m=0;m<string.length();m++)
			for(n=0;n<local[string.charAt(m)-'A'].length;n++)
			{
				newlocal[pointer][X]=ZOOM*local[string.charAt(m)-'A'][n][X];
				newlocal[pointer][Y]=ZOOM*local[string.charAt(m)-'A'][n][Y];
				newlocal[pointer][Z]=-ZOOM;

				newlocal[pointer+size][X]=ZOOM*local[string.charAt(m)-'A'][n][X];
				newlocal[pointer+size][Y]=ZOOM*local[string.charAt(m)-'A'][n][Y];
				newlocal[pointer+size][Z]=ZOOM;

				pointer++;
			}

		return newlocal;
	}

	public static int[][] getSurface(char name)
	{
		int n;
		int m;
		int l;

		int size=surface[name-'A'].length;
		int nsize;

		m=2*size;

		for(n=0;n<size;n++)
			m+=surface[name-'A'][n].length;

		int newsurface[][]=new int[m][];

		for(n=0;n<size;n++)
		{
			nsize=surface[name-'A'][n].length;

			newsurface[n]=new int[nsize];

			for(m=0;m<nsize;m++)
				newsurface[n][m]=surface[name-'A'][n][m];

			newsurface[n+size]=new int[nsize];

			for(m=0;m<nsize;m++)
				newsurface[n+size][m]=newsurface[n][m]+local[name-'A'].length;
		}

		for(l=2*size,n=0;n<size;n++)
		{
			nsize=newsurface[n].length;

			for(m=0;m<nsize;m++,l++)
			{
				newsurface[l]=new int[4];

				newsurface[l][0]=newsurface[n][m];
				newsurface[l][1]=newsurface[n][(m+1)%nsize];
				newsurface[l][2]=newsurface[n+size][(m+1)%nsize];
				newsurface[l][3]=newsurface[n+size][m];
			}
		}

		return newsurface;
	}

	public static int getWidth(char name)
	{
		return width[name-'A']*ZOOM;
	}
}

