import java.applet.*;
import java.awt.*;
import java.util.*;

/**
 * This applet displays arbitrary text as rotating 3D letters.
 * <P>
 * Example HTML code:
 * <applet code="Kubik.class" width=222 height=77>
 * </applet>
 * <P>
 * author: Michael Kraus<BR>
 * version: 1.2<BR>
 * date: 1999/5/17<BR>
 * environment: JDK 1.0.2<BR>
 * email: <A href="michael.kraus@informatik.uni-muenchen.de">michael.kraus@informatik.uni-muenchen.de</A><BR>
 * homepage: <A href="www.informatik.uni-muenchen.de/~michael.kraus">www.informatik.uni-muenchen.de/~michael.kraus</A>
 */

public class Kubik extends Applet implements Runnable
{
	private Thread thread;
	ParameterUtilities parameterUtilities;

	private FixedCamera camera;
	private Vector wireframeVector;

	private Dimension appletDimension;

	private Color foreground;
	private Color background;

	private int dxangle;
	private int dyangle;
	private int dzangle;

	private int delay;

	private int prev_x;
	private int prev_y;

	private int getAngleParameter(String name,int xdefault)
	{
		int angle;
		String parameter=getParameter(name);

		if(parameter==null)
			angle=xdefault;
		else if(parameter.equalsIgnoreCase("RANDOM"))
			angle=(int)(Math.random()*360);
		else
			angle=Integer.parseInt(parameter,10);

		return angle*FastMath.TWOPI/360;
	}

	public void init()
	{
		int n;
		char character;
		Wireframe letter;

		int xpos;
		int ypos;
		int zpos;

		int z0pos;
		int dzpos;
		int maxxpos;

		int x0angle;
		int y0angle;
		int z0angle;

		int dx0angle;
		int dy0angle;
		int dz0angle;

		int width;
		int lastwidth;

		String text;
		int size;

		int cameradistance;
		int screendistance;

		appletDimension=size();
		parameterUtilities=new ParameterUtilities(this);

		if((text=getParameter("text"))==null)
			text="KUBIK";

		wireframeVector=new Vector(size=text.length());

		xpos=0;
		ypos=0;

		maxxpos=0;
		lastwidth=0;

		z0pos=parameterUtilities.getIntegerParameter("zpos",0);
		dzpos=parameterUtilities.getIntegerParameter("dzpos",0);
		zpos=z0pos;

		x0angle=getAngleParameter("x0",0);
		y0angle=getAngleParameter("y0",0);
		z0angle=getAngleParameter("z0",0);

		dx0angle=getAngleParameter("dx0",15);
		dy0angle=getAngleParameter("dy0",45);
		dz0angle=getAngleParameter("dz0",0);

		for(n=0;n<size;n++)
		{
			character=text.charAt(n);

			if(character==' ')
			{
				xpos+=(lastwidth+KubikFont.SPACEWIDTH)/2+KubikFont.SPACEWIDTH;
				lastwidth=KubikFont.SPACEWIDTH;
				zpos+=dzpos;
			}
			else if(character=='|')
			{
				maxxpos=Math.max(maxxpos,xpos+lastwidth/2-KubikFont.SPACEWIDTH);

				xpos=0;
				ypos+=KubikFont.LINEHEIGHT;
				zpos=z0pos;

				lastwidth=0;
			}
			else
			{
				width=KubikFont.getWidth(character);
				xpos+=(lastwidth+width)/2;
				lastwidth=width;

				wireframeVector.addElement(new Wireframe(KubikFont.getLocal(character),KubikFont.getSurface(text.charAt(n)),xpos,ypos,zpos,x0angle,y0angle,z0angle));

				xpos+=KubikFont.SPACEWIDTH;
				zpos+=dzpos;

				x0angle+=dx0angle;
				y0angle+=dy0angle;
				z0angle+=dz0angle;
			}
		}

		maxxpos=Math.max(maxxpos,xpos+lastwidth/2-KubikFont.SPACEWIDTH);

		cameradistance=parameterUtilities.getIntegerParameter("camera distance",10000);
		screendistance=parameterUtilities.getIntegerParameter("screen distance",5000);

		camera=new FixedCamera(maxxpos/2,ypos/2,-cameradistance,appletDimension.width,appletDimension.height,screendistance);

		setForeground(foreground=parameterUtilities.getColorParameter("foreground",Color.green));
		setBackground(background=parameterUtilities.getColorParameter("background",Color.black));

		dxangle=getAngleParameter("dx",-2);
		dyangle=getAngleParameter("dy",-10);
		dzangle=getAngleParameter("dz",0);

		delay=10*parameterUtilities.getIntegerParameter("delay",10);

		for(n=0;n<wireframeVector.size();n++)
		{
			camera.addWireframe((Wireframe)wireframeVector.elementAt(n));
		}
	}

	public void run()
	{
		while(true)
		{
			for(int n=0;n<wireframeVector.size();n++)
			{
				((Wireframe)wireframeVector.elementAt(n)).rotate(dxangle,dyangle,dzangle);
			}

			repaint();

			try
			{
				thread.sleep(delay);
			}
			catch(InterruptedException exception)
			{
			}
		}
	}

	public void update(Graphics graphics)
	{
		int n;
		Image dbuf;
		Graphics dbufgraphics;

		dbuf=createImage(appletDimension.width,appletDimension.height);
		dbufgraphics=dbuf.getGraphics();

		dbufgraphics.setColor(background);
		dbufgraphics.fillRect(0,0,appletDimension.width,appletDimension.height);

		dbufgraphics.setColor(foreground);

		camera.draw(dbufgraphics);

		graphics.drawImage(dbuf,0,0,null);
	}

	public void paint(Graphics graphics)
	{
		update(graphics);
	}

	public String[][] getParameterInfo()
	{
		String parameterinfo[][]=
		{
			{"text","String","Only 'A' through 'Z' and blanks supported. Use '|' as newline."},
			{"foreground","24 bit RGB (hex. int)/RANDOM/DARK RANDOM/LIGHT RANDOM","default: green"},
			{"background","24 bit RGB (hex. int)/RANDOM/DARK RANDOM/LIGHT RANDOM","default: black"},
			{"camera distance","pixels (int)","default: 10000"},
			{"screen distance","pixels (int)","default: 5000"},
			{"dx","degrees (int)","default: -2"},
			{"dy","degrees (int)","default: -10"},
			{"dz","degrees (int)","default: 0"},
			{"delay","1/100 seconds (int)","default: 10"},
			{"zpos","pixels (int)","default: 0"},
			{"dzpos","pixels (int)","default: 0"},
			{"x0","degrees (int)","default: 0"},
			{"y0","degrees (int)","default: 0"},
			{"z0","degrees (int)","default: 0"},
			{"dx0","degrees (int)","default: 15"},
			{"dy0","degrees (int)","default: 45"},
			{"dz0","degrees (int)","default: 0"}
		};

		return parameterinfo;
	}

	public String getAppletInfo()
	{
		return
			"Kubik\n"+
			"\n"+
			"author: Michael Kraus\n"+
			"version: 1.2\n"+
			"date: January 1998\n"+
			"environment: JDK 1.0.2\n"+
			"email: michael.kraus@informatik.uni-muenchen.de\n"+
			"homepage: www.informatik.uni-muenchen.de/~michael.kraus\n";
	}

	public void start()
	{
		if(thread==null)
		{
			thread=new Thread(this);
			thread.start();
		}
	}

	public void stop()
	{
		if(thread!=null)
		{
			thread.stop();
			thread=null;
		}
	}

	public boolean mouseEnter(Event event,int x,int y)
	{
		stop();

		prev_x=x;
		prev_y=y;

		return true;
	}

	public boolean mouseExit(Event event,int x,int y)
	{
		start();

		return true;
	}

	public boolean mouseMove(Event event,int x,int y)
	{
		for(int n=0;n<wireframeVector.size();n++)
		{
			((Wireframe)wireframeVector.elementAt(n)).rotate((y-prev_y)*FastMath.TWOPI/appletDimension.height,(x-prev_x)*FastMath.TWOPI/appletDimension.width,0);
		}

		repaint();

		prev_x=x;
		prev_y=y;

		return true;
	}

	public boolean mouseDrag(Event event,int x,int y)
	{
		for(int n=0;n<wireframeVector.size();n++)
		{
			((Wireframe)wireframeVector.elementAt(n)).rotate(0,0,(y-prev_y)*FastMath.TWOPI/appletDimension.height+(x-prev_x)*FastMath.TWOPI/appletDimension.width);
		}

		repaint();

		prev_x=x;
		prev_y=y;

		return true;
	}
}

