<?php
require_once "../regexpBuilder.php";
/*
Find every word longer than 3 characters:
In der Informatik ist ein Regulrer Ausdruck (engl. regular expression, Abk. RegExp oder Regex) eine Zeichenkette, die der Beschreibung von Mengen beziehungsweise Untermengen von Zeichenketten mit Hilfe bestimmter syntaktischer Regeln dient. Regulre Ausdrcke finden vor allem in der Softwareentwicklung Verwendung; fr fast alle Programmiersprachen existieren Implementierungen.
Regulre Ausdrcke stellen erstens eine Art Filterkriterium fr Texte dar, indem der jeweilige regulre Ausdruck in Form eines Musters mit dem Text abgeglichen wird. So ist es beispielsweise mglich, alle Wrter, die mit S beginnen und mit D enden, zu matchen (von englisch to match  auf etwas passen, bereinstimmen, eine bereinstimmung finden), ohne die zwischenliegenden Buchstaben explizit vorgeben zu mssen.
Ein weiteres Beispiel fr den Einsatz als Filter ist die Mglichkeit, komplizierte Textersetzungen durchzufhren, indem man die zu suchenden Zeichenketten durch regulre Ausdrcke beschreibt.
Zweitens lassen sich aus regulren Ausdrcken, als eine Art Schablone, auch Mengen von Wrtern erzeugen, ohne jedes Wort einzeln angeben zu mssen. So lsst sich beispielsweise ein Ausdruck angeben, der alle denkbaren Zeichenkombinationen (Wrter) erzeugt, die mit S beginnen und mit D enden. 

LOGIC:
- start capture
- match every letter char repeated 4 or more times
- end capture and match it one or more times
*/

//Set the case insensitive mode and the Unicode mode,
//beacause in this text there are letters that are not only a-z but also ,
$regexp=new regexpBuilder(CASE_INSENSITIVE.UNICODE_MODE);

$regexp->capture()	//Start a capture
->matchOneOfTheseChars(UNICODE_LETTER_CHAR)->frequency(MORE_THEN_OR_EQUAL_TO,4)	//match every letter char repeated 4 or more times
->closeCapture();	//end capture

$match=$regexp->execOn("In der Informatik ist ein Regulrer Ausdruck (engl. regular expression, Abk. RegExp oder Regex) eine Zeichenkette, die der Beschreibung von Mengen beziehungsweise Untermengen von Zeichenketten mit Hilfe bestimmter syntaktischer Regeln dient. Regulre Ausdrcke finden vor allem in der Softwareentwicklung Verwendung; fr fast alle Programmiersprachen existieren Implementierungen. Regulre Ausdrcke stellen erstens eine Art Filterkriterium fr Texte dar, indem der jeweilige regulre Ausdruck in Form eines Musters mit dem Text abgeglichen wird. So ist es beispielsweise mglich, alle Wrter, die mit S beginnen und mit D enden, zu matchen (von englisch to match  auf etwas passen, bereinstimmen, eine bereinstimmung finden), ohne die zwischenliegenden Buchstaben explizit vorgeben zu mssen. Ein weiteres Beispiel fr den Einsatz als Filter ist die Mglichkeit, komplizierte Textersetzungen durchzufhren, indem man die zu suchenden Zeichenketten durch regulre Ausdrcke beschreibt.Zweitens lassen sich aus regulren Ausdrcken, als eine Art Schablone, auch Mengen von Wrtern erzeugen, ohne jedes Wort einzeln angeben zu mssen. So lsst sich beispielsweise ein Ausdruck angeben, der alle denkbaren Zeichenkombinationen (Wrter) erzeugt, die mit S beginnen und mit D enden.");
foreach($match[1] as $result)
	echo $result."<br>";
?>