<?php
require_once "../regexpBuilder.php";
/*
Replace every word with more than 10 letters followed by a space with the character "":
Et regulrt uttrykk brukes innen programmering og er en streng som beskriver et sett av strenger  et mnster  i forhold til 
gitte syntaksregler. Regulre uttrykk brukes i mange tekstbehandlere og verkty for  ske etter og manipulere tekst basert 
p gitte mnstre. I tillegg er det en rekke programmeringssprk som sttter regulre uttrykk; Perl er kanskje det mest kjente 
sprket i s henseende.

LOGIC:
- match every letter char repeated 10 or more times followed by a space character
- replace with "" with a function
*/

//Set the case insensitive mode and the Unicode mode
$regexp=new regexpBuilder(CASE_INSENSITIVE.UNICODE_MODE);

$regexp->capture()
->matchOneOfTheseChars(UNICODE_LETTER_CHAR)->frequency(MORE_THEN,10)  //match every letter char repeated 1,2 or 3 times
->closeCapture()
->ifItIs(FOLLOWED_BY)->match(GENERAL_SPACE_CHAR)->closeIf();  //followed by a space character

$callback=create_function('$match','return "";');
$result=$regexp->replaceWithCallback($callback,"Et regulrt uttrykk brukes innen programmering og er en streng som beskriver et sett av strenger  et mnster  i forhold til gitte syntaksregler. Regulre uttrykk brukes i mange tekstbehandlere og verkty for  ske etter og manipulere tekst basert p gitte mnstre. I tillegg er det en rekke programmeringssprk som sttter regulre uttrykk; Perl er kanskje det mest kjente sprket i s henseende.");
echo $result;
?>