<?php

  //require EmbeVi Class
  require_once('embevi.class.php');
  
  
  /**
   * SET default settings
   * 
   * $myString is the place where you will put your text to be verified and parsed
   * 
   * $_POST['text'] test his value if can be embedded
   *          this is very helpful if you want to test quickly if EmbeVi can embed your link without changing the code  
   */
  
  //text to be parsed for code embedding
  $myString = 'This is a simple test with text and links http://www.vsocial.com/ups/9c7cb729c4d977caad9bc5a86505618a and another link to video http://u-tube.ru/pages/video/26455/';
  
  if(isset($_POST['text'])){
    $myString = $_POST['text'];
  }
  
?>
<br/>
input in the field below some text with links for testing<br/>
<form method="POST">
  <textarea name="text" rows="2" cols="70"></textarea><br/>
  <input type="submit" value="Test now" />
</form>
<br/><br/>
<hr/>
Testing with text:
<br/>
<b><?php echo nl2br($myString);?></b>
<hr/>
<br/><br/>
<?php
  
  //instantiate EmbeVi class
  $embevi = new EmbeVi();
  
  //set this width to all embedded codes
  $embevi->setGlobalWidth(400);
  //set this height to all embedded codes
  $embevi->setGlobalHeight(350);
  //unset with value, now the video will have his default width
  $embevi->unsetGlobalWidth();
  //unset with value, now the video will have his default height
  $embevi->unsetGlobalHeight();
  //set HTML to appear before the embedded code (optional)
  //$embevi->setBeforeHtml('<div class="beforeEmbed"></div><br/>');
  //set HTML to appear after the embedded code (optional)
  //$embevi->setAfterHtml('<div class="afterEmbed"></div><br/>');
  
  /*
   * parse $myString with options:
   * - keep embedded links;
   * - add HTML code before the embedded code
   * - add HTML code after the embedded code
   */
  //echo $embevi->parseText($myString, 1, 1, 1);
  
  /*
   * parse $myString with default options:
   * - don't keep embedded links;
   * - doesn't add HTML code before the embedded code
   * - doesn't add HTML code after the embedded code
   */
  //echo $embevi->parseText($myString);
  
  /*
   * parse $myString with options:
   * - don't keep embedded links;
   * - add HTML code before the embedded code
   * - doesn't add HTML code after the embedded code
   */
  $embevi->setBeforeHtml('<div style="background:#D70000;width:200px;height:5px;"></div><br/>');
  echo $embevi->parseText($myString, false, true, false);
  
?>