<?php

	// This file uses most of the functions of QuickDB MySQL wrapper.
	// It is very easy to use these funtions (methods), see below examples.
	// Once you know how to use this, i bet you are gonna use it in future as well :)

	require_once "quickdb.class.php";
	// Argumentd are: host, user, password, database, persistent connection, show errors on screen
	$db = new QuickDB("localhost", "root", "", "test", false, true);
	

	## execute Method/Function
	// it can run any query whether select, insert, update or delete like mysql_query function
	
	// returns:
	// 1) resource identifier for "Select query" that can later be used with mysql_fetch_array or mysql_fetch_object
	// 2) number of rows affected for "insert, update or delete" queries		

																											// Usage Of:
																											// --------------------------

	$result = $db->execute("select * from quickdbtest order by catname");									// $db->execute
	// Or
	// 		$result = $db->select("quickdbtest");															// $db->select
				
	while ($row = mysql_fetch_array($result))
	{
		print $row["catname"] . "<br />";
	}

	print "<br />Number of rows selected from previous query : " . $db->count_select();						// $db->count_select()

	$affected = $db->execute("insert into quickdbtest set catname = 'New Category'");
	// Or
	//		$affected = $db->insert("quickdbtest", "catname = 'New Category'");								// $db->insert

	print "<br />Number of rows affected are: $affected";
	// Or
	print "<br />Number of rows affected using class method: " . $db->count_affected();						// $db->count_affected()
	$db->success_msg("Record was added successfully !!");

	$affected = $db->update("quickdbtest", "catname = 'New Category 2'", "catname = 'New Category'");		// $db->update
	print "<br />Number of rows affected are: $affected";
	
	$db->delete("quickdbtest", "catid = " . $db->last_insert_id());											// $db->last_insert_id(), $db->delete
	print "<br />Number of rows affected using class method: " . $db->count_affected();
	
	print "<br />Total records in table are: " . $db->count_all("quickdbtest");								// $db->count_all
	
	print "<br />Counting records using 'count_rows' : " . $db->count_rows("select * from quickdbtest");	// $db->count_rows
	
	// $db->insert_update will update if row exists, or insert data if it doesn't with catid=5
	$affected = $db->insert_update("quickdbtest", "catname='Test Category'", "catid=5");					// $db->insert_update
	print "<br />Number of rows affected are: $affected<br />";
	
	$result = $db->select_limited("quickdbtest", 4, 1);														// $db->select_limited

	while ($row = mysql_fetch_array($result))
	{
		print $row["catname"] . "<br />";
	}

	
	if ($db->has_rows("quickdbtest"))																		// $db->has_rows
	{
		print "This table is not empty, it has rows in it !!";
	}
	else
	{
		print "Oops, the table is empty !!!";
	}


	if ($db->row_exists("select * from quickdbtest where catid = 5"))										// $db->row_exists
	{
		print "<br />Yes, row exists";
	}
	else
	{
		print "<br />No, row does not exist";
	}

	// fetch a single row from db
	$row = $db->fetch_row("select * from quickdbtest where catid = 1");										// $db->fetch_row
	print "<br />The fetched values are: " . $row->catid . " " . $row->catname ;

	// fetch a single row from db
	$catname = $db->fetch_value("quickdbtest", "catname", "catid = 3");										// $db->fetch_value
	print "<br />The fetched value is: " . $catname;
	
	print "<br /> The date today is: " . $db->get_date();													// $db->get_date()
	print "<br /> The current time is: " . $db->get_time();													// $db->get_time()
	
	// $db->last_query() gives the last run query, may be useful for debugging queries
	print "<br /> The last run query was: <strong>" . $db->last_query()  . "</strong><br /><br />";

	// using very useful $db->load_data()
	$db->select("quickdbtest");																				// $db->select
	$data = $db->load_array();																				// $db->load_array()
	print_r($data);
	/////////////////////////
	
	// using another very useful function that convert db table to a html table
	$db->get_html("select * from quickdbtest order by catname" , true, 'width = 50%, align="center"');		// $db->get_html
	
	print "<br /><strong>Database Tables</strong><br />";
	$db->list_tables();																						// $db->list_tables()

	print "<br /><strong>Table Information</strong><br />";
	$db->table_info("quickdbtest");																			// $db->table_info
	
	
	$db->success_msg("Wow, this is cool class !!");															// $db->success_msg
	
	// just a wrong table to get that error
	$db->count_rows("select * from NO_TABLE");
	$db->display_errors();																					// $db->display_errros()
	
	$db->failure_msg("Oops, i must have received the error !!");											// $db->failure_msg
	
	$db->alert_msg("This is general alert message !!");														// $db->alert_msg
	





	print "<br /><br /><br />" . $db->success_msg("<STRONG>REQUEST:</STRONG> IF YOU LIKE THIS THEN PLEASE GO AHEAD AND <a href='http://www.phpclasses.org/browse/package/5318.html'>RATE</a> THIS AT PHPCLASSES.ORG, THANKS :)") . "<br /><br />";



?>
