<?php

/**
 * @author Can Ince <chesssoft@gmail.com>
 * @copyright copyright @ 2007 by Can Ince.
 * @license http://www.gnu.org/licenses/gpl.html
 * @version 0.0.2
 * @package Adminiature
 */

require_once "config.php";
class impex extends mysqli
{
	/**
	 * @param string $dbHost
	 * @param string $dbUser
	 * @param string $dbPassword
	 * @param string $sqlFile
	 */
    private $dbHost=__HOST__, $dbUser=__USER__, $dbPassword=__DB_PASSWORD__,$sqlFile,$dbName;
     
     /**
     * @access public
     * @param string $dbName database name
     */

    public function __construct($dbName) {
        @parent::__construct($this->dbHost, $this->dbUser, $this->dbPassword, $dbName);

        if (mysqli_connect_errno())
        {
            die(sprintf("Can't connect to database. Error: %s", mysqli_connect_error()));
        }
	$this->dbName=$dbName;
    }

     /**
     * MySQL dump
     *
     * @access public
     * @param string $tableName  name of the table to be dumped.
     * @param string $ifNotExists  adds "if not exists" when set to 1.
     * @param string $dropTable  adds "drop table" when set to 1.
     */

    public function exportTable($tableName,$ifNotExists=0,$dropTable=0,$verbose=0,$fileName="") {
	if($verbose==2) {
	$handle=fopen($fileName,"w");
	}
	$query=$this->query("SHOW CREATE TABLE $tableName");
	if($query) {
	$fetch=$query->fetch_row(); 
	}
	if($ifNotExists==1) {
		$fetch[1]=str_replace("CREATE TABLE ","CREATE TABLE IF NOT EXISTS ",$fetch[1]);
		}
	if($dropTable==1) {
		$fetch[1]="DROP TABLE IF EXISTS `$tableName`\n CREATE TABLE $tableName\n".$fetch[1];
		}
	$queryFinal=$fetch[1].";\n\n";
	if($verbose==1) {
		echo $queryFinal;
		}
	elseif($verbose==2) {
		fputs($handle, $queryFinal);
		}
	$query2=$this->query("select * from $tableName");
	if($query2) {
	while($fetch2=$query2->fetch_row()) {
	$cont='';
	foreach($fetch2 as $key=>$val) {
		$cont.="'".$val."', ";
		}
	$cont=substr($cont,0,-2);
	$subQ="INSERT INTO `$tableName` VALUES ($cont);\n";
	if($verbose==1) {
		echo $queryFinal;
		}
	elseif($verbose==2) {
		fputs($handle, $subQ);
		}
	else {
		$queryFinal.=$subQ;
		}
	}
	}
	if($verbose==0) {
	return $queryFinal;
	}
	elseif($verbose==2) {
	fclose($handle);
	}
   }



     /**
     * Dump entire database
     * @access public
     * @param string $ifNotExists  adds "if not exists" when set to 1.
     * @param string $dropTable  adds "drop table" when set to 1.
     */

   public function exportDb($ifNotExists=0,$dropTable=0,$compress=0,$uniqueTable="") {
	//DEBUG $control=0;
	if($uniqueTable=="") $fileExt=""; else $fileExt="-$uniqueTable";
	$this->set_charset("utf8");
	if($compress==1) {
	$file="backup/".$this->dbName.$fileExt.time().".sql.gz";
	$gz=gzopen($file,"w");
	} else {
	$file="backup/".$this->dbName.$fileExt.time().".sql";
	$gz=fopen($file,"w");
	}
	if($uniqueTable==""){$like="";} else {$like="like '$uniqueTable'";}
	$query=$this->query("SHOW TABLES $like");
	while($fetch=$query->fetch_array()) {
	$table=$fetch[0];
	$query3=$this->query("SHOW CREATE TABLE $table");
	$fetch3=$query3->fetch_row(); 
	if($ifNotExists==1) {
		$fetch3[1]=str_replace("CREATE TABLE ","CREATE TABLE IF NOT EXISTS ",$fetch3[1]);
		}
	if($dropTable==1) {
		$fetch3[1]="DROP TABLE IF EXISTS `$table`;\n".$fetch3[1];
		}
	$queryFinal=$fetch3[1].";\n\n";
	
		if($compress==1) {
			gzwrite($gz, $queryFinal);
			} else {
			fwrite($gz,$queryFinal);
			}
		//
		$query2=$this->query("select * from $table");
		while($fetch2=$query2->fetch_row()) {
			$cont='';
			foreach($fetch2 as $key=>$val) {
				$val=$this->escape_string($val);
				$cont.="'".$val."', ";
			}
			$cont=substr($cont,0,-2);
			$cont=str_replace("\n","%0A",$cont);
			//DEBUG echo $control++;if($control>=10)exit;
			$subQ="INSERT INTO `$table` VALUES ($cont);\n";
			if($compress==1) {
			gzwrite($gz, $subQ);
			} else {
			fwrite($gz,$subQ);
			}
		}
	}
	if($compress==1) {
		gzclose($gz);
		} else {
		fclose($gz);
		}
	return $file;
   }

   public function showDb($structure=1,$data=1,$dropTable,$ifNotExists,$uniqueTable="") {

	//DEBUG $control=0;
	$this->set_charset("utf8");
	
	if($uniqueTable=="") {$like="";} else {$like="like '$uniqueTable'";}
	$query=$this->query("SHOW TABLES $like");
	while($fetch=$query->fetch_array()) {
	$table=$fetch[0];
	if($structure==1) {
	$query3=$this->query("SHOW CREATE TABLE $table");
	$fetch3=$query3->fetch_row(); 
	if($ifNotExists==1) {
		$fetch3[1]=str_replace("CREATE TABLE ","CREATE TABLE IF NOT EXISTS ",$fetch3[1]);
		}
	if($dropTable==1) {
		$fetch3[1]="DROP TABLE IF EXISTS `$table`;\n".$fetch3[1];
		}
	$queryFinal=$fetch3[1].";\n\n";
	$queryFinal=$this->convertCharsetText($queryFinal);
		$result.=$queryFinal;
	}
		if($data==1) {
		$query2=$this->query("select * from $table");
		while($fetch2=$query2->fetch_row()) {
			$cont='';
			foreach($fetch2 as $key=>$val) {
				$val=$this->escape_string($val);
				$cont.="'".$val."', ";
			}
			$cont=substr($cont,0,-2);
			$cont=str_replace("\n","%0A",$cont);
			//DEBUG echo $control++;if($control>=10)exit;
			$subQ="INSERT INTO `$table` VALUES ($cont);\n";
			$result.=$subQ;
			}

		}
	}
	
	return $result;
   
}
     /**
     * Restore a table or the entire database.
     * @access public
     * @param string $fileName  name of the sql file.
     */


    public function importSql($fileName) {
		$this->importSqlStructures($fileName);
		$this->importSqlData($fileName);
	}

     /**
     * Restore sql data.
     * @access public
     * @param string $fileName  name of the sql file.
     * @param string $verbose  : 1 prints the output.
     */

    public function importSqlData($fileName,$verbose=0) {
	$buffer="";$subs="";$rest="";
	$this->set_charset("utf8");
	//DEBUG: $count=0; $start=time();
	if(strstr($fileName,".gz")) {
		$handle=gzopen($fileName,"r");
		} else {
		$handle=fopen($fileName,"r");
		}
	while(!feof($handle)) {
	if(strstr($fileName,".gz")) {
		$buffer.=gzread($handle,3600);
		} else {
		$buffer.=fread($handle,3600);
		}
	while($subs=stristr($buffer,"INSERT INTO")) {
	$buffer=$subs;
	if($rest=strstr($buffer,"\n")) {
			$buffer=str_replace($rest,"",$buffer);
			$buffer=str_replace("%0A","\n",$buffer);
			if($verbose==1) {
				echo $buffer."<hr />";
				}
			
		
			$this->query($buffer);
			//DEBUG:  $count++;if($count>=500){echo time()-$start;exit;}
			$buffer=$rest;
				} else {break;}
			}
		}
		if(strstr($fileName,".gz")) {
			gzclose($handle);
			} else {
			fclose($handle);
			}
	}


     /**
     * Restore table structures.
     * @access public
     * @param string $fileName  name of the sql file.
     * @param string $verbose  : 1 prints the output.
     */

    public function importSqlStructures($fileName,$verbose=0) {
	$buffer="";$subs="";$rest="";
	$handle=gzopen($fileName,"r");
	while(!feof($handle)) {
	$buffer.=gzread($handle,960000);
	while($subs=stristr($buffer,"create table")) {
	$buffer=$subs;
	if($rest=strstr($buffer,"\n\n")) {
			$buffer=str_replace($rest,"",$buffer);
			$buffer=$this->convertCharsetText($buffer);
			if($verbose==1) {
				echo $buffer."<br />";
				}
			$this->query($buffer);
			$buffer=$rest;
				} else {break;}
			}
		}
		gzclose($handle);
	}

     /**
     * Change any charset text to "utf8".
     * @access public
     * @param string $str : "show create table" output.
     */

    public function convertCharsetText($str) {
	$begin=stristr($str,"DEFAULT CHARSET=");
	$rest=strstr($begin," ");
	if($rest=="") {
		$rest=strstr($begin,";");
		}
	$charset=str_replace("CHARSET=","",$rest);
	$charset=str_replace(";","",$charset);
	$charset=trim($charset);
	$res= str_replace($charset,"utf8",$str);
	return $res;
	}

     /**
     * Export dump to external file
     * @access public
     * @param string $exportFile  name of the output file.
     * @param array $compress [defaults to no] compress the output file using gz.
     */
    public function save($exportFile,$compress=0) {
	if($compress==1) {
		$queryFinal=gzdeflate($queryFinal,9);
		$exportFile.=".gz";
	}
	$handle=fopen($exportFile,"w");
	fputs($handle,$this->sqlFile);
	fclose($handle);
    }

     /**
     * gz compression
     * @access public
     * @param file $infile name of theinput file.
     * @param file $outfile name of the output file.
     * @param int $unlink 1 deletes infile.
     */

    public function compress($infile,$outfile,$unlink=0) {
	$gz = gzopen($outfile,'w9');
	$handle=fopen($infile,"r");
	while (!feof($handle)) {
        	$buffer = fgets($handle, 4096);
		gzwrite($gz, $buffer);
		}
	gzclose($gz);
	fclose($handle);
	if($unlink==1) {
		@unlink($infile);
		}
	}
	
}

?>