<?php

/**
 * @author Can Ince <chesssoft@gmail.com>
 * @copyright copyright @ 2007 by Can Ince.
 * @license http://www.gnu.org/licenses/gpl.html
 * @version 0.0.2
 * @package Adminiature
 */

require_once "config.php";
//require_once "lang/".__DEFAULT_LANG_."/collation.php";
function lang($string,$db="",$table="",$file="",$field="",$removeQ="") {
require "lang/".__DEFAULT_LANG_."/".__DEFAULT_LANG_.".php";
$str = $$string;
if($str=="") $str=$string;
return $str;
}

function getBetween($str,$beginStr,$endStr) {
$begin=strstr($str,$beginStr);
$rest=strstr($begin,$endStr);
$candidate=str_replace($rest,"",$begin);
$result=str_replace($beginStr,"",$candidate);
return $result;
}

function getAttribs($field) {
$total="";
$array=explode(" ",$field);
foreach($array as $key=>$val) {
	if($key!=0) {
		$total.=$val." ";
		}
	}
$total=substr($total,0,-1);
return $total;
}

function getCollations($table) {
global $mysqli;
$final=array();
$query = "show create table `$table`";

if (@$result = $mysqli->query($query)) {

    $finfo = $result->fetch_array();

	$res=$finfo[1];
	$res=strstr($res,"(");
	$resArray=explode(",",$res);
	foreach($resArray as $key=>$item) {
		$field=getBetween($item,'`',' ');
		$field=trim(str_replace(")","",$field));
		$charset=getBetween($item,'collate ','NULL');
		$charset=trim(str_replace("NOT","",$charset));
		if(!$charset)$charset='';
		$final[$field]=$charset;
		}
	return $final;
	}
}

function updateButton($field,$db,$table) {
$nameField=gebiVal('name',$field);
$typeField=gebiVal('type',$field);
$lenvalField=gebiVal('lenval',$field);
$attribsField=gebiVal('attribs',$field);
$nullField=gebiVal('null',$field);
//$keyField=gebiVal('key',$field);
$defaultField=gebiVal('default',$field);
$extraField=gebiVal('extra',$field);
$collation=gebiVal('collation',$field);
$content='<a href="javascript:;" onclick="xajax_saveField(\''.$db.'\',\''.$table.'\','.$nameField.','.$typeField.','.$lenvalField.','
.$attribsField.','.$nullField.','.$defaultField.','.$extraField.','.$collation.')"><img src="images/save.png" alt="save" border="0" title="save" /></a>';
return $content;
}

function tableStatus($db,$table) {
global $mysqli;
$mysqli->select_db($db);
$query=$mysqli->query("show table status from $db like '$table'");
$fetch=$query->fetch_assoc(); 
return $fetch;
}

function actionsOpts($db,$table) {
global $paginationVal;
$content='<a href="javascript:;" title="'.lang("_BROWSE").'" 
onclick="xajax_browse(\''.$db.'\',\''.$table.'\',\'0\',\''.$paginationVal.'\')"><img src="images/browse.png" alt="" border="0" /></a>';
$content.='<a href="javascript:;" title="'.lang("_STRUCTURE_SMALL").'" 
onclick="xajax_showTableFields(\''.$db.'\',\''.$table.'\')"><img src="images/structure.png" alt="" border="0" /></a>';
$content.='<a href="javascript:;" title="'.lang("_INSERT").'" onclick="xajax_insertBox(\''.$db.'\',\''.$table.'\');"><img src="images/add.png" alt="" border="0" /></a>';
$content.='<a href="javascript:;" title="'.lang("_EMPTY_SMALL").'" 
onclick="d=confirm(\''.lang("_REALLY_TRUNCATE_TABLE",'',$table).' ?\');'. 'if(d==true)xajax_truncateTable(\''.$db.'\',\''.$table.'\');"><img src="images/empty.png" alt="" border="0" /></a>';
$content.='<a href="javascript:;" title="'.lang("_DROP_SMALL").'" onclick="d=confirm(\''.lang("_REALLY_DROP_TABLE",'',$table).' ?\');'. 'if(d==true)xajax_dropTable(\''.$db.'\',\''.$table.'\');"><img src="images/drop.png" alt="" border="0" /></a>';
return $content;
}

function insertButton($db,$table) {
$nameField=gebiVal('name','');
$typeField=gebiVal('type','');
$lenvalField=gebiVal('lenval','');
$attribsField=gebiVal('attribs','');
$nullField=gebiVal('null','');
//$keyField=gebiVal('key',$field);
$defaultField=gebiVal('default','');
$extraField=gebiVal('extra','');
$collation=gebiVal('collation','');
$content='<a href="javascript:;" onclick="xajax_insertField(\''.$db.'\',\''.$table.'\','.$nameField.','.$typeField.','.$lenvalField.
','.$attribsField.','.$nullField.','.$defaultField.','.$extraField.','.$collation.')"><img src="images/add.png" alt="save" border="0" title="save" /></a>';
return $content;
}


function createTableCode($db,$table,$numFields) {
$content='var namei = new Array();var typei = new Array();var lenvali = new Array();'.
'var attribsi = new Array();var nulli = new Array();var collationi = new Array();'.
'var defaulti = new Array();var extrai = new Array();';
for ($n=0;$n<=$numFields-1;$n++) {
	$content.="namei[$n]=document.getElementById('name$n').value;";
	$content.="typei[$n]=document.getElementById('type$n').value;";
	$content.="lenvali[$n]=document.getElementById('lenval$n').value;";
	$content.="attribsi[$n]=document.getElementById('attribs$n').value;";
	$content.="nulli[$n]=document.getElementById('null$n').value;";
	$content.="collationi[$n]=document.getElementById('collation$n').value;";
	$content.="defaulti[$n]=document.getElementById('default$n').value;";
	$content.="extrai[$n]=document.getElementById('extra$n').value;";
	}
return $content;
}

function addIndexButton($db,$table) {
$fieldField=gebiVal('fields','');
$indexField=gebiVal('keys','');
$content='<a href="javascript:;" onclick="xajax_insertIndex(\''.$db.'\',\''.$table.'\','.$fieldField.','.$indexField.')"><img src="images/add.png" alt="save" border="0" title="save" /></a>';
return $content;
}

function gebiVal($field,$fieldMain) {
return "document.getElementById('".$field.$fieldMain."').value";
}

function attribOpts($selected="") {
$selected=strtoupper($selected);
$options=array('','UNSIGNED','UNSIGNED ZEROFILL','ON UPDATE CURRENT_TIMESTAMP');
$content='<option selected value="'.$selected.'">'.$selected.'</option>';
foreach($options as $option) {
         if($option!=$selected)
		$content.='<option value="'.$option.'">'.$option.'</option>';
	}
               
return $content;
}

function nullOpts($selected="") {
$selected=strtoupper($selected);
if($selected=="NO")$selected="NOT NULL"; else $selected="NULL";
$options=array('NULL','NOT NULL');
$content='<option selected value="'.$selected.'">'.$selected.'</option>';
foreach($options as $option) {
         if($option!=$selected)
		$content.='<option value="'.$option.'">'.$option.'</option>';
	}
               
return $content;
}

function extraOpts($selected="") {
$options=array('auto_increment','');
$content='<option selected value="'.$selected.'">'.$selected.'</option>';
foreach($options as $option) {
         if($option!=$selected)
		$content.='<option value="'.$option.'">'.$option.'</option>';
	}
               
return $content;
}

function typeOpts($selected="") {
$selected=strtoupper($selected);
$options=array('VARCHAR','INT','TINYINT','SMALLINT','MEDIUMINT','INT','BIGINT','TEXT','DATE','DATETIME'
,'FLOAT','DOUBLE','DECIMAL','TIMESTAMP','TIME','YEAR','CHAR','BLOB','TINYBLOB','MEDIUMBLOB','LONGBLOB'
,'TINYTEXT','MEDIUMTEXT','LONGTEXT','ENUM','SET','BOOL','BINARY','VARBINARY');
$content='<option selected value="'.$selected.'">'.$selected.'</option>';
foreach($options as $option) {
         if($option!=$selected)
		$content.='<option value="'.$option.'">'.$option.'</option>';
	}
               
return $content;
}

function fieldOpts($db,$tableName) {
global $mysqli;
$mysqli->select_db($db);
$query=$mysqli->query("show columns from $tableName");
$content="";
$numrows=$query->num_rows;
if($numrows>=1) {
	while(@$fetch=$query->fetch_row()) {
		$content.='<option value="'.$fetch[0].'">'.$fetch[0].'</option>';
		}
	}
return $content;
}

function fieldsRow($db,$tableName) {
global $mysqli;
$mysqli->select_db($db);
$query=$mysqli->query("show columns from $tableName");
$content="";
$numrows=$query->num_rows;
if($numrows>=1) {
	while(@$fetch=$query->fetch_row()) {
		$content.='<td>'.$fetch[0].'</td>';
		}
	}
return $content;
}

function fieldsArray($db,$tableName) {
global $mysqli;
$res=array();
$mysqli->select_db($db);
$query=$mysqli->query("show columns from $tableName");
$content="";
$numrows=$query->num_rows;
if($numrows>=1) {
	while(@$fetch=$query->fetch_row()) {
		$res[]=$fetch[0];
		}
	}
return $res;
}

function keyOpts($db,$tableName) {
$content='<option value="PRIMARY KEY">PRIMARY</option>';	
$content.='<option value="UNIQUE">UNIQUE</option>';
$content.='<option value="INDEX">INDEX</option>';
$content.='<option value="FULLTEXT">FULLTEXT</option>';
return $content;
}

function getKeys($table) {
global $mysqli;
$final=array();
$query = "show create table `$table`";

if (@$result = $mysqli->query($query)) {

    $finfo = $result->fetch_array();

	$res=$finfo[1];
	$rest=strstr($res,"ENGINE=");
	$res=str_replace($rest,"",$res);
	$res=strstr($res,"(");
	$resArray=explode(",",$res);
	foreach($resArray as $key=>$item) {
		
		if(strstr($item,"PRIMARY KEY")){
		$item=str_replace("`","",$item);
		$item=str_replace("(","",$item);
		$item=str_replace(")","",$item);
		$tempArray=explode(" ",$item);
		if(trim($tempArray[count($tempArray)-1])=='') {
		$final[count($final)]["field"]=$tempArray[count($tempArray)-2];
		} else {
		$final[count($final)]["field"]=$tempArray[count($tempArray)-1];
		}
		$final[count($final)-1]["type"]="PRIMARY";
		
		}
		elseif(strstr($item,"UNIQUE KEY")) {
		$item=str_replace("`","",$item);
		$item=str_replace("(","",$item);
		$item=str_replace(")","",$item);
		$tempArray=explode(" ",$item);
		if($tempArray[count($tempArray)-1]=='') {
		$final[count($final)]["field"]=$tempArray[count($tempArray)-2];
		} else {
		$final[count($final)]["field"]=$tempArray[count($tempArray)-1];
		}
		$final[count($final)-1]["type"]="UNIQUE";
		}
		elseif(strstr($item,"FULLTEXT KEY")) {
		$item=str_replace("`","",$item);
		$item=str_replace("(","",$item);
		$item=str_replace(")","",$item);
		$tempArray=explode(" ",$item);
		$final[count($final)]["field"]=$tempArray[count($tempArray)-3];
		$final[count($final)-1]["type"]="FULLTEXT";
		}

		elseif(strstr($item,"KEY")) {
		$item=str_replace("`","",$item);
		$item=str_replace("(","",$item);
		$item=str_replace(")","",$item);
		$tempArray=explode(" ",$item);
		$final[count($final)]["field"]=$tempArray[count($tempArray)-2];
		$final[count($final)-1]["type"]="INDEX";
		}
		
		}
	return $final;
	}
}

function dbMenu($db) {
$content="<span class=\"dbTableTitle\">".lang("_DB").": <b>$db</b></span><br /><br /><a href=\"javascript:;\" class=\"menuLink\"
onclick=\"xajax_changeDbShowTables('$db');\">".lang("_STRUCTURE")."</a> | ";
$content.="<a href=\"javascript:;\" class=\"menuLink\"
onclick=\"xajax_exportDbBox('$db');\">".lang("_EXPORT")."</a> | ";
$content.="<a href=\"javascript:;\" class=\"menuLink\"
onclick=\"xajax_importBox('$db');\">".lang("_RESTORE_DOWNLOAD")."</a> | ";
$content.="<a href=\"javascript:;\" class=\"warning\"
onclick=\"d=confirm('".lang("_REALLY_DROP_ALL_TABLES")."?');".
"if(d==true)xajax_emptyDb('$db');\">".lang("_EMPTY")."</a> | ";
$content.="<a href=\"javascript:;\" class=\"warning\"
onclick=\"d=confirm('".lang("_REALLY_DROP_DB",$db)." ?');".
"if(d==true)xajax_dropDb('$db');\">".lang("_DROP")."</a>";
return $content;
}

function menu($db,$table) {
global $mysqli,$paginationVal;
$content="<span class=\"dbTableTitle\">".lang("_DB").": <b><a href=\"javascript:;\" class=\"menuLink\"
onclick=\"xajax_changeDbShowTables('$db');\">$db</a></b>
<span class=\"dbTableTitle\"> -> ".lang("_TABLE_BIG").": </span><b><a href=\"javascript:;\" class=\"menuLink\" 
onclick=\"xajax_showTableFields('$db','$table');\" title=\"Table structure\">$table</a></b><br /><br />";
$content.='<a href="javascript:;" class="menuLink" 
onclick="xajax_browse(\''.$db.'\',\''.$table.'\',\'0\',\''.$paginationVal.'\');">'.lang("_BROWSE").'</a> | '.'<a href="javascript:;" class="menuLink" 
onclick="xajax_queryBox(\''.$db.'\',\''.$table.'\');">'.lang("_SQL").'</a> | '.'<a href="javascript:;" class="menuLink"
onclick="xajax_insertBox(\''.$db.'\',\''.$table.'\');">'.lang("_INSERT").'</a> | ';
$content.='<a href="javascript:;" class="menuLink" onclick="xajax_importBox(\''.$db.'\');">'.lang("_RESTORE_DOWNLOAD").'</a> | ';
$content.='<a href="javascript:;" class="menuLink" onclick="xajax_exportTableBox(\''.$db.'\',\''.$table.'\');">'.lang("_EXPORT").'</a> | ';
$content.='<a href="javascript:;" class="warning" 
onclick="d=confirm(\''.lang("_REALLY_TRUNCATE_TABLE",'',$table).' ?\');'. 'if(d==true)xajax_truncateTable(\''.$db.'\',\''.$table.'\');">'.lang("_EMPTY").'</a> | ';
$content.='<a href="javascript:;" class="warning" 
onclick="d=confirm(\''.lang("_REALLY_DROP_TABLE",'',$table).' ?\');'. 'if(d==true)xajax_dropTable(\''.$db.'\',\''.$table.'\');">'.lang("_DROP").'</a>';

$content.="<br /><br />";
return $content;
}

function selectLang($selected) {
$langArray=array();
$langArray["tur"]="Türkçe";
$langArray["eng"]="English";
$content='<form id="langForm" method="post" action="index.php"><select name="lang" id="lang" onchange="this.form.submit();">
<option selected value="'.$selected.'">'.$langArray[$selected].'</option>';
foreach($langArray as $abr=>$lang) {
	if($abr!=$selected) {
	$content.='<option value="'.$abr.'">'.$lang.'</option>';
	}
}
$content.='</select></form>';
return $content;
}

function collationOpts($selected="") {
$res="";
return '<option selected value="'.$selected.'">'.$selected.'</option><option value=""></option>
        <option value="utf8_bin" title="'.lang('_UNICODE').' ('.lang('_MULTILINGUAL').'), '.lang('_BINARY').'">utf8_bin</option>
        <option value="utf8_czech_ci" title="'.lang('_CZECH').', '.lang('_CASE_INSENSITIVE').'">utf8_czech_ci</option>
        <option value="utf8_danish_ci" title="'.lang('_DANISH').', '.lang('_CASE_INSENSITIVE').'">utf8_danish_ci</option>
        <option value="utf8_esperanto_ci" title="'.lang('_ESPERANTO').', '.lang('_CASE_INSENSITIVE').'">utf8_esperanto_ci</option>
        <option value="utf8_estonian_ci" title="'.lang('_ESTONIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_estonian_ci</option>

        <option value="utf8_general_ci" title="'.lang('_UNICODE').' ('.lang('_MULTILINGUAL').'), '.lang('_CASE_INSENSITIVE').'">utf8_general_ci</option>
        <option value="utf8_hungarian_ci" title="'.lang('_HUNGARIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_hungarian_ci</option>
        <option value="utf8_icelandic_ci" title="'.lang('_ICELANDIC').', '.lang('_CASE_INSENSITIVE').'">utf8_icelandic_ci</option>
        <option value="utf8_latvian_ci" title="'.lang('_LATVIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_latvian_ci</option>
        <option value="utf8_lithuanian_ci" title="'.lang('_LITHUANIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_lithuanian_ci</option>
        <option value="utf8_persian_ci" title="'.lang('_PERSIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_persian_ci</option>

        <option value="utf8_polish_ci" title="'.lang('_POLISH').', '.lang('_CASE_INSENSITIVE').'">utf8_polish_ci</option>
        <option value="utf8_roman_ci" title="'.lang('_WEST_EUROPEAN').', '.lang('_CASE_INSENSITIVE').'">utf8_roman_ci</option>
        <option value="utf8_romanian_ci" title="'.lang('_ROMANIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_romanian_ci</option>
        <option value="utf8_slovak_ci" title="'.lang('_SLOVAK').', '.lang('_CASE_INSENSITIVE').'">utf8_slovak_ci</option>
        <option value="utf8_slovenian_ci" title="'.lang('_SLOVENIAN').', '.lang('_CASE_INSENSITIVE').'">utf8_slovenian_ci</option>
        <option value="utf8_spanish2_ci" title="'.lang('_TRADITIONAL_SPANISH').', '.lang('_CASE_INSENSITIVE').'">utf8_spanish2_ci</option>

        <option value="utf8_spanish_ci" title="'.lang('_SPANISH').', '.lang('_CASE_INSENSITIVE').'">utf8_spanish_ci</option>
        <option value="utf8_swedish_ci" title="'.lang('_SWEDISH').', '.lang('_CASE_INSENSITIVE').'case-insensitive">utf8_swedish_ci</option>
        <option value="utf8_turkish_ci" title="'.lang('_TURKISH').', '.lang('_CASE_INSENSITIVE').'" >utf8_turkish_ci</option>
        <option value="utf8_unicode_ci" title="'.lang('_UNICODE').' ('.lang('_MULTILINGUAL').'), '.lang('_CASE_INSENSITIVE').'">utf8_unicode_ci</option>';

}

?>