<?php 
/*
*
*	Writed by Setec Astronomy - setec@freemail.it
*
*	This simple class allows to extract the keywords contained in the 
*	HTTP Referrer header provided by the web browser when a client comes 
*	to your site from a search engine query.	
*
*	This script is distributed  under the GPL License
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* 	GNU General Public License for more details.
*
*	http://www.gnu.org/licenses/gpl.txt
*
*/

class CReferrer 
{
	var $_iniFile;
	var $_iniArray;
	var $_globalFields;	
	
	function CReferrer  ($INIFile = "")
	{
		if (empty ($INIFile))
		{ $this->_iniFile = dirname(__FILE__) . "/engines.ini"; }
		else
		{ $this->_iniFile = $INIFile; }
		
		$this->_iniArray = @parse_ini_file ($this->_iniFile, true);
		if ($this->_iniArray === false)		
		{ 
			print ("<b>CReferrer object creation failed!"); 
			exit;
		}
		
		$this->_globalFields = array ("q", "p", "query", "qwederr", "qs");
	} // function CReferrer  ($INIFile = "")

	function _safe_set (&$var_true, $var_false = "")
	{
		if (!isset ($var_true))
		{ $var_true = $var_false; }
		return $var_true;
	} // function _safe_set (&$var_true, $var_false = "")
	

	function getKeywords ($URL = "")
	{
		if (empty ($URL) || $this->_iniArray === false)
		{ return false; }

		$parse_url = parse_url ($URL);			
		$this->_safe_set ($parse_url["host"], "");
		$parse_url["host"] = strtolower ($parse_url["host"]);
		$this->_safe_set ($parse_url["query"], "");
		parse_str ($parse_url["query"], $parse_query);

		if (!empty ($parse_url["host"]))
		{
			$founded = false;
			foreach ($this->_iniArray as $engine)
			{
				$this->_safe_set ($engine["Host"], "");
				$this->_safe_set ($engine["QueryField"], "");
				$this->_safe_set ($engine["SubQueryField"], "");
				$engine["Host"] = strtolower ($engine["Host"]);
				$host_pos = strpos($parse_url["host"], $engine["Host"]); 
				if ($host_pos !== false) // host referrer match
				{
					$founded = true;
					$result = false;
					if (isset ($parse_query[$engine["QueryField"]]))
					{ $result = urldecode ($parse_query[$engine["QueryField"]]); }
					if (($result !== false) && ($engine["SubQueryField"] !== "")) 
					{
						$parse_suburl = parse_url($result);
						$this->_safe_set ($parse_suburl["query"], "");	
						parse_str ($parse_suburl["query"], $parse_subquery);
						if (isset ($parse_subquery[$engine["SubQueryField"]]))
						{ $result = urldecode($parse_subquery[$engine["SubQueryField"]]); }
					}
					return $result;
				} // if ($host_pos !== false)	 
			} // foreach ($this->_iniArray as $engine)
			
			if (!$founded)
			{
				foreach ($this->_globalFields as $field)
				{
					if (isset ($parse_query[$field]))
					{ return urldecode ($parse_query[$field]); }
				} // foreach ($this->_globalFields as $field)
			} // if (!$founded)
		} // if (isset ($parse_url["host"]))
		return false;
	} // function GetKeywords ($URL = "")
} // class CReferrer 
?>