<?php
/***************************************************************************
 phpTrafficA @soft.ZoneO.net
 Copyright (C) 2004-2007 ZoneO-soft, Butchu (email: "butchu" with the domain "zoneo.net")

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/
/*********************************************************************************/
/* Function: echoOS
/* Role: stats results on operating system
/* Parameters: 
/*   - $table: base name for sql tables
/*   - $site: id of the website
/* Output:
/*   - nothing, but echos whatever it finds
/* Created: 06/2004
/*********************************************************************************/
function echoOS($c,$table, $site,$toplot, $sort) {
  echoMonthly($c,$table,$site,"os",$toplot, $sort);
}

/*********************************************************************************/
/* Function: echoOS
/* Role: stats results on web browsers
/* Parameters: 
/*   - $table: base name for sql tables
/*   - $site: id of the website
/* Output:
/*   - nothing, but echos whatever it finds
/* Created: 06/2004
/*********************************************************************************/
function echoBrowser($c,$table, $site,$toplot, $sort) {
  echoMonthly($c,$table,$site,"browser",$toplot, $sort);
}

/*********************************************************************************/
/* Function: echoOS
/* Role: stats results on operating systems
/* Parameters: 
/*   - $table: base name for sql tables
/*   - $site: id of the website
/* Output:
/*   - nothing, but echos whatever it finds
/* Created: 06/2004
/*********************************************************************************/
function echoCountry($c,$table, $site,$toplot, $sort) {
  echoMonthly($c,$table,$site,"country",$toplot, $sort);
}

/*********************************************************************************/
/* Function: browserImg
/* Role: returns the logo of a browser 
/* Parameters: 
/*   - $c: browser name
/* Output:
/*   - string, with image link to the browser logo
/* Created: 11/2006
/*********************************************************************************/
function browserImg($c, $extratxt = "") {
	$img="Img/noimage.gif";
	$strings = array("msie", "firefox", "gecko", "konqueror", "safari", "ns", "opera", "crawler", "google", "lynx","galeon");
	$images = array("Img/ie.gif", "Img/firefox.gif", "Img/mozilla.gif", "Img/konqueror.gif", "Img/safari.gif", "Img/netscape.gif", "Img/opera.gif", "Img/crawler.gif", "Img/crawler.gif","Img/lynx.gif","Img/galeon.gif");
	for ($cpt = 0; $cpt < 11 ; $cpt++) {
		if (ereg($strings[$cpt],strtolower($c))) $img=$images[$cpt];
	}
	if(is_file($img)) {
		list($width, $height, $type, $attr) = getimagesize($img);
		$width = intval($width*14/$height);
		$string = "<center><img src=\"$img\"  width=\"$width\" height=\"14\" alt=\"$c\" title=\"$c $extratxt\"></center>";
	} else {
		$string = "$c";
	}
	return $string;
}

/*********************************************************************************/
/* Function: browserImgName
/* Role: returns the logo and name of a browser 
/* Parameters: 
/*   - $c: browser name
/* Output:
/*   - string, with image link to the browser logo and its name
/* Created: 05/2005
/*********************************************************************************/
function browserImgName($c) {
	$img="Img/noimage.gif";
	$strings = array("msie", "firefox", "gecko", "konqueror", "safari", "ns", "opera", "crawler", "google", "lynx","galeon");
	$images = array("Img/ie.gif", "Img/firefox.gif", "Img/mozilla.gif", "Img/konqueror.gif", "Img/safari.gif", "Img/netscape.gif", "Img/opera.gif", "Img/crawler.gif", "Img/crawler.gif","Img/lynx.gif","Img/galeon.gif");
	for ($cpt = 0; $cpt < 11 ; $cpt++) {
		if (ereg($strings[$cpt],strtolower($c))) $img=$images[$cpt];
	}
	if(is_file($img)) {
		$string = "<center><img src=\"$img\" alt=\"$c\"></center></td><td>$c";
	} else {
		$string = "</td><td>$c";
	}
	return $string;
}

/*********************************************************************************/
/* Function: osImg
/* Role: returns the logo of an OS
/* Parameters: 
/*   - $c: os name
/* Output:
/*   - string, with image link to the os logo
/* Created: 11/2006
/*********************************************************************************/
function osImg($c, $extratxt = "") {
	$img="Img/noimage.gif";
	$strings = array("win", "linux", "mac", "sun", "bsd", "sgi", "hp", "crawler", "google","palm");
	$images = array("Img/windows.gif", "Img/linux.gif", "Img/osx.gif", "Img/sun.gif", "Img/bsd.gif", "Img/sgi.gif", "Img/hp.gif", "Img/crawler.gif", "Img/crawler.gif","Img/palm.gif"); 
	for ($cpt = 0; $cpt < 10 ; $cpt++) {
		if (ereg($strings[$cpt],strtolower($c))) $img=$images[$cpt];
	}
	if(is_file($img)) {
		list($width, $height, $type, $attr) = getimagesize($img);
		$width = intval($width*14/$height);
		$string = "<center><img src=\"$img\"  height=\"14\" width=\"$width\" alt=\"$c\" title=\"$c $extratxt\"></center>";
	} else {
		$string = "$c";
	}
	return $string;
}

/*********************************************************************************/
/* Function: osImgName
/* Role: returns the logo and name of an OS
/* Parameters: 
/*   - $c: os name
/* Output:
/*   - string, with image link to the os logo and its name
/* Created: 05/2005
/*********************************************************************************/
function osImgName($c) {
	$img="Img/noimage.gif";
	$strings = array("win", "linux", "mac", "sun", "bsd", "sgi", "hp", "crawler", "google","palm");
	$images = array("Img/windows.gif", "Img/linux.gif", "Img/osx.gif", "Img/sun.gif", "Img/bsd.gif", "Img/sgi.gif", "Img/hp.gif", "Img/crawler.gif", "Img/crawler.gif","Img/palm.gif"); 
	for ($cpt = 0; $cpt < 10 ; $cpt++) {
		if (ereg($strings[$cpt],strtolower($c))) $img=$images[$cpt];
	}
	if(is_file($img)) {
		$string = "<center><img src=\"$img\" alt=\"$c\"></center></td><td>$c";
	} else {
		$string = "</td><td>$c";
	}
	return $string;
}

/*********************************************************************************/
/* Function: countryFlag
/* Role: converts the 2 chars string into flag 
/* Parameters: 
/*   - $c: 2 chars country string
/* Output:
/*   - string, with image link to the flag
/* Created: 11/2006
/*********************************************************************************/
function countryFlag($c) {
  global $ip2c;
  global $extFlag;
  global $dirFlags;
  $ty=strtolower($c);
  $ty=str_replace("\n","",$ty);
  $rz = countryName($ty);
  $img="$dirFlags/$ty.$extFlag";
  if(is_file($img)) {
	list($width, $height, $type, $attr) = getimagesize($img);
	$width = intval($width*12/$height);
    $string = "<center><img src=\"$img\" height=\"12\" width=\"$width\" alt=\"$rz\" title=\"$rz\"></center>";
  } else {
    $string = "$rz";
  }
  return $string;
}

/*********************************************************************************/
/* Function: countryNameFlag
/* Role: converts the 2 chars string into full country name 
/*    and flag 
/* Parameters: 
/*   - $c: 2 chars country string
/* Output:
/*   - string, with image link to the flag and full country name
/* Source: ip2c, http://hot-things.net
/* Created: 06/2004
/* Changed 05/2005 (added </td><td> between the image and the country name)
/*********************************************************************************/
function countryNameFlag($c) {
  global $ip2c;
  global $extFlag;
  global $dirFlags;
  $ty=strtolower($c);
  $ty=str_replace("\n","",$ty);
  $rz = countryName($ty);
  $img="$dirFlags/$ty.$extFlag";
  if(is_file($img)) {	
		list($width, $height, $type, $attr) = getimagesize($img);
		$string = "<center><img src=\"$img\" alt=\"$rz\" class=\"flag\" $attr></center></td><td>$rz";
  } else {
    $string = "</td><td>$rz";
  }
  return $string;
}

/*********************************************************************************/
/* Function: plotHistory
/* Role: returns a string with a link to a plot with the evolution of the mosy 
/*    popular qty with time 
/* Parameters: 
/*   - $c: connection to the database
/*   - $table: base name for sql tables
/*   - $what: can be "os", "browser", "country"
/* Output:
/*   - a link to the plot
/* Created: 09/2005
/*********************************************************************************/
function plotHistory($c,$table, $what) {
global $strings;
global $tmpdirectory;
// We get the nplot most common qties (country, OS, browser out of the db, 
// then plot the history for them
$nplot = 8;
// Getting the qties to plot, the most common ones in the last 6 months
$limitmonth = date("Y-m-01", time()-86400*6*30);
$req = "SELECT label,SUM(count) as count FROM ${table}_$what WHERE date>'$limitmonth' GROUP BY label ORDER BY count DESC LIMIT 0,$nplot;";
$res = mysql_query($req,$c);
$qty = array();
$count = array();
while($row = mysql_fetch_object($res)) {
	$qty[] = $row->label;
	$count[] = $row->count;
}
// Get the monthly data (total)
// Pull number of counts for each month
$req = "SELECT date,SUM(count) as count FROM ${table}_$what GROUP BY date;";
$res = mysql_query($req,$c);
$nMonth = 0;
$date = array();
$total = array();
while($row = mysql_fetch_object($res)) {
	$date[$nMonth] = $row->date;
	$total[$nMonth] = $row->count;
	$nMonth += 1;
}
// For each of the qty to plot, get the monthly data
$datecount = array();
for ($j=0;$j<$nplot;$j++) {
	$req = "SELECT date,count FROM ${table}_$what WHERE label='$qty[$j]';";
	$res = mysql_query($req,$c);
	while($row = mysql_fetch_object($res)) {
		$i = array_search($row->date, $date); 
		$datecount[$i][$j] = $row->count;
	}
}
// Plot the history
$start = 100000000000;
$end = 0;
$maxcount = 0;
$string = "<?php  \n\$date_data = array(";
$max = count ($qty);
for ($i=0;$i<$nMonth;$i++) {
	$time = strtotime($date[$i]);
	if ($time<$start) {$start=$time;}
	if ($time>$end) {$end=$time;}
	if ($i>0) {
		$string .= "\n,array(\"\",$time";
	} else {
		$string .= "\narray(\"\",$time";
	}
	$other = 100.;
	for ($j=0;$j<$max;$j++) {
		if ($datecount[$i][$j] == "") $datecount[$i][$j] = 0;
		$tt = intval(1000.*$datecount[$i][$j]/$total[$i])/10;
		if ($tt == "") $tt = 0;
		$other -= $tt;
		if ($tt>$maxcount) {$maxcount = $tt;}
		$string .= ",$tt";
	}
	if ($other>$maxcount) {$maxcount=$tt;}
	$string .= ",$other)";
}
$legende = "\"$qty[0]\"";
for ($j=0;$j<$max;$j++) {
	if ($what == "country") {
		$txt = shorten(translitarate(countryName($qty[$j])),12);
	} else {
			$txt = $qty[$j];
	}
	if ($j==0) {
		$legende = "\"$txt\"";
	} else {
		$legende .= ",\"$txt\"";
	}
}
$legende .= ",\"".translitarate($strings['Other'])."\"";
$string .= "\n);\n\$start=$start;\n\$end=$end;\n\$maxY=$maxcount;\n\$plottype=\"lines\";"; 
$string .= "\n\$legende = array($legende);\n\$width = 600;\n\$height = 300;\n\$ylabel = \"".translitarate($strings['pcoftotal'])."\";\n?>";
if ((($start+2679000) != $end)&&$maxcount>0) {
	$timecall = time();
	$temp = fopen ("$tmpdirectory/tmp.$timecall.txt.php", 'w');
	fwrite($temp, $string);
	fclose($temp);
	return "<img src=\"./plotStat.php?file=tmp.$timecall.txt.php\" alt=\"".$strings['History']."\">"; 
} else {
	return $strings['Nothingyet'];
}
}

/*********************************************************************************/
/* Function: plotThisMonth
/* Role: returns a string with a link to a plot with the plot for this month
/* Parameters: 
/*   - $c: connection to the database
/*   - $table: base name for sql tables
/*   - $what: can be "os", "browser", "country"
/* Output:
/*   - a link to the plot
/* Created: 09/2005
/*********************************************************************************/
function plotThisMonth($c,$table, $what) {
global $strings;
global $tmpdirectory;
$nplot = 6;
$timecall = time();
$thismonth = date("Y-m-01");
// get the most popular QTY
$req = "SELECT label,count FROM ${table}_$what WHERE date='$thismonth' ORDER BY count DESC LIMIT 0,$nplot;";
$res = mysql_query($req,$c);
$thismonthNQty = 0;
$totalthismonth = 0;
while($row = mysql_fetch_object($res)) {
	$thismonthqty[$thismonthNQty] = $row->label;
	$thismonthcount[$thismonthNQty] = $row->count;
	$thismonthNQty += 1;
	$totalthismonth -= $row->count;
}
if ($totalthismonth < 0) {
	$req = "SELECT SUM(count) as count FROM ${table}_$what WHERE date='$thismonth' GROUP BY date;";
	$res = mysql_query($req,$c);
	$row=mysql_fetch_array($res);
	$total=$row['count'];
	$string = "<?php  \n\$date_data = array(";
	$max = min($thismonthNQty,$nplot);
	for ($j=0;$j<$max;$j++) {
		$tt = $thismonthcount[$j];
		if ($what == "country") {
			$txt = shorten(translitarate(countryName($thismonthqty[$j])),12);
		} else {
			$txt = $thismonthqty[$j];
		}
		if ($j>0) {
			$string .= ",$tt";
			$legende .= ",\"$txt\"";
		} else {
			$string .= "array(\"\",$tt";
			$legende = "\"$txt\"";
		}
	}
	$other = $totalthismonth + $total;
	$string .= ",$other)";
	$legende .= ",\"".translitarate($strings['Other'])."\"";
	$string .= "\n);\n\$plottype=\"pie\";\n\$legende = array($legende);\n\$width = 500;\n\$height = 200;\n?>";
	$temp = fopen ("$tmpdirectory/tmp2.$timecall.txt.php", 'w');
	fwrite($temp, $string);
	fclose($temp);
	return "<img src=\"./plotStatPie.php?file=tmp2.$timecall.txt.php\" alt=\"".$strings['Thismonth']."\">";
} 
return "&nbsp;<br>".$strings['Nothingyet']."<br>&nbsp;";
}

/*********************************************************************************/
/* Function: tableHistory
/* Role: returns a string with a table with numbers
/* Parameters: 
/*   - $c: connection to the database
/*   - $table: base name for sql tables
/*   - $sid: site id
/*   - $what: can be "os", "browser", "country"
/*   - $link: link to the page without sorting information
/*   - $sort: can be "thismonth", "lastmonth", or "total"
/*   - $full: true if you want a full list, false for a list limited to the one 
/*      that are more than 1% of the total.
/* Output:
/*   - a link to the plot
/* Created: 09/2005
/* Changed: 11/2006 to add option to change the sort order
/*********************************************************************************/
function tableHistory($c,$table, $sid, $what, $link, $sort,$full=false) {
global $strings;
global $lang;

$txtThisMonth = linksTableUp("$link&amp;sort=thismonth", $strings['Sortby'], $strings['Thismonth']);
$txtLastMonth = linksTableUp("$link&amp;sort=lastmonth", $strings['Sortby'], $strings['Lastmonth']);
$txtTotal = linksTableUp("$link&amp;sort=total", $strings['Sortby'], $strings['Total']);

$string = "<table class=\"stat\">
<tr class=\"title\"><td colspan=\"5\">".$strings['Recentstatistics']."</td></tr>
<tr class=\"caption\"><td colspan=\"2\">&nbsp;</td><td>$txtThisMonth</td><td>$txtLastMonth</td><td>$txtTotal</td></tr>
<tr><td colspan=\"2\">".$strings['Totalnumberofaccess']."</td>";
// Getting the info out of the database, we'll do it in two steps: total numbers, and numbers for this month, last month, and two month ago...
$thismonth = date("Y-m-01");
$lastmonth = date("Y-m-01",strtotime("-1 month"));
$req = "SELECT date, SUM(count) as count FROM ${table}_$what GROUP BY date;";
$total = array();
$bigTotal = 0;
$res = mysql_query($req,$c);
while($row = mysql_fetch_object($res)) {
	$total[$row->date] = $row->count;
	$bigTotal += $row->count;
}

// Extracting data from db, depending on sorting order
if ($sort == "thismonth") {
	if (!$full) {
		$limit = intval($total[$thismonth]/100);
	} else {
		$limit = 0;
	}
	// Number for thismonth, the month before and the two month ago...
	$req = "SELECT date,label,count FROM ${table}_$what WHERE date='$thismonth' OR date='$lastmonth';";
	$res = mysql_query($req,$c);
	$arrayMonthly = array();
	$arraySort = array();
	while($row = mysql_fetch_object($res)) {
		$arrayMonthly[$row->label][$row->date]=$row->count;
		if ($arrayMonthly[$row->label][$thismonth]>$limit) {
			$arraySort[$row->label] = $arrayMonthly[$row->label][$thismonth];
		}
	}
	arsort($arraySort);
	// Total number, grouped by label
	$req = "SELECT label, SUM(count) as bigcount FROM ${table}_$what GROUP BY label ORDER BY bigcount DESC;";
	$res = mysql_query($req,$c);
	$arrayTotal = array();
	while(($row = mysql_fetch_object($res))) {
		if ($arraySort[$row->label]>0) {
			$arrayTotal[$row->label] = $row->bigcount;
		}
	}
} else if ($sort == "lastmonth") {
	if (!$full) {
		$limit = intval($total[$lastmonth]/100);
	} else {
		$limit = 0;
	}
	// Number for thismonth, the month before and the two month ago...
	$req = "SELECT date,label,count FROM ${table}_$what WHERE date='$thismonth' OR date='$lastmonth';";
	$res = mysql_query($req,$c);
	$arrayMonthly = array();
	$arraySort = array();
	while($row = mysql_fetch_object($res)) {
		$arrayMonthly[$row->label][$row->date]=$row->count;
		if ($arrayMonthly[$row->label][$lastmonth]>$limit) {
			$arraySort[$row->label] = $arrayMonthly[$row->label][$lastmonth];
		}
	}
	arsort($arraySort);
	// Total number, grouped by label
	$req = "SELECT label, SUM(count) as bigcount FROM ${table}_$what GROUP BY label ORDER BY bigcount DESC;";
	$res = mysql_query($req,$c);
	$arrayTotal = array();
	while(($row = mysql_fetch_object($res))) {
		if ($arraySort[$row->label]>0) {
			$arrayTotal[$row->label] = $row->bigcount;
		}
	}
} else { // sort on total number
	if (!$full) {
		$limit = intval($bigTotal/100);
	} else {
		$limit = 0;
	}
	// Total number, grouped by label
	$req = "SELECT label, SUM(count) as bigcount FROM ${table}_$what GROUP BY label ORDER BY bigcount DESC;";
	$res = mysql_query($req,$c);
	$arrayTotal = array();
	$arraySort = array();
	while(($row = mysql_fetch_object($res))) {
		if ($row->bigcount > $limit) {
			$arrayTotal[$row->label] = $row->bigcount;
			$arraySort[$row->label] = 1;
		}
	}
	// Number for thismonth, the month before and the two month ago...
	$req = "SELECT date,label,count FROM ${table}_$what WHERE date='$thismonth' OR date='$lastmonth';";
	$res = mysql_query($req,$c);
	$arrayMonthly = array();
	while($row = mysql_fetch_object($res)) {
		if ($arraySort[$row->label]>0) {
			$arrayMonthly[$row->label][$row->date]=$row->count;
		}
	}
}

$toPull[0] = $thismonth;
$toPull[1] = $lastmonth;
$counted[0] = 0;
$counted[1] = 0;
$counted[2] = 0;
$max[$thismonth] = 0;
$max[$lastmonth] = 0;
foreach ($arraySort as $key=>$doit) {
	if ($arrayMonthly[$key][$thismonth] > $max[$thismonth]) $max[$thismonth] = $arrayMonthly[$key][$thismonth];
	if ($arrayMonthly[$key][$lastmonth] > $max[$lastmonth]) $max[$lastmonth] = $arrayMonthly[$key][$lastmonth];
}
if ($total[$thismonth]>0) {
	$max[$thismonth] = 100.*$max[$thismonth]/$total[$thismonth];
} else {
	$max[$thismonth]=0;
}
if ($total[$lastmonth]>0) {
	$max[$lastmonth] = 100.*$max[$lastmonth]/$total[$lastmonth];
} else {
	$max[$lastmonth]=0;
}
for ($i=0;$i<2;$i++) {
	$n = $total[$toPull[$i]];
	if ($n == "") $n = 0;
	$string .= "<td>$n</td>";
}
$string .= "<td>$bigTotal</td></tr>\n";
foreach ($arraySort as $key=>$doit) {
	if ($what == "country") {
		$string .= "\n<tr><td>".countryNameFlag($key)."</td>";
	} else if ($what=="browser") {
		$string .= "\n<tr><td>".browserImgName($key)."</td>";
	} else if ($what=="os") {
		$string .= "\n<tr><td>".osImgName($key)."</td>";
	} else {
		$string .= "\n<tr><td>$key</td>";
	}
	for ($i=0;$i<2;$i++) {
		$n = $arrayMonthly[$key][$toPull[$i]];
		$counted[$i] += $n;
		if ($n == "") $n = 0;
		if ($total[$toPull[$i]] == 0) {$pc = 0.0;} else {$pc = number_format(100*$n/$total[$toPull[$i]],1);}
		$string .= "<td>".bartext($pc, $max[$toPull[$i]], "$n - $pc%")."</td>";
	}
	$n = $arrayTotal[$key];
	$counted[3] += $n;
	$pc = number_format(100*$n/$bigTotal,1);
	$maxtot = 100*max($arrayTotal)/$bigTotal;
	$string .= "<td>".bartext($pc, $maxtot,"$n - $pc%")."</td>";
}
if (!$full) {
	$string .= "\n<tr><td colspan=\"2\">".$strings['Other']."</td>";
	for ($i=0;$i<2;$i++) {
		$n = $total[$toPull[$i]]-$counted[$i];
		if ($total[$toPull[$i]] == 0.0) {$pc = 0.0;} else {$pc = number_format(100*$n/$total[$toPull[$i]],1);}
		$string .= "<td>".bartext($pc, $max[$toPull[$i]],"$n - $pc%")."</td>";
	}
	$n = $bigTotal-$counted[3];
	if ($bigTotal == 0.0) {$pc = 0.0;} else {$pc = number_format(100*$n/$bigTotal,1);}
	$string .= "<td>".bartext($pc, $maxtot,"$n - $pc%")."</td>\n";
	$string .= "<tr><td colspan=\"5\" align=\"center\"><a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=$what&amp;toplot=fulllist&amp;lang=$lang\">".$strings['Fulllist']."</a></td></tr>\n";
}
$string .= "</table>\n";
return $string;
}

/*********************************************************************************/
/* Function: echoMonthly
/* Role: stats results for monthly quantity, such as OS, browser, or country
/* Parameters:
/*   - $c: connection to the database
/*   - $table: base name for sql tables
/*   - $site: id of the website
/*   - $what: can be "os", "browser", "country"
/*   - $toplot: can be "history", "fulllist"
/*   - $sort: sort order for the table
/* Output:
/*   - nothing, but echos whatever it finds
/* Created: 06/2004
/* Split in several subroutines and fully rewritten, 09/2005
/* 11/2006: removed database connection function (moved earlier in the code)
/*********************************************************************************/
function echoMonthly($c,$table, $site, $what, $toplot, $sort) {
global $strings;
global $lang;

if ($toplot == 'history') {
	$title = $strings['History'];
	$plot = plotHistory($c,$table, $what);
	$link = "<a href=\"./index.php?mode=stats&amp;sid=$site&amp;show=$what&amp;toplot=thismonth&amp;lang=$lang\">".$strings['Plotforthismonth']."</a>";
} elseif ($toplot != "fulllist") {
	$title = $strings['Thismonth'];
	$plot = plotThisMonth($c,$table, $what);
	$link = "<a href=\"./index.php?mode=stats&amp;sid=$site&amp;show=$what&amp;toplot=history&amp;lang=$lang\">".$strings['Plothistory']."</a>";
}
if ($toplot != "fulllist") {
	echo "<table class=\"stat\">
<tr class=\"title\"><td>$title</td></tr>
<tr><td align=\"center\">$plot</td></tr>
<tr><td align=\"center\">$link</td></tr>
</table>\n";
	$link = "./index.php?mode=stats&amp;sid=$site&amp;show=$what&amp;toplot=$toplot&amp;lang=$lang";
	echo tableHistory($c, $table, $site, $what, $link, $sort, false);
} else {
	$link = "./index.php?mode=stats&amp;sid=$site&amp;show=$what&amp;toplot=$toplot&amp;lang=$lang";
	echo tableHistory($c, $table, $site, $what, $link, $sort, true);
}
}

?>
