#!/usr/bin/php -q
<?php

list ($scriptname, $memtype, $overflow) = $argv;

if (!preg_match ('#^(assign|target|content|click)$#', $memtype)) {
    print <<<__TEXT__
Usage:

showshm assign|target|content|click [overflowflag]

   overflowflag is either 0 or 1 (defaults to 0)


__TEXT__;
    exit;
}

$overflow = (!$overflow) ? false : true;

$totalbytes = 0;

if ($memtype == 'assign') {
    $shm_key = ($overflow) ? 0x4f415305 : 0x4f415300;

    if (!($smh = @shm_attach($shm_key, 0))) {
        print "error connecting to shm key $shm_key ($php_errormsg)\n";
        exit;
    }

    for ($i = 1; $i <= 1000; $i++) {
        $s_assign = @shm_get_var($smh, $i);
        if (!$s_assign) continue;

        $totalbytes += strlen(serialize($s_assign));
        printf ("%4d    ", $i);
        ksort($s_assign);
        $j = 0;
        while(list($d, $sd_assign) = each($s_assign)) {
            if ($j++ > 0) print "        ";

            print "($d) ";
            print join (',', $sd_assign);
            print "\n";
        }
    }

    
}

if ($memtype == 'target') {
    $shm_key = ($overflow) ? 0x4f415306 : 0x4f415301;

    if (!($smh = @shm_attach($shm_key, 0))) {
        print "error connecting to shm key $shm_key ($php_errormsg)\n";
        exit;
    }

    print "CrID     Tar.     Wt.      Rem.     Clicks\n";  
    print "--------------------------------------------------\n";
    for ($i = 1; $i <= 10000; $i++) {
        $cr_i = @shm_get_var($smh, $i);
        if (!$cr_i) continue;

        $totalbytes += strlen(serialize($cr_i));
        printf ("%4d    %5d    %5d    %5d    %5d\n", $i, $cr_i[0], $cr_i[1], $cr_i[2], $cr_i[3]);
    }
    print "--------------------------------------------------\n";

    list ($imp_caps, $delivery_controls) = @shm_get_var($smh, 0);
    print "Impression Caps:\n";
    print_r($imp_caps);
    print "Delivery Controls:\n";
    print_r($delivery_controls);

}

if ($memtype == 'content') {
    $shm_key = ($overflow) ? 0x4f415307 : 0x4f415302;

    if (!($smh = @shm_attach($shm_key, 0))) {
        print "error connecting to shm key $shm_key ($php_errormsg)\n";
        exit;
    }

    print "CrID  Re.   MIME         An. Alt\n";  
    print "----------------------------------------------------------------------\n";
    for ($i = 1; $i <= 10000; $i++) {
        $cr_i = @shm_get_var($smh, $i);
        if (!$cr_i) continue;

        $totalbytes += strlen(serialize($cr_i));
        printf ("%4d  %1s  %-15s  %1s  %-35s\n", $i, $cr_i[1], substr ($cr_i[2], 0, 15), $cr_i[3], substr ($cr_i[4], 0, 35));
    }
    print "----------------------------------------------------------------------\n";

}

if ($memtype == 'click') {
    $shm_key = ($overflow) ? 0x4f415308 : 0x4f415303;

    if (!($smh = @shm_attach($shm_key, 0))) {
        print "error connecting to shm key $shm_key ($php_errormsg)\n";
        exit;
    }

    print "CrID     Clickthrough\n";
    print "----------------------------------------------------------------------\n";
    for ($i = 1; $i <= 10000; $i++) {
        $cr_i = @shm_get_var($smh, $i);
        if (!$cr_i) continue;

        $totalbytes += strlen(serialize($cr_i));
        printf ("%4d    %-60s\n", $i, substr ($cr_i, 0, 60));
    }
    print "----------------------------------------------------------------------\n";

}

$totalbytes = number_format($totalbytes / 1024, 0);
print "Total bytes used: $totalbytes KB\n";

?>
