#!/usr/bin/perl

use Geo::IP::PurePerl;
#my $gi = Geo::IP->new(GEOIP_STANDARD);
my $gi = Geo::IP::PurePerl->new('GeoIP.dat');

print "reading $ARGV[0] as oasis log file...\n";
open (INFILE, $ARGV[0]);
while (<INFILE>)
{
    chomp;
    ($time, $ip, $id, $event, $section, $creative) = split("\t", $_);

    $country = $gi->country_code_by_addr($ip);

    $countrycount{$country}++;

    if ($event eq 'imp') {
        $impcount{$country}++;
    }
    if ($event eq 'click') {
        $clickcount{$country}++;
    }

    $crcount{$creative}++;
    if ($event eq 'imp') {
        $crimpcount{$creative}++;
    }
    if ($event eq 'click') {
        $crclickcount{$creative}++;
    }
}
close(INFILE);

print "COUNTRIES:\n";
foreach $c (sort {$countrycount{$b} <=> $countrycount{$a}} keys (%countrycount)) {
    print "\t$c\t$impcount{$c}\t$clickcount{$c}\n";
}

print "CREATIVES:\n";
foreach $c (sort {$crcount{$b} <=> $crcount{$a}} keys (%crcount)) {
    print "\t$c\t$crimpcount{$c}\t$crclickcount{$c}\n";
}
