<?php


#### If the call to the script was with an "iid" argument,
#### then use that as the client id instead of the cookie
$instance_id = get_instance_id();
if($instance_id)
{
  $cl_id = $instance_id;
  $remote_address = NULL;
}
else
{
  $cl_id = get_client_id($remote_address);
  $remote_address = get_oasis_env("REMOTE_ADDR");
}


$cr_id = 0;
$OG_error_code = '';
$header_list = array();
$cr_content = '';
$OG_sem_id = 0;

#### don't want any null section ids
if($s == 0) $s = 0;

#### are we getting called by an embedded ad serve or a direct creative link?
if($cr_id = $c)
{
  if ($l)
  {
    if (attach_sem()
     && record_delivery($cr_id, $remote_address, $cl_id, $s, $HTTP_USER_AGENT))
    {
      @sem_release($OG_sem_id);
      retrieve_creative($cr_id);
      deliver_creative();
    }
    else
    {
      deliver_default();
      log_msg(1, $cl_id, $remote_address, $s, $cr_id, 'ierr', $OG_error_code, $HTTP_USER_AGENT);
    }
  }
  else
  {
    retrieve_creative($cr_id);
    deliver_creative();
  }
}
#### otherwise we need to select a creative
else
{
  if (select_creative($s, $w, $h, 1)
     && record_delivery($cr_id, $remote_address, $cl_id, $s, $HTTP_USER_AGENT))
  {
    @sem_release($OG_sem_id);
    retrieve_creative($cr_id);
    record_cookie($cl_id, $remote_address, $s, $w, $h, $cr_id);
    deliver_creative();
  }
  else
  {
    @sem_release($OG_sem_id);
    deliver_default();
    log_msg(1, $cl_id, $remote_address, $s, $cr_id, 'ierr', $OG_error_code, $HTTP_USER_AGENT);
  }
}

[OASIS_COMMON:get_oasis_env]

[OASIS_COMMON:get_client_id]

[OASIS_COMMON:select_creative]

[OASIS_COMMON:record_delivery]

[OASIS_COMMON:get_instance_id]


####---------------------------------------------------------------------------
#### retrieve the content of the specified creative
####---------------------------------------------------------------------------
function retrieve_creative($cr_id)
{
  global $cr_content, $header_list;
  global $OG_error_code;

  $OG_error_code = '';

  #### attach to a shared memory segment
  #### identifier:     O A S 2
  @$smh = shm_attach(0x4f415302, 0); 
  @$creative_info = shm_get_var($smh, $cr_id);
  @shm_detach($smh);

  if(!$creative_info)
  {
    $OG_error_code = "no_cr_content ($php_errormsg)";
    return 0;
  }

  list($content, $redirect, $mime_type, $animated) = $creative_info;

  if($redirect == 'Y')
  {
    mt_srand((double)microtime()*1000000);
    $rand_num = mt_rand();

    $content = preg_replace("#\[(OASIS)?CB\]#", $rand_num, $content);
    $content = preg_replace("#\[OASISTIMESTAMP\]#", time(), $content);
    $content = preg_replace("#\[OASISREFERER\]#",
                              $HTTP_SERVER_VARS['HTTP_REFERER'], $content);

    array_push($header_list, "Location: $content");

    #### these seem to cause the same headaches that they do for locally
    #### served animated banners!
    #header("Pragma: no-cache");
    #header("Cache-Control: no-cache");
  }
  else
  {
    array_push($header_list, "Content-type: $mime_type");
    array_push($header_list,
               "Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 

    #### set some headers to control caching; note that due to browser
    #### wackiness, we can't set these for animated GIFs
    if($animated == 'N')
    {
      array_push($header_list, "Expires: Sat, 13 Jun 1992 00:00:00 GMT");
      array_push($header_list, "Cache-Control: no-store, no-cache, must-revalidate");
      array_push($header_list, "Pragma: no-cache");
    }

    $cr_content = $content;
  }

  return 1;
}


####---------------------------------------------------------------------------
#### print out the headers and the content
####---------------------------------------------------------------------------
function deliver_creative()
{
  global $cr_content, $header_list;

  foreach($header_list as $h) header($h);
  print $cr_content;
}


####---------------------------------------------------------------------------
#### spit out a blank 1x1 GIF
####---------------------------------------------------------------------------
function deliver_default()
{
  header("Content-type: image/gif");
  header("Expires: Sat, 13 Jun 1992 00:00:00 GMT");
  header("Cache-Control: no-store, no-cache, must-revalidate");
  header("Pragma: no-cache");

  $content = sprintf("GIF89a%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
                                      0x01, 0x00,
  0x01, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0xf9, 0x04, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0x00, 0x40, 0x02, 0x02, 0x84,
  0x51, 0x00, 0x3b, 0x00);

  print $content;
}


####---------------------------------------------------------------------------
#### record which creative was delivered to this user so that if he clicks
#### through, we can send him to the right destination
####---------------------------------------------------------------------------
function record_cookie($client, $ra, $sec, $w, $h, $creative)
{
  #print "client: $client<BR>\n";

  $key_end = sprintf("%04x%04x%04x", $sec, $w, $h);

  #### save the creative twice, once with the client ID and once
  #### with the IP address (in case client is not accepting cookies,
  #### we'll have a fallback if he clicks through)
  $bucket_key1 = $client . $key_end;

  #### Only compute the second bucket value if the remote address (IP)
  #### was passed
  if($ra)
  {
    preg_match('#(\d+)\.(\d+)\.(\d+)\.(\d+)#', $ra, $ip);
    $bucket_key2 = sprintf("%02x%02x%02x%02x", $ip[1], $ip[2], $ip[3], $ip[4])
                   . $key_end;
  }

  #### suppress warnings so that if database is temporarily down, we
  #### can at least deliver the creative
  @mysql_pconnect(get_oasis_env('oasis_db_host'),
                  get_oasis_env('oasis_db_user'),
                  get_oasis_env('oasis_db_passwd'));

  @mysql_select_db("oasis");

  #### Only update both records (client id and IP)
  #### if the remote address (IP) was passed
  if($bucket_key2)
    @mysql_query("replace into Delivery values ('$bucket_key1', $creative, NULL), ('$bucket_key2', $creative, NULL)");
  else
    @mysql_query("replace into Delivery values ('$bucket_key1', $creative, NULL)");

}


[OASIS_COMMON:log_msg]

?>
