<?php

require("lib-mgmt.inc");
require("lib-creative.inc");

if($save)
{
  save_section($SectionID);
}
if($delete)
{
  delete_section($SectionID);
  $SectionID = '';
}

print_html_header($OASISmsg['Section_Management']);
print $javascript;

print_header('Sections', '', '');

$section_tree = '';
$filter = array();
build_filter(0, 'SectionID', 'Sections');
if($SectionID)
{
  build_section_tree($SectionID, 1, '');
  $sample_form = build_sample_form($SectionID);

  if($section_tree)
    $section_tree = "<P><STRONG>$OASISmsg[Subsections]</STRONG><BR>$section_tree\n";

  $display_section_form = 1;
}
elseif($PSectionID != '')
{
  $display_section_form = 1;
}
else
{
  print <<<__TEXT__

<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Sections]</STRONG></FONT><BR>
<P>
__TEXT__;

  build_section_tree(0, 0, '');
  print "$section_tree</TD></TR></TABLE>\n";
}

get_section_info($SectionID, $PSectionID);
?>

<?php if($display_section_form): ?>

<FORM METHOD=POST ACTION="section.php">
<INPUT TYPE=hidden NAME=PSectionID VALUE="<?php echo $PSectionID; ?>">
<INPUT TYPE=hidden NAME=SectionID VALUE="<?php echo $SectionID; ?>">
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=1 BORDER=0>

<TR>
<TD><?php echo $OASISmsg[Name]; ?></TD>
<TD>
<INPUT NAME="Name" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['Name']; ?>">
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Report_Name]; ?></TD>
<TD>
<?php if($SectionID): ?>
<INPUT NAME="ReportName" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['ReportName']; ?>">
<?php else: ?>
<INPUT NAME="ReportName" SIZE=32 MAXLENGTH=64 VALUE="<?php echo "$values[PReportName] - "; ?>">
<?php endif; ?>
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Active]; ?></TD>
<TD>
<?php if($values['Active'] == 'Y'): ?>
<INPUT TYPE=checkbox NAME="Active" CHECKED>
<?php else: ?>
<INPUT TYPE=checkbox NAME="Active">
<?php endif; ?>
</TD>
</TR>
<TR>
<TD COLSPAN=2>
<INPUT TYPE=submit NAME=save VALUE="<?php echo $OASISmsg[Save]; ?>">
<?php if(is_deletable($SectionID)): ?>
<INPUT TYPE=submit NAME=delete VALUE="<?php echo $OASISmsg[Delete]; ?>">
<?php endif; ?>
</TD>
</TR>
</TABLE>
</FORM>

<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=1 BORDER=0>
<TR>
<TD COLSPAN=2>
<P>
<?php if($SectionID): ?>
<?php echo $section_tree; ?>
<P>
<A HREF="companion.php?SectionID=<?php echo $SectionID; ?>"><?php echo $OASISmsg['Companion_Sections']; ?></A>
<P>
<A HREF="section.php?PSectionID=<?php echo $SectionID; ?>"><?php echo $OASISmsg[Add_new_subsection]; ?></A>
<?php echo "<P>$sample_form"; ?>
<?php endif; ?>

<?php echo $campaign_list; echo $creative_list; ?>
</TD>
</TR>
</TABLE>


<?php endif; ?>

<?php

print_footer();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function delete_section($SectionID)
{
  global $Name, $PSectionID, $children, $ignoreassignments;
  global $ca_assign, $cr_assign, $subpub_root_assign;
  global $OASISmsg;

  #### go through all sections to build parent->child relationships
  if($result = mysql_query("select SectionID, PSectionID from Sections"))
  {
    while(list($s, $p) = mysql_fetch_row($result))
    {
      $parent[$s] = $p;
      if(!$children[$p]) $children[$p] = array();
      array_push($children[$p], $s);
    }
  }

  #### check to see if anything is assigned
  #### to this section or any subsections and advise the user accordingly
  if(!$ignoreassignments)
  {
    $ca_assign = array();
    $cr_assign = array();
    $subpub_root_assign = array();
    rcheck_section($SectionID);

    if ($subpub_root_assign)
    {
      print $OASISmsg[subpub_del_error];
      print "<P><UL>\n<LI>" . join("\n<LI>", $subpub_root_assign) . "</UL>";
      exit;
    }

    if($ca_assign || $cr_assign)
    {
      print $OASISmsg[section_del_warning];

      if($ca_assign)
        print "<P>$OASISmsg[Campaigns]<UL>\n<LI>" . join("\n<LI>", $ca_assign) . "</UL>";
      if($cr_assign)
        print "<P>$OASISmsg[Creatives]<UL>\n<LI>" . join("\n<LI>", $cr_assign) . "</UL>";

      print <<<__TEXT__
<P>
$OASISmsg[To_proceed_click]
<A HREF="section.php?delete=1&ignoreassignments=1&SectionID=$SectionID">$OASISmsg[here]</A>.
$OASISmsg[Otherwise_click]
<A HREF="section.php?SectionID=$SectionID">$OASISmsg[here]</A>.
__TEXT__;
      exit;
    }
  }

  rdelete_section($SectionID);

  header("Location: section.php?SectionID=0");
  exit;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function rcheck_section($SectionID)
{
  global $children, $ca_assign, $cr_assign, $subpub_root_assign, $OASISmsg;

  if(!$result = mysql_query("select Campaigns.CampaignID, Name from CampaignAssignments natural left join Campaigns where SectionID=$SectionID"))
  {
    print "$OASISmsg[error_ca_ass_section] $SectionID"
          . mysql_error();
    exit;
  }
  while(list($ca_id, $ca_name) = mysql_fetch_row($result))
    array_push($ca_assign, "<A HREF='campaign.php?CampaignID=$ca_id'>$ca_name</A>");

  if(!$result = mysql_query("select Creatives.CreativeID, Name from CreativeAssignments natural left join Creatives where SectionID=$SectionID"))
  {
    print "$OASISmsg[error_cr_ass_section] $SectionID"
          . mysql_error();
    exit;
  }
  while(list($cr_id, $cr_name) = mysql_fetch_row($result))
    array_push($cr_assign, "<A HREF='creative.php?CreativeID=$cr_id'>$cr_name</A>");

  if(!$result = mysql_query("select PublisherID, Name from Publishers where RootSectionID=$SectionID"))
  {
    print "$OASISmsg[error_pub_root_section] $SectionID"
          . mysql_error();
    exit;
  }
  while(list($pub_id, $pub_name) = mysql_fetch_row($result))
    array_push($subpub_root_assign, "<A HREF='publisher.php?PublisherID=$pub_id'>$pub_name</A>");

  if($children[$SectionID])
    while(list(, $c) = each($children[$SectionID])) rcheck_section($c);
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function rdelete_section($SectionID)
{
  global $children;

  mysql_query("delete from CampaignAssignments where SectionID=$SectionID");
  mysql_query("delete from CreativeAssignments where SectionID=$SectionID");
  mysql_query("delete from Sections where SectionID=$SectionID");

  if($children[$SectionID])
  {
    reset($children[$SectionID]);
    while(list(, $c) = each($children[$SectionID])) rdelete_section($c);
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_section($SectionID)
{
  global $Name, $ReportName, $PSectionID, $Active, $OASISmsg;

  $Name       = addslashes($Name);
  $ReportName = addslashes($ReportName);

  $active = ($Active == 'on') ? 'Y' : 'N';
  
  if($SectionID)
  {
    $sql = "update Sections set Name='$Name', ReportName='$ReportName', Active='$active' where SectionID=$SectionID";
  }
  else
  {
    $v = get_table_row_s('Sections', 'SectionID', $PSectionID);
    $sql = "insert into Sections (Name, ReportName, PSectionID, Active, PublisherID) values ('$Name', '$ReportName', $PSectionID, '$active', '$v[PublisherID]')";
  }

  if(mysql_query($sql))
  { 
    header("Location: section.php?SectionID=0");
    exit;
  }

  print "<EM>$OASISmsg[error_save_section]:<BR>\n"
                . mysql_error() . " .<BR>SQL: $sql</EM><BR>\n";
  exit;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_campaign_list($SectionID)
{
  global $OASISmsg;

  $sql = "select Campaigns.CampaignID, Name, StartDate, EndDate, ImpressionsGuaranteed, Type from CampaignAssignments natural left join Campaigns where SectionID=$SectionID order by Type, Name";
  if($result = mysql_query($sql))
  {
    while(list($id, $name, $sd, $ed, $imp, $type) = mysql_fetch_row($result))
    {
      $ca_list .= <<<__TEXT__
<TR>
<TD><A HREF="campaign.php?CampaignID=$id">$name</A></TD>
<TD>$sd</TD>
<TD>$ed</TD>
<TD>$imp</TD>
<TD>$type</TD>
</TR>
__TEXT__;
    }

    if(!$ca_list) return '';

    $ca_list = <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Assigned_Campaigns]</STRONG></FONT><BR>
<TABLE WIDTH="100%" CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Start_Date]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[End_Date]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Assignment_Type]</SPAN></TD>
</TR>
$ca_list
</TABLE>
<FONT SIZE="-1">
$OASISmsg[section_ca_note]
</FONT>
__TEXT__;
  }

  return $ca_list;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_creative_list($SectionID)
{
  global $OASISmsg;

  $sql = "select Creatives.CreativeID, Name, StartDate, EndDate, Type from CreativeAssignments natural left join Creatives where SectionID=$SectionID order by Type, Name";
  #print "$sql<BR>\n";
  if($result = mysql_query($sql))
  {
    while(list($id, $name, $sd, $ed, $type) = mysql_fetch_row($result))
    {
      $cr_list .= <<<__TEXT__
<TR>
<TD><A HREF="creative.php?CreativeID=$id">$name</A></TD>
<TD>$sd</TD>
<TD>$ed</TD>
<TD>$type</TD>
</TR>
__TEXT__;
    }

    if(!$cr_list) return '';

    $cr_list = <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Assigned_Creatives]</STRONG></FONT><BR>
<TABLE WIDTH="100%" CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR CLASS="tablehead">
<TD><SPAN CLASS=tablehead>$OASISmsg[Creative]</SPAN></TD>
<TD><SPAN CLASS=tablehead>$OASISmsg[Start_Date]</SPAN></TD>
<TD><SPAN CLASS=tablehead>$OASISmsg[End_Date]</SPAN></TD>
<TD><SPAN CLASS=tablehead>$OASISmsg[Assignment_Type]</SPAN></TD>
</TR>
$cr_list
</TABLE>
<FONT SIZE="-1">
$OASISmsg[section_cr_note]
</FONT>
__TEXT__;
  }

  return $cr_list;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_section_info($SectionID, $PSectionID)
{
  global $values, $campaign_list, $creative_list;

  $values = array();
  if($SectionID) $values = get_table_row('Sections', 'SectionID', $SectionID);

  if($PSectionID)
  {
    if($result = mysql_query("select ReportName from Sections where SectionID=$PSectionID"))
    {
      list($prn) = mysql_fetch_row($result);
      $values[PReportName] = $prn;
    }
  }
  
  $campaign_list = build_campaign_list($SectionID);
  $creative_list = build_creative_list($SectionID);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_section_tree($root, $depth, $publisher)
{
  global $section_tree;
  global $filter;

  if(!$root) $root = 0;

  #### create a spacer
  for($i = 0; $i < $depth * 5; $i++) { $spacer .= "&nbsp;"; }
  
  if($result = mysql_query("select SectionID, Sections.Name,  Publishers.Name
                           from Sections, Publishers
                           where PSectionID = $root and 
                                 Publishers.PublisherID = Sections.PublisherID
                                 and Publishers.Status = 'Active'
                           order by Sections.Name"))
  {
    while(list($s_id, $s_name, $pub_name) = mysql_fetch_row($result))
    {
      if (in_array($s_id, $filter))
      {
        $section_tree .= <<<__TEXT__
$spacer<A HREF="section.php?SectionID=$s_id">$s_name</A>
__TEXT__;
        if ($publisher != $pub_name)
        {
          $section_tree .= " ($pub_name)";
          $publisher = $pub_name;
        }
        $section_tree .= "<BR>\n";
        build_section_tree($s_id, $depth+1, $pub_name);
      }
      else
        build_section_tree($s_id, $depth, '');
    }
  }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function is_deletable($SectionID)
{
  global $OG_PubID;
  if (! $SectionID) return false;

  $v = get_table_row_s('Publishers', 'RootSectionID', $SectionID);
  if ($v[PublisherID])
    return false;
  else
    return true;
}

?>
