<?php

require("lib-mgmt.inc");

if ($save)
  save_pub($PublisherID);

if ($delete)
{
  delete_pub($PublisherID);
  $PublisherID = '';
}

print_html_header($OASISmsg[Publisher_Management]);
print_header('Admin', '', '');

$pub_tree = '';
if($PublisherID)
{
  build_pub_list($PublisherID, 0);

  if ($pub_tree)
    $pub_tree = "<P><STRONG>$OASISmsg[Subpublishers]</STRONG><BR>$pub_tree\n";
  $v = get_table_row_s('Publishers', 'PublisherID', $PublisherID);
  $status_array = array(
                        'Active'    => $OASISmsg[Active],
                        'Inactive' => $OASISmsg[Suspended]);
  $status_select = build_select($status_array, 'Status', $v[Status], 1, 0, 0);

  ## determine whether this publisher's status can be set
  ## this is true only if it's parent publisher is active
  $parent_v = get_table_row_s('Publishers', 'PublisherID', $v[PPublisherID]);
  $status_select = ($parent_v[Status] == 'Active') ? $status_select : $v[Status];

  $display_pub_form = 1;
}
elseif($PPublisherID != '')
{
  $display_pub_form = 1;
  $section_select = build_section_select();
}
else
{
  $v = get_table_row_s('Users', 'Login', $PHP_AUTH_USER);
  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Publishers]</STRONG></FONT><BR>
<P>
<A HREF="publisher.php?PPublisherID=$v[PublisherID]">$OASISmsg[Add_top_level_publisher]</A><BR>
<P>
__TEXT__;

  build_pub_list($v[PublisherID], 0);
  print "$pub_tree</TD></TR></TABLE>\n";
}

get_pub_info($PublisherID, $PPublisherID);
$values[HostingCharge]   = number_format($values[HostingCharge], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPMCharge]   = number_format($values[CPMCharge], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPMChargePerc]   = number_format($values[CPMChargePerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPCCharge]   = number_format($values[CPCCharge], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPCChargePerc]   = number_format($values[CPCChargePerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[FixedCharge]   = number_format($values[FixedCharge], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[FixedChargePerc]   = number_format($values[FixedChargePerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPM]   = number_format($values[CPM], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPMPerc]   = number_format($values[CPMPerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPC]   = number_format($values[CPC], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[CPCPerc]   = number_format($values[CPCPerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[Fixed]   = number_format($values[Fixed], $OASIScurrdp, $OASISdecpt, $OASIStsep);
$values[FixedPerc]   = number_format($values[FixedPerc], $OASIScurrdp, $OASISdecpt, $OASIStsep);

?>

<?php if($display_pub_form): ?>

<FORM METHOD="POST" ACTION="publisher.php">
<INPUT TYPE="HIDDEN" NAME="PPublisherID" VALUE="<?php echo $PPublisherID; ?>">
<INPUT TYPE="HIDDEN" NAME="PublisherID" VALUE="<?php echo $PublisherID; ?>">

<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=1 BORDER=0>

<TR>
<TD COLSPAN="4"><FONT SIZE="+1"><STRONG><?php echo $OASISmsg[Publisher_Details]; ?></STRONG></FONT></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Name]; ?></TD>
<TD COLSPAN="3">
<INPUT NAME="Name" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['Name']; ?>">
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Street_Address]; ?></TD>
<TD COLSPAN="3">
<TEXTAREA NAME="StreetAddress" WRAP=virtual ROWS=2 COLS=40><?php echo $values['StreetAddress']; ?></TEXTAREA>
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg['City']; ?></TD>
<TD><INPUT NAME="City" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['City']; ?>"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg['State']; ?></TD>
<TD><INPUT NAME="State" SIZE=16 MAXLENGTH=64 VALUE="<?php echo $values['State']; ?>"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg['Postal_Code']; ?></TD>
<TD><INPUT NAME="PostalCode" SIZE=16 MAXLENGTH=64 VALUE="<?php echo $values['PostalCode']; ?>"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg['Country']; ?></TD>
<TD><INPUT NAME="Country" SIZE=16 MAXLENGTH=64 VALUE="<?php echo $values['Country']; ?>"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Contact]; ?></TD>
<TD COLSPAN="3">
<INPUT NAME="ContactName" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['ContactName']; ?>">
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Phone]; ?></TD>
<TD COLSPAN="3">
<INPUT NAME="Phone" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['Phone']; ?>">
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Contact_Email]; ?></TD>
<TD COLSPAN="3">
<INPUT NAME="ContactEmail" SIZE=32 MAXLENGTH=64 VALUE="<?php echo $values['ContactEmail']; ?>">
</TD>
</TR>
<?php if($PublisherID): ?>
<TR>
<TD><?php echo $OASISmsg[Publisher_Status]; ?></TD>
<TD COLSPAN="3">
<?php echo $status_select; ?>
</TD>
</TR>
<?php endif; ?>
<?php if(! $PublisherID): ?>
<TR>
<TD><?php echo "$OASISmsg[Admin] $OASISmsg[Login]";?></TD>
<TD COLSPAN="3">
<INPUT NAME="Login" SIZE=32 MAXLENGTH=64 VALUE="">
</TD>
</TR>
<TR>
<TD><?php echo "$OASISmsg[Admin] $OASISmsg[Password]";?></TD>
<TD COLSPAN="3">
<INPUT TYPE=password NAME="Password" SIZE=16 MAXLENGTH=32 VALUE="">
</TD>
</TR>
<TR>
<TD><?php echo "$OASISmsg[Top_level_section_name]";?></TD>
<TD COLSPAN="3">
<INPUT NAME="SectionName" SIZE=32 MAXLENGTH=64 VALUE="">
</TD>
</TR>
<TR>
<TD><?php echo "$OASISmsg[Parent_Section]";?></TD>
<TD COLSPAN="3">
<?php echo $section_select; ?>
</TD>
</TR>
<?php endif; ?>
<TR>
<TD COLSPAN="4"><HR NOSHADE></TD>
</TR>
<TR>
<TD COLSPAN="4"><STRONG><?php echo $OASISmsg[Hosting_Charges]; ?></STRONG></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Monthly_Charge]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="HostingCharge" SIZE=10 VALUE="<?php echo $values['HostingCharge']; ?>"><?php echo $OASIStcurrsym; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPM]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="CPMCharge" SIZE=10 VALUE="<?php echo $values['CPMCharge']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_CPM]; ?></TD>
<TD><INPUT NAME="CPMChargePerc" SIZE=4 VALUE="<?php echo $values['CPMChargePerc']; ?>"> %</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPC]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="CPCCharge" SIZE=10 VALUE="<?php echo $values['CPCCharge']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_CPC]; ?></TD>
<TD><INPUT NAME="CPCChargePerc" SIZE=4 VALUE="<?php echo $values['CPCChargePerc']; ?>"> %</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Fixed]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="FixedCharge" SIZE=10 VALUE="<?php echo $values['FixedCharge']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_Fixed]; ?></TD>
<TD><INPUT NAME="FixedChargePerc" SIZE=4 VALUE="<?php echo $values['FixedChargePerc']; ?>"> %</TD>
</TR>

<TR><TD><BR></TD></TR>

<TR>
<TD COLSPAN="4"><STRONG><?php echo $OASISmsg[Network_Payments]; ?></STRONG></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPM]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="CPM" SIZE=10 VALUE="<?php echo $values['CPM']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_CPM]; ?></TD>
<TD><INPUT NAME="CPMPerc" SIZE=4 VALUE="<?php echo $values['CPMPerc']; ?>"> %</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPC]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="CPC" SIZE=10 VALUE="<?php echo $values['CPC']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_CPC]; ?></TD>
<TD><INPUT NAME="CPCPerc" SIZE=4 VALUE="<?php echo $values['CPCPerc']; ?>"> %</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Fixed]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?><INPUT NAME="Fixed" SIZE=10 VALUE="<?php echo $values['Fixed']; ?>"><?php echo $OASIStcurrsym; ?></TD>
<TD><?php echo $OASISmsg[or_Percentage_Fixed]; ?></TD>
<TD><INPUT NAME="FixedPerc" SIZE=4 VALUE="<?php echo $values['FixedPerc']; ?>"> %</TD>
</TR>

<TR>
<TD COLSPAN=2>
<INPUT TYPE=submit NAME=save VALUE="<?php echo $OASISmsg[Save]; ?>">
<?php if($PublisherID && $values[Status] == 'Inactive'): ?>
<INPUT TYPE=submit NAME=delete VALUE="<?php echo $OASISmsg[Delete]; ?>">
<?php endif; ?>
</TD>
</TR>
</TABLE>

<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=1 BORDER=0>
<TR>
<TD COLSPAN=2>
<P>
<?php if($PublisherID && $values[Status] == 'Active'): ?>
<?php echo $pub_tree; ?>
<P>
<A HREF="publisher.php?PPublisherID=<?php echo $PublisherID; ?>"><?php echo $OASISmsg[Add_new_subpublisher]; ?></A>
<?php endif; ?>

</TD>
</TR>
</TABLE>


</FORM>
<?php endif; ?>

<?php

print_footer();


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_pub_list($root, $depth)
{
  global $pub_tree;
  global $PHP_AUTH_USER;

  for($i = 0; $i < $depth * 5; $i++) { $spacer .= "&nbsp;"; }

  $sql = "select PublisherID, Name, Status
          from Publishers 
          where PPublisherID=$root 
          order by Name";
  #print "$sql<BR>\n";
  if($result = mysql_query($sql))
  {
    while(list($pub_id, $pub, $status) = mysql_fetch_row($result))
    {
      $pub_tree .= <<<__TEXT__
$spacer<A HREF="publisher.php?PublisherID=$pub_id">$pub</A>
__TEXT__;
      if ($status == 'Inactive')
        $pub_tree .= " <EM>(Inactive)</EM>";
      $pub_tree .= "<BR>\n";
      build_pub_list($pub_id, $depth+1);
    }
  }
}     
      
####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_pub_info($PublisherID, $PPublisherID)
{
  global $values;

  $values = array();
  if($PublisherID) $values = get_table_row('Publishers', 'PublisherID', $PublisherID);
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_pub($PublisherID)
{
  global $Name, $PPublisherID, $ContactName, $Phone, $ContactEmail, $OASISmsg;
  global $HostingCharge, $CPMCharge, $CPMChargePerc, $CPCCharge, 
         $CPCChargePerc, $FixedCharge, $FixedChargePerc,
         $CPM, $CPMPerc, $CPC, $CPCPerc, $Fixed, $FixedPerc;
  global $Login, $Password, $SectionName, $ParentSection, $Status;
  global $StreetAddress, $City, $State, $PostalCode, $Country;
  global $OASISmsg, $OASIStsep;

  $HostingCharge = preg_replace("#[$OASIStsep]#", '', $HostingCharge);
  $CPMCharge = preg_replace("#[$OASIStsep]#", '', $CPMCharge);
  $CPCCharge = preg_replace("#[$OASIStsep]#", '', $CPCCharge);
  $CPM = preg_replace("#[$OASIStsep]#", '', $CPM);
  $CPC = preg_replace("#[$OASIStsep]#", '', $CPC);

  if (!$HostingCharge) $HostingCharge = 0;
  if (!$CPMCharge) $CPMCharge = 0;
  if (!$CPMChargePerc) $CPMChargePerc = 0;
  if (!$CPCCharge) $CPCCharge = 0;
  if (!$CPCChargePerc) $CPCChargePerc = 0;
  if (!$FixedCharge) $FixedCharge = 0;
  if (!$FixedChargePerc) $FixedChargePerc = 0;
  if (!$CPM) $CPM = 0;
  if (!$CPMPerc) $CPMPerc = 0;
  if (!$CPC) $CPC = 0;
  if (!$CPCPerc) $CPCPerc = 0;
  if (!$Fixed) $Fixed = 0;
  if (!$FixedPerc) $FixedPerc = 0;

  if (!$PublisherID && ($Login == '' || $Password == ''))
    $errors .= "$OASISmsg[error_pub_missing_admin]<BR>\n";

  if (!$PublisherID && !$SectionName)
    $errors .= "$OASISmsg[error_missing_section]<BR>\n";

  if (!$PublisherID && !$ParentSection)
    $errors .= "$OASISmsg[error_missing_parent_section]<BR>\n";
  
  if ($errors)
  {
    print_html_header($OASISmsg[Publisher_Management]);
    print_header('Admin', '', '');
    print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$errors
<P>
$OASISmsg[error_edit_items]
</TD></TR></TABLE>
__TEXT__;
    print_footer();
    exit;
  }

  if($PublisherID)  ## this is an update
  {
    $sql = "update Publishers 
            set Name='$Name', StreetAddress='$StreetAddress', City='$City',
                State='$State', PostalCode='$PostalCode', Country='$Country',
                ContactName='$ContactName', Phone='$Phone',
                ContactEmail='$ContactEmail', HostingCharge='$HostingCharge',
                CPMCharge='$CPMCharge', CPMChargePerc='$CPMChargePerc',
                CPCCharge='$CPCCharge', CPCChargePerc='$CPCChargePerc',
                FixedCharge='$FixedCharge', FixedChargePerc='$FixedChargePerc',
                CPM='$CPM', CPMPerc='$CPMPerc', CPC='$CPC', CPCPerc='$CPCPerc',
                Fixed='$Fixed', FixedPerc='$FixedPerc', Status='$Status'
            where PublisherID=$PublisherID";
    if(mysql_query($sql))
    {
      if($Status == 'Inactive')
        rset_status($PublisherID, 'Inactive');
      header("Location: publisher.php?PublisherID=0");
      exit;
    }

    print "<EM>$OASISmsg[error_save_publisher]:<BR>\n"
                . mysql_error() . " .<BR>SQL: $sql</EM><BR>\n";
    exit;
  }
  else  ## this is a new subpublisher
  {
    ## check to see if this user login already exists in db
    $v = get_table_row_s('Users', 'Login', $Login);
    if ($v[Login])
    {
      print_html_header($OASISmsg[Publisher_Management]);
      print_header('Admin', '', '');
      print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$OASISmsg[error_user_already_exists]
</TD></TR></TABLE>
__TEXT__;
      print_footer();
      exit;
    }

    ## create the new root section for this publisher
    $sql = "insert into Sections (PSectionID, Name, ReportName, Active) 
            values ($ParentSection,  '$SectionName', '$SectionName', 'Y')";

    mysql_query($sql);
    $result = mysql_query("select LAST_INSERT_ID()");
    list($secid) = mysql_fetch_row($result);

    $sql = "insert into Publishers 
              (Name, PPublisherID, StreetAddress, City, State,
               PostalCode, Country, ContactName, Phone, ContactEmail,
               HostingCharge, CPMCharge, CPMChargePerc, CPCCharge, 
               CPCChargePerc, FixedCharge, FixedChargePerc,
               CPM, CPMPerc, CPC, CPCPerc, 
               Fixed, FixedPerc, Status, RootSectionID) 
            values ('$Name', $PPublisherID, '$StreetAddress', '$City', '$State',
                    '$PostalCode', '$Country', '$ContactName', '$Phone', 
                    '$ContactEmail', '$HostingCharge', '$CPMCharge', 
                    '$CPMChargePerc', '$CPCCharge', '$CPCChargePerc',
                    '$FixedCharge', '$FixedChargePerc',
                    '$CPM', '$CPMPerc', '$CPC', '$CPCPerc', 
                    '$Fixed', '$FixedPerc',
                    'Active', $secid)";

    if(mysql_query($sql))
    {
      $result = mysql_query("select LAST_INSERT_ID()");
      list($pubid) = mysql_fetch_row($result);

      ## add the admin user for this publisher
      $p = "password('$Password')";
      mysql_query("insert into Users (Login, Password, PublisherID, Campaigns,
                                      Advertisers, Sections, Reports, Admin,
                                      CampaignInsertion, Invoicing, 
                                      LimitedCampaigns) 
                   values ('$Login', $p, $pubid, 'Y', 'Y', 'Y', 'Y', 'Y', 'Y',
                           'Y', 'Y')");

      mysql_query("update Sections set PublisherID=$pubid where SectionID=$secid");
      header("Location: publisher.php?PublisherID=0");
      exit;
    }

    #### copy all per-publisher OASISPrefs from the parent publisher
    $sql = "SELECT PrefKey, PrefValue FROM OASISPrefs WHERE PerPublisher='Y' AND PublisherID=$PPublisherID";
    if ($result = mysql_query($sql)) {
        while (list ($k, $v) = mysql_fetch_row ($result)) {
            $sql = "INSERT INTO OASISPrefs
                          (PrefKey, PrefValue, PerPublisher, PublisherID)
                    VALUES
                          ('$k', '" . addslashes ($v) . "', 'Y', $pubid)";
            mysql_query($sql);
        }
    }

    print "<EM>$OASISmsg[error_save_publisher]:<BR>\n"
                . mysql_error() . " .<BR>SQL: $sql</EM><BR>\n";
    exit;
  }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function delete_pub($PublisherID)
{   
  global $children, $reallydelete;
  global $OASISmsg;
    
  #### go through all sections to build parent->child relationships
  if($result = mysql_query("select PublisherID, PPublisherID from Publishers"))
  {   
    while(list($pub, $pubparent) = mysql_fetch_row($result))
    {
      if(!$children[$pubparent]) $children[$pubparent] = array();
      array_push($children[$pubparent], $pub);
    }
  }

  if(!$reallydelete)
  {
    print_html_header($OASISmsg[Publisher_Management]);
    print_header('Admin', '', '');
    print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$OASISmsg[publisher_del_warning]
$OASISmsg[To_proceed_click]
<A HREF="publisher.php?delete=1&reallydelete=1&PublisherID=$PublisherID">$OASISmsg[here]</A>.
$OASISmsg[Otherwise_click]
<A HREF="publisher.php?PublisherID=$PublisherID">$OASISmsg[here]</A>.
</TD></TR></TABLE>
__TEXT__;
    print_footer();
    exit;
  } 
      
  rdelete_pub($PublisherID);
      
  header("Location: publisher.php?PublisherID=0");
  exit;
}     

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function rdelete_pub($PublisherID)
{
  global $children;

  mysql_query("delete from Users where PublisherID=$PublisherID");
  mysql_query("delete from OASISPrefs where PublisherID=$PublisherID");
  if ($result = mysql_query("select SectionID from Sections where PublisherID=$PublisherID"))
  {
    while(list($sec_id) = mysql_fetch_row($result))
    {
      mysql_query("delete from CampaignAssignments where SectionID=$sec_id");
      mysql_query("delete from CreativeAssignments where SectionID=$sec_id");
      mysql_query("delete from Sections where SectionID=$sec_id");

      ## delete companion assignments as well
      if ($result2 = mysql_query("select  CompanionGroupID from CompanionSections where SectionID=$sec_id"))
      {
        while(list($comgrp_id) = mysql_fetch_row($result2))
        {
          if ($result3 = mysql_query("select  count(*) from CompanionSections where CompanionGroupID=$comgrp_id"))
          {
            list($num_secs) = mysql_fetch_row($result3);
            if ($num_secs == 2)
            {
              mysql_query("delete from CompanionSections where CompanionGroupID=$comgrp_id");
              mysql_query("delete from CompanionGroups where CompanionGroupID=$comgrp_id");
            }
            else
              mysql_query("delete from CompanionSections where SectionID=$sec_id and CompanionGroupID=$comgrp_id");

          }
        }
      }
    }
  }
  mysql_query("delete from Advertisers where PublisherID=$PublisherID");
  mysql_query("delete from Publishers where PublisherID=$PublisherID");

  if($children[$PublisherID])
  {
    reset($children[$PublisherID]);
    while(list(, $c) = each($children[$PublisherID])) rdelete_pub($c);
  }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_section_select()
{
  global $PPublisherID;
  global $sec_hash;
  $sec_hash = array();

  $v = get_table_row('Publishers', 'PublisherID', $PPublisherID);
  build_section_tree($v[RootSectionID], 0, 1);
  return build_select($sec_hash, "ParentSection", 0, 1, 0, 0);
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_section_tree($root, $depth, $firsttime)
{
  global $sec_hash;
  global $PPublisherID;

  if (!$root) $root = 0;

  #### create a spacer
  for($i = 0; $i < $depth * 5; $i++) { $spacer .= "&nbsp;"; }

  if ($firsttime)
     $where = "where SectionID = $root";
  else
     $where = "where PSectionID = $root";
  if ($result = mysql_query("select SectionID, Sections.Name
                             from Sections, Publishers
                             $where and Sections.PublisherID = $PPublisherID
                             order by Name"))
  {
    $xhash = array();
    while(list($s_id, $s_name) = mysql_fetch_row($result))
    {
      $xhash["$s_id"] = $s_name;
    }

    foreach (array_keys ($xhash) as $s_id) {
      $s_name = $xhash["$s_id"];
      $sec_hash["$s_id"] = "$spacer$s_name";
      build_section_tree($s_id, $depth+1, 0);
    }
  }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function rset_status($parent, $status)
{
  if($result = mysql_query("select PublisherID
                            from Publishers
                            where PPublisherID = $parent"))
  {
    while(list($p_id) = mysql_fetch_row($result))
    {
      mysql_query("update Publishers set Status = '$status' where PublisherID=$p_id");
      rset_status($p_id, $status);
    }
  }
}

?>

