<?php


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function campaign_report($CampaignID, $StartDate, $EndDate)
{
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep;

  $report = '';

  if(!($result = mysql_query("select Name from Campaigns where CampaignID=$CampaignID")))
  {
    print "$OASISmsg[error_pulling_campaign]: " . mysql_error();
    return "";
  }
  list($ca_name) = mysql_fetch_row($result);

  if(!($result1 = mysql_query("select CreativeID from Creatives where CampaignID=$CampaignID")))
  {
    print "$OASISmsg[Error_pulling_creatives]: " . mysql_error();
    return "";
  }

  preg_match('#(\d+)-(\d+)-(\d+)#', $StartDate, $matches);
  list ($j, $y, $m, $d) = $matches;
  $pStartDate = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";
  preg_match('#(\d+)-(\d+)-(\d+)#', $EndDate, $matches);
  list ($j, $y, $m, $d) = $matches;
  $pEndDate = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";

  $report .= <<<__TEXT__
<TABLE WIDTH=605><TR><TD>
<FONT SIZE="+1"><STRONG>$ca_name</STRONG></FONT><BR>
$OASISmsg[From] $pStartDate $OASISmsg[to] $pEndDate
<BR>
__TEXT__;

  $total_imp = 0;
  while(list($CreativeID) = mysql_fetch_row($result1))
  {
    if(!($result2 = mysql_query("select Day, Hour, Sections.ReportName, Creatives.Name, Impressions, Clicks, ImpressionErrors, ClickErrors from (HourlyStats natural left join Sections) left join Creatives on HourlyStats.CreativeID=Creatives.CreativeID where HourlyStats.CreativeID=$CreativeID and Day >= '$StartDate' and Day <= '$EndDate'")))
    {
      print "$OASISmsg[Error_pulling_creative_stats] $CreativeID: " . mysql_error();
      return "";
    }

    while(list($day, $hour, $section, $creative, $imp, $click, $ierr, $cerr)
          = mysql_fetch_row($result2))
    {
      $total_imp += $imp;
    
      $stats[0] += $imp;
      $stats[1] += $click;
      $stats[2] += $ierr;
      $stats[3] += $cerr;

      $stats['Creative'][$creative][0] += $imp;
      $stats['Creative'][$creative][1] += $click;
      $stats['Creative'][$creative][2] += $ierr;
      $stats['Creative'][$creative][3] += $cerr;

      $stats['Hour'][$hour][0] += $imp;
      $stats['Hour'][$hour][1] += $click;
      $stats['Hour'][$hour][2] += $ierr;
      $stats['Hour'][$hour][3] += $cerr;

      $stats['Section'][$section][0] += $imp;
      $stats['Section'][$section][1] += $click;
      $stats['Section'][$section][2] += $ierr;
      $stats['Section'][$section][3] += $cerr;

      $stats['Date'][$day][0] += $imp;
      $stats['Date'][$day][1] += $click;
      $stats['Date'][$day][2] += $ierr;
      $stats['Date'][$day][3] += $cerr;
    }
  }

  if($total_imp == 0)
    return "$OASISmsg[No_campaign_stats] $pStartDate $OASISmsg[to] $pEndDate";

  $perc[0] = number_format($stats[0] / $total_imp * 100, 2, $OASISdecpt, $OASIStsep);
  $perc[1] = $stats[0] ? number_format($stats[1] / $stats[0] * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $perc[2] = $stats[0] ? number_format($stats[2] / ($stats[0] + $stats[2]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $perc[3] = $stats[1] ? number_format($stats[3] / ($stats[1] + $stats[3]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $stats[0] = number_format($stats[0], 0, $OASISdecpt, $OASIStsep);
  $stats[1] = number_format($stats[1], 0, $OASISdecpt, $OASIStsep);
  $stats[2] = number_format($stats[2], 0, $OASISdecpt, $OASIStsep);
  $stats[3] = number_format($stats[3], 0, $OASISdecpt, $OASIStsep);

  $report .= <<<__TEXT__
<TABLE WIDTH=605 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead ROWSPAN=2 VALIGN=bottom><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Clickthroughs]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Imp_Errors]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Click_Errors]</SPAN></TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
</TR>
<TR>
<TD ALIGN=right>$stats[0]</TD>
<TD ALIGN=right>$stats[1]</TD>
<TD ALIGN=right>$perc[1] %</TD>
<TD ALIGN=right>$stats[2]</TD>
<TD ALIGN=right>$perc[2] %</TD>
<TD ALIGN=right>$stats[3]</TD>
<TD ALIGN=right>$perc[3] %</TD>
</TR>
</TABLE>
__TEXT__;

  foreach(array('Creative', 'Date', 'Hour', 'Section') as $statstype)
  {
    $report .= <<<__TEXT__
<P>
<FONT SIZE="+1"><STRONG>$OASISmsg[By] $OASISmsg[$statstype]</STRONG></FONT><BR>

<TABLE WIDTH=605 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Clickthroughs]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Imp_Errors]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Click_Errors]</SPAN></TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[$statstype]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Perc]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
</TR>
__TEXT__;
    
    $tstats = $stats[$statstype];
    ksort($tstats);
    $bgcolor = '#cccccc';
    $total_imp = 0;
    while(list($k, $s) = each($tstats)) $total_imp += $s[0];
    reset($tstats);
    while(list($k, $s) = each($tstats))
    {
      if((string)$k == '') continue;

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      $perc[0] = number_format($s[0] / $total_imp * 100, 2, $OASISdecpt, $OASIStsep);
      $perc[1] = $s[0] ? number_format($s[1] / $s[0] * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $perc[2] = $s[0] ? number_format($s[2] / ($s[0] + $s[2]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $perc[3] = $s[1] ? number_format($s[3] / ($s[1] + $s[3])* 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $s[0] = number_format($s[0], 0, $OASISdecpt, $OASIStsep);
      $s[1] = number_format($s[1], 0, $OASISdecpt, $OASIStsep);
      $s[2] = number_format($s[2], 0, $OASISdecpt, $OASIStsep);
      $s[3] = number_format($s[3], 0, $OASISdecpt, $OASIStsep);

      $report .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR='$bgcolor'>
<TD>$k</TD>
<TD ALIGN=right>$s[0]</TD>
<TD ALIGN=right>$perc[0] %</TD>
<TD ALIGN=right>$s[1]</TD>
<TD ALIGN=right>$perc[1] %</TD>
<TD ALIGN=right>$s[2]</TD>
<TD ALIGN=right>$perc[2] %</TD>
<TD ALIGN=right>$s[3]</TD>
<TD ALIGN=right>$perc[3] %</TD>
</TR>
__TEXT__;
    }

    $report .= "</TABLE>\n";
  }

  $report .= "</TD></TR></TABLE>\n";

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_subsection_list($SectionID, $depth, $max_depth)
{
  global $subsection_list;

  if($max_depth && $depth >= $max_depth) return;

  if(!($result = mysql_query("select SectionID from Sections where PSectionID=$SectionID")))
    return;
    
  while(list($s) = mysql_fetch_row($result))
  {
    array_push($subsection_list, $s);
    build_subsection_list($s, $depth + 1, $max_depth);
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function section_report($SectionID, $StartDate, $EndDate, $depth)
{
  $report = '';
  global $subsection_list;
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep;

  $filter_string = "";
  $subsection_list = array($SectionID);
  build_subsection_list($SectionID, 1, $depth);
  $subsection_list = implode(",", $subsection_list);
  $filter_string = " HourlyStats.SectionID in ($subsection_list) and";

  if(!($result = mysql_query("select Name from Sections where SectionID=$SectionID")))
  {
    print "$OASISmsg[error_pulling_section] $SectionID: " . mysql_error();
    return "";
  }
  list($s_name) = mysql_fetch_row($result);

  preg_match('#(\d+)-(\d+)-(\d+)#', $StartDate, $matches);
  list ($j, $y, $m, $d) = $matches;
  $pStartDate = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";
  preg_match('#(\d+)-(\d+)-(\d+)#', $EndDate, $matches);
  list ($j, $y, $m, $d) = $matches;
  $pEndDate = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";

  $report .= <<<__TEXT__
<TABLE WIDTH=605><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Section]: $s_name</STRONG></FONT><BR>
$OASISmsg[From] $pStartDate $OASISmsg[to] $pEndDate
<BR>
__TEXT__;

  $total_imp = 0;
  $sql = "select Day, Hour, Sections.ReportName, Creatives.Name, Creatives.Width, Creatives.Height, Campaigns.Name, Impressions, Clicks, ImpressionErrors, ClickErrors from (HourlyStats natural left join Sections) left join Creatives on HourlyStats.CreativeID=Creatives.CreativeID left join Campaigns on Creatives.CampaignID=Campaigns.CampaignID where$filter_string Day >= '$StartDate' and Day <= '$EndDate'";
  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[error_pulling_section_stats] $SectionID: " . mysql_error();
    return "";
  }

  while(list($day, $hour, $section, $creative, $width, $height, $campaign, $imp, $click, $ierr, $cerr)
        = mysql_fetch_row($result))
  {
    $dim = "{$width}x{$height}";
    $creative = "$creative ($dim)";

    $total_imp += $imp;
    
    $stats[0] += $imp;
    $stats[1] += $click;
    $stats[2] += $ierr;
    $stats[3] += $cerr;

    $stats['Creative'][$creative][0] += $imp;
    $stats['Creative'][$creative][1] += $click;
    $stats['Creative'][$creative][2] += $ierr;
    $stats['Creative'][$creative][3] += $cerr;

    $stats['Dimension'][$dim][0] += $imp;
    $stats['Dimension'][$dim][1] += $click;
    $stats['Dimension'][$dim][2] += $ierr;
    $stats['Dimension'][$dim][3] += $cerr;

    $stats['Campaign'][$campaign][0] += $imp;
    $stats['Campaign'][$campaign][1] += $click;
    $stats['Campaign'][$campaign][2] += $ierr;
    $stats['Campaign'][$campaign][3] += $cerr;

    $stats['Hour'][$hour][0] += $imp;
    $stats['Hour'][$hour][1] += $click;
    $stats['Hour'][$hour][2] += $ierr;
    $stats['Hour'][$hour][3] += $cerr;

    $stats['Section'][$section][0] += $imp;
    $stats['Section'][$section][1] += $click;
    $stats['Section'][$section][2] += $ierr;
    $stats['Section'][$section][3] += $cerr;

    $stats['Date'][$day][0] += $imp;
    $stats['Date'][$day][1] += $click;
    $stats['Date'][$day][2] += $ierr;
    $stats['Date'][$day][3] += $cerr;
  }

  if($total_imp == 0)
    return "$OASISmsg[No_section_stats] $OASISmsg[for] $StartDate $OASISmsg[to] $EndDate";

  $perc[0] = number_format($stats[0] / $total_imp * 100, 2, $OASISdecpt, $OASIStsep);
  $perc[1] = $stats[0] ? number_format($stats[1] / $stats[0] * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $perc[2] = $stats[0] ? number_format($stats[2] / ($stats[0] + $stats[2]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $perc[3] = $stats[1] ? number_format($stats[3] / ($stats[1] + $stats[3]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
  $stats[0] = number_format($stats[0], 0, $OASISdecpt, $OASIStsep);
  $stats[1] = number_format($stats[1], 0, $OASISdecpt, $OASIStsep);
  $stats[2] = number_format($stats[2], 0, $OASISdecpt, $OASIStsep);
  $stats[3] = number_format($stats[3], 0, $OASISdecpt, $OASIStsep);

  $report .= <<<__TEXT__
<TABLE WIDTH=605 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead ROWSPAN=2 VALIGN=bottom><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Clickthroughs]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Imp_Errors]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Click_Errors]</SPAN></TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
</TR>
<TR>
<TD ALIGN=right>$stats[0]</TD>
<TD ALIGN=right>$stats[1]</TD>
<TD ALIGN=right>$perc[1] %</TD>
<TD ALIGN=right>$stats[2]</TD>
<TD ALIGN=right>$perc[2] %</TD>
<TD ALIGN=right>$stats[3]</TD>
<TD ALIGN=right>$perc[3] %</TD>
</TR>
</TABLE>
__TEXT__;

  foreach(array('Dimension', 'Campaign', 'Creative', 'Date', 'Hour', 'Section') as $statstype)
  {
    $report .= <<<__TEXT__
<P>
<FONT SIZE="+1"><STRONG>$OASISmsg[By] $OASISmsg[$statstype]</STRONG></FONT><BR>

<TABLE WIDTH=605 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Clickthroughs]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Imp_Errors]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Click_Errors]</SPAN></TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[$statstype]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Perc]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Num]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Rate]</SPAN></TD>
</TR>
__TEXT__;
    
    $tstats = $stats[$statstype];
    ksort($tstats);
    $bgcolor = '#cccccc';
    $total_imp = 0;
    while(list($k, $s) = each($tstats)) $total_imp += $s[0];
    reset($tstats);
    while(list($k, $s) = each($tstats))
    {
      if((string)$k == '') continue;

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      $perc[0] = number_format($s[0] / $total_imp * 100, 2, $OASISdecpt, $OASIStsep);
      $perc[1] = $s[0] ? number_format($s[1] / $s[0] * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $perc[2] = $s[0] ? number_format($s[2] / ($s[0] + $s[2]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $perc[3] = $s[1] ? number_format($s[3] / ($s[1] + $s[3]) * 100, 2, $OASISdecpt, $OASIStsep) : "0{$OASISdecpt}00";
      $s[0] = number_format($s[0], 0, $OASISdecpt, $OASIStsep);
      $s[1] = number_format($s[1], 0, $OASISdecpt, $OASIStsep);
      $s[2] = number_format($s[2], 0, $OASISdecpt, $OASIStsep);
      $s[3] = number_format($s[3], 0, $OASISdecpt, $OASIStsep);

      $report .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR='$bgcolor'>
<TD>$k</TD>
<TD ALIGN=right>$s[0]</TD>
<TD ALIGN=right>$perc[0] %</TD>
<TD ALIGN=right>$s[1]</TD>
<TD ALIGN=right>$perc[1] %</TD>
<TD ALIGN=right>$s[2]</TD>
<TD ALIGN=right>$perc[2] %</TD>
<TD ALIGN=right>$s[3]</TD>
<TD ALIGN=right>$perc[3] %</TD>
</TR>
__TEXT__;
    }

    $report .= "</TABLE>\n";
  }

  $report .= "</TD></TR></TABLE>\n";

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function network_campaigns ($fd, $td, $show_clicks)
{
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep, $OASIScurrdp,
        $OASISlcurrsym, $OASIStcurrsym;
  global $impd_total, $cpmc_total, $clickd_total, $cpcc_total, $fixedc_total,
         $gr_total, $acc_total, $hostpay_total, $netpay_total, $nd_total;
  global $OG_PubID;

  $simpd_total = 0;
  $scpmc_total = 0;
  $sclickd_total = 0;
  $scpcc_total = 0;
  $sfixedc_total = 0;
  $sgr_total = 0;
  $sacc_total = 0;
  $snetpay_total = 0;
  $snd_total = 0;

  $ft = mysql_date_to_unix ($fd);
  $tt = mysql_date_to_unix ($td);

  $parent_hash = get_parent_pubs ($OG_PubID);
  $parent_ids = array_keys ($parent_hash);
  if (count ($parent_ids) < 1) return '';

  $im_subpub_hash = get_immediate_subpubs ($OG_PubID);
  list ($all_subpub_hash, $subtrees) 
    = get_all_subpubs ($OG_PubID, array_keys ($im_subpub_hash));

  $filter_str = join (',', $parent_ids);

  $sql = <<<__TEXT__
SELECT 
  CampaignID, a.PublisherID, ca.Name, a.Name, 
  unix_timestamp(StartDate), unix_timestamp(EndDate), 
  CPM, CPC, Fixed, PayFixed, AgencyCommission, EvenDelivery
FROM 
  Campaigns ca LEFT JOIN
  Advertisers a ON ca.AdvertiserID = a.AdvertiserID 
WHERE
  StartDate <= '$td' 
  AND (EndDate = '0000-00-00' OR EndDate >= '$fd')
  AND Status!='Cancelled' 
  AND a.PublisherID IN ($filter_str)
ORDER BY a.Name, ca.Name
__TEXT__;
  #AND (Fixed > 0 OR CPM > 0 OR CPC > 0 OR ForceInvoice='Y') 

  if(!($result1 = mysql_query($sql)))
  {
    #print "$OASISmsg[No_active_campaigns] $fd $OASISmsg[to] $td: " . mysql_error() . "\n";
    return "";
  }

  $bgcolor = '#cccccc';
  while(list($ca_id, $pid, $ca_name, $a_name, $st, $et, $cpm, $cpc, $fixed, $pf, $ac, $even) = mysql_fetch_row($result1))
  {
    #### how much of this campaign revenue will be paid to us?
    list ($pname, $my_cpm, $my_cpmperc, $my_cpc, $my_cpcperc, $my_fixed, $my_fixedperc)
      = $parent_hash[$pid];

    list($caimpd, $caclickd, $imphash, $clickhash)
       = get_impclick($ca_id, $fd, $td);

    #### find out how much of the campaign ran on our site
    #### and our subpublishers
    $impd = 0;
    $clickd = 0;
    foreach (array_keys ($all_subpub_hash) as $p) {
      $impd += $imphash[$p];
      $clickd += $clickhash[$p];
    }

    #### adjust the rates to reflect our percentage
    $cpm   = $my_cpm + $cpm * $my_cpmperc;
    $cpc   = $my_cpc + $cpc * $my_cpcperc;
    $fixed = $my_fixed + $fixed * $my_fixedperc;

    $cpmc = $cpm * $impd / 1000;
    $cpcc = $cpc * $clickd;

    #### compute how much of the fixed cost should be charged this month.
    $ft = mysql_date_to_unix ($fd);
    $tt = mysql_date_to_unix ($td);
    $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pf, $ca_id);

    #### we only get paid a fraction of the fixed cost, based on the fraction
    #### of the overall impressions we've delivered
    $fixedc = ($caimpd > 0) ? ($fixedc * $impd / $caimpd) : 0;

    $cpmc   = round($cpmc * 100) / 100;
    $cpcc   = round($cpcc * 100) / 100;
    $fixedc = round($fixedc * 100) / 100;

    $gr     = $cpmc + $cpcc + $fixedc;

    #### agency commission is 0 for network campaigns
    $acc    = 0.0;

    #### determine network payments
    $netpay = 0;
    foreach (array_keys ($im_subpub_hash) as $spid) {
      $pub_info = $im_subpub_hash[$spid];
      array_shift ($pub_info);

      $subsubimps = 0;
      $subsubclicks = 0;
      $subsubpubs = $subtrees[$spid];
      foreach ($subsubpubs as $ssp) {
        $subsubimps   += $imphash[$ssp];
        $subsubclicks += $clickhash[$ssp];
      }
      $netpay += get_netpay ($impd, $cpm, $clickd, $cpc, $fixed, $fixedc, 
                       $pub_info, $subsubimps, $subsubclicks);
    }

    #### hosting fee is 0 for network campaigns
    $hostpay = 0.0;

    $nd     = $gr - $acc - $hostpay - $netpay;
    if ($impd == 0 && $nd == 0) continue;

    $simpd_total    += $impd;
    $scpmc_total    += $cpmc;
    $sclickd_total  += $clickd;
    $scpcc_total    += $cpcc;
    $sfixedc_total  += $fixedc;
    $sacc_total     += $acc;
    $sgr_total      += $gr;
    $shostpay_total += $hostpay;
    $snetpay_total  += $netpay;
    $snd_total      += $nd;

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    if($cpm == 0)
    {
      $cpm = ($impd > 0) ? number_format($gr / ($impd / 1000),
                            $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpm$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpm    = number_format($cpm, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpmc   = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpm$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpmc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($cpc == 0)
    {
      $cpc = ($clickd > 0) ? number_format($gr / $clickd,
                             $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpc$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpc    = number_format($cpc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpcc   = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpc$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpcc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($fixed == 0)
    {
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>
__TEXT__;
    }
    else
    {
      $fixedc = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$fixedc$OASIStcurrsym</SPAN></TD>
__TEXT__;
    }

    if($show_clicks == 'N') $clickdata = '';

    $gr     = number_format($gr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $nd     = number_format($nd, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $acc    = '-';
    $hostpay = '-';
    $netpay = ($netpay <= 0) ? '-' : '(' . number_format($netpay, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';

    $report .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR="$bgcolor">
<TD><SPAN CLASS=smalldata>$ca_name<BR>
$a_name</SPAN></TD>
$impdata$clickdata$fixeddata
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$gr$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $acc</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $hostpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $netpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$nd$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  $impd_total    += $simpd_total;
  $cpmc_total    += $scpmc_total;
  $clickd_total  += $sclickd_total;
  $cpcc_total    += $scpcc_total;
  $fixedc_total  += $sfixedc_total;
  $acc_total     += $sacc_total;
  $gr_total      += $sgr_total;
  $hostpay_total += $shostpay_total;
  $netpay_total  += $snetpay_total;
  $nd_total      += $snd_total;

  $scpm_avg      = ($simpd_total > 0)
                   ? number_format($scpmc_total / ($simpd_total / 1000), 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);
  $scpc_avg      = ($sclickd_total > 0)
                   ? number_format($scpcc_total / $sclickd_total, 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);

  $simpd_total    = number_format($simpd_total, 0, $OASISdecpt, $OASIStsep);
  $scpmc_total    = number_format($scpmc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sclickd_total  = number_format($sclickd_total, 0, $OASISdecpt, $OASIStsep);
  $scpcc_total    = number_format($scpcc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sfixedc_total  = number_format($sfixedc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sgr_total      = number_format($sgr_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sacc_total     = number_format($sacc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $shostpay_total = number_format($shostpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snetpay_total  = number_format($snetpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snd_total      = number_format($snd_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $clickdata = ($show_clicks == 'Y')
    ? "<TD ALIGN=right><SPAN CLASS=smalldata>$sclickd_total</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpc_avg$OASIStcurrsym</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpcc_total$OASIStcurrsym</SPAN></TD>\n"
    : "";

  if ($report) {
    $report .= <<<__TEXT__
<TR>
<TD>$OASISmsg[Subtotals]:</TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$simpd_total</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpm_avg$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpmc_total$OASIStcurrsym</SPAN></TD>
$clickdata<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sfixedc_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sgr_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$sacc_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$shostpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$snetpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$snd_total$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function local_campaigns ($fd, $td, $show_clicks)
{
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep, $OASIScurrdp,
        $OASISlcurrsym, $OASIStcurrsym;
  global $impd_total, $cpmc_total, $clickd_total, $cpcc_total, $fixedc_total,
         $gr_total, $hostpay_total, $acc_total, $netpay_total, $nd_total;
  global $OG_PubID;

  $simpd_total = 0;
  $scpmc_total = 0;
  $sclickd_total = 0;
  $scpcc_total = 0;
  $sfixedc_total = 0;
  $sgr_total = 0;
  $sacc_total = 0;
  $shostpay_total = 0;
  $snetpay_total = 0;
  $snd_total = 0;

  $ft = mysql_date_to_unix ($fd);
  $tt = mysql_date_to_unix ($td);

  $im_subpub_hash = get_immediate_subpubs ($OG_PubID);
  list ($all_subpub_hash, $subtrees)
    = get_all_subpubs ($OG_PubID, array_keys ($im_subpub_hash));

  $sql = <<<__TEXT__
SELECT 
  CampaignID, ca.Name, a.Name, 
  unix_timestamp(StartDate), unix_timestamp(EndDate), 
  CPM, CPC, Fixed, PayFixed, AgencyCommission, EvenDelivery 
FROM 
  Campaigns ca LEFT JOIN
  Advertisers a ON ca.AdvertiserID = a.AdvertiserID 
WHERE
  StartDate <= '$td' 
  AND (EndDate = '0000-00-00' OR EndDate >= '$fd')
  AND Status!='Cancelled' 
  AND a.PublisherID=$OG_PubID
ORDER BY a.Name, ca.Name
__TEXT__;

  if(!($result1 = mysql_query($sql)))
  {
    #print "$OASISmsg[No_active_campaigns] $fd $OASISmsg[to] $td: " . mysql_error() . "\n";
    return "";
  }

  #### this is cheesy, but probably faster than a loop;
  $mypubinfo = get_pub_info ($OG_PubID);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);

  $bgcolor = '#cccccc';
  while(list($ca_id, $ca_name, $a_name, $st, $et, $cpm, $cpc, $fixed, $pf, $ac, $even) = mysql_fetch_row($result1))
  {
    #### FIXME!!! this needs to aggregate the impressions to the immediate
    #### subpublishers
    list($impd, $clickd, $imphash, $clickhash) = get_impclick($ca_id, $fd, $td);

    $cpmc = $cpm * $impd / 1000;
    $cpcc = $cpc * $clickd;

    #### compute how much of the fixed cost should be charged this month.
    $ft = mysql_date_to_unix ($fd);
    $tt = mysql_date_to_unix ($td);

    $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pf, $ca_id);
    #$report  .= "$ca_name: $fixed<BR>\n";

    $cpmc   = round($cpmc * 100) / 100;
    $cpcc   = round($cpcc * 100) / 100;

    $gr     = $cpmc + $cpcc + $fixedc;

    #### round agency commission up, since it may be double-checked by
    #### an accountant
    $acc    = Ceil($ac * $gr) / 100;

    #### determine hosting payments
    $hostpay = get_netpay ($impd, $cpm, $clickd, $cpc, $fixed, $fixedc,
                                $mypubinfo, $impd, $clickd);

    #### determine network payments by looking at each immediate subpub
    #### for credit rates; then total the number of imps and clicks for
    #### the entire tree of publishers beneath the subpub
    $netpay = 0;
    foreach (array_keys ($im_subpub_hash) as $spid) {
      $pub_info = $im_subpub_hash[$spid];
      array_shift ($pub_info);

      $subsubimps = 0;
      $subsubclicks = 0;
      $subsubpubs = $subtrees[$spid];
      foreach ($subsubpubs as $ssp) {
        $subsubimps   += $imphash[$ssp];
        $subsubclicks += $clickhash[$ssp];
      }
      $netpay += get_netpay ($impd, $cpm, $clickd, $cpc, $fixed, $fixedc, 
                       $pub_info, $subsubimps, $subsubclicks);
    }

    $nd     = $gr - $acc - $hostpay - $netpay;

    $simpd_total    += $impd;
    $scpmc_total    += $cpmc;
    $sclickd_total  += $clickd;
    $scpcc_total    += $cpcc;
    $sfixedc_total  += $fixedc;
    $sgr_total      += $gr;
    $sacc_total     += $acc;
    $shostpay_total += $hostpay;
    $snetpay_total  += $netpay;
    $snd_total      += $nd;

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    if($cpm == 0)
    {
      $cpm = ($impd > 0) ? number_format($gr / ($impd / 1000),
                            $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpm$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpm    = number_format($cpm, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpmc   = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpm$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpmc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($cpc == 0)
    {
      $cpc = ($clickd > 0) ? number_format($gr / $clickd,
                             $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpc$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpc    = number_format($cpc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpcc   = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpc$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpcc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($fixed == 0)
    {
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>
__TEXT__;
    }
    else
    {
      $fixedc = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$fixedc$OASIStcurrsym</SPAN></TD>
__TEXT__;
    }

    if($show_clicks == 'N') $clickdata = '';

    $gr      = number_format($gr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $nd      = number_format($nd, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $acc     = ($acc <= 0) ? '-' : '(' . number_format($acc, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';
    $hostpay = ($hostpay <= 0) ? '-' : '(' . number_format($hostpay, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';
    $netpay  = ($netpay <= 0) ? '-' : '(' . number_format($netpay, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';

    $report .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR="$bgcolor">
<TD><SPAN CLASS=smalldata>$ca_name<BR>
$a_name</SPAN></TD>
$impdata$clickdata$fixeddata
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$gr$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $acc</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $hostpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $netpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$nd$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  $impd_total    += $simpd_total;
  $cpmc_total    += $scpmc_total;
  $clickd_total  += $sclickd_total;
  $cpcc_total    += $scpcc_total;
  $fixedc_total  += $sfixedc_total;
  $gr_total      += $sgr_total;
  $acc_total     += $sacc_total;
  $hostpay_total += $shostpay_total;
  $netpay_total  += $snetpay_total;
  $nd_total      += $snd_total;

  $scpm_avg      = ($simpd_total > 0)
                   ? number_format($scpmc_total / ($simpd_total / 1000), 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);
  $scpc_avg      = ($sclickd_total > 0)
                   ? number_format($scpcc_total / $sclickd_total, 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);

  $simpd_total    = number_format($simpd_total, 0, $OASISdecpt, $OASIStsep);
  $scpmc_total    = number_format($scpmc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sclickd_total  = number_format($sclickd_total, 0, $OASISdecpt, $OASIStsep);
  $scpcc_total    = number_format($scpcc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sfixedc_total  = number_format($sfixedc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sgr_total      = number_format($sgr_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sacc_total     = number_format($sacc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $shostpay_total = number_format($shostpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snetpay_total  = number_format($snetpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snd_total      = number_format($snd_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $clickdata = ($show_clicks == 'Y')
    ? "<TD ALIGN=right><SPAN CLASS=smalldata>$sclickd_total</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpc_avg$OASIStcurrsym</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpcc_total$OASIStcurrsym</SPAN></TD>\n"
    : "";

  if ($report) {
    $report .= <<<__TEXT__
<TR>
<TD>$OASISmsg[Subtotals]:</TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$simpd_total</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpm_avg$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpmc_total$OASIStcurrsym</SPAN></TD>
$clickdata<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sfixedc_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sgr_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$sacc_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$shostpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$snetpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$snd_total$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function subpub_campaigns ($fd, $td, $show_clicks)
{
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep, $OASIScurrdp,
        $OASISlcurrsym, $OASIStcurrsym;
  global $impd_total, $cpmc_total, $clickd_total, $cpcc_total, $fixedc_total,
         $gr_total, $acc_total, $hostpay_total, $netpay_total, $nd_total;
  global $OG_PubID;

  $simpd_total = 0;
  $scpmc_total = 0;
  $sclickd_total = 0;
  $scpcc_total = 0;
  $sfixedc_total = 0;
  $sgr_total = 0;
  $sacc_total = 0;
  $snetpay_total = 0;
  $shostpay_total = 0;
  $snd_total = 0;

  $ft = mysql_date_to_unix ($fd);
  $tt = mysql_date_to_unix ($td);

  list ($all_subpub_hash) = get_all_subpubs ($OG_PubID);
  $subpub_ids = array_keys ($all_subpub_hash);
  if (count ($subpub_ids) < 1) return '';

  $filter_str = join (',', $subpub_ids);

  $sql = <<<__TEXT__
SELECT 
  CampaignID, a.PublisherID, ca.Name, a.Name, 
  unix_timestamp(StartDate), unix_timestamp(EndDate), 
  CPM, CPC, Fixed, PayFixed, AgencyCommission, EvenDelivery
FROM 
  Campaigns ca LEFT JOIN
  Advertisers a ON ca.AdvertiserID = a.AdvertiserID 
WHERE
  StartDate <= '$td' 
  AND (EndDate = '0000-00-00' OR EndDate >= '$fd')
  AND Status!='Cancelled' 
  AND a.PublisherID IN ($filter_str)
ORDER BY a.Name, ca.Name
__TEXT__;

  if(!($result1 = mysql_query($sql)))
  {
    #print "$OASISmsg[No_active_campaigns] $fd $OASISmsg[to] $td: " . mysql_error() . "\n";
    return "";
  }

  #### this is cheesy, but probably faster than a loop;
  $mypubinfo = get_pub_info ($OG_PubID);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);
  array_shift ($mypubinfo); array_shift ($mypubinfo);

  $bgcolor = '#cccccc';
  while(list($ca_id, $pid, $ca_name, $a_name, $st, $et, $cpm, $cpc, $fixed, $pf, $ac, $even) = mysql_fetch_row($result1))
  {
    #### get_all_subpubs() will include the current publisher in the list
    #### so we don't want to include it.
    if ($pid == $OG_PubID) continue;

    #### how much of this campaign revenue will be paid to us?
    list ($p_name, $my_cpm, $my_cpmperc, 
                   $my_cpc, $my_cpcperc,
                   $my_fixed, $my_fixedperc) = $all_subpub_hash[$pid];

    list($impd, $clickd, $imphash, $clickhash) = get_impclick($ca_id, $fd, $td);

    #### adjust the rates to reflect our percentage
    $cpm   = $my_cpm + $cpm * $my_cpmperc;
    $cpc   = $my_cpc + $cpc * $my_cpcperc;
    $fixed = $my_fixed + $fixed * $my_fixedperc;

    $cpmc = $cpm * $impd / 1000;
    $cpcc = $cpc * $clickd;

    #### compute how much of the fixed cost should be charged this month.
    $ft = mysql_date_to_unix ($fd);
    $tt = mysql_date_to_unix ($td);

    $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pf, $ca_id);

    $cpmc   = round($cpmc * 100) / 100;
    $cpcc   = round($cpcc * 100) / 100;

    $gr     = $cpmc + $cpcc + $fixedc;

    #### agency commission is 0 for subpub campaigns
    $acc    = 0.0;

    #### network payments are 0 for subpub campaigns
    $netpay = 0;

    #### hosting fee
    $hostpay = get_netpay ($impd, $cpm, $clickd, $cpc, $fixed, $fixedc,
                                $mypubinfo, $impd, $clickd);

    $nd     = $gr - $acc - $hostpay - $netpay;

    $simpd_total    += $impd;
    $scpmc_total    += $cpmc;
    $sclickd_total  += $clickd;
    $scpcc_total    += $cpcc;
    $sfixedc_total  += $fixedc;
    $sacc_total     += $acc;
    $sgr_total      += $gr;
    $shostpay_total += $hostpay;
    $snetpay_total  += $netpay;
    $snd_total      += $nd;

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    if($cpm == 0)
    {
      $cpm = ($impd > 0) ? number_format($gr / ($impd / 1000),
                            $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpm$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpm    = number_format($cpm, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpmc   = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $impd   = number_format($impd, 0, $OASISdecpt, $OASIStsep);
      $impdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$impd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpm$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpmc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($cpc == 0)
    {
      $cpc = ($clickd > 0) ? number_format($gr / $clickd,
                             $OASIScurrdp, $OASISdecpt, $OASIStsep) : '-';
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata><FONT COLOR="#666666"><EM>$OASISlcurrsym$cpc$OASIStcurrsym</EM></FONT></SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>

__TEXT__;
    }
    else
    {
      $cpc    = number_format($cpc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpcc   = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $clickd = number_format($clickd, 0, $OASISdecpt, $OASIStsep);
      $clickdata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$clickd</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpc$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpcc$OASIStcurrsym</SPAN></TD>

__TEXT__;
    }

    if($fixed == 0)
    {
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>-</SPAN></TD>
__TEXT__;
    }
    else
    {
      $fixedc = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $fixeddata = <<<__TEXT__
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$fixedc$OASIStcurrsym</SPAN></TD>
__TEXT__;
    }

    if($show_clicks == 'N') $clickdata = '';

    $gr     = number_format($gr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $nd     = number_format($nd, $OASIScurrdp, $OASISdecpt, $OASIStsep);
    $acc    = ($acc <= 0) ? '-' : '(' . number_format($acc, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';
    $hostpay = ($hostpay <= 0) ? '-' : '(' . number_format($hostpay, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';
    $netpay = ($netpay <= 0) ? '-' : '(' . number_format($netpay, $OASIScurrdp,
                                         $OASISdecpt, $OASIStsep) . ')';

    $report .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR="$bgcolor">
<TD><SPAN CLASS=smalldata>$ca_name<BR>
$a_name</SPAN></TD>
$impdata$clickdata$fixeddata
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$gr$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $acc</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $hostpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata> $netpay</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$nd$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  $impd_total    += $simpd_total;
  $cpmc_total    += $scpmc_total;
  $clickd_total  += $sclickd_total;
  $cpcc_total    += $scpcc_total;
  $fixedc_total  += $sfixedc_total;
  $acc_total     += $sacc_total;
  $gr_total      += $sgr_total;
  $hostpay_total += $shostpay_total;
  $netpay_total  += $snetpay_total;
  $nd_total      += $snd_total;

  $scpm_avg      = ($simpd_total > 0)
                   ? number_format($scpmc_total / ($simpd_total / 1000), 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);
  $scpc_avg      = ($sclickd_total > 0)
                   ? number_format($scpcc_total / $sclickd_total, 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);

  $simpd_total    = number_format($simpd_total, 0, $OASISdecpt, $OASIStsep);
  $scpmc_total    = number_format($scpmc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sclickd_total  = number_format($sclickd_total, 0, $OASISdecpt, $OASIStsep);
  $scpcc_total    = number_format($scpcc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sfixedc_total  = number_format($sfixedc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sgr_total      = number_format($sgr_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $sacc_total     = number_format($sacc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $shostpay_total = number_format($shostpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snetpay_total  = number_format($snetpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $snd_total      = number_format($snd_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $clickdata = ($show_clicks == 'Y')
    ? "<TD ALIGN=right><SPAN CLASS=smalldata>$sclickd_total</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpc_avg$OASIStcurrsym</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpcc_total$OASIStcurrsym</SPAN></TD>\n"
    : "";

  if ($report) {
    $report .= <<<__TEXT__
<TR>
<TD>$OASISmsg[Subtotals]:</TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$simpd_total</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpm_avg$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$scpmc_total$OASIStcurrsym</SPAN></TD>
$clickdata<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sfixedc_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$sgr_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$sacc_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$shostpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$snetpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$snd_total$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
  }

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function hosting_charges($fd, $td)
{
  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep, $OASIScurrdp,
        $OASISlcurrsym, $OASIStcurrsym;
  global $OG_PubID;

  $num_months = num_months ($fd, $td);
  $report = '';
  $bgcolor = '#cccccc';

  #### see if I owe anything...
  $pub_info = get_pub_info ($OG_PubID);
  $hc = $pub_info[14];
  if ($hc > 0) {
    $pname = $pub_info[1];
    $hc = $hc * $num_months;
    $shc -= $hc;
    $hc = number_format($hc, $OASIScurrdp, $OASISdecpt, $OASIStsep);

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    $report .= <<<__TEXT__
<TR>
<TD><SPAN CLASS=smalldata>$pname</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$hc$OASIStcurrsym)</SPAN></TD>
</TR>
__TEXT__;
  }

  #### do my subpubs owe me anything?
  $im_subpub_hash = get_immediate_subpubs ($OG_PubID);
  $subpub_keys = array_keys ($im_subpub_hash);

  foreach ($subpub_keys as $spid) {
    $subpub_info = $im_subpub_hash[$spid];
    $hc = $subpub_info[13];

    if ($hc > 0) {
      $pname = $subpub_info[0];
      $hc = $hc * $num_months;
      $shc += $hc;
      $hc = number_format($hc, $OASIScurrdp, $OASISdecpt, $OASIStsep);

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      $report .= <<<__TEXT__
<TR>
<TD><SPAN CLASS=smalldata>$pname</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$hc$OASIStcurrsym</SPAN></TD>
</TR>
__TEXT__;
    }
  }

  if ($report) {
      if ($shc < 0) {
        $shc = number_format(0 - $shc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
        $shc = "($OASISlcurrsym$shc$OASIStcurrsym)";
      }
      else {
        $shc = number_format($shc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
        $shc = "$OASISlcurrsym$shc$OASIStcurrsym";
      }

      $report .= <<<__TEXT__
<TR>
<TD><SPAN CLASS=smalldata>$OASISmsg[Totals]:</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$shc</SPAN></TD>
</TR>
__TEXT__;

  }

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function revenue_report($fd, $td, $show_clicks)
{
  require("lib-invoice.inc");
  require("lib-publisher.inc");
  global $impd_total, $cpmc_total, $clickd_total, $cpcc_total, $fixedc_total,
         $gr_total, $acc_total, $hostpay_total, $netpay_total, $nd_total;

  global $OASISmsg, $OASISdatefmt, $OASISdecpt, $OASIStsep, $OASIScurrdp,
        $OASISlcurrsym, $OASIStcurrsym;

  $clickhead = ($show_clicks == 'Y')
     ? "<TD CLASS=tablehead COLSPAN=3><SPAN CLASS=tablehead>$OASISmsg[Clicks]</SPAN></TD>\n"
     : "";

  preg_match('#(\d+)-?(\d+)-?(\d+)#', $fd, $matches);
  list ($j, $y, $m, $d) = $matches;
  $pfd = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";
  preg_match('#(\d+)-?(\d+)-?(\d+)#', $td, $matches);
  list ($j, $y, $m, $d) = $matches;
  $ptd = ($OASISdatefmt == 'mdy') ? "$m/$d/$y" : "$d/$m/$y";

  $report = <<<__TEXT__
<TABLE><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Revenue_Report]</STRONG></FONT><BR>
$OASISmsg[From] $pfd $OASISmsg[to] $ptd
<BR>
<TABLE CELLPADDING=1 CELLSPACING=0 BORDER=1>
__TEXT__;

  $subreport = network_campaigns ($fd, $td, $show_clicks);
  if ($subreport) {
    $report .= <<<__TEXT__
<TR>
<TD CLASS=tablehead COLSPAN=13><SPAN CLASS=tablehead>$OASISmsg[Network_Campaigns]</SPAN</TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=3><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
$clickhead<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Fixed]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Gross]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Comm]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Host]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Ntwk]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Net_Due]</SPAN></TD>
</TR>
__TEXT__;

    $report .= $subreport;
  }
  $subreport = local_campaigns ($fd, $td, $show_clicks);
  if ($subreport) {
    $report .= <<<__TEXT__
<TR>
<TD CLASS=tablehead COLSPAN=13><SPAN CLASS=tablehead>$OASISmsg[Local_Campaigns]</SPAN</TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=3><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
$clickhead<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Fixed]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Gross]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Comm]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Host]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Ntwk]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Net_Due]</SPAN></TD>
</TR>
__TEXT__;

    $report .= $subreport;
  }

  $subreport = subpub_campaigns ($fd, $td, $show_clicks);
  if ($subreport) {
    $report .= <<<__TEXT__
<TR>
<TD CLASS=tablehead COLSPAN=13><SPAN CLASS=tablehead>$OASISmsg[Subpublisher_Campaigns]</SPAN</TD>
</TR>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=3><SPAN CLASS=tablehead>$OASISmsg[Impressions]</SPAN></TD>
$clickhead<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Fixed]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Gross]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Comm]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Host]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Ntwk]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Net_Due]</SPAN></TD>
</TR>
__TEXT__;

    $report .= $subreport;
  }

  $cpm_avg      = ($impd_total > 0)
                   ? number_format($cpmc_total / ($impd_total / 1000), 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);
  $cpc_avg      = ($clickd_total > 0)
                   ? number_format($cpcc_total / $clickd_total, 
                                $OASIScurrdp, $OASISdecpt, $OASIStsep)
                   : "0{$OASISdecpt}" . str_repeat('0', $OASIScurrdp);

  $impd_total    = number_format($impd_total, 0, $OASISdecpt, $OASIStsep);
  $cpmc_total    = number_format($cpmc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $clickd_total  = number_format($clickd_total, 0, $OASISdecpt, $OASIStsep);
  $cpcc_total    = number_format($cpcc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $fixedc_total  = number_format($fixedc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $gr_total      = number_format($gr_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $acc_total     = number_format($acc_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $hostpay_total = number_format($hostpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $netpay_total  = number_format($netpay_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $nd_total      = number_format($nd_total, $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $clickdata = ($show_clicks == 'Y')
    ? "<TD ALIGN=right><SPAN CLASS=smalldata>$clickd_total</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpc_avg$OASIStcurrsym</SPAN></TD>\n<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpcc_total$OASIStcurrsym</SPAN></TD>\n"
    : "";

  $report .= <<<__TEXT__
<TR>
<TD><STRONG>$OASISmsg[Totals]:</STRONG></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$impd_total</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpm_avg$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$cpmc_total$OASIStcurrsym</SPAN></TD>
$clickdata<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$fixedc_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$gr_total$OASIStcurrsym</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$acc_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$hostpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>($OASISlcurrsym$netpay_total$OASIStcurrsym)</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$OASISlcurrsym$nd_total$OASIStcurrsym</SPAN></TD>
</TR>
</TABLE>
</TD></TR></TABLE>
__TEXT__;


  $subreport = hosting_charges ($fd, $td);
  if ($subreport) {
    $report .= <<<__TEXT__
<P>
<STRONG>{$OASISmsg['Hosting_Charges']}</STRONG><BR>
<TABLE CELLPADDING=1 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>{$OASISmsg['Publisher']}</SPAN</TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>{$OASISmsg['Charge']}</SPAN</TD>
</TR>
$subreport
</TABLE>
__TEXT__;
  }

  return $report;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function inventory_report($SectionID, $depth, $date)
{
  global $subsection_list;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $sql = "select ReportName from Sections where SectionID=$SectionID";
  $result = mysql_query($sql);
  list($section_name) = mysql_fetch_row($result);

  $subsection_list = array($SectionID);
  build_subsection_list($SectionID, 1, $depth);
  $subsection_list = implode(",", $subsection_list);

  $first_col = ($date)
    ? "<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>"
    : "<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Date]</SPAN></TD>";

  if($date) $pdate = "<EM>$date</EM><BR>";
  $pdepth = ($depth == 0) ? $OASISmsg[all] : $depth;

  $report = <<<__TEXT__
<TABLE WIDTH=605><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Inventory_Report]</STRONG></FONT><BR>
<STRONG>$section_name, $OASISmsg[depth]=$pdepth</STRONG><BR>
$pdate
<P>
<TABLE WIDTH=605 CELLPADDING=1 CELLSPACING=0 BORDER=1>
<TR>
$first_col
<TD CLASS=tablehead COLSPAN=2><SPAN CLASS=tablehead>$OASISmsg[Projected_Inventory]</SPAN></TD>
<TD CLASS=tablehead COLSPAN=3><SPAN CLASS=tablehead>$OASISmsg[Inventory_Allocated]</SPAN></TD>
</TR>
__TEXT__;

  if($date) $filter = " and Day='$date' order by ReportName";

  $sql = "select Day, ReportName, Width, Height, Impressions, Allocated from SimSectionDailyTraffic natural left join Sections where SimSectionDailyTraffic.SectionID in ($subsection_list)$filter";

  $result = mysql_query($sql);
  while(list($day, $name, $w, $h, $imp, $alloc) = mysql_fetch_row($result))
  {
    if($date)
    {
      $palloc = $alloc / $imp * 100;
      $imp = number_format($imp, 0, $OASISdecpt, $OASIStsep);
      $alloc = number_format($alloc, 0, $OASISdecpt, $OASIStsep);
      $b1 = "<IMG SRC=\"graphics/red1.gif\" HEIGHT=12 WIDTH=$palloc>";
      $palloc = number_format($palloc, 1, $OASISdecpt, $OASIStsep);

      $report .= <<<__TEXT__
<TR>
<TD>$name</TD>
<TD>$w x $h</TD>
<TD ALIGN=right COLSPAN=2>$imp</TD>
<TD ALIGN=right>$alloc</TD>
<TD ALIGN=right>$palloc %</TD>
<TD WIDTH=100>$b1</TD>
</TR>
__TEXT__;
    }
    else
    {
      $imp_total[$day] += $imp;
      $alloc_total[$day] += $alloc;
    }
  }

  if(!$date)
  {
    $max = 0;
    while(list($day, $imp) = each($imp_total)) if($imp > $max) $max = $imp;

    reset($imp_total);

    while(list($day, $imp) = each($imp_total))
    {
      $nimp = (int)($imp / $max * 100);
      $b1 = "<IMG SRC=\"graphics/blue1.gif\" HEIGHT=12 WIDTH=$nimp>";
      $palloc = (int)($alloc_total[$day] / $imp * 100);
      $b2 = "<IMG SRC=\"graphics/red1.gif\" HEIGHT=12 WIDTH=$palloc>";
      $palloc = number_format($alloc_total[$day] / $imp * 100, 1, $OASISdecpt, $OASIStsep);
      $alloc = number_format($alloc_total[$day], 0, $OASISdecpt, $OASIStsep);
      $imp = number_format($imp, 0, $OASISdecpt, $OASIStsep);

      $report .= <<<__TEXT__
<TR>
<TD><A HREF="report.php?report_type=inventory&SectionID1=$SectionID&Depth1=$depth&date=$day">$day</A></TD>
<TD ALIGN=right>$imp</TD>
<TD WIDTH=100>$b1</TD>
<TD ALIGN=right>$alloc</TD>
<TD ALIGN=right>$palloc %</TD>
<TD WIDTH=100>$b2</TD>
</TR>

__TEXT__;
    }
  } 

  $report .= "</TABLE></TD></TR></TABLE>";

  return $report;
}

?>
